
;;; star-debugger.el

;; Copyright (C) 2014-2015 Davin Pearson

;; Emacs Lisp Archive Entry
;; Filename: star-debugger.el
;; Author/Maintainer: Davin Pearson <http://davin.50webs.com>
;; Keywords:
;; Version: 1.0

;;; Commentary:

;; This file is not part of GNU Emacs.

;;; Limitation of Warranty

;; This program is free software: you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or (at
;; your option) any later version.
;;
;; This program is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs, see the file COPYING.  If not, see:
;;
;; <http://www.gnu.org/licenses/gpl-3.0.txt>.


;;; Known Bugs:

;; None so far!

;;; Code:

(defvar star--buf-name "*star*")

(defun star--create-buffer ()
  (if (get-buffer star--buf-name)
      (kill-buffer (get-buffer star--buf-name)))
  (set-buffer (generate-new-buffer star--buf-name)))

(defun star-debug (filename)
  (interactive "fEnter filename: ")
  (let (p found line)
    (star--create-buffer)
    (save-excursion
      (set-buffer star--buf-name)
      (insert "cd " default-directory "\n")
      (insert "\n"))

    (save-excursion
      (find-file filename)
      (goto-char (point-min))
      (while (re-search-forward "\\<[A-Z]+[a-z][a-zA-Z0-9_]*\\>" nil t)

        (setq p (get-char-property (1- (point)) 'face))
        (when (and (not (eq p 'font-lock-string-face))
                   (not (eq p 'font-lock-comment-face)))
          (setq found (buffer-substring-no-properties (match-beginning 0) (match-end 0)))
          (setq line (d-what-line))
          (save-excursion
            (set-buffer star--buf-name)
            (goto-char (point-max))
            (insert (format "%s:%d: %s\n" (file-name-nondirectory filename) line found))))))
    (switch-to-buffer star--buf-name)
    (compilation-mode)
    (read-only-mode -1)
    ))

(provide 'star-debugger)
;;; star-debugger.el ends here
