.\"	$NetBSD: mdoc.samples.7,v 1.21 1999/08/23 21:54:20 ross Exp $
.\"
.\" Copyright (c) 1990, 1993
.\"	The Regents of the University of California.  All rights reserved.
.\"
.\" Redistribution and use in source and binary forms, with or without
.\" modification, are permitted provided that the following conditions
.\" are met:
.\" 1. Redistributions of source code must retain the above copyright
.\"    notice, this list of conditions and the following disclaimer.
.\" 2. Redistributions in binary form must reproduce the above copyright
.\"    notice, this list of conditions and the following disclaimer in the
.\"    documentation and/or other materials provided with the distribution.
.\" 3. All advertising materials mentioning features or use of this software
.\"    must display the following acknowledgement:
.\"	This product includes software developed by the University of
.\"	California, Berkeley and its contributors.
.\" 4. Neither the name of the University nor the names of its contributors
.\"    may be used to endorse or promote products derived from this software
.\"    without specific prior written permission.
.\"
.\" THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
.\" ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
.\" IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
.\" ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
.\" FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
.\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
.\" OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
.\" HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
.\" LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
.\" OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
.\" SUCH DAMAGE.
.\"
.\"     @(#)mdoc.samples.7	8.2 (Berkeley) 12/30/93
.\"
.\" This tutorial sampler invokes every macro in the package several
.\" times and is guaranteed to give a worst case performance
.\" for an already extremely slow package.
.\"
.Dd November 24, 1997
.Os
.Dt MDOC.SAMPLES 7
.Sh NAME
.Nm mdoc.samples
.Nd tutorial sampler for writing
.Bx
manuals with
.Nm \-mdoc
.Sh SYNOPSIS
.Nm man mdoc.samples
.Sh DESCRIPTION
A tutorial sampler for writing
.Bx
manual pages with the
.Nm \-mdoc
macro package, a
.Em content Ns \-based
and
.Em domain Ns \-based
formatting
package for
.Xr troff 1 .
Its predecessor, the
.Xr \-man 7
package,
addressed page layout leaving the
manipulation of fonts and other
typesetting details to the individual author.
In
.Nm \-mdoc ,
page layout macros
make up the
.Em "page structure domain"
which consists of macros for titles, section headers, displays
and lists. Essentially items which affect the physical position
of text on a formatted page.
In addition to the page structure domain, there are two more domains,
the manual domain and the general text domain.
The general text domain is defined as macros which
perform tasks such as quoting or emphasizing pieces of text.
The manual domain is defined as macros that are a subset of the
day to day informal language used to describe commands, routines
and related
.Bx
files.
Macros in the manual domain handle
command names, command line arguments and options, function names,
function parameters, pathnames, variables, cross
references to other manual pages, and so on.
These domain
items have value
for both the author and the future user of the manual page.
It is hoped the consistency gained
across the manual set will provide easier
translation to future documentation tools.
.Pp
Throughout the
.Ux
manual pages, a manual entry
is simply referred
to as a man page, regardless of actual length and without
sexist intention.
.Sh GETTING STARTED
Since a tutorial document is normally read when a person
desires to use the material immediately, the assumption has
been made that the user of this document may be impatient.
The material presented in the remained of this document is
outlined as follows:
.Bl -enum -offset indent
.It
.Tn "TROFF IDIOSYNCRASIES"
.Bl -tag -width flag -compact -offset indent
.It "Macro Usage" .
.It "Passing Space Characters in an Argument" .
.It "Trailing Blank Space Characters (a warning)" .
.It "Escaping Special Characters" .
.El
.It
.Tn "THE ANATOMY OF A MAN PAGE"
.Bl -tag -width flag -compact -offset indent
.It "A manual page template" .
.El
.It
.Tn "INTRODUCTION OF TITLE MACROS" .
.It
.Tn "INTRODUCTION OF MANUAL AND GENERAL TEXT DOMAINS" .
.Bl -tag -width flag -compact -offset indent
.It "What's in a name..." .
.It "General Syntax" .
.El
.It
.Tn "MANUAL DOMAIN"
.Bl -tag -width flag -compact -offset indent
.It "Addresses" .
.It "Arguments" .
.It "Configuration Declarations (section four only)" .
.It "Command Modifier" .
.It "Defined Variables" .
.It "Errno's (Section two only)" .
.It "Environment Variables" .
.It "Function Argument" .
.It "Function Declaration" .
.It "Flags" .
.It "Functions (library routines)" .
.It "Function Types" .
.\" .It "Header File (including source code)" .
.It "Interactive Commands" .
.It "Literals" .
.It "Names" .
.It "Options" .
.It "Pathnames" .
.It "Variables" .
.It "Cross References" .
.El
.It
.Tn "GENERAL TEXT DOMAIN"
.Bl -tag -width flag -compact -offset indent
.It "AT&T Macro" .
.It "BSD Macro" .
.It "UNIX Macro" .
.It "Emphasis Macro" .
.It "Enclosure/Quoting Macros"
.Bl -tag -width flag -compact -offset indent
.It "Angle Bracket Quote/Enclosure" .
.It "Bracket Quotes/Enclosure" .
.It "Double Quote macro/Enclosure" .
.It "Parenthesis Quote/Enclosure" .
.It "Single Quotes/Enclosure" .
.It "Prefix Macro" .
.El
.It "Extended  Arguments" .
.It "No\-Op or Normal Text Macro" .
.It "No Space Macro" .
.It "Section Cross References" .
.It "Symbolic Macro" .
.It "References and Citations" .
.It "Trade Names (Acronyms and Type Names)" .
.El
.It
.Tn "PAGE STRUCTURE DOMAIN"
.Bl -tag -width flag -compact -offset indent
.It "Section Headers" .
.It "Paragraphs and Line Spacing" .
.It "Keeps" .
.It "Displays" .
.It "Lists and Columns" .
.El
.It
.Tn "PREDEFINED STRINGS"
.It
.Tn "DIAGNOSTICS"
.It
.Tn "FORMATTING WITH GROFF, TROFF AND NROFF"
.It
.Tn "BUGS"
.El
.ne 7
.Sh TROFF IDIOSYNCRASIES
The
.Nm \-mdoc
package attempts to simplify the process of writing a man page.
Theoretically, one should not have to learn the dirty details of
.Xr troff 1
to use
.Nm \-mdoc ;
however, there are a few
limitations which are unavoidable and best gotten out
of the way.
And, too, be forewarned, this package is
.Em not
fast.
.Ss Macro Usage
As in
.Xr troff 1 ,
a macro is called by placing a
.Ql \&\.
(dot character)
at the beginning of
a line followed by the two character name for the macro.
Arguments may follow the macro separated by spaces.
It is the dot character at the beginning of the line which causes
.Xr troff 1
to interpret the next two characters as a macro name.
To place a
.Ql \&\.
(dot character)
at the beginning of a line in some context other than
a macro invocation, precede the
.Ql \&\.
(dot) with the
.Ql \e&
escape sequence.
The
.Ql \e&
translates literally to a zero width space, and is never displayed in the
output.
.Pp
In general,
.Xr troff 1
macros accept up to nine arguments, any
extra arguments are ignored.
Most macros in
.Nm \-mdoc
accept nine arguments and,
in limited cases, arguments may be continued or extended
on the
next line (See
.Sx Extended Arguments ) .
A few macros handle quoted arguments (see
.Sx Passing Space Characters in an Argument
below).
.Pp
Most of the
.Nm \-mdoc
general text domain and manual domain macros are special
in that their argument lists are
.Em parsed
for callable macro names.
This means an argument on the argument list which matches
a general text or manual domain macro name and is determined
to be callable will be executed
or called when it is processed.
In this case
the argument, although the name of a macro,
is not preceded by a
.Ql \&\.
(dot).
It is in this manner that many macros are nested; for
example
the option macro,
.Ql \&.Op ,
may
.Em call
the flag and argument macros,
.Ql \&Fl
and
.Ql \&Ar ,
to specify an optional flag with an argument:
.Bl -tag -width "\&.Op \&Fl s \&Ar bytes" -offset indent
.It Op Fl s Ar bytes
is produced by
.Li \&.Op \&Fl s \&Ar bytes
.El
.Pp
To prevent a two character
string from being interpreted as a macro name, precede
the string with the
escape sequence
.Ql \e& :
.Bl -tag -width "\&.Op \&Fl s \&Ar bytes" -offset indent
.It Op \&Fl s \&Ar bytes
is produced by
.Li \&.Op \e&Fl s \e&Ar bytes
.El
.Pp
Here the strings
.Ql \&Fl
and
.Ql \&Ar
are not interpreted as macros.
Macros whose argument lists are parsed for callable arguments
are referred to
as parsed and macros which may be called from an argument
list are referred to as callable
throughout this document and in the companion quick reference
manual
.Xr mdoc 7 .
This is a technical
.Em faux pas
as almost all of the macros in 
.Nm \-mdoc
are parsed, but as it was cumbersome to constantly refer to macros
as being callable and being able to call other macros,
the term parsed has been used.
.Ss Passing Space Characters in an Argument
Sometimes it is desirable to give as one argument a string
containing one or more blank space characters.
This may be necessary
to defeat the nine argument limit or to specify arguments to macros
which expect particular arrangement of items in the argument list.
For example,
the function macro
.Ql \&.Fn
expects the first argument to be the name of a function and any
remaining arguments to be function parameters.
As
.Tn "ANSI C"
stipulates the declaration of function parameters in the
parenthesized parameter list, each parameter is guaranteed
to be at minimum a two word string.
For example,
.Fa int foo .
.Pp
There are two possible ways to pass an argument which contains
an embedded space.
.Em Implementation note :
Unfortunately, the most convenient way
of passing spaces in between quotes by reassigning individual
arguments before parsing was fairly expensive speed wise
and space wise to implement in all the macros for
.Tn AT&T
.Xr troff .
It is not expensive for
.Xr groff
but for the sake of portability, has been limited
to the following macros which need
it the most:
.Pp
.Bl -tag -width 4n -offset indent -compact
.It Li \&Cd
Configuration declaration (section 4
.Sx SYNOPSIS )
.It Li \&Bl
Begin list (for the width specifier).
.It Li \&Em
Emphasized text.
.It Li \&Fn
Functions (sections two and four).
.It Li \&It
List items.
.It Li \&Li
Literal text.
.It Li \&Sy
Symbolic text.
.It Li \&%B
Book titles.
.It Li \&%J
Journal names.
.It Li \&%O
Optional notes for a reference.
.It Li \&%R
Report title (in a reference).
.It Li \&%T
Title of article in a book or journal.
.El
.Pp
One way of passing a string
containing blank spaces is to use the hard or unpaddable space character
.Ql \e\  ,
that is, a blank space preceded by the escape character
.Ql \e .
This method may be used with any macro but has the side effect
of interfering with the adjustment of text
over the length of a line.
.Xr Troff
sees the hard space as if it were any other printable character and
cannot split the string into blank or newline separated pieces as one
would expect.
The method is useful for strings which are not expected
to overlap a line boundary.
For example:
.Bl -tag -width "fetch(char *str)" -offset indent
.It Fn fetch char\ *str
is created by
.Ql \&.Fn fetch char\e *str
.It Fn fetch "char *str"
can also be created by
.Ql \&.Fn fetch "\\*q*char *str\\*q"
.El
.Pp
If the
.Ql \e
or quotes
were omitted,
.Ql \&.Fn
would see three arguments and
the result would be:
.Pp
.Dl Fn fetch char *str
.Pp
For an example of what happens when the parameter list overlaps
a newline boundary, see the
.Sx BUGS
section.
.Ss Trailing Blank Space Characters
.Xr Troff
can be confused by blank space characters at the end of a line.
It
is a wise preventive measure to globally remove all blank spaces
from <blank-space><end-of-line> character sequences.
Should the need
arise to force a blank character at the end of a line,
it may be forced with an unpaddable space and the
.Ql \e&
escape character.
For example,
.Ql string\e\ \e& .
.Ss Escaping Special Characters
Special characters
like the newline character
.Ql \en ,
are handled by replacing the
.Ql \e
with
.Ql \ee
(e.g.
.Ql \een )
to preserve
the backslash.
.Sh THE ANATOMY OF A MAN PAGE
The body of a man page is easily constructed from a basic
template found in the file:
.Bd -literal -offset indent
\&.\e" /usr/share/misc/mdoc.template:
\&.\e" The following six lines are required.
\&.Dd Month day, year
\&.Os OPERATING_SYSTEM [version/release]
\&.Dt DOCUMENT_TITLE [section number] [volume]
\&.Sh NAME
\&.Sh SYNOPSIS
\&.Sh DESCRIPTION
\&.\e" The following requests should be uncommented and
\&.\e" used where appropriate.  This next request is
\&.\e" for sections 2 and 3 function return values only.
\&.\e" .Sh RETURN VALUES
\&.\e" This next request is for sections 1, 6, 7 & 8 only
\&.\e" .Sh ENVIRONMENT
\&.\e" .Sh FILES
\&.\e" .Sh EXAMPLES
\&.\e" This next request is for sections 1, 6, 7 & 8 only
\&.\e"     (command return values (to shell) and
\&.\e"	  fprintf/stderr type diagnostics)
\&.\e" .Sh DIAGNOSTICS
\&.\e" The next request is for sections 2 and 3 error
\&.\e" and signal handling only.
\&.\e" .Sh ERRORS
\&.\e" .Sh SEE ALSO
\&.\e" .Sh STANDARDS
\&.\e" .Sh HISTORY
\&.\e" .Sh AUTHORS
\&.\e" .Sh BUGS
.Ed
.Pp
The first items in the template are the macros
.Pq Li \&.Dd , \&.Os , \&.Dt ;
the document date,
the operating system the man page or subject source is developed
or modified for,
and the man page title
.Pq Em in upper case
along with the section of the manual the page
belongs in.
These macros identify the page,
and are discussed below in
.Sx TITLE MACROS .
.Pp
The remaining items in the template are section headers
.Pq Li \&.Sh ;
of which
.Sx NAME ,
.Sx SYNOPSIS
and
.Sx DESCRIPTION
are mandatory.
The
headers are
discussed in
.Sx PAGE STRUCTURE DOMAIN ,
after
presentation of
.Sx MANUAL DOMAIN .
Several content macros are used to demonstrate page layout macros;
reading about content macros before page layout macros is
recommended.
.Sh TITLE MACROS
The title macros are the first portion of the page structure
domain, but are presented first and separate for someone who
wishes to start writing a man page yesterday.
Three header macros designate the document title or manual page title,
the operating system,
and the date of authorship.
These macros are one called once at the very beginning of the document
and are used to construct the headers and footers only.
.Bl -tag -width 6n
.It Li \&.Dt DOCUMENT_TITLE section# [volume]
The document title is the
subject of the man page and must be in
.Tn CAPITALS
due to troff
limitations.
The section number may be 1,\ ...,\ 9,
and if it is specified,
the volume title may be omitted.
A volume title may be arbitrary or one of the following:
.\" .Cl
.\" USD	UNIX User's Supplementary Documents
.\" .Cl
.\" PS1	UNIX Programmer's Supplementary Documents
.Pp
.Bl -column SMM -offset indent -compact
.It Li AMD	NetBSD Ancestral Manual Documents
.It Li SMM	NetBSD System Manager's Manual
.It Li URM	NetBSD Reference Manual
.It Li PRM	NetBSD Programmer's Manual
.It Li KM	NetBSD Kernel Manual
.El
.Pp
The default volume labeling is
.Li URM
for sections 1, 6, and 7;
.Li SMM
for section 8;
.Li PRM
for sections 2, 3, 4, and 5;
.Li KM
for section 9.
.\" .Cl
.\" MMI	UNIX Manual Master Index
.\" .Cl
.\" CON	UNIX Contributed Software Manual
.\" .Cl
.\" LOC	UNIX Local Manual
.It Li \&.Os operating_system release#
The name of the operating system
should be the common acronym, e.g.
.Tn BSD
or
.Tn ATT .
The release should be the standard release
nomenclature for the system specified, e.g. 4.3, 4.3+Tahoe, V.3,
V.4.
Unrecognized arguments are displayed as given in the page footer.
For instance, a typical footer might be:
.Pp
.Dl \&.Os BSD 4.3
.Pp
or for a locally produced set
.Pp
.Dl \&.Os CS Department
.Pp
The Berkeley default,
.Ql \&.Os
without an argument, has been defined as
.Nx 1.4
in the site specific file
.Pa /usr/share/tmac/tmac.doc-common .
Note, if the
.Ql \&.Os
macro is not present, the bottom left corner of the page
will be ugly.
.It Li \&.Dd month day, year
The date should be written formally:
.Pp
.ne 5
.Dl January 25, 1989
.sp
Note that the date must not be placed in quotes!
.El
.Sh MANUAL DOMAIN
.Ss What's in a name...
The manual domain macro names are derived from the day to day
informal language used to describe commands, subroutines and related
files.
Slightly
different variations of this language are used to describe
the three different aspects of writing a man page.
First, there is the description of
.Nm \-mdoc
macro request usage.
Second is the description of a
.Ux
command
.Em with
.Nm \-mdoc
macros and third,
the
description of a command to a user in the verbal sense;
that is, discussion of a command in the text of a man page.
.Pp
In the first case,
.Xr troff 1
macros are themselves a type of command;
the general syntax for a troff command is:
.Bd -filled -offset indent
\&.Va argument1 argument2 ... argument9
.Ed
.Pp
The
.Ql \&.Va
is a macro command or request, and anything following it is an argument to
be processed.
In the second case,
the description of a
.Ux
command using the content macros is a
bit more involved;
a typical
.Sx SYNOPSIS
command line might be displayed as:
.Bd -filled -offset indent
.Nm filter
.Op Fl flag
.Ar infile outfile
.Ed
.Pp
Here,
.Nm filter
is the command name and the
bracketed string
.Fl flag
is a
.Em flag
argument designated as optional by the option brackets.
In
.Nm \-mdoc
terms,
.Ar infile
and
.Ar outfile
are
called
.Em arguments .
The macros which formatted the above example:
.Bd -literal -offset indent
\&.Nm filter
\&.Op \&Fl flag
\&.Ar infile outfile
.Ed
.Pp
In the third case, discussion of commands and command syntax
includes both examples above, but may add more detail.
The
arguments
.Ar infile
and
.Ar outfile
from the example above might be referred to as
.Em operands
or
.Em file arguments .
Some command line argument lists are quite long:
.Bl -tag -width make -offset indent
.It Nm make
.Op Fl eiknqrstv
.Op Fl D Ar variable
.Op Fl d Ar flags
.Op Fl f Ar makefile
.Bk -words
.Op Fl I Ar directory
.Ek
.Op Fl j Ar max_jobs
.Op Ar variable=value
.Bk -words
.Op Ar target ...
.Ek
.El
.Pp
Here one might talk about the command
.Nm make
and qualify the argument
.Ar makefile ,
as an argument to the flag,
.Fl f ,
or discuss the optional
file
operand
.Ar target .
In the verbal context, such detail can prevent confusion,
however the
.Nm \-mdoc
package
does not have a macro for an argument
.Em to
a flag.
Instead the
.Ql \&Ar
argument macro is used for an operand or file argument like
.Ar target
as well as an argument to a flag like
.Ar variable .
The make command line was produced from:
.Bd -literal -offset indent
\&.Nm make
\&.Op Fl eiknqrstv
\&.Op Fl D Ar variable
\&.Op Fl d Ar flags
\&.Op Fl f Ar makefile
\&.Op Fl I Ar directory
\&.Op Fl j Ar max_jobs
\&.Op Ar variable=value
\&.Bk -words
\&.Op Ar target ...
\&.Ek
.Ed
.Pp
The
.Ql \&.Bk
and
.Ql \&.Ek
macros are explained in
.Sx Keeps .
.Ss General Syntax
The manual domain and general text domain macros share a similar
syntax with a few minor deviations:
.Ql \&.Ar ,
.Ql \&.Fl ,
.Ql \&.Nm ,
and
.Ql \&.Pa
differ only when called without arguments;
.Ql \&.Fn
and
.Ql \&.Xr
impose an order on their argument lists
and the
.Ql \&.Op
and
.Ql \&.Fn
macros
have nesting limitations.
All content macros
are capable of recognizing and properly handling punctuation,
provided each punctuation character is separated by a leading space.
If an request is given:
.Pp
.Dl \&.Li sptr, ptr),
.Pp
The result is:
.Pp
.Dl Li sptr, ptr),
.Pp
The punctuation is not recognized and all is output in the
literal font. If the punctuation is separated by a leading
white space:
.Pp
.Dl \&.Li "sptr , ptr ) ,"
.Pp
The result is:
.Pp
.Dl Li sptr , ptr ) ,
.Pp
The punctuation is now recognized and is output in the
default font distinguishing it from the strings in literal font.
.Pp
To remove the special meaning from a punctuation character
escape it with
.Ql \e& .
.Xr Troff
is limited as a macro language, and has difficulty
when presented with a string containing
a member of the mathematical, logical or
quotation set:
.Bd -literal -offset indent-two
\&{+,\-,/,*,\&%,<,>,<=,>=,=,==,&,`,',"}
.Ed
.Pp
The problem is that
.Xr troff
may assume it is supposed to actually perform the operation
or evaluation suggested by the characters.  To prevent
the accidental evaluation of these characters,
escape them with
.Ql \e& .
Typical syntax is shown in the first content macro displayed
below,
.Ql \&.Ad .
.Ss Address Macro
The address macro identifies an address construct
of the form addr1[,addr2[,addr3]].
.Pp
.Dl Usage: .Ad address ... \*(Pu
.Bl -tag -width ".Ad f1 , f2 , f3 :" -compact -offset 14n
.It Li \&.Ad addr1
.Ad addr1
.It Li \&.Ad addr1\ .
.Ad addr1 .
.It Li \&.Ad addr1\ , file2
.Ad addr1 , file2
.It Li \&.Ad f1\ , f2\ , f3\ :
.Ad f1 , f2 , f3 :
.It Li \&.Ad addr\ )\ )\ ,
.Ad addr ) ) ,
.El
.Pp
It is an error to call
.Li \&.Ad
without arguments.
.Li \&.Ad
is callable by other macros and is parsed.
.Ss Argument Macro
The
.Li \&.Ar
argument macro may be used whenever
a command line argument is referenced.
.Pp
.Dl Usage: .Ar argument ... \*(Pu
.Bl -tag -width ".Ar file1 file2" -compact -offset 15n
.It Li \&.Ar
.Ar
.It Li \&.Ar file1
.Ar file1
.It Li \&.Ar file1\ .
.Ar file1 .
.It Li \&.Ar file1 file2
.Ar file1 file2
.It Li \&.Ar f1 f2 f3\ :
.Ar f1 f2 f3 :
.It Li \&.Ar file\ )\ )\ ,
.Ar file ) ) ,
.El
.Pp
If
.Li \&.Ar
is called without arguments
.Ql Ar
is assumed.
The
.Li \&.Ar
macro is parsed and is callable.
.Ss Configuration Declaration (section four only)
The
.Ql \&.Cd
macro is used to demonstrate a
.Xr config 8
declaration for a device interface in a section four manual.
This macro accepts quoted arguments (double quotes only).
.Pp
.Bl -tag -width "device le0 at scode?" -offset indent
.It Cd "device le0 at scode?"
produced by:
.Ql ".Cd device le0 at scode?" .
.El
.Ss Command Modifier
The command modifier is identical to the
.Ql \&.Fl
(flag) command with the exception
the
.Ql \&.Cm
macro does not assert a dash
in front of every argument.
Traditionally flags are marked by the
preceding dash, some commands or subsets of commands do not use them.
Command modifiers may also be specified in conjunction with interactive
commands such as editor commands.
See
.Sx Flags .
.Ss Defined Variables
A variable which is defined in an include file is specified
by the macro
.Ql \&.Dv .
.Pp
.Dl Usage: .Dv defined_variable ... \*(Pu
.Bl -tag -width ".Dv MAXHOSTNAMELEN" -compact -offset 14n
.It Li ".Dv MAXHOSTNAMELEN"
.Dv MAXHOSTNAMELEN
.It Li ".Dv TIOCGPGRP )"
.Dv TIOCGPGRP )
.El
.Pp
It is an error to call
.Ql \&.Dv
without arguments.
.Ql \&.Dv
is parsed and is callable.
.Ss Errno's (Section two only)
The
.Ql \&.Er
errno macro specifies the error return value
for section two library routines.
The second example
below shows
.Ql \&.Er
used with the
.Ql \&.Bq
general text domain macro, as it would be used in
a section two manual page.
.Pp
.Dl Usage: .Er ERRNOTYPE ... \*(Pu
.Bl -tag -width ".Bq Er ENOTDIR" -compact -offset 14n
.It Li \&.Er ENOENT
.Er ENOENT
.It Li \&.Er ENOENT\ )\ ;
.Er ENOENT ) ;
.It Li \&.Bq \&Er ENOTDIR
.Bq Er ENOTDIR
.El
.Pp
It is an error to call
.Ql \&.Er
without arguments.
The
.Ql \&.Er
macro is parsed and is callable.
.Ss Environment Variables
The
.Ql \&.Ev
macro specifies an environment variable.
.Pp
.Dl Usage: .Ev argument ... \*(Pu
.Bl -tag -width ".Ev PRINTER ) ) ," -compact -offset 14n
.It Li \&.Ev DISPLAY
.Ev  DISPLAY
.It Li \&.Ev PATH\ .
.Ev PATH .
.It Li \&.Ev PRINTER\ )\ )\ ,
.Ev PRINTER ) ) ,
.El
.Pp
It is an error to call
.Ql \&.Ev
without arguments.
The
.Ql \&.Ev
macro is parsed and is callable.
.Ss Function Argument
The
.Ql \&.Fa
macro is used to refer to function arguments (parameters)
outside of the
.Sx SYNOPSIS
section of the manual or inside
the
.Sx SYNOPSIS
section should a parameter list be too
long for the
.Ql \&.Fn
macro and the enclosure macros
.Ql \&.Fo
and
.Ql \&.Fc
must be used.
.Ql \&.Fa
may also be used to refer to structure members.
.Pp
.Dl Usage: .Fa function_argument ... \*(Pu
.Bl -tag -width ".Fa d_namlen\ )\ )\ ," -compact -offset 14n
.It Li \&.Fa d_namlen\ )\ )\ ,
.Fa d_namlen ) ) ,
.It Li \&.Fa iov_len
.Fa iov_len
.El
.Pp
It is an error to call
.Ql \&.Fa
without arguments.
.Ql \&.Fa
is parsed and is callable.
.Ss Function Declaration
The
.Ql \&.Fd
macro is used in the
.Sx SYNOPSIS
section with section two or three
functions.
The
.Ql \&.Fd
macro does not call other macros and is not callable by other
macros.
.Pp
.Dl Usage: .Fd include_file (or defined variable)
.Pp
In the
.Sx SYNOPSIS
section a
.Ql \&.Fd
request causes a line break if a function has already been presented
and a break has not occurred.
This leaves a nice vertical space
in between the previous function call and the declaration for the
next function.
.Ss Flags
The
.Ql \&.Fl
macro handles command line flags.
It prepends
a dash,
.Ql \- ,
to the flag.
For interactive command flags, which
are not prepended with a dash, the
.Ql \&.Cm
(command modifier)
macro is identical, but without the dash.
.Pp
.Dl Usage: .Fl argument ... \*(Pu
.Bl -tag -width ".Fl \-s \-t \-v" -compact -offset 14n
.It Li \&.Fl
.Fl
.It Li \&.Fl cfv
.Fl cfv
.It Li \&.Fl cfv\ .
.Fl cfv .
.It Li \&.Fl s v t
.Fl s v t
.It Li \&.Fl -\ ,
.Fl - ,
.It Li \&.Fl xyz\ )\ ,
.Fl xyz ) ,
.El
.Pp
The
.Ql \&.Fl
macro without any arguments results
in a dash representing stdin/stdout.
Note that giving
.Ql \&.Fl
a single dash, will result in two dashes.
The
.Ql \&.Fl
macro is parsed and is callable.
.Ss Functions (library routines)
The .Fn macro is modeled on ANSI C conventions.
.Bd -literal
Usage: .Fn [type] function [[type] parameters ... \*(Pu]
.Ed
.Bl -tag -width ".Fn .int align. .const * char *sptrsxx" -compact
.It Li "\&.Fn getchar"
.Fn getchar
.It Li "\&.Fn strlen ) ,"
.Fn strlen ) ,
.It Li \&.Fn "\\*qint align\\*q" "\\*qconst * char *sptrs\\*q" ,
.Fn "int align" "const * char *sptrs" ,
.El
.Pp
It is an error to call
.Ql \&.Fn
without any arguments.
The
.Ql \&.Fn
macro
is parsed and is callable,
note that any call to another macro signals the end of
the
.Ql \&.Fn
call (it will close-parenthesis at that point).
.Pp
For functions that have more than eight parameters (and this
is rare), the
macros
.Ql \&.Fo
(function open)
and
.Ql \&.Fc
(function close)
may be used with
.Ql \&.Fa
(function argument)
to get around the limitation. For example:
.Bd -literal -offset indent
\&.Fo "int res_mkquery"
\&.Fa "int op"
\&.Fa "char *dname"
\&.Fa "int class"
\&.Fa "int type"
\&.Fa "char *data"
\&.Fa "int datalen"
\&.Fa "struct rrec *newrr"
\&.Fa "char *buf"
\&.Fa "int buflen"
\&.Fc
.Ed
.Pp
Produces:
.Bd -filled -offset indent
.Fo "int res_mkquery"
.Fa "int op"
.Fa "char *dname"
.Fa "int class"
.Fa "int type"
.Fa "char *data"
.Fa "int datalen"
.Fa "struct rrec *newrr"
.Fa "char *buf"
.Fa "int buflen"
.Fc
.Ed
.Pp
The
.Ql \&.Fo
and
.Ql \&.Fc
macros are parsed and are callable.
In the
.Sx SYNOPSIS
section, the function will always begin at
the beginning of line.
If there is more than one function
presented in the
.Sx SYNOPSIS
section and a function type has not been
given, a line break will occur, leaving a nice vertical space
between the current function name and the one prior.
At the moment,
.Ql \&.Fn
does not check its word boundaries
against troff line lengths and may split across a newline
ungracefully.
This will be fixed in the near future.
.Ss Function Type
This macro is intended for the
.Sx SYNOPSIS
section.
It may be used
anywhere else in the man page without problems, but its main purpose
is to present the function type in kernel normal form for the
.Sx SYNOPSIS
of sections two and three
(it causes a page break allowing the function name to appear
on the next line).
.Pp
.Dl Usage: .Ft type ... \*(Pu
.Bl -tag -width "\&.Ft struct stat" -offset 14n -compact
.It Li \&.Ft struct stat
.Ft struct stat
.El
.Pp
The
.Ql \&.Ft
request is not callable by other macros.
.Ss Interactive Commands
The
.Ql \&.Ic
macro designates an interactive or internal command.
.Pp
.Dl Usage: .Li argument ... \*(Pu
.Bl -tag -width ".Ic setenv , unsetenvxx" -compact -offset 14n
.It Li \&.Ic :wq
.Ic :wq
.It Li \&.Ic do while {...}
.Ic do while {...}
.It Li \&.Ic setenv\ , unsetenv
.Ic setenv , unsetenv
.El
.Pp
It is an error to call
.Ql \&.Ic
without arguments.
The
.Ql \&.Ic
macro is parsed and is callable.
.Ss Literals
The
.Ql \&.Li
literal macro may be used for special characters,
variable constants, anything which should be displayed as it
would be typed.
.Pp
.Dl Usage: .Li argument ... \*(Pu
.Bl -tag -width ".Li cntrl-D ) ,"  -compact -offset 14n
.It Li \&.Li \een
.Li \en
.It Li \&.Li M1 M2 M3\ ;
.Li M1 M2 M3 ;
.It Li \&.Li cntrl-D\ )\ ,
.Li cntrl-D ) ,
.It Li \&.Li 1024\ ...
.Li 1024 ...
.El
.Pp
The
.Ql \&.Li
macro is parsed and is callable.
.Ss Name Macro
The
.Ql \&.Nm
macro is used for the document title or subject name.
It has the peculiarity of remembering the first
argument it was called with, which should
always be the subject name of the page.
When called without
arguments,
.Ql \&.Nm
regurgitates this initial name for the sole purpose
of making less work for the author.
If trailing punctuation is required with this feature,
use
.Qq
as a first argument to
.Ql \&.Nm .
Note:
a section two
or three document function name is addressed with the
.Ql \&.Nm
in the
.Sx NAME
section, and with
.Ql \&.Fn
in the
.Sx SYNOPSIS
and remaining sections.
For interactive commands, such as the
.Ql while
command keyword in
.Xr csh 1 ,
the
.Ql \&.Ic
macro should be used.
While the
.Ql \&.Ic
is nearly identical
to
.Ql \&.Nm ,
it can not recall the first argument it was invoked with.
.Pp
.Dl Usage: .Nm argument ... \*(Pu
.Bl -tag -width ".Nm mdoc.samples" -compact -offset 14n
.It Li \&.Nm mdoc.samples
.Nm  mdoc.samples
.It Li \&.Nm \e-mdoc
.Nm \-mdoc
.It Li \&.Nm foo\ )\ )\ ,
.Nm foo ) ) ,
.It Li \&.Nm
.Nm
.It Li \&.Nm \&"\&"\ :
.Nm "" :
.El
.Pp
The
.Ql \&.Nm
macro is parsed and is callable.
.Ss Options
The
.Ql \&.Op
macro
places option brackets around the any remaining arguments on the command
line, and places any
trailing punctuation outside the brackets.
The macros
.Ql \&.Oc
and
.Ql \&.Oo
may be used across one or more lines.
.Pp
.Dl Usage: .Op options ... \*(Pu
.Bl -tag -width ".Op Fl c Ar objfil Op Ar corfil ," -compact -offset indent
.It Li \&.Op
.Op
.It Li ".Op Fl k"
.Op Fl k
.It Li ".Op Fl k ) ."
.Op Fl k ) .
.It Li ".Op Fl k Ar kookfile"
.Op Fl k Ar kookfile
.It Li ".Op Fl k Ar kookfile ,"
.Op Fl k Ar kookfile ,
.It Li ".Op Ar objfil Op Ar corfil"
.Op Ar objfil Op Ar corfil
.It Li ".Op Fl c Ar objfil Op Ar corfil ,"
.Op Fl c Ar objfil Op Ar corfil ,
.It Li \&.Op word1 word2
.Op word1 word2
.El
.Pp
The
.Ql \&.Oc
and
.Ql \&.Oo
macros:
.Bd -literal -offset indent
\&.Oo
\&.Op \&Fl k \&Ar kilobytes
\&.Op \&Fl i \&Ar interval
\&.Op \&Fl c \&Ar count
\&.Oc
.Ed
.Pp
Produce:
.Oo
.Op Fl k Ar kilobytes
.Op Fl i Ar interval
.Op Fl c Ar count
.Oc
.Pp
The macros
.Ql \&.Op ,
.Ql \&.Oc
and
.Ql \&.Oo
are parsed and are callable.
.Ss Pathnames
The
.Ql \&.Pa
macro formats path or file names.
.Pp
.Dl Usage: .Pa pathname \*(Pu
.Bl -tag -width ".Pa /tmp/fooXXXXX ) ." -compact -offset 14n
.It Li \&.Pa /usr/share
.Pa /usr/share
.It Li \&.Pa /tmp/fooXXXXX\ )\ .
.Pa /tmp/fooXXXXX ) .
.El
.Pp
The
.Ql \&.Pa
macro is parsed and is callable.
.Ss Variables
Generic variable reference:
.Pp
.Dl Usage: .Va variable ... \*(Pu
.Bl -tag -width ".Va char s ] ) ) ," -compact -offset 14n
.It Li \&.Va count
.Va count
.It Li \&.Va settimer ,
.Va settimer ,
.It Li \&.Va int\ *prt\ )\ :
.Va int\ *prt ) :
.It Li \&.Va char\ s\ ]\ )\ )\ ,
.Va char\ s ] ) ) ,
.El
.Pp
It is an error to call
.Ql \&.Va
without any arguments.
The
.Ql \&.Va
macro is parsed and is callable.
.Ss Manual Page Cross References
The
.Ql \&.Xr
macro expects the first argument to be
a manual page name, and the second argument, if it exists,
to be either a section page number or punctuation.
Any
remaining arguments are assumed to be punctuation.
.Pp
.Dl Usage: .Xr man_page [1,...,9] \*(Pu
.Bl -tag -width ".Xr mdoc 7 ) ) ," -compact -offset 14n
.It Li \&.Xr mdoc
.Xr mdoc
.It Li \&.Xr mdoc\ ,
.Xr mdoc ,
.It Li \&.Xr mdoc 7
.Xr mdoc 7
.It Li \&.Xr mdoc 7\ )\ )\ ,
.Xr mdoc 7 ) ) ,
.El
.Pp
The
.Ql \&.Xr
macro is parsed and is callable.
It is an error to call
.Ql \&.Xr
without
any arguments.
.Sh GENERAL TEXT DOMAIN
.Ss AT&T Macro
.Bd -literal -offset indent -compact
Usage: .At [v1 .. v7 | 32v | V.1 | V.4] ... \*(Pu
.Ed
.Bl -tag -width ".At v6 ) ," -compact -offset 14n
.It Li ".At"
.At
.It Li ".At v6 ."
.At v6 .
.El
.Pp
The
.Ql \&.At
macro is
.Em not
parsed and
.Em not
callable. It accepts at most two arguments.
.Ss BSD Macro
.Dl Usage: .Bx [Version/release] ... \*(Pu
.Bl -tag -width ".Bx 4.3 ) ," -compact -offset 14n
.It Li ".Bx"
.Bx
.It Li ".Bx 4.3 ."
.Bx 4.3 .
.El
.Pp
The
.Ql \&.Bx
macro is parsed and is callable.
.Ss NetBSD Macro
.Dl Usage: .Nx [Version/release] ... \*(Pu
.Bl -tag -width ".Nx 1.4 ) ," -compact -offset 14n
.It Li ".Nx"
.Nx
.It Li ".Nx 1.4 ."
.Nx 1.4 .
.El
.Pp
The
.Ql \&.Nx
macro is parsed and is callable.
.Ss FreeBSD Macro
.Dl Usage: .Fx [Version/release] ... \*(Pu
.Bl -tag -width ".Fx 2.2 ) ," -compact -offset 14n
.It Li ".Fx"
.Fx
.It Li ".Fx 2.2 ."
.Fx 2.2 .
.El
.Pp
The
.Ql \&.Fx
macro is parsed and is callable.
.Ss UNIX Macro
.Dl Usage: .Ux ... \*(Pu
.Bl -tag -width ".Ux 4.3 ) ," -compact -offset 14n
.It Li ".Ux"
.Ux
.El
.Pp
The
.Ql \&.Ux
macro is parsed and is callable.
.Ss Emphasis Macro
Text may be stressed or emphasized with the
.Ql \&.Em
macro.
The usual font for emphasis is italic.
.Pp
.Dl Usage: .Em argument ... \*(Pu
.Bl -tag -width ".Em vide infra ) ) ," -compact -offset 14n
.It Li ".Em does not"
.Em does not
.It Li ".Em exceed 1024 ."
.Em exceed 1024 .
.It Li ".Em vide infra ) ) ,"
.Em vide infra ) ) ,
.El
.\" .Pp
.\" The emphasis can be forced across several lines of text by using
.\" the
.\" .Ql \&.Bf
.\" macro discussed in
.\" .Sx Modes
.\" under
.\" .Sx PAGE STRUCTURE DOMAIN .
.\" .Pp
.\" .Bf -emphasis
.\" We are certain the reason most people desire a Harvard MBA
.\" so they can become to be successful philanthropists.  Only
.\" mathematicians and physicists go to graduate school strictly
.\" to acquire infinite wealthy and fame. Its that inifinity
.\" word that does it to them. Ruins them.
.\" .Ef
.Pp
The
.Ql \&.Em
macro is parsed and is callable.
It is an error to call
.Ql \&.Em
without arguments.
.Ss Enclosure and Quoting Macros
The concept of enclosure is similar to quoting.
The object being to enclose one or more strings between
a pair of characters like quotes or parentheses.
The terms quoting and enclosure are used
interchangeably throughout this document.
Most of the
one line enclosure macros end
in small letter
.Ql q
to give a hint of quoting, but there are a few irregularities.
For each enclosure macro
there is also a pair of open and close macros which end
in small letters
.Ql o
and
.Ql c
respectively.
These can be used across one or more lines of text
and while they have nesting limitations, the one line quote macros
can be used inside
of them.
.Pp
.ne 5
.Bd -filled -offset indent
.Bl -column "quote " "close " "open " "Enclose Stringx(in XX) " XXstringXX
.Em " Quote	 Close	 Open	Function	Result"
\&.Aq	.Ac	.Ao	Angle Bracket Enclosure	<string>
\&.Bq	.Bc	.Bo	Bracket Enclosure	[string]
\&.Dq	.Dc	.Do	Double Quote	``string''
	.Ec	.Eo	Enclose String (in XX)	XXstringXX
\&.Pq	.Pc	.Po	Parenthesis Enclosure	(string)
\&.Ql			Quoted Literal	`st' or string
\&.Qq	.Qc	.Qo	Straight Double Quote	"string"
\&.Sq	.Sc	.So	Single Quote	`string'
.El
.Ed
.Pp
Except for the irregular macros noted below, all
of the quoting macros are parsed and callable.
All handle punctuation properly, as long as it
is presented one character at a time and separated by spaces.
The quoting macros examine opening and closing punctuation
to determine whether it comes before or after the
enclosing string. This makes some nesting possible.
.Bl -tag -width xxx,xxxx
.It Li \&.Ec , \&.Eo
These macros expect the first argument to be the
opening and closing strings respectively.
.It Li \&.Ql
The quoted literal macro behaves differently for
.Xr troff
than
.Xr nroff .
If formatted with
.Xr nroff ,
a quoted literal is always quoted. If formatted with
troff, an item is only quoted if the width
of the item is less than three constant width characters.
This is to make short strings more visible where the font change
to literal (constant width) is less noticeable.
.It Li \&.Pf
The prefix macro is not callable, but it is parsed:
.Bl -tag -width "(namexx" -offset indent
.It Li ".Pf ( Fa name2"
becomes
.Pf ( Fa name2 .
.El
.It Li \&.Ns
The
.Ql \&.Ns
(no space) macro, which
.Em is
callable,
performs the analogous suffix function.
.It Li ".Ap
The \&.Ap macro inserts an apostrophe and exits any special text modes,
continuing in
.Li \&.No
mode.
.El
.Pp
.ne 4
Examples of quoting:
.Bl -tag -width ".Aq Pa ctype.h ) ,xxxxxxxx" -compact -offset indent
.It Li \&.Aq
.Aq
.It Li \&.Aq \&Ar ctype.h\ )\ ,
.Aq Ar ctype.h ) ,
.It Li \&.Bq
.Bq
.It Li \&.Bq \&Em Greek \&, French \&.
.Bq Em Greek , French .
.It Li \&.Dq
.Dq
.It Li ".Dq string abc ."
.Dq string abc .
.It Li ".Dq \'^[A-Z]\'"
.Dq \'^[A-Z]\'
.It Li "\&.Ql man mdoc"
.Ql man mdoc
.It Li \&.Qq
.Qq
.It Li "\&.Qq string ) ,"
.Qq string ) ,
.It Li "\&.Qq string Ns ),"
.Qq string Ns ),
.It Li \&.Sq
.Sq
.It Li "\&.Sq string
.Sq string
.It Li "\&.Em or Ap ing
.Em or Ap ing
.El
.Pp
For a good example of nested enclosure macros, see the
.Ql \&.Op
option macro.
It was created from the same
underlying enclosure macros as those presented in the list
above.
The
.Ql \&.Xo
and
.Ql \&.Xc
extended argument list macros
were also built from the same underlying routines and are a good
example of
.Nm \-mdoc
macro usage at its worst.
.Ss No\-Op or Normal Text Macro
The macro
.Li \&.No
is
a hack for words in a macro command line which should
.Em not
be formatted and follows the conventional syntax
for content macros.
.Ss No Space Macro
The
.Ql \&.Ns
macro eliminates unwanted spaces in between macro requests.
It is useful for old style argument lists where there is no space
between the flag and argument:
.Bl -tag -width ".Op Fl I Ns Ar directoryxx" -offset indent
.It Li ".Op Fl I Ns Ar directory"
produces
.Op Fl I Ns Ar directory
.El
.Pp
Note: the
.Ql \&.Ns
macro always invokes the
.Ql \&.No
macro after eliminating the space unless another macro name
follows it.
The macro
.Ql \&.Ns
is parsed and is callable.
.Ss Section Cross References
The
.Ql \&.Sx
macro designates a reference to a section header
within the same document.
It is parsed and is callable.
.Pp
.Bl -tag -width "Li \&.Sx FILES" -offset 14n
.It Li \&.Sx FILES
.Sx FILES
.El
.Ss Symbolic
The symbolic emphasis macro is generally a boldface macro in
either the symbolic sense or the traditional English usage.
.Pp
.Dl Usage: .Sy symbol ... \*(Pu
.Bl -tag -width ".Sy Important Noticex" -compact -offset 14n
.It Li \&.Sy Important Notice
.Sy Important Notice
.El
.Pp
The
.Ql \&.Sy
macro is parsed and is callable.
Arguments to
.Ql \&.Sy
may be quoted.
.Ss References and Citations
The following macros make a modest attempt to handle references.
At best, the macros make it convenient to manually drop in a subset of
refer style references.
.Pp
.Bl -tag -width 6n -offset indent -compact
.It Li ".Rs"
Reference Start.
Causes a line break and begins collection
of reference information until the
reference end macro is read.
.It Li ".Re"
Reference End.
The reference is printed.
.It Li ".%A"
Reference author name, one name per invocation.
.It Li ".%B"
Book title.
.It Li ".\&%C"
City/place.
.It Li ".\&%D"
Date.
.It Li ".%J"
Journal name.
.It Li ".%N"
Issue number.
.It Li ".%O"
Optional information.
.It Li ".%P"
Page number.
.It Li ".%R"
Report name.
.It Li ".%T"
Title of article.
.It Li ".%V"
Volume(s).
.El
.Pp
The macros beginning with
.Ql %
are not callable, and are parsed only for the trade name macro which
returns to its caller.
(And not very predictably at the moment either.)
The purpose is to allow trade names
to be pretty printed in
.Xr troff Ns / Ns Xr ditroff
output.
.Ss Trade Names (or Acronyms and Type Names)
The trade name macro is generally a small caps macro for
all upper case words longer than two characters.
.Pp
.Dl Usage: .Tn symbol ... \*(Pu
.Bl -tag -width ".Tn ASCII" -compact -offset 14n
.It Li \&.Tn DEC
.Tn DEC
.It Li \&.Tn ASCII
.Tn ASCII
.El
.Pp
The
.Ql \&.Tn
macro
is parsed and is callable by other macros.
.Ss Extended Arguments
The
.Li \&.Xo
and
.Li \&.Xc
macros allow one to extend an argument list
on a macro boundary.
Argument lists cannot
be extended within a macro
which expects all of its arguments on one line such
as
.Ql \&.Op .
.Pp
Here is an example of
.Ql \&.Xo
using the space mode macro to turn spacing off:
.Bd -literal -offset indent
\&.Sm off
\&.It Xo Sy I Ar operation
\&.No \een Ar count No \een
\&.Xc
\&.Sm on
.Ed
.Pp
Produces
.Bd -filled -offset indent
.Bl -tag -width flag -compact
.Sm off
.It Xo Sy I Ar operation
.No \en Ar count No \en
.Xc
.Sm on
.El
.Ed
.Pp
Another one:
.Bd -literal -offset indent
\&.Sm off
\&.It Cm S No \&/ Ar old_pattern Xo
\&.No \&/ Ar new_pattern
\&.No \&/ Op Cm g
\&.Xc
\&.Sm on
.Ed
.Pp
Produces
.Bd -filled -offset indent
.Bl -tag -width flag -compact
.Sm off
.It Cm S No \&/ Ar old_pattern Xo
.No \&/ Ar new_pattern
.No \&/ Op Cm g
.Xc
.Sm on
.El
.Ed
.Pp
Another example of
.Ql \&.Xo
and using enclosure macros:
Test the value of an variable.
.Bd -literal -offset indent
\&.It Xo
\&.Ic .ifndef
\&.Oo \e&! Oc Ns Ar variable
\&.Op Ar operator variable ...
\&.Xc
.Ed
.Pp
Produces
.Bd -filled -offset indent
.Bl -tag -width flag -compact
.It Xo
.Ic .ifndef
.Oo \&! Oc Ns Ar variable
.Op Ar operator variable ...
.Xc
.El
.Ed
.Pp
All of the above examples have used the
.Ql \&.Xo
macro on the argument list of the
.Ql \&.It
(list-item)
macro.
The extend macros are not used very often, and when they are
it is usually to extend the list-item argument list.
Unfortunately, this is also where the extend macros are the
most finicky.
In the first two examples, spacing was turned off;
in the third, spacing was desired in part of the output but
not all of it.
To make these macros work in this situation make sure
the
.Ql \&.Xo
and
.Ql \&.Xc
macros are placed as shown in the third example.
If the
.Ql \&.Xo
macro is not alone on the
.Ql \&.It
argument list, spacing will be unpredictable.
The
.Ql \&.Ns
(no space macro)
must not occur as the first or last macro on a line
in this situation.
Out of 900 manual pages (about 1500 actual pages)
currently released with
.Bx
only fifteen use the
.Ql \&.Xo
macro.
.Sh PAGE STRUCTURE DOMAIN
.Ss Section Headers
The first three
.Ql \&.Sh
section header macros
list below are required in every
man page.
The remaining section headers
are recommended at the discretion of the author
writing the manual page.
The
.Ql \&.Sh
macro can take up to nine arguments.
It is parsed and but is not callable.
.Bl -tag -width ".Sh SYNOPSIS"
.It \&.Sh NAME
The
.Ql \&.Sh NAME
macro is mandatory.
If not specified,
the headers, footers and page layout defaults
will not be set and things will be rather unpleasant.
The
.Sx NAME
section consists of at least three items.
The first is the
.Ql \&.Nm
name macro naming the subject of the man page.
The second is the Name Description macro,
.Ql \&.Nd ,
which separates the subject
name from the third item, which is the description.
The
description should be the most terse and lucid possible,
as the space available is small.
.It \&.Sh SYNOPSIS
The
.Sx SYNOPSIS
section describes the typical usage of the
subject of a man page.
The  macros required
are either
.Ql ".Nm" ,
.Ql ".Cd" ,
.Ql ".Fn" ,
(and possibly
.Ql ".Fo" ,
.Ql ".Fc" ,
.Ql ".Fd" ,
.Ql ".Ft"
macros).
The function name
macro
.Ql ".Fn"
is required
for manual page sections 2 and 3, the command and general
name macro
.Ql \&.Nm
is required for sections 1, 5, 6, 7, 8.
Section 4 manuals require a
.Ql ".Nm" , ".Fd"
or a
.Ql ".Cd"
configuration device usage macro.
Several other macros may be necessary to produce
the synopsis line as shown below:
.Pp
.Bd -filled -offset indent
.Nm cat
.Op Fl benstuv
.Op Fl
.Ar
.Ed
.Pp
The following macros were used:
.Pp
.Dl \&.Nm cat
.Dl \&.Op \&Fl benstuv
.Dl \&.Op \&Fl
.Dl \&.Ar
.Pp
.Sy Note :
The macros
.Ql \&.Op ,
.Ql \&.Fl ,
and
.Ql \&.Ar
recognize the pipe bar character
.Ql \*(Ba ,
so a command line such as:
.Pp
.Dl ".Op Fl a | Fl b"
.Pp
will not go orbital.
.Xr Troff
normally interprets a \*(Ba as a special operator.
See
.Sx PREDEFINED STRINGS
for a usable \*(Ba
character in other situations.
.It \&.Sh DESCRIPTION
In most cases the first text in the
.Sx DESCRIPTION
section
is a brief paragraph on the command, function or file,
followed by a lexical list of options and respective
explanations.
To create such a list, the
.Ql \&.Bl
begin-list,
.Ql \&.It
list-item and
.Ql \&.El
end-list
macros are used (see
.Sx Lists and Columns
below).
.El
.Pp
The following
.Ql \&.Sh
section headers are part of the
preferred manual page layout and must be used appropriately
to maintain consistency.
They are listed in the order
in which they would be used.
.Bl -tag -width SYNOPSIS
.It \&.Sh ENVIRONMENT
The
.Sx ENVIRONMENT
section should reveal any related
environment
variables and clues to their behavior and/or usage.
.It \&.Sh EXAMPLES
There are several ways to create examples.
See
the
.Sx EXAMPLES
section below
for details.
.It \&.Sh FILES
Files which are used or created by the man page subject
should be listed via the
.Ql \&.Pa
macro in the
.Sx FILES
section.
.It \&.Sh SEE ALSO
References to other material on the man page topic and
cross references to other relevant man pages should
be placed in the
.Sx SEE ALSO
section.
Cross references
are specified using the
.Ql \&.Xr
macro.
At this time
.Xr refer 1
style references are not accommodated.
.Pp
It is recommended that the cross references are sorted on the section
number, and then alphabetically on the names within a section.
.It \&.Sh STANDARDS
If the command, library function or file adheres to a
specific implementation such as
.St -p1003.2
or
.St -ansiC
this should be noted here.
If the
command does not adhere to any standard, its history
should be noted in the
.Sx HISTORY
section.
.It \&.Sh HISTORY
Any command which does not adhere to any specific standards
should be outlined historically in this section.
.It \&.Sh AUTHORS
Credits, if need be, should be placed here.
.It \&.Sh DIAGNOSTICS
Diagnostics from a command should be placed in this section.
.It \&.Sh ERRORS
Specific error handling, especially from library functions
(man page sections 2 and 3) should go here.
The
.Ql \&.Er
macro is used to specify an errno.
.It \&.Sh BUGS
Blatant problems with the topic go here...
.El
.Pp
User specified
.Ql \&.Sh
sections may be added,
for example, this section was set with:
.Bd -literal -offset 14n
\&.Sh PAGE LAYOUT MACROS
.Ed
.Ss Paragraphs and Line Spacing.
.Bl -tag -width 6n
.It \&.Pp
The \&.Pp paragraph command may
be used to specify a line space where necessary.
The macro is not necessary after a
.Ql \&.Sh
or
.Ql \&.Ss
macro or before
a
.Ql \&.Bl
macro.
(The
.Ql \&.Bl
macro asserts a vertical distance unless the -compact flag is given).
.El
.\" This worked with version one, need to redo for version three
.\" .Pp
.\" .Ds I
.\" .Cw (ax+bx+c) \ is\ produced\ by\ \&
.\" .\".Cw (ax+bx+c) \&.Va_by_) \&_and_\& \&[?/]m_b1_e1_f1[?/]\&
.\" .Cl Cx \t\t
.\" .Li \&.Cx\ (
.\" .Cx
.\" .Cl Cx \t\t
.\" .Li \&.Va ax
.\" .Cx
.\" .Cl Cx \t\t
.\" .Li \&.Sy \+
.\" .Cx
.\" .Cl Cx \&(\&
.\" .Va ax
.\" .Cx +
.\" .Va by
.\" .Cx +
.\" .Va c )
.\" .Cx \t
.\" .Em is produced by
.\" .Cx \t
.\" .Li \&.Va by
.\" .Cx
.\" .Cl Cx \t\t
.\" .Li \&.Sy \+
.\" .Cx
.\" .Cl Cx \t\t
.\" .Li \&.Va c )
.\" .Cx
.\" .Cl Cx \t\t
.\" .Li \&.Cx
.\" .Cx
.\" .Cw
.\" .De
.\" .Pp
.\" This example shows the same equation in a different format.
.\" The spaces
.\" around the
.\" .Li \&+
.\" signs were forced with
.\" .Li \e :
.\" .Pp
.\" .Ds I
.\" .Cw (ax\ +\ bx\ +\ c) \ is\ produced\ by\ \&
.\" .\".Cw (ax+bx+c) \&.Va_by_) \&_and_\& \&[?/]m_b1_e1_f1[?/]\&
.\" .Cl Cx \t\t
.\" .Li \&.Cx\ (
.\" .Cx
.\" .Cl Cx \t\t
.\" .Li \&.Va a
.\" .Cx
.\" .Cl Cx \t\t
.\" .Li \&.Sy x
.\" .Cx
.\" .Cl Cx \t\t
.\" .Li \&.Cx \e\ +\e\ \e&
.\" .Cx
.\" .Cl Cx \&(\&
.\" .Va a
.\" .Sy x
.\" .Cx \ +\ \&
.\" .Va b
.\" .Sy y
.\" .Cx \ +\ \&
.\" .Va c )
.\" .Cx \t
.\" .Em is produced by
.\" .Cl Cx \t\t
.\" .Li \&.Va b
.\" .Cx
.\" .Cl Cx \t\t
.\" .Li \&.Sy y
.\" .Cx
.\" .Cl Cx \t\t
.\" .Li \&.Cx \e\ +\e\ \e&
.\" .Cx
.\" .Cl Cx \t\t
.\" .Li \&.Va c )
.\" .Cx
.\" .Cl Cx \t\t
.\" .Li \&.Cx
.\" .Cx
.\" .Cw
.\" .De
.\" .Pp
.\" The incantation below was
.\" lifted from the
.\" .Xr adb 1
.\" manual page:
.\" .Pp
.\" .Ds I
.\" .Cw \&[?/]m_b1_e1_f1[?/]\& is\ produced\ by
.\" .Cl Cx \t\t
.\" .Li \&.Cx Op Sy ?/
.\" .Cx
.\" .Cl Cx \t\t
.\" .Li \&.Nm m
.\" .Cx
.\" .Cl Cx Op Sy ?/
.\" .Nm m
.\" .Ad \ b1 e1 f1
.\" .Op Sy ?/
.\" .Cx \t
.\" .Em is produced by
.\" .Cx \t
.\" .Li \&.Ar \e\ b1 e1 f1
.\" .Cx
.\" .Cl Cx \t\t
.\" .Li \&.Op Sy ?/
.\" .Cx
.\" .Cl Cx \t\t
.\" .Li \&.Cx
.\" .Cx
.\" .Cw
.\" .De
.\" .Pp
.Ss Keeps
The only keep that is implemented at this time is for words.
The macros are
.Ql \&.Bk
(begin-keep)
and
.Ql \&.Ek
(end-keep).
The only option that
.Ql \&.Bl
accepts is
.Fl words
and is useful for preventing line breaks in the middle of options.
In the example for the make command line arguments (see
.Sx What's in a name ) ,
the keep prevented
.Xr nroff
from placing up the
flag and the argument
on separate lines.
(Actually, the option macro used to prevent this from occurring,
but was dropped when the decision (religious) was made to force
right justified margins in
.Xr troff
as options in general look atrocious when spread across a sparse
line.
More work needs to be done with the keep macros, a
.Fl line
option needs to be added.)
.Ss Examples and Displays
There are six types of displays, a quickie one line indented display
.Ql \&.D1 ,
a quickie one line literal display
.Ql \&.Dl ,
and block literal, block filled, block unfilled, and block ragged which use
the
.Ql \&.Bd
begin-display
and
.Ql \&.Ed
end-display macros.
.Pp
.Bl -tag -width \&.Dlxx
.It Li \&.D1
(D-one) Display one line of indented text.
This macro is parsed, but it is not callable.
.Pp
.Dl Fl ldghfstru
.Pp
The above was produced by:
.Li \&.Dl Fl ldghfstru .
.It Li \&.Dl
(D-ell)
Display one line of indented
.Em literal
text.
The
.Ql \&.Dl
example macro has been used throughout this
file.
It allows
the indent (display) of one line of text.
Its default font is set to
constant width (literal) however
it is parsed and will recognized other macros.
It is not callable however.
.Pp
.Dl % ls -ldg /usr/local/bin
.Pp
The above was produced by
.Li \&.Dl % ls -ldg /usr/local/bin .
.It Li \&.Bd
Begin-display.
The
.Ql \&.Bd
display must be ended with the
.Ql \&.Ed
macro.
Displays may be nested within lists, but may
.Em not
contain other displays; this also prohibits nesting
of .D1 and .Dl one-line displays.
.Ql \&.Bd
has the following syntax:
.Pp
.Dl ".Bd display-type [-offset offset_value] [-compact]"
.Pp
The display-type must be one of the following four types and
may have an offset specifier for indentation:
.Ql \&.Bd .
.Pp
.Bl -tag -width "file file_name  " -compact
.It Fl ragged
Fill, but do not adjust the right margin.
.It Fl unfilled
Do not fill: display a block of text as typed, the
right (and left) margin edges are left ragged.
.It Fl filled
Display a filled (formatted) block.
The block of text is formatted (the edges are filled \-
not left unjustified).
.It Fl literal
Display a literal block, useful for source code or
simple tabbed or spaced text.
.It Fl file Ar file_name
The file name following the
.Fl file
flag is read and displayed.
Literal mode is
asserted and tabs are set at 8 constant width character
intervals, however any
.Xr troff/ Ns Nm \-mdoc
commands in file will be processed.
.It Fl offset Ar string
If
.Fl offset
is specified with one of the following strings, the string
is interpreted to indicate the level of indentation for the
forthcoming block of text:
.Pp
.Bl -tag -width "indent-two" -compact
.It Ar left
Align block on the current left margin,
this is the default mode of
.Ql \&.Bd .
.It Ar center
Supposedly center the block.
At this time
unfortunately, the block merely gets
left aligned about an imaginary center margin.
.It Ar indent
Indents by one default indent value or tab.
The default
indent value is also used for the
.Ql \&.D1
display so one is guaranteed the two types of displays
will line up.
This indent is normally set to 6n or about two
thirds of an inch (six constant width characters).
.It Ar indent-two
Indents two times the default indent value.
.It Ar right
This
.Em left
aligns the block about two inches from
the right side of the page.
This macro needs
work and perhaps may never do the right thing by
.Xr troff .
.El
.El
.It ".Ed"
End-display.
.El
.Ss Tagged Lists and Columns
There are several types of lists which may be initiated with the
.Ql ".Bl"
begin-list macro.
Items within the list
are specified with the
.Ql ".It"
item macro and
each list must end with the
.Ql ".El"
macro.
Lists other than
.Li \-enum
may be nested within themselves and within displays.
The use of columns inside of lists or lists inside of columns
is unproven.
.Pp
In addition, several list attributes may be specified such as
the width of a tag, the list offset, and compactness
(blank lines between items allowed or disallowed).
Most of this document has been formatted with a tag style list
.Pq Fl tag .
For a change of pace, the list-type used to present the list-types
is an over-hanging list
.Pq Fl ohang .
This type of list is quite popular with
.Tn TeX
users, but might look a bit funny after having read many pages of
tagged lists.
The following list types are accepted by
.Ql ".Bl" :
.Pp
.Bl -ohang -compact
.It Fl bullet
.It Fl dash
.It Fl enum
.It Fl hyphen
.It Fl item
These five are the simplest types of lists.
Once the
.Ql ".Bl"
macro has been given, items in the list are merely
indicated by a line consisting solely of the
.Ql ".It"
macro.
For example, the source text for a simple enumerated list
would look like:
.Bd -literal -offset indent-two
\&.Bl -enum -compact
\&.It
\&Item one goes here.
\&.It
\&And item two here.
\&.It
\&Lastly item three goes here.
\&.El
.Ed
.Pp
The results:
.Pp
.Bl -enum -offset indent-two -compact
.It
Item one goes here.
.It
And item two here.
.It
Lastly item three goes here.
.El
.Pp
A simple bullet list construction:
.Bd -literal -offset indent-two
\&.Bl -bullet -compact
\&.It
\&Bullet one goes here.
\&.It
\&Bullet two here.
\&.El
.Ed
.Pp
Produces:
.Bl -bullet -offset indent-two -compact
.It
Bullet one goes here.
.It
Bullet two here.
.El
.Pp
.It Fl tag
.It Fl diag
.It Fl hang
.It Fl ohang
.It Fl inset
These list-types collect arguments specified with the
.Ql \&.It
macro and create a label which may be
.Em inset
into the forthcoming text,
.Em hanged
from the forthcoming text,
.Em overhanged
from above and not indented or
.Em tagged .
This
list was constructed with the
.Ql Fl ohang
list-type.
The
.Ql \&.It
macro is parsed only for the inset, hang
and tag list-types and is not callable.
Here is an example of inset labels:
.Bl -inset -offset indent
.It Em Tag
The tagged list (also called a tagged paragraph) is the
most common type of list used in the Berkeley manuals. Use a
.Fl width
attribute as described below.
.It Em Diag
Diag lists create section four diagnostic lists
and are similar to inset lists except callable
macros are ignored.
.It Em Hang
Hanged labels are a matter of taste.
.It Em Ohang
Overhanging labels are nice when space is constrained.
.It Em Inset
Inset labels are useful for controlling blocks of
paragraphs and are valuable for converting
.Nm \-mdoc
manuals to other formats.
.El
.Pp
Here is the source text which produced the above example:
.Bd -literal -offset indent
\&.Bl -inset -offset indent
\&.It Em Tag
\&The tagged list (also called a tagged paragraph) is the
\&most common type of list used in the Berkeley manuals.
\&.It Em Diag
\&Diag lists create section four diagnostic lists
\&and are similar to inset lists except callable
\&macros are ignored.
\&.It Em Hang
\&Hanged labels are a matter of taste.
\&.It Em Ohang
\&Overhanging labels are nice when space is constrained.
\&.It Em Inset
\&Inset labels are useful for controlling blocks of
\&paragraphs and are valuable for converting
\&.Nm \-mdoc
\&manuals to other formats.
\&.El
.Ed
.Pp
Here is a hanged list with just one item:
.Bl -hang -offset indent
.It Em Hanged
labels appear similar to tagged lists when the
label is smaller than the label width.
.It Em Longer hanged list labels
blend in to the paragraph unlike
tagged paragraph labels.
.El
.Pp
And the unformatted text which created it:
.Bd -literal -offset indent
\&.Bl -hang -offset indent
\&.It Em Hanged
\&labels appear similar to tagged lists when the
\&label is smaller than the label width.
\&.It Em Longer hanged list labels
\&blend in to the paragraph unlike
\&tagged paragraph labels.
\&.El
.Ed
.Pp
The tagged list which follows uses a width specifier to control
the width of the tag.
.Pp
.Bl -tag -width "PAGEIN" -compact -offset indent
.It SL
sleep time of the process (seconds blocked)
.It PAGEIN
number of disk
.Tn I/O Ns 's
resulting from references
by the process to pages not loaded in core.
.It UID
numerical user-id of process owner
.It PPID
numerical id of parent of process process priority
(non-positive when in non-interruptible wait)
.El
.Pp
The raw text:
.Bd -literal -offset indent
\&.Bl -tag -width "PAGEIN" -compact -offset indent
\&.It SL
\&sleep time of the process (seconds blocked)
\&.It PAGEIN
\&number of disk
\&.Tn I/O Ns 's
\&resulting from references
\&by the process to pages not loaded in core.
\&.It UID
\&numerical user-id of process owner
\&.It PPID
\&numerical id of parent of process process priority
\&(non-positive when in non-interruptible wait)
\&.El
.Ed
.Pp
Acceptable width specifiers:
.Bl -tag -width Ar -offset indent
.It Fl width Ar "\&Fl"
sets the width to the default width for a flag.
All callable
macros have a default width value.
The
.Ql \&.Fl ,
value is presently
set to ten constant width characters or about five sixth of
an inch.
.It Fl width Ar "24n"
sets the width to 24 constant width characters or about two
inches.
The
.Ql n
is absolutely necessary for the scaling to work correctly.
.It Fl width Ar "ENAMETOOLONG"
sets width to the constant width length of the
string given.
.It Fl width  Ar "\\*qint mkfifo\\*q"
again, the width is set to the constant width of the string
given.
.El
.Pp
If a width is not specified for the tag list type, the first
time
.Ql \&.It
is invoked, an attempt is made to determine an appropriate
width.
If the first argument to
.Ql ".It"
is a callable macro, the default width for that macro will be used
as if the macro name had been supplied as the width.
However,
if another item in the list is given with a different callable
macro name, a new and nested list is assumed. This effectively
means that
.Fl width
is required for the tag list type.
.Pp
.It Fl column
This list type generates multiple columns.
The number of columns and the width of each column is determined by
the arguments to the
.Fl column
list.
Each
.Ql ".It"
argument is parsed to make a row, each column within the
row is a separate argument separated by a tab or the
.Ql ".Ta"
macro.
.El
The table:
.Bl -column "String" "Nroff" "Troff" -offset indent
.It Sy "String" Ta Sy "Nroff" Ta Sy "Troff"
.It Li "<=" Ta \&<\&= Ta \*(<=
.It Li ">=" Ta \&>\&= Ta \*(>=
.El
.Pp
was produced by:
.Bd -literal -offset indent
\&.Bl -column "String" "Nroff" "Troff" -offset indent
\&.It Sy "String" Ta Sy "Nroff" Ta Sy "Troff"
\&.It Li "<=" Ta \&<\&= Ta \*(<=
\&.It Li ">=" Ta \&>\&= Ta \*(>=
\&.El
.Ed
.Sh PREDEFINED STRINGS
The following strings are predefined as may be used by
preceding with the troff string interpreting sequence
.Ql \&\e*(xx
where
.Em xx
is the name of the defined string or as
.Ql \&\e*x
where
.Em x
is the name of the string.
The interpreting sequence may be used any where in the text.
.Pp
.Bl -column "String " "Nroff " "Troff " -offset indent
.It Sy "String	Nroff	Troff"
.It Li "<=" Ta \&<\&= Ta \*(<=
.It Li ">=" Ta \&>\&= Ta \*(>=
.It Li "Rq" Ta "''" Ta \*(Rq
.It Li "Lq" Ta "``" Ta \*(Lq
.It Li "ua" Ta ^ Ta \*(ua
.It Li "aa" Ta ' Ta \*(aa
.It Li "ga" Ta \` Ta \*(ga
.\" .It Li "sL" Ta ` Ta \*(sL
.\" .It Li "sR" Ta ' Ta \*(sR
.It Li "q" Ta \&" Ta \*q
.It Li "Pi" Ta pi Ta \*(Pi
.It Li "Ne" Ta != Ta \*(Ne
.It Li "Le" Ta <= Ta \*(Le
.It Li "Ge" Ta >= Ta \*(Ge
.It Li "Lt" Ta < Ta \*(Gt
.It Li "Gt" Ta > Ta \*(Lt
.It Li "Pm" Ta +- Ta \*(Pm
.It Li "If" Ta infinity Ta \*(If
.It Li "Na" Ta \fINaN\fP Ta \*(Na
.It Li "Ba" Ta \fR\&|\fP Ta \*(Ba
.El
.Pp
.Sy Note :
The string named
.Ql q
should be written as
.Ql \e*q
since it is only one char.
.Sh DIAGNOSTICS
The debugging facilities for
.Nm \-mdoc
are limited, but can help detect subtle errors such
as the collision of an argument name with an internal
register or macro name.
(A what?)
A register is an arithmetic storage class for
.Xr troff
with a one or two character name.
All registers internal to
.Nm \-mdoc
for
.Xr troff
and
.Xr ditroff
are two characters and
of the form <upper_case><lower_case> such as
.Ql \&Ar ,
<lower_case><upper_case> as
.Ql \&aR
or
<upper or lower letter><digit> as
.Ql \&C\&1 .
And adding to the muddle,
.Xr troff
has its own internal registers all of which are either
two lower case characters or a dot plus a letter or meta-character
character.
In one of the introduction examples, it was shown how to
prevent the interpretation of a macro name with the escape sequence
.Ql \e& .
This is sufficient for the internal register names also.
.Pp
.\" Every callable macro name has a corresponding register
.\" of the same name (<upper_case><lower_case>).
.\" There are also specific registers which have
.\" been used for stacks and arrays and are listed in the
.\" .Sx Appendix .
.\" .Bd -ragged -offset 4n
.\" [A-Z][a-z]	registers corresponding to macro names (example ``Ar'')
.\" [a-z][A-Z]	registers corresponding to macro names (example ``aR'')
.\" C[0-9]		argument types (example C1)
.\" O[0-9]		offset stack (displays)
.\" h[0-9]		horizontal spacing stack (lists)
.\" o[0-9]		offset (stack) (lists)
.\" t[0-9]		tag stack (lists)
.\" v[0-9]		vertical spacing stack (lists)
.\" w[0-9]		width tag/label stack
.\" .Ed
.\" .Pp
If a non-escaped register name is given in the argument list of a request
unpredictable behavior will occur.
In general, any time huge portions
of text do not appear where expected in the output, or small strings
such as list tags disappear, chances are there is a misunderstanding
about an argument type in the argument list.
Your mother never intended for you to remember this evil stuff - so here
is a way to find out whether or not your arguments are valid: The
.Ql \&.Db
(debug)
macro displays the interpretation of the argument list for most
macros.
Macros such as the
.Ql \&.Pp
(paragraph)
macro do not contain debugging information.
All of the callable macros do,
and it is strongly advised whenever in doubt,
turn on the
.Ql \&.Db
macro.
.Pp
.Dl Usage: \&.Db [on | off]
.Pp
An example of a portion of text with
the debug macro placed above and below an
artificially created problem (a flag argument
.Ql \&aC
which should be
.Ql \e&aC
in order to work):
.Bd -literal -offset indent
\&.Db on
\&.Op Fl aC Ar file )
\&.Db off
.Ed
.Pp
The resulting output:
.Bd -literal -offset indent
DEBUGGING ON
DEBUG(argv) MACRO: `.Op'  Line #: 2
	Argc: 1  Argv: `Fl'  Length: 2
	Space: `'  Class: Executable
	Argc: 2  Argv: `aC'  Length: 2
	Space: `'  Class: Executable
	Argc: 3  Argv: `Ar'  Length: 2
	Space: `'  Class: Executable
	Argc: 4  Argv: `file'  Length: 4
	Space: ` '  Class: String
	Argc: 5  Argv: `)'  Length: 1
	Space: ` '  Class: Closing Punctuation or suffix
	MACRO REQUEST: .Op Fl aC Ar file )
DEBUGGING OFF
.Ed
.Pp
The first line of information tells the name of the calling
macro, here
.Ql \&.Op ,
and the line number it appears on.
If one or more files are involved
(especially if text from another file is included) the line number
may be bogus.
If there is only one file, it should be accurate.
The second line gives the argument count, the argument
.Pq Ql \&Fl
and its length.
If the length of an argument is two characters, the
argument is tested to see if it is executable (unfortunately, any
register which contains a non-zero value appears executable).
The third line gives the space allotted for a class, and the
class type.
The problem here is the argument aC should not be
executable.
The four types of classes are string, executable, closing
punctuation and opening punctuation.
The last line shows the entire
argument list as it was read.
In this next example, the offending
.Ql \&aC
is escaped:
.Bd -literal -offset indent
\&.Db on
\&.Em An escaped \e&aC
\&.Db off
.Ed
.Bd -literal -offset indent
DEBUGGING ON
DEBUG(fargv) MACRO: `.Em'  Line #: 2
	Argc: 1  Argv: `An'  Length: 2
	Space: ` '  Class: String
	Argc: 2  Argv: `escaped'  Length: 7
	Space: ` '  Class: String
	Argc: 3  Argv: `aC'  Length: 2
	Space: ` '  Class: String
	MACRO REQUEST: .Em An escaped &aC
DEBUGGING OFF
.Ed
.Pp
The argument
.Ql \e&aC
shows up with the same length of 2 as the
.Ql \e&
sequence produces a zero width, but a register
named
.Ql \e&aC
was not found and the type classified as string.
.Pp
Other diagnostics consist of usage statements and are self explanatory.
.Sh GROFF, TROFF AND NROFF
The
.Nm \-mdoc
package does not need compatibility mode with
.Xr groff .
.Pp
The package inhibits page breaks, and the headers and footers
which normally occur at those breaks with
.Xr nroff ,
to make the manual more efficient for viewing on-line.
At the moment,
.Xr groff
with
.Fl T Ns Ar ascii
does eject the imaginary remainder of the page at end of file.
The inhibiting of the page breaks makes
.Xr nroff Ns 'd
files unsuitable for hardcopy.
There is a register named
.Ql \&cR
which can be set to zero in the site dependent style file
.Pa /usr/src/share/tmac/doc-nroff
to restore the old style behavior.
.Sh FILES
.Bl -tag -width /usr/share/misc/mdoc.template -compact
.It Pa /usr/share/tmac/tmac.doc
manual macro package
.It Pa /usr/share/misc/mdoc.template
template for writing a man page
.El
.Sh SEE ALSO
.Xr mdoc 7 ,
.Xr man 1 ,
.Xr troff 1
.Sh BUGS
Undesirable hyphenation on the dash of a flag
argument is not yet resolved, and causes
occasional mishaps in the
.Sx DESCRIPTION
section.
(line break on the hyphen).
.Pp
Predefined strings are not declared in documentation.
.Pp
Section 3f has not been added to the header routines.
.Pp
.Ql \&.Nm
font should be changed in
.Sx NAME
section.
.Pp
.Ql \&.Fn
needs to have a check to prevent splitting up
if the line length is too short.
Occasionally it
separates the last parenthesis, and sometimes
looks ridiculous if a line is in fill mode.
.Pp
The method used to prevent header and footer page
breaks (other than the initial header and footer) when using
nroff occasionally places an unsightly partially filled line (blank)
at the would be bottom of the page.
.Pp
If the outer-most list definition doesn't have a
.Fl width
argument, the
.Ql ".It"
elements of inner lists may not work (producing a list where
each successive element
.Sq walks
to the right).
.Pp
The list and display macros to not do any keeps
and certainly should be able to.
.\" Note what happens if the parameter list overlaps a newline
.\" boundary.
.\" to make sure a line boundary is crossed:
.\" .Bd -literal
.\" \&.Fn struct\e\ dictionarytable\e\ *dictionarylookup struct\e\ dictionarytable\e\ *tab[]
.\" .Ed
.\" .Pp
.\" produces, nudge nudge,
.\" .Fn struct\ dictionarytable\ *dictionarylookup char\ *h struct\ dictionarytable\ *tab[] ,
.\" .Fn struct\ dictionarytable\ *dictionarylookup char\ *h struct\ dictionarytable\ *tab[] ,
.\" nudge
.\" .Fn struct\ dictionarytable\ *dictionarylookup char\ *h struct\ dictionarytable\ *tab[] .
.\" .Pp
.\" If double quotes are used, for example:
.\" .Bd -literal
.\" \&.Fn \*qstruct dictionarytable *dictionarylookup\*q \*qchar *h\*q \*qstruct dictionarytable *tab[]\*q
.\" .Ed
.\" .Pp
.\" produces, nudge nudge,
.\" .Fn "struct dictionarytable *dictionarylookup" "char *h" "struct dictionarytable *tab[]" ,
.\" nudge
.\" .Fn "struct dictionarytable *dictionarylookup" "char *h" "struct dictionarytable *tab[]" ,
.\" nudge
.\" .Fn "struct dictionarytable *dictionarylookup" "char *h" "struct dictionarytable *tab[]" .
.\" .Pp
.\" Not a pretty sight...
.\" In a paragraph, a long parameter containing unpaddable spaces as
.\" in the former example will cause
.\" .Xr troff
.\" to break the line and spread
.\" the remaining words out.
.\" The latter example will adjust nicely to
.\" justified margins, but may break in between an argument and its
.\" declaration.
.\" In
.\" .Xr nroff
.\" the right margin adjustment is normally ragged and the problem is
.\" not as severe.
