#!/usr/local/bin/perl

# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.

use StatKoi '.' ;

open(FILE, "> ../src/nsCyrillicProb.h") or die "cannot open nsCyrillicDetector.h";

print FILE <<EOF;
/* -*- Mode: C; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 2 -*- */

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef nsCyrillicDetector_h__
#define nsCyrillicDetector_h__
/*
    DO NOT EDIT THIS FILE !!!
    This file is generated by the perl script in 
    mozilla/intl/chardet/tools/gencyrillic.pl

    To ues that script, you need to grab StatKoi.pm file from
    the "Cyrillic Software Suite" written by John Neystdt.
    http://www.neystadt.org/cyrillic (You can also find it from CPAN)
 */
EOF
$table = \%Lingua::DetectCharset::StatKoi::StatsTableKoi;
print FILE "const uint16_t gCyrillicProb[33][33] = {";
  print FILE "{ \n";
  print FILE "0,\n";
  for($j = 0xc0; $j < 0xe0; $j++)
  {
     print FILE "0, \t";
     if( 7 == ( $j % 8) )
     {
           print FILE "\n";
     }
  }
  print FILE "\n}, \n";
for($i = 0xc0; $i < 0xe0; $i++)
{
  print FILE "{ \n";
  print FILE "0,\n";
  for($j = 0xc0; $j < 0xe0; $j++)
  {
     $key = chr($i) . chr($j);
     if(exists($table->{$key}))
     {
          $v = $table->{$key};
     } else {
          $v = 0;
     }
     print FILE $v . ", \t";
     if( 7 == ( $j % 8) )
     {
           print FILE "\n";
     }
  }
  print FILE "\n}, \n";
}
print FILE "};\n";
print FILE "#endif\n";
