/* -*- c++ -*- */
/*
 * Copyright 2004 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <usrp1_sink_s.h>
#include <gr_io_signature.h>
#include <usrp_standard.h>

usrp1_sink_s_sptr
usrp1_make_sink_s (int which_board,
		   unsigned int interp_rate,
		   int nchan,
		   int mux
		   ) throw (std::runtime_error)
{
  return usrp1_sink_s_sptr (new usrp1_sink_s (which_board,
					      interp_rate,
					      nchan, mux));
}


usrp1_sink_s::usrp1_sink_s (int which_board,
			    unsigned int interp_rate,
			    int nchan,
			    int mux
			    ) throw (std::runtime_error)
  : usrp1_sink_base ("usrp1_sink_s",
		     gr_make_io_signature (1, 1, sizeof (short)),
		     which_board, interp_rate,
		     nchan, mux)
{
  set_output_multiple (512 / sizeof(short));	// don't change
}

usrp1_sink_s::~usrp1_sink_s ()
{
  // NOP
}

/*
 * Take one short input stream and format it into interleaved short I & Q
 * for the usrp.
 */
void
usrp1_sink_s::copy_to_usrp_buffer (gr_vector_const_void_star &input_items,
				   int  input_index,
				   int	input_items_available,
				   int  &input_items_consumed,	// out
				   void *usrp_buffer,
				   int  usrp_buffer_length,
				   int	&bytes_written)		// out
{
  short *in = &((short *) input_items[0])[input_index];
  short *dst = (short *) usrp_buffer;

  static const int usrp_bytes_per_input_item = sizeof (short);

  int nitems = std::min (input_items_available,
			 usrp_buffer_length / usrp_bytes_per_input_item);

  for (int i = 0; i < nitems; i++){	// FIXME unroll
    dst[i] = in[i];
  }

  input_items_consumed = nitems;
  bytes_written = nitems * usrp_bytes_per_input_item;
}

