/* -*- c++ -*- */
/*
 * Copyright 2004 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/*
 * WARNING: This file is automatically generated by
 * generate_gr_rational_resampler_base_XXX.py Any changes made to this
 * file will be overwritten.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <gr_rational_resampler_base_ccf.h>
#include <gr_fir_ccf.h>
#include <gr_fir_util.h>
#include <gr_io_signature.h>
#include <stdexcept>
#include <iostream>

gr_rational_resampler_base_ccf_sptr 
gr_make_rational_resampler_base_ccf (unsigned interpolation,
		     unsigned decimation, 
		     const std::vector<float> &taps)
{
  return gr_rational_resampler_base_ccf_sptr (new gr_rational_resampler_base_ccf (interpolation, decimation, taps));
}

gr_rational_resampler_base_ccf::gr_rational_resampler_base_ccf (unsigned interpolation, unsigned decimation,
		const std::vector<float> &taps)
  : gr_block ("rational_resampler_base_ccf",
	      gr_make_io_signature (1, 1, sizeof (gr_complex)),
	      gr_make_io_signature (1, 1, sizeof (gr_complex))),
    d_history(1),
    d_interpolation(interpolation), d_decimation(decimation),
    d_ctr(0), d_updated(false),
    d_firs(interpolation)
{
  if (interpolation == 0)
    throw std::out_of_range ("interpolation must be > 0");
  if (decimation == 0)
    throw std::out_of_range ("decimation must be > 0");

  set_relative_rate (1.0 * interpolation / decimation);
  set_output_multiple (1);

  std::vector<float>	dummy_taps;
  
  for (unsigned i = 0; i < interpolation; i++)
    d_firs[i] = gr_fir_util::create_gr_fir_ccf (dummy_taps);

  set_taps (taps);
  install_taps (d_new_taps);
}

gr_rational_resampler_base_ccf::~gr_rational_resampler_base_ccf ()
{
  int interp = interpolation();
  for (int i = 0; i < interp; i++)
    delete d_firs[i];
}

void
gr_rational_resampler_base_ccf::set_taps (const std::vector<float> &taps)
{
  d_new_taps = taps;
  d_updated = true;

  // round up length to a multiple of the interpolation factor
  int n = taps.size () % interpolation ();
  if (n > 0){
    n = interpolation () - n;
    while (n-- > 0)
      d_new_taps.insert(d_new_taps.begin(), 0);
  }

  assert (d_new_taps.size () % interpolation () == 0);
}


void
gr_rational_resampler_base_ccf::install_taps (const std::vector<float> &taps)
{
  int nfilters = interpolation ();
  int nt = taps.size () / nfilters;

  assert (nt * nfilters == (int) taps.size ());

  std::vector< std::vector <float> > xtaps (nfilters);

  for (int n = 0; n < nfilters; n++)
    xtaps[n].resize (nt);  

  for (int i = 0; i < (int) taps.size(); i++)
    xtaps[i % nfilters][i / nfilters] = taps[i];

  for (int n = 0; n < nfilters; n++)
    d_firs[n]->set_taps (xtaps[n]);
  
  set_history (nt);
  d_updated = false;

#if 0
  for (int i = 0; i < nfilters; i++){
    std::cout << "filter[" << i << "] = ";
    for (int j = 0; j < nt; j++)
      std::cout << xtaps[i][j] << " ";

    std::cout << "\n";
  }
#endif

}

void
gr_rational_resampler_base_ccf::forecast (int noutput_items, gr_vector_int &ninput_items_required)
{
  int nreqd = std::max((unsigned)1, (int)((double) (noutput_items+1) * decimation() / interpolation()) + history() - 1);
  unsigned ninputs = ninput_items_required.size ();
  for (unsigned i = 0; i < ninputs; i++)
    ninput_items_required[i] = nreqd;
}

int
gr_rational_resampler_base_ccf::general_work (int noutput_items,
		      gr_vector_int &ninput_items,
		      gr_vector_const_void_star &input_items,
		      gr_vector_void_star &output_items)
{
  const gr_complex *in = (const gr_complex *) input_items[0];
  gr_complex *out = (gr_complex *) output_items[0];

  if (d_updated) {
    install_taps (d_new_taps);
    return 0;		// history requirement may have increased.
  }

  unsigned int ctr = d_ctr;

  int i = 0;
  while (i < noutput_items){
    out[i++] = d_firs[ctr]->filter(in);
    ctr += decimation();
    while (ctr >= interpolation()){
      ctr -= interpolation();
      in++;
    }
  }

  d_ctr = ctr;
  consume_each(in - (gr_complex *) input_items[0]);
  return i;
}
