#
# Copyright 2001 Free Software Foundation, Inc.
# 
# This file is part of GNU Radio
# 
# GNU Radio is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
# 
# GNU Radio is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with GNU Radio; see the file COPYING.  If not, write to
# the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.
# 

function v = read_float_binary (filename, count)

  ## usage: read_float_binary (filename, [count])
  ##
  ##  open filename and return the contents, treating them as
  ##  32 bit floats
  ##

  if ((m = nargchk (1,2,nargin)))
    usage (m);
  endif;

  if (nargin < 2)
    count = Inf;
  endif;

  f = fopen (filename, "r");
  if (f < 0)
    v = 0;
  else
    v = fread (f, count, "float");
    fclose (f);
  endif;
endfunction;