#!/usr/bin/env python
#
# Copyright 2004 Free Software Foundation, Inc.
# 
# This file is part of GNU Radio
# 
# GNU Radio is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3, or (at your option)
# any later version.
# 
# GNU Radio is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with GNU Radio; see the file COPYING.  If not, write to
# the Free Software Foundation, Inc., 51 Franklin Street,
# Boston, MA 02110-1301, USA.
# 

from gnuradio import gr, gr_unittest
import math

class test_sig_source (gr_unittest.TestCase):

    def setUp (self):
        self.tb = gr.top_block()

    def tearDown (self):
        self.tb = None

    def test_pll_refout (self):
        expected_result = ((1+7.39965699825e-10j),
                           (0.999980390072+0.00626518437639j),
                           (0.999828696251+0.0185074284673j),
                           (0.999342679977+0.0362518876791j),
                           (0.998255133629+0.0590478181839j),
                           (0.996255218983+0.0864609107375j),
                           (0.993005692959+0.118066303432j),
                           (0.988157629967+0.153442293406j),
                           (0.981362581253+0.192165210843j),
                           (0.972283244133+0.233806177974j),
                           (0.960601866245+0.277928203344j),
                           (0.946027755737+0.324085712433j),
                           (0.928303182125+0.371824204922j),
                           (0.907292485237+0.420500129461j),
                           (0.882742881775+0.469856351614j),
                           (0.854515135288+0.519426465034j),
                           (0.822515428066+0.568742752075j),
                           (0.786696314812+0.617340147495j),
                           (0.747057616711+0.664759278297j),
                           (0.703645646572+0.710551083088j),
                           (0.656552672386+0.754280209541j),
                           (0.605915129185+0.795529305935j),
                           (0.551911592484+0.833902597427j),
                           (0.494760006666+0.869029641151j),
                           (0.43471455574+0.900568306446j),
                           (0.37224894762+0.928132891655j),
                           (0.30767711997+0.951490819454j),
                           (0.241136431694+0.970491230488j),
                           (0.172981828451+0.984925031662j),
                           (0.103586450219+0.99462044239j),
                           (0.0333373323083+0.999444127083j),
                           (-0.0373690575361+0.999301552773j),
                           (-0.108130030334+0.994136750698j),
                           (-0.178540825844+0.983932495117j),
                           (-0.248198583722+0.968709170818j),
                           (-0.316705673933+0.948523879051j),
                           (-0.383672952652+0.923469007015j),
                           (-0.448723316193+0.893670737743j),
                           (-0.51132196188+0.85938924551j),
                           (-0.571328520775+0.820721447468j),
                           (-0.628420114517+0.777874112129j),
                           (-0.682293117046+0.73107868433j),
                           (-0.732665538788+0.680588841438j),
                           (-0.779277384281+0.626679122448j),
                           (-0.821892917156+0.569642007351j),
                           (-0.860301196575+0.509786069393j),
                           (-0.894317150116+0.447433561087j),
                           (-0.923782229424+0.382918298244j),
                           (-0.948564887047+0.316582858562j),
                           (-0.968560874462+0.248776733875j),
                           (-0.983657121658+0.180051699281j),
                           (-0.993847966194+0.110753215849j),
                           (-0.999158322811+0.0410195216537j),
                           (-0.999585151672-0.0288011860102j),
                           (-0.995150566101-0.0983632653952j),
                           (-0.985901713371-0.16732545197j),
                           (-0.971909940243-0.235353127122j),
                           (-0.953270018101-0.302119642496j),
                           (-0.9300994277-0.367307811975j),
                           (-0.902537107468-0.430612027645j),
                           (-0.870742559433-0.49173912406j),
                           (-0.834894418716-0.550410091877j),
                           (-0.795189499855-0.606360971928j),
                           (-0.751972675323-0.659194231033j),
                           (-0.705345034599-0.708864152431j),
                           (-0.65554022789-0.755160272121j),
                           (-0.602804005146-0.79788929224j),
                           (-0.547393083572-0.836875617504j),
                           (-0.489574223757-0.871961653233j),
                           (-0.429622590542-0.903008520603j),
                           (-0.367820799351-0.929896712303j),
                           (-0.30445766449-0.952525854111j),
                           (-0.239826664329-0.970815718174j),
                           (-0.174224823713-0.984705924988j),
                           (-0.107951194048-0.994156181812j),
                           (-0.0415063276887-0.999138236046j),
                           (0.0248276274651-0.999691724777j),
                           (0.0909758731723-0.995853126049j),
                           (0.156649470329-0.987654268742j),
                           (0.221562758088-0.975146114826j),
                           (0.285434871912-0.958398103714j),
                           (0.347990810871-0.937497973442j),
                           (0.408962905407-0.912550985813j),
                           (0.468091338873-0.883680105209j),
                           (0.525126338005-0.851024270058j),
                           (0.57982814312-0.814738810062j),
                           (0.631968915462-0.77499371767j),
                           (0.681333422661-0.731973171234j),
                           (0.727582573891-0.68602013588j),
                           (0.770699381828-0.637198925018j),
                           (0.810512244701-0.585721731186j),
                           (0.846863090992-0.531810998917j),
                           (0.879608631134-0.475698113441j),
                           (0.908620357513-0.417623132467j),
                           (0.933785498142-0.357833325863j),
                           (0.955007195473-0.296582698822j),
                           (0.972205162048-0.234130680561j),
                           (0.985315918922-0.170741200447j),
                           (0.994293272495-0.106681488454j),
                           (0.999108314514-0.0422209985554j))

        sampling_freq = 10e3
        freq = sampling_freq / 100

        alpha = 0.1
        beta = alpha * alpha / 4.0
        maxf = 1
        minf = -1

        src = gr.sig_source_c (sampling_freq, gr.GR_COS_WAVE, freq, 1.0)
        pll = gr.pll_refout_cc(alpha, beta, maxf, minf)
        head = gr.head (gr.sizeof_gr_complex, int (freq))
        dst = gr.vector_sink_c ()

        self.tb.connect (src, pll, head)
        self.tb.connect (head, dst)

        self.tb.run ()
        dst_data = dst.data ()

        self.assertComplexTuplesAlmostEqual (expected_result, dst_data, 5)

if __name__ == '__main__':
    gr_unittest.main ()
