/*
 * Decompiled with CFR 0.152.
 */
package org.gnunet.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.gnunet.util.AbsoluteTimeMessage;
import org.gnunet.util.RelativeTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbsoluteTime
implements Comparable<AbsoluteTime> {
    private static final Logger logger = LoggerFactory.getLogger(AbsoluteTime.class);
    public static final AbsoluteTime ZERO = new AbsoluteTime(0L);
    public static final AbsoluteTime FOREVER = new AbsoluteTime(Long.MAX_VALUE);
    private final long absValueUs;

    public static AbsoluteTime now() {
        return new AbsoluteTime(System.currentTimeMillis() * 1000L);
    }

    public AbsoluteTime(long absValueUs) {
        this.absValueUs = absValueUs;
    }

    public AbsoluteTime add(RelativeTime duration) {
        if (this.absValueUs == Long.MAX_VALUE || duration.isForever()) {
            return FOREVER;
        }
        if (this.absValueUs + duration.getMicroseconds() < this.absValueUs) {
            return FOREVER;
        }
        return new AbsoluteTime(this.absValueUs + duration.getMicroseconds());
    }

    public static RelativeTime calculateETA(AbsoluteTime start, long finished, long total) {
        if (finished >= total) {
            return RelativeTime.ZERO;
        }
        if (finished == 0L) {
            return RelativeTime.FOREVER;
        }
        RelativeTime dur = start.getDuration();
        double exp = (double)(dur.getMicroseconds() * total) / (double)finished;
        return new RelativeTime((long)exp);
    }

    public boolean equals(Object other) {
        return other instanceof AbsoluteTime && this.compareTo((AbsoluteTime)other) == 0;
    }

    public int hashCode() {
        return (int)this.absValueUs;
    }

    @Override
    public int compareTo(AbsoluteTime other) {
        if (this.absValueUs < other.absValueUs) {
            return -1;
        }
        if (this.absValueUs > other.absValueUs) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        if (this.isForever()) {
            return "AbsoluteTime(FOREVER)";
        }
        return "AbsoluteTime(" + this.absValueUs + ")";
    }

    public boolean isDue() {
        return this.absValueUs < AbsoluteTime.now().absValueUs;
    }

    public boolean isForever() {
        return this.absValueUs == Long.MAX_VALUE;
    }

    public RelativeTime getDifference(AbsoluteTime other) {
        if (other.absValueUs == Long.MAX_VALUE) {
            return RelativeTime.FOREVER;
        }
        return new RelativeTime(this.absValueUs - other.absValueUs);
    }

    public RelativeTime getDuration() {
        assert (this.absValueUs != Long.MAX_VALUE);
        return this.getDifference(AbsoluteTime.now());
    }

    public long getMicroseconds() {
        return this.absValueUs;
    }

    public RelativeTime getRemaining() {
        if (this.absValueUs == Long.MAX_VALUE) {
            return RelativeTime.FOREVER;
        }
        return this.getDifference(AbsoluteTime.now());
    }

    public AbsoluteTime max(AbsoluteTime other) {
        return this.absValueUs >= other.absValueUs ? this : other;
    }

    public AbsoluteTime min(AbsoluteTime other) {
        return this.absValueUs <= other.absValueUs ? this : other;
    }

    public AbsoluteTime subtract(RelativeTime duration) {
        if (this.absValueUs <= duration.getMicroseconds()) {
            return ZERO;
        }
        if (this.absValueUs == Long.MAX_VALUE) {
            return this;
        }
        return new AbsoluteTime(this.absValueUs - duration.getMicroseconds());
    }

    public AbsoluteTimeMessage asMessage() {
        return new AbsoluteTimeMessage(this);
    }

    public static AbsoluteTime fromNetwork(AbsoluteTimeMessage m) {
        return m.value < 0L ? FOREVER : new AbsoluteTime(m.value);
    }

    public Date toDate() {
        return new Date(this.absValueUs / 1000L);
    }

    public long getSeconds() {
        return this.absValueUs / 1000000L;
    }

    public static AbsoluteTime fromSeconds(long stamp) {
        return new AbsoluteTime(stamp * 1000L * 1000L);
    }

    public String toFancyString() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(new Date(this.getMilliseconds()));
    }

    private long getMilliseconds() {
        return this.absValueUs / 1000L;
    }

    public static AbsoluteTime fromString(String s) {
        Date date = null;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yy-MM-dd HH:mm:ss");
            date = sdf.parse(s);
            return new AbsoluteTime(date.getTime() * 1000L);
        }
        catch (ParseException e) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat("yy-MM-dd HH:mm");
                date = sdf.parse(s);
                return new AbsoluteTime(date.getTime() * 1000L);
            }
            catch (ParseException e2) {
                try {
                    SimpleDateFormat sdf = new SimpleDateFormat("yy-MM-dd");
                    date = sdf.parse(s);
                    return new AbsoluteTime(date.getTime() * 1000L);
                }
                catch (ParseException parseException) {
                    return null;
                }
            }
        }
    }
}

