/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.pki.provider;

import gnu.crypto.pki.X509CRLImpl;
import gnu.crypto.pki.X509CertPath;
import gnu.crypto.pki.X509CertificateImpl;
import gnu.crypto.pki.io.Base64InputStream;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactorySpi;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class X509CertificateFactory
extends CertificateFactorySpi {
    public static final String BEGIN_CERTIFICATE = "-----BEGIN CERTIFICATE-----";
    public static final String END_CERTIFICATE = "-----END CERTIFICATE-----";
    public static final String BEGIN_X509_CRL = "-----BEGIN X509 CRL-----";
    public static final String END_X509_CRL = "-----END X509 CRL-----";

    public Certificate engineGenerateCertificate(InputStream inStream) throws CertificateException {
        try {
            return this.generateCert(inStream);
        }
        catch (IOException ioe) {
            CertificateException ce = new CertificateException(ioe.getMessage());
            ce.initCause(ioe);
            throw ce;
        }
    }

    public Collection engineGenerateCertificates(InputStream inStream) throws CertificateException {
        LinkedList<X509CertificateImpl> certs = new LinkedList<X509CertificateImpl>();
        while (true) {
            try {
                certs.add(this.generateCert(inStream));
            }
            catch (EOFException eof) {
                break;
            }
            catch (IOException ioe) {
                CertificateException ce = new CertificateException(ioe.getMessage());
                ce.initCause(ioe);
                throw ce;
            }
        }
        return certs;
    }

    public CRL engineGenerateCRL(InputStream inStream) throws CRLException {
        try {
            return this.generateCRL(inStream);
        }
        catch (IOException ioe) {
            CRLException crle = new CRLException(ioe.getMessage());
            crle.initCause(ioe);
            throw crle;
        }
    }

    public Collection engineGenerateCRLs(InputStream inStream) throws CRLException {
        LinkedList<X509CRLImpl> crls = new LinkedList<X509CRLImpl>();
        while (true) {
            try {
                crls.add(this.generateCRL(inStream));
            }
            catch (EOFException eof) {
                break;
            }
            catch (IOException ioe) {
                CRLException crle = new CRLException(ioe.getMessage());
                crle.initCause(ioe);
                throw crle;
            }
        }
        return crls;
    }

    public CertPath engineGenerateCertPath(List certs) {
        return new X509CertPath(certs);
    }

    public CertPath engineGenerateCertPath(InputStream in) throws CertificateEncodingException {
        return new X509CertPath(in);
    }

    public CertPath engineGenerateCertPath(InputStream in, String encoding) throws CertificateEncodingException {
        return new X509CertPath(in, encoding);
    }

    public Iterator engineGetCertPathEncodings() {
        return X509CertPath.ENCODINGS.iterator();
    }

    private final X509CertificateImpl generateCert(InputStream inStream) throws IOException, CertificateException {
        if (inStream == null) {
            throw new CertificateException("missing input stream");
        }
        if (!inStream.markSupported()) {
            inStream = new BufferedInputStream(inStream, 8192);
        }
        inStream.mark(20);
        int i = inStream.read();
        if (i == -1) {
            throw new EOFException();
        }
        if (i != 48) {
            inStream.reset();
            StringBuffer line = new StringBuffer(80);
            do {
                line.setLength(0);
                do {
                    if ((i = inStream.read()) == -1) {
                        throw new EOFException();
                    }
                    if (i == 10 || i == 13) continue;
                    line.append((char)i);
                } while (i != 10 && i != 13);
            } while (!line.toString().equals(BEGIN_CERTIFICATE));
            X509CertificateImpl ret = new X509CertificateImpl(new BufferedInputStream(new Base64InputStream(inStream), 8192));
            line.setLength(0);
            line.append('-');
            do {
                if ((i = inStream.read()) == -1) {
                    throw new EOFException();
                }
                if (i == 10 || i == 13) continue;
                line.append((char)i);
            } while (i != 10 && i != 13);
            if (!line.toString().equals(END_CERTIFICATE)) {
                throw new CertificateException("no end-of-certificate marker");
            }
            return ret;
        }
        inStream.reset();
        return new X509CertificateImpl(inStream);
    }

    private final X509CRLImpl generateCRL(InputStream inStream) throws IOException, CRLException {
        if (inStream == null) {
            throw new CRLException("missing input stream");
        }
        if (!inStream.markSupported()) {
            inStream = new BufferedInputStream(inStream, 8192);
        }
        inStream.mark(20);
        int i = inStream.read();
        if (i == -1) {
            throw new EOFException();
        }
        if (i != 48) {
            inStream.reset();
            StringBuffer line = new StringBuffer(80);
            do {
                line.setLength(0);
                do {
                    if ((i = inStream.read()) == -1) {
                        throw new EOFException();
                    }
                    if (i == 10 || i == 13) continue;
                    line.append((char)i);
                } while (i != 10 && i != 13);
            } while (!line.toString().startsWith(BEGIN_X509_CRL));
            X509CRLImpl ret = new X509CRLImpl(new BufferedInputStream(new Base64InputStream(inStream), 8192));
            line.setLength(0);
            line.append('-');
            do {
                if ((i = inStream.read()) == -1) {
                    throw new EOFException();
                }
                if (i == 10 || i == 13) continue;
                line.append((char)i);
            } while (i != 10 && i != 13);
            if (!line.toString().startsWith(END_X509_CRL)) {
                throw new CRLException("no end-of-CRL marker");
            }
            return ret;
        }
        inStream.reset();
        return new X509CRLImpl(inStream);
    }
}

