/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.callback;

import java.io.Serializable;
import javax.security.auth.callback.Callback;

public class PasswordCallback
implements Callback,
Serializable {
    private String prompt;
    private boolean echoOn;
    private char[] inputPassword;

    public PasswordCallback(String prompt, boolean echoOn) {
        this.setPrompt(prompt);
        this.echoOn = echoOn;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public boolean isEchoOn() {
        return this.echoOn;
    }

    public void setPassword(char[] password) {
        this.inputPassword = password == null ? null : (char[])password.clone();
    }

    public char[] getPassword() {
        if (this.inputPassword == null) {
            return null;
        }
        return (char[])this.inputPassword.clone();
    }

    public void clearPassword() {
        if (this.inputPassword != null) {
            for (int i = 0; i < this.inputPassword.length; ++i) {
                this.inputPassword[i] = '\u0000';
            }
            this.inputPassword = null;
        }
    }

    private void setPrompt(String prompt) throws IllegalArgumentException {
        if (prompt == null || prompt.length() == 0) {
            throw new IllegalArgumentException("invalid prompt");
        }
        this.prompt = prompt;
    }
}

