/*
 * EDMA: Entorno de Desarrollo Modular y Abierto
 * Object Oriented and Componetware Framework
 * Copyright (C) 1998, 2002, 2003, 2004, 2005, 2006, 2007, 2008, 2010, 2013
 *    David Martnez Oliveira
 *
 * This file is part of EDMA.
 *
 * EDMA is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * EDMA is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with EDMA.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
**************************************************
    Entorno de Desarrollo Modular y Abierto (EDMA)
    EDMA 0.9.4
    (c) David Martnez Oliveira
    File generated by : EDMA C Implementation Builder class
------------------------------------------------------
    Module Type : CLASS IMPLEMENTATION
    Class List  : MULTI_SERIALIZER
    Description : Serializer class for compound objects
    Author      : David Martnez Oliveira
    Date        : 23th, Novemberm 2002
    Version     : 0.0
-----------------------------------------------------
  REVISIONS :
***************************************************
*/
 
/*
***************************************************
  General Header Files
***************************************************
*/
 
/* Add here the includes you need for your class*/
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

/*
***************************************************
  EDMA Header Files
***************************************************
*/
 
#include <edma.h>

/*
***************************************************
  Private Data Struct for class MULTI_SERIALIZER
***************************************************
*/

#define SUPER 1
#define SUB   2
 
typedef struct
{
  EDMAT_BUFFER		buffer;
  EDMAT_BUFFER          vmap;
  EUint32               cnt;
} DtMULTI_SERIALIZER;

/************************************************************
 * Internal Data Structs
 ************************************************************/

/* Property record to store object's properties*/
typedef struct
{
  ESint32         type;
  ESint32         size;
  unsigned char   data[1];
} PROP_RECORD;

typedef struct
{
  OBJID           virtual_id;    /* Virtual Identifier for the serialized object */
  EChar           class_name[EDMA_CLASS_NAME_LEN]; /* serialized object class*/
  ESint32         major_version;
  ESint32         minor_version;
  PROP_RECORD     data[1];  /* PROP_RECORD packed array for serialized object*/
} OBJECT_RECORD;

typedef struct
{
  OBJID           real_id;
  OBJID           virtual_id;
} VIRTUAL_ID_MAP;

typedef struct
{
  ESint32     type;
  OBJID       src;
  OBJID       dst;
  ESint32     size;
  EChar       Id[EDMA_GENERAL_ID_LEN];
} MAPPING_RECORD;

typedef struct
{
  EChar           serializer_class[EDMA_CLASS_NAME_LEN];
  ESint32         major_version;
  ESint32         minor_version;
  ESint32         n_obj;
  ESint32         n_ap;
  unsigned char   data[1]; /* Opaque array to store serialized data */
  /* Object Record
       Property Records
     ...
     Virtual Identifier Mapping Table
   */
} DATA_STREAM;


ESint32 _marshall_simple_object (EDMAT_BUFFER *buffer, OBJID id);
ESint32 _marshall_compound_object (OBJID mems, OBJID IdObj, OBJID id);
ESint32 _marshall_anchor_points (OBJID mems, OBJID IdObj);
ESint32 _unmarshall_simple_object (OBJID ms, OBJID *id);
ESint32 _vmap_locate (OBJID IdObj, OBJID id);
OBJID   _vmap_at (OBJID IdObj, ESint32 i);
ESint32 _vmap_add (OBJID IdObj, OBJID id);
/*
***************************************************
  Method Declaration for class MULTI_SERIALIZER
***************************************************
*/
 
ESint32 EDMAPROC
MULTI_SERIALIZERmarshallOrS32(OBJID IdObj, OBJID id)
{
  DtMULTI_SERIALIZER	*m;
  CLASSID               cid;
  OBJID                 ms, n_ap;
  ESint32               len;
  ESint32               size;
  EDMAT_BUFFER          aux, aux1;
  
  m = (DtMULTI_SERIALIZER *) edma_get_data_ref (IdObj);
  m->cnt = 0;
  /* Get object class id and test object existence */
  if ((cid = edma_get_obj_class_id (id)) == -1)
    {
      edma_printf_obj (IdObj, "[Marshall] **ERROR** Can't get class id for object %d", id);
      return -1;
    }

  if ((ms = edma_new_obj ("MEMORY_STREAM")) == -1)
    {
      edma_printf_obj (IdObj, "[Marshall] **ERROR** Can't create MEMORY_STREAM object");
      return -1;
    }

  /* Init serializer buffer */
  edma_buffer_alloc (&aux, sizeof (DATA_STREAM));
  /* Stores information about the serializer to be used */
  strcpy (((DATA_STREAM *)aux.dat)->serializer_class, "MULTI_SERIALIZER");
  ((DATA_STREAM *)aux.dat)->major_version = 0;
  ((DATA_STREAM *)aux.dat)->minor_version = 0;

  /* Sets up variables to take into account the header just created */
  size = EDMA_CLASS_NAME_LEN + 2 * sizeof (ESint32); /* Current stream size*/

  len = aux.Size;
  edma_met3 (ms, "write", aux, &len);
  
  edma_buffer_free (&aux);

  _marshall_compound_object (ms, IdObj, id);
  n_ap =  _marshall_anchor_points (ms, IdObj);

  edma_rprop3 (ms, "buf", &aux1);
  
  ((DATA_STREAM *)aux1.dat)->n_obj = m->cnt;
  ((DATA_STREAM *)aux1.dat)->n_ap = n_ap;
  
  edma_buffer_alloc (&aux, aux1.Size);
  memcpy (aux.dat, aux1.dat, aux1.Size);
  
  edma_wprop3 (IdObj, "buffer", aux);
  
  edma_free_obj (ms);

  return 0;
}

/******************************************************
 * Helper functions
 ********************************************************/
ESint32
_marshall_compound_object (OBJID mems, OBJID IdObj, OBJID id)
{
  DtMULTI_SERIALIZER	*m;
  ESint32               i, len, n;
  OBJID                 temp_id;
  EDMAT_BUFFER          aux;

  m = (DtMULTI_SERIALIZER *) edma_get_data_ref (IdObj);

  /* Locate object in vmap table*/
  if ((_vmap_locate (IdObj, id)) == -1)
    {
      len = _marshall_simple_object (&aux, id);
      _vmap_add (IdObj, id);
      edma_met3 (mems, "write", aux, &len);
      edma_buffer_free (&aux);
    }
  else
    return -1;

  /* Recursive call for superobjects */
  n = edma_get_obj_num_superobjects (id);
  for (i = 0; i < n; i++)
    {
      temp_id = edma_get_obj_superobject (id, i);
      /* Get anchor point information*/
      _marshall_compound_object (mems, IdObj, temp_id); 

    }

  /* Recursive call for subobjects */
  n = edma_get_obj_num_subobjects (id);
  for (i = 0; i < n; i++)
    {
      temp_id = edma_get_obj_subobject (id, i);
      /* Get anchor point information*/
      _marshall_compound_object (mems, IdObj, temp_id); 
    }

  return 0;
}


ESint32
_marshall_anchor_points (OBJID mems, OBJID IdObj)
{
  DtMULTI_SERIALIZER	*m;
  ESint32               i, j, k, len, n, n_objs, n_items;
  OBJID                 temp_id, temp_id1;
  EDMAT_BUFFER          aux;
  VIRTUAL_ID_MAP        *p;
  EChar                 ap_name[EDMA_GENERAL_ID_LEN];
  MAPPING_RECORD        *mr;

  m = (DtMULTI_SERIALIZER *) edma_get_data_ref (IdObj);

  p = (VIRTUAL_ID_MAP*) m->vmap.dat;
  n_objs = m->cnt;
  n_items = 0;
  aux.h=(HMEM)0;

  /* Process items*/
  for (k = 0; k < n_objs; k++)
    {
      j = p[k].real_id;

      n = edma_get_obj_num_superobjects (j);
      if (n)
	{
	  if ((edma_buffer_realloc (&aux, sizeof (MAPPING_RECORD) * (n_items + n ))) == -1)
	    {
	      edma_printf_obj (IdObj, "[%s] **ERROR** Can't realloc buffer", __FUNCTION__);
	      return -1;
	    }
	}
      mr = (MAPPING_RECORD*) aux.dat;
      for (i = 0; i < n; i++)
	{
	  temp_id = edma_get_obj_superobject (j, i);
	  temp_id1 = _vmap_locate (IdObj, temp_id);
	  edma_get_obj_superobject_ap (j, i, ap_name);
	  /* Get anchor point information*/
	  mr[n_items].type = SUPER;
	  mr[n_items].src = k;
	  mr[n_items].dst = temp_id1;
	  mr[n_items].size = strlen(ap_name);
	  strcpy (mr[n_items].Id, ap_name);

	  n_items ++;
	}
      
      /* Recursive call for subobjects */
      n = edma_get_obj_num_subobjects (j);
      if (n)
	{
	  if ((edma_buffer_realloc (&aux, sizeof (MAPPING_RECORD) * (n_items + n))) == -1)
	    {
	      edma_printf_obj (IdObj, "[%s] **ERROR** Can't realloc buffer", __FUNCTION__);
	      return -1;
	    }

	}
      mr = (MAPPING_RECORD*) aux.dat;
      for (i = 0; i < n; i++)
	{
	  temp_id = edma_get_obj_subobject (j, i);
	  temp_id1 = _vmap_locate (IdObj, temp_id);
	  edma_get_obj_subobject_ap (j, i, ap_name);
	  /* Get anchor point information*/
	  mr[n_items].type = SUB;
	  mr[n_items].src = k;
	  mr[n_items].dst = temp_id1;
	  mr[n_items].size = strlen(ap_name);
	  strcpy (mr[n_items].Id, ap_name);

	  n_items++;
	}
    }

  len = aux.Size;
  edma_met3 (mems, "write", aux, &len);


  return n_items;
}



ESint32 
_marshall_simple_object (EDMAT_BUFFER *buffer, OBJID id)
{
  CLASSID       cid;
  ESint32       n_prop;
  unsigned char *data;
  EUint32       type, size, new_size, old_size, i;
  EChar         prop_name[EDMA_PROP_NAME_LEN];
  EDMAT_BUFFER  aux;
  unsigned char base_type[8]; /* Max size for base types is 8 bytes*/
  PROP_RECORD   *item;

  /* Get object class identifier*/
  if ((cid = edma_get_obj_class_id (id)) == -1)
    {
      edma_printf ("[_marshall_simple_object]*ERROR* Can't get class id for object %d", id);
      return -1;
    }
  /* Get prop num */
  if ((n_prop = edma_get_prop_num (cid)) == -1)
    {
      edma_printf ("[_marshall_simple_object]*ERROR* Can't get number of properties "
		   "for class id %ld", cid);
      return -1;
    }

  /* Alloc base record and initialize. Virtual id is set from outside this function */
  edma_buffer_alloc (buffer, sizeof (OBJECT_RECORD));
  edma_get_class_name (cid, ((OBJECT_RECORD *)buffer->dat)->class_name);

  /* Begin propery parsing */
  new_size = 0;
  old_size= EDMA_CLASS_NAME_LEN + 2 * sizeof (ESint32) + sizeof(OBJID);

#if 0
  edma_printf ("Marshalling %d property from class %s\n",
	       n_prop, ((OBJECT_RECORD *)buffer->dat)->class_name);
#endif

  for (i = 0; i < n_prop; i++)
    {
      /* Get property information */
      edma_get_prop_name (cid, i, prop_name);
      type = edma_get_prop_type_id (cid, i);
      size = edma_get_type_size (type);
      /* First implementation. We just consider simple types*/
      /* Here we process special types */
      switch (type)
	{
	case DT_EBUFFER:
	  edma_rprop1 (id, i, &aux);
	  size = aux.Size;
	  break;
	case DT_EZSTRING:
	  size = edma_prop1_size (id, i) + 1; 
	  break;
	default:
	  break;
	}

      //printf ("++ Property %d %d bytes\n", i, size);
      //new_size = old_size + sizeof (PROP_RECORD) + size;
      new_size = old_size + sizeof (ESint32) * 2 + size;
      edma_buffer_realloc (buffer, new_size);

      //item = (PROP_RECORD*)((EPByte)buffer->dat + old_size);
      item = (PROP_RECORD*)((EPByte)buffer->dat + old_size);
      item->type = type;
      item->size = size;
      switch (type)
	{
	case DT_EBUFFER:
	  data = (unsigned char*) aux.dat;
	  memcpy (item->data, data, size);
	  break;
	case DT_EZSTRING:
	  memset (item->data, 0, item->size);
	  edma_rprop1 (id, i, item->data);
	  break;
	default:
	  edma_rprop1 (id, i, &base_type);
	  data = base_type;
	  memcpy (item->data, data, size);
	  break;
	}

      old_size = new_size;
    }

  //item = (PROP_RECORD *) ((OBJECT_RECORD *)buffer->dat)->data;
  printf ("Total size is: %d\n", old_size);
  return old_size;
}



ESint32 EDMAPROC
MULTI_SERIALIZERunmarshallsOrS32(OBJID IdObj, OBJID *id)
{
  DtMULTI_SERIALIZER	*m;
  DATA_STREAM           *header;
  ESint32               i, len;
  OBJID                 ms, temp_id;
  OBJID                 src_id, dst_id;
  EDMAT_BUFFER          aux;
  MAPPING_RECORD        *mr;

  m = (DtMULTI_SERIALIZER *) edma_get_data_ref (IdObj);

  /* Initialize variables*/
  edma_buffer_free (&m->vmap);
  m->cnt = 0;

  if ((ms = edma_new_obj ("MEMORY_STREAM")) == -1)
    {
      edma_printf_obj (IdObj, "[Unmarshall] Can't create memory stream");
      return -1;
    }
  /* Set serialized stream in a memory stream */
  edma_rprop3 (IdObj, "buffer", &aux);
  edma_wprop3 (ms, "buf", aux);

  /* Read the header from memory stream*/
  len = sizeof (DATA_STREAM);
  edma_buffer_alloc (&aux, len);
  edma_met3 (ms, "read", &aux, &len);

  /* get header ... check if this serializer is suitable to handle the data
   * we need to define a general structure to deal with multiple serializers*/
  header = (DATA_STREAM*) m->buffer.dat;
  edma_log (IdObj, "Stream serialized using %s v %d.%d", 
	    header->serializer_class, 
	    header->major_version, header->minor_version);
  edma_log (IdObj, "Unmarshalling compound object. %d subobjects and %d ap rules",
	    header->n_obj, header->n_ap);

  /* For each object in the block (this data is in the header)
   * Unmarshall object (create single object and recover properties values*/
  for (i = 0; i < header->n_obj; i++)
    {
      _unmarshall_simple_object (ms, &temp_id);
      _vmap_add (IdObj, temp_id);
    }

  /* For each anchor point rule in the block (this data is in the header)
   * Link the required objects using the vmap table built while unmarshalling simple objects */
  for (i = 0; i < header->n_ap; i++)
    {
      len = sizeof (MAPPING_RECORD);
      edma_met3 (ms, "read", &aux, &len);
      mr = (MAPPING_RECORD*) aux.dat;

      src_id = _vmap_at (IdObj, mr->src);
      dst_id = _vmap_at (IdObj, mr->dst);
      switch (mr->type)
	{
	case SUPER:
	  edma_add_superobject (src_id, dst_id, mr->Id);
	  break;
	case SUB:
	  edma_add_subobject (src_id, dst_id, mr->Id);
	  break;
	}
      edma_buffer_free (&aux);
    }
  *id = _vmap_at (IdObj, 0);


  return 0;
}

ESint32
_unmarshall_simple_object (OBJID ms, OBJID *id)
{
  CLASSID           cid;
  EDMAT_BUFFER      aux, data;
  ESint32           i, len, n_prop, type;
  OBJECT_RECORD     *obj;
  PROP_RECORD       *item;
  EChar             cname[1024];

  /* Read Object record from stream */
  len = sizeof (OBJECT_RECORD) - sizeof (PROP_RECORD);
  edma_buffer_alloc (&aux, len);
  edma_met3 (ms, "read", &aux, &len);

  obj = (OBJECT_RECORD*) aux.dat;

  /* FIXME: We must check class versioning...*/
  if ((cid = edma_get_class_id (obj->class_name)) == -1)
    {
      edma_printf ("[%s] Class '%s' doesn't exist", __FUNCTION__, obj->class_name);
      return -1;
    }

  edma_load_class_int (cid);
  /* Get prop num */
  if ((n_prop = edma_get_prop_num (cid)) == -1)
    {
      edma_printf ("[%s] ** ERROR ** Can't get number of properties "
		   "for class id %ld", __FUNCTION__, cid);
      return -1;
    }

  /* Create the object without inheritance information*/
  *id = edma_new_simple_obj (obj->class_name, NULL);
  edma_printf ("Received class id: %d. Creating objecto of class '%s'", 
	       cid, obj->class_name);
  /********************************************************************************* 
   * NOTE:
   * Check what happens with parent and pseudiparent information... we aren't recovering
   * it... make some tests and if require add it to the serialized stream
   **********************************************************************************/
  
  /* Loop through object property values */
  edma_buffer_free (&aux);
  printf ("Unmarshalling object of class %s (%d props)\n",
	  obj->class_name, n_prop);
  for (i = 0; i < n_prop; i++)
    {
      type = edma_get_prop_type_id (cid, i);
      len = sizeof(ESint32) * 2;
      edma_buffer_alloc (&aux, len);
      edma_met3 (ms, "read", &aux, &len);

      item = (PROP_RECORD*) aux.dat;
      printf ("++ Property %d %d bytes\n", i, item->size);
      if (type != item->type)
	{
	  edma_printf ("[%s] Type missmatch in property %d (received:%d expected:%d)",
		       __FUNCTION__, i, item->type, type);
	  return -1;
	}

      /* Read the data */
      //len = item->size + 4; 
      len = item->size; 
      edma_buffer_alloc (&data, len);
      edma_met3 (ms, "read", &data, &len);
      
      switch (type)
	{
	case DT_EBUFFER:
	  _edma_wprop1_pargs (*id, i, &data);
	  break;
	case DT_EZSTRING:
	  edma_wprop1 (*id, i, data.dat);
	  break;
	default:
	  _edma_wprop1_pargs (*id, i, data.dat);
	  edma_buffer_free (&data);	  
	}
      edma_buffer_free (&aux);
    } 

  return 0;
}


ESint32 EDMAPROC
MULTI_SERIALIZERsaveZrS32(OBJID IdObj, EPChar fname)
{
  DtMULTI_SERIALIZER	*m;
  OBJID         id;
  ESint32       len;
  
  m = (DtMULTI_SERIALIZER *) edma_get_data_ref (IdObj);
  if ((id = edma_new_obj ("NFILE")) == -1)
    {
      edma_printf_obj (IdObj, "[ERROR] Can't create 'NFILE' object");
      return -1;
    }
  if ((edma_met3 (id, "open", fname, "wb")) == -1)
    {
      edma_printf_obj (IdObj, "Can't open %s file to save data", fname);
      edma_free_obj (id);
      return -1;
    }
  len = m->buffer.Size;
  if ((edma_met3 (id, "write", m->buffer, &len)) == -1)
    {
      edma_printf_obj (IdObj, "Can't write data to file");
      edma_free_obj (id);
      return -1;
    }
  edma_met3 (id, "close");
  edma_free_obj (id);
  return 0;
}


ESint32 EDMAPROC
MULTI_SERIALIZERloadZrS32(OBJID IdObj, EPChar fname)
{
  DtMULTI_SERIALIZER	*m;
  OBJID         id;
  ESint32       len;
  
  m = (DtMULTI_SERIALIZER *) edma_get_data_ref (IdObj);
  if ((id = edma_new_obj ("NFILE")) == -1)
    {
      edma_printf_obj (IdObj, "[ERROR] Can't create 'NFILE' object");
      return -1;
    }
  if ((edma_met3 (id, "open", fname, "rb")) == -1)
    {
      edma_printf_obj (IdObj, "Can't open %s file to read data", fname);
      edma_free_obj (id);
      return -1;
    }
  len = (ESint32) edma_smet3 ("FILESYSTEM", "GetFileSize", fname);
  edma_printf_obj (IdObj, "[INFO] About to read %ld bytes from file %s", len, fname);
  /* Free old data and realloc buffer */
  if (m->buffer.dat)
    edma_buffer_free (&m->buffer);
  edma_buffer_alloc (&m->buffer, len);
  if ((edma_met3 (id, "read", &m->buffer, &len)) == -1)
    {
      edma_printf_obj (IdObj, "Can't write data to file");
      edma_free_obj (id);
      return -1;
    }
  edma_met3 (id, "close");
  edma_free_obj (id);
  return 0;
}

/********** END C IMPLEMENTATION SKELETON ******************/
/* vmap management functions */

/* Check if a given object exists in current vmap table*/
ESint32
_vmap_locate (OBJID IdObj, OBJID id)
{
  DtMULTI_SERIALIZER	*m;
  ESint32         n, i;
  VIRTUAL_ID_MAP  *p;

  m = (DtMULTI_SERIALIZER *) edma_get_data_ref (IdObj);

  p = (VIRTUAL_ID_MAP*) m->vmap.dat;
  n = m->cnt;

  for (i = 0; i < n; i++)
    if (p[i].real_id == id)
      {
	return i;
      }

  return -1;
}

OBJID
_vmap_at (OBJID IdObj, ESint32 i)
{
  DtMULTI_SERIALIZER	*m;
  VIRTUAL_ID_MAP  *p;

  m = (DtMULTI_SERIALIZER *) edma_get_data_ref (IdObj);

  p = (VIRTUAL_ID_MAP*) m->vmap.dat;

  if (i >= m->cnt)
    {
      edma_printf_obj (IdObj, "[%s] Index out of range.... Data may be corrupted", __FUNCTION__);
      return -1;
    }

  return p[i].real_id;
}

ESint32
_vmap_add (OBJID IdObj, OBJID id)
{
  DtMULTI_SERIALIZER	*m;
  ESint32               n;
  VIRTUAL_ID_MAP        *p;

  m = (DtMULTI_SERIALIZER *) edma_get_data_ref (IdObj);


  n = m->cnt;

  if ((_vmap_locate (IdObj, id)) == -1) 
    {
      /* If object id isn't in vmap table, add it*/
      if ((edma_buffer_realloc (&m->vmap, 
				sizeof (VIRTUAL_ID_MAP) * (m->cnt + 1))) == -1)
	{
	  edma_printf_obj (IdObj, "(_vmap_add) ** ERROR **. Can't alloc memory");
	  return -1;
	}

      p = (VIRTUAL_ID_MAP*) m->vmap.dat;
      p[m->cnt].real_id = id;
      p[m->cnt].virtual_id = m->cnt;
      m->cnt++;
      
      return (m->cnt - 1);
    }

  return -1;
}
