;;; -*- Mode: LISP; Syntax: COMMON-LISP; Base: 10.; Package: XIT; -*-
;;;_____________________________________________________________________________
;;;
;;;                       System: XIT
;;;                       Module: Copy Window Button
;;;                       (Version 1.0)
;;;
;;; Copyright (c): Forschungsgruppe DRUID, Juergen Herczeg
;;;                Universitaet Stuttgart
;;;
;;; File: /usr/local/lisp/xit/utilities/copy.lisp
;;; File Creation Date: 5/19/90 09:48:11
;;; Last Modification Time: 07/24/92 14:26:31
;;; Last Modification By: Juergen Herczeg
;;;
;;;
;;; Changes (worth to be mentioned):
;;; ================================
;;;_____________________________________________________________________________

(in-package :xit)

;(pmds::load-system :copy-objects)

(define-resources
  (* copy-button x) 200
  (* copy-button y) 5
  (* copy-button border-width) 2
  (* copy-button inside-border) 5
  (* copy-button background) "white"
  (* copy-button cursor) "dot"
  (* copy-button font) '(:face :italic))

(defparameter *copy-button* nil)

(defun make-copy-button (&optional (toplevel *toplevel*))
  (setq *copy-button* (make-window 'window-identifier
				   :parent toplevel
				   :name :copy-button
				   :label "Copy Window"
				   :action #'copy-and-move-window)))
    
(if (and (boundp '*display*) *display*
	 (boundp '*toplevel*) *toplevel*)
    (make-copy-button *toplevel*)
  (add-open-toplevel-hook 'make-copy-button))
       