;;; -*- Mode: LISP; Syntax: COMMON-LISP; Package: CLUEI; Base: 10; -*-

;;; 06/19/1992 (Juergen) 
;;;
;; optimized version of initialize-geometry by using while-changing-layout;
;; initialize-geometry for child may trigger change-layout for composite
 
(in-package :cluei)

(defmethod initialize-geometry ((composite composite))
  ;; Negotiate initial managed geometry from the bottom up
  (declare (type composite composite))
  (let ((newly-managed 0) new-child)

    ;; Recursively descend to initialize-geometry for all unrealized managed children
    (dolist (child (composite-children composite))            
      (when (and (not (realized-p child)) (managed-p child))
	(setf new-child child)
	(incf newly-managed)
	;;(while-changing-layout (composite) ;; no final change-layout needed
	(setf (composite-changing-layout-p composite) t) ;; ***
	(initialize-geometry child)
	(setf (composite-changing-layout-p composite) nil) ;; ***
	;;)
      ))

    ;; Optimization: don't bother to change layout unless necessary
    (when new-child      
      (change-layout
	composite
	(unless (> newly-managed 1) new-child)))))


