;;; -*- Mode: LISP; Syntax: Common-Lisp; Package: USER; Base: 10; -*-
;;;_____________________________________________________________________________
;;;
;;;                       System: XIT
;;;                       Version: 5.8.0
;;;
;;; Copyright (c): Forschungsgruppe DRUID, Juergen Herczeg
;;;                Universitaet Stuttgart
;;;
;;; File: /usr/local/lisp/xit/defsystem.lisp
;;; File Creation Date: 01/30/90 09:52:48
;;; Last Modification Time: 12/15/92 14:40:14
;;; Last Modification By: Juergen Herczeg
;;;
;;; Changes (worth to be mentioned):
;;; ================================
;;; 04/29/1991 (Matthias) New: System :xit-resource-sheet
;;; 06/25/1992 (Matthias) Changed defparameter to defvar
;;;  .e.g. augmented *bitmap-directory* was overwritten when loading 
;;;  defsystem again.
;;; 08/04/1992 (Matthias) Moved rgb from system :xit-color-sheet to :xit
;;;                       since it is needed for colored multi-line-text-dispels
;;; 08/31/1992 (Matthias) Added clx-auth
;;;_____________________________________________________________________________


(in-package :user)

;;; XIT Version 

(pushnew :XIT-V5.8.0 *features*)
(pushnew :XIT *features*)


;;; Package Definitions
;;;

#+xit-ansi-common-lisp
(defpackage common-lisp-utilities
  (:nicknames "UT")
  (:use common-lisp
	#+pcl pcl
	#+(and (not pcl) lucid) clos))

#-xit-ansi-common-lisp
(in-package "COMMON-LISP-UTILITIES" :nicknames '("UT")
                                    :use '("LISP" #+pcl "PCL")
)

#+xit-ansi-common-lisp
(defpackage xit
  (:use common-lisp common-lisp-utilities
	#+pcl pcl
	#+(and (not pcl) lucid) clos
	clue xlib)
  )

#-xit-ansi-common-lisp
(in-package "XIT"
            :use '("LISP" "COMMON-LISP-UTILITIES" #+pcl "PCL" "CLUE" "XLIB")
)


(in-package :xit)

;;; default pathname for bitmap files
;;;
(defvar *bitmap-directory*
    #-lispm '("." "/usr/local/lisp/xit/bitmaps/")
    #+lispm '("DIA:/usr/local/lisp/xit/bitmaps/")
    )

;;; default extensions for bitmap files
;;;
#-lispm (defvar *bitmap-extensions* '("xbm" "bm"))
#+lispm (defvar *bitmap-extensions* '("XBM" "BM"))

;;; prefix for images to be cached
;;;
(defvar *bitmap-prefix* "XBM-")

;;; default pathname for font tables
;;;
(defvar *font-table-directory*
    #-lispm '("." "/usr/local/lisp/xit/font-tables/")
    #+lispm '("DIA:/usr/local/lisp/xit/font-tables/")
    )

;;; default pathname for audio files
;;;
(defvar *sound-directory*
    #-lispm '("." "/usr/local/lisp/xit/sounds/"
	      "/usr/demo/SOUND/sounds/" "/usr/local/druid/sounds/")
    #+lispm '("DIABOLO:/usr/local/lisp/xit/sounds/"
	      "DIABOLO:/usr/demo/SOUND/sounds/"
	      "DIABOLO:/usr/local/druid/sounds/")
    )

;;; default extensions for audio files
;;;
#+LISPM (defvar *sound-extensions* '("AU"))
#-LISPM (defvar *sound-extensions* '("au"))

;;; variable indicating whether server and client run on the same host
;;;
(defvar *same-host-p* t)


;;; System Definitions
;;;

(in-package :pmds)

(define-system :ut
       (:default-directory "/usr/local/lisp/xit/cl-utilities/")
   (:module macros
	    ("cl-utilities"))
   (:module copy
	    ("copy-objects"))
   (:module completion
	    ("completion"))
   (:serial macros copy))

(define-system :xit
       (:default-directory #-lispm "/usr/local/lisp/xit/kernel/"
			   #+lispm "DIABOLO:/usr/local/lisp/xit/kernel/")
   (:module :ut
	    :subsystem
	    (:default-directory "/usr/local/lisp/xit/")
	    )
   (:module clx-enhancements
	    ("clx+"
	     "clx-auth"))
   (:module macros
	    ("macros"))
   (:module before-patches
	    ("clx-patch-1"
	     "clue-patch-1"
	     "clue-patch-3"
	     "clue-patch-5"
	     "clue-patch-6"
	     "clue-patch-7"
	     "clue-patch-8"
	     "clue-patch-9"
	     "clue-patch-10"
	     "clue-patch-11"
	     "clue-patch-12"
	     "clue-patch-13"
	     "clue-patch-14"
	     "clue-patch-15"
	     ;;"openwin2.0-patch-1"
	     )
	    (:default-directory #-lispm "/usr/local/lisp/xit/patches/"
				#+lispm "DIABOLO:/usr/local/lisp/xit/patches/"))
   (:module main
	    ("general"
	     "mouse-tracking"
	     "display"
	     "scrolling"
	     "fonts"
	     "window"
	     "virtual-window"
	     "minimax"
	     "shadow-borders"
	     "rgb"             ; is needed in special-dispels
	     ;
	     "layouters"
	     "focus"
	     "view"
	     "transformers"
	     "application-connection"
	     "timers"
	     "interaction-window"
	     "toplevel"
	     "popup-window"
	     "shrinkable-window"
	     "intels"
	     "images" ;; *** this is were it should be loaded
	     "dispels" 
	     ;"images"  ;; *** to be removed again 
	     "special-dispels"
	     "virtual-dispels"
	     "containers"
	     "margins"
	     "title-window"
	     "icons"
	     "menus"
	     "switches"
	     "property-sheets"
	     "forms"
	     "paned-window"
	     "sliders"
	     "dialog-windows"
	     "sounds"
	     "copy-windows"
	     ))
   (:serial :ut clx-enhancements macros before-patches main)
   )


#+(and lucid clos (not pcl))
(define-system :lucid-clos-patch
       (:default-directory #-lispm "/usr/local/lisp/xit/patches/"
			   #+lispm "DIABOLO:/usr/local/lisp/xit/patches/")
    (:module main
	     ("lucid-clos-patch")))

(define-system :xit-identifier
       (:default-directory #-lispm "/usr/local/lisp/xit/utilities/"
			   #+lispm "DIABOLO:/usr/local/lisp/xit/utilities/")
    (:module main
	     ("window-identifier")))

(define-system :xit-window-pool-manager
       (:default-directory #-lispm "/usr/local/lisp/xit/utilities/"
			   #+lispm "DIABOLO:/usr/local/lisp/xit/utilities/")
    (:module main
	     ("window-pool-manager")))

;;(define-system :copy-objects
;;       (:default-directory #-lispm "/usr/local/lisp/xit/utilities/"
;;			   #+lispm "DIABOLO:/usr/local/lisp/xit/utilities/")
;;    (:module main
;;	     ("copy-objects"
;;	      "copy-windows")))

(define-system :xit-utilities
       (:default-directory #-lispm "/usr/local/lisp/xit/utilities/"
			   #+lispm "DIABOLO:/usr/local/lisp/xit/utilities/")
    (:module main
	     ("mouse-documentation"
	      "system-menu"
	      ;;"tree-window" no longer in use
	      "hardcopy")))

(define-system :xit-color-sheet
       (:default-directory #-lispm "/usr/local/lisp/xit/utilities/"
			   #+lispm "DIABOLO:/usr/local/lisp/xit/utilities/")
       (:module utilities
		("fancy-dispels"))
       (:module color-sheet
		("color-sheet"))
       (:serial utilities color-sheet))

(define-system :xit-resource-sheet
       (:default-directory #-lispm "/usr/local/lisp/xit/utilities/"
			   #+lispm "DIABOLO:/usr/local/lisp/xit/utilities/")
       (:module :xit-color-sheet
		:subsystem
		(:default-directory "/usr/local/lisp/xit/")
		) 
       (:module resource-sheet
		("resource-sheet"))
       (:serial :xit-color-sheet resource-sheet))

(define-system :xit-examples
       (:default-directory #-lispm "/usr/local/lisp/xit/examples/"
			   #+lispm "DIABOLO:/usr/local/lisp/xit/examples/")
    (:module defs
	     ("definitions"))
    (:module init
	     ("initialization"))
    (:module main
	     ("dispel-examples"
	      "virtual-examples"
	      "layouter-examples"
	      "icon-examples"
	      "menu-examples"
	      "switch-examples"
	      "property-sheet-examples"
	      ;;"form-examples" obsolete
	      "slider-examples"
	      "margin-examples"
	      "paned-window-examples"
	      "sound-examples"
	      "animation-examples"
	      ))
    (:serial defs init main)
    )




			 



