;;  -*-  indent-tabs-mode:nil; coding: utf-8 -*-
;;  Copyright (C) 2018
;;      "Mu Lei" known as "NalaGinrut" <NalaGinrut@gmail.com>
;;  Artanis is free software: you can redistribute it and/or modify
;;  it under the terms of the GNU General Public License and GNU
;;  Lesser General Public License published by the Free Software
;;  Foundation, either version 3 of the License, or (at your option)
;;  any later version.

;;  Artanis is distributed in the hope that it will be useful,
;;  but WITHOUT ANY WARRANTY; without even the implied warranty of
;;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;  GNU General Public License and GNU Lesser General Public License
;;  for more details.

;;  You should have received a copy of the GNU General Public License
;;  and GNU Lesser General Public License along with this program.
;;  If not, see <http://www.gnu.org/licenses/>.

(define-module (artanis common trie)
  #:use-module (artanis utils)
  #:use-module ((rnrs) #:select (define-record-type))
  #:export ())

(define-record-type trie
  (fields sub-tries content))

(::define (new-trie root)
  (:anno: (char) -> trie)
  (make-trie '() root))

(define-syntax-rule (next-level t c)
  (assoc-ref (trie-sub-tries t) c))

(::define (trie-lookup t str)
  (:anno: (string) -> ANY)
  (let ((len (string-length str)))
    (let lp ((t t) (i 0))
      (cond
       ((= i len) #f)
       ((next-level t (string-ref str i))
        => (lambda (next-trie)
             (lp next-trie (1+ i))))
       (else #f)))))
