#include <stdio.h>
#ifdef __STDC__
#include <stdarg.h>
#else
#include <varargs.h>
#endif
#include "whois.h"

werr_str_t  werr_str[] = {
   { WERR_INTERNAL, "Internal Error"}, /* Hast to be first */
   { WINFO_WELCOME, "Welcome to the WHOIS++ server. Type HELP for help."},
   { WINFO_HOLDING, "Holding connection"},
   { WINFO_CLOSING, "Closing connection."},
   { WINFO_OK, "OK"},
   { WWARN_NO_CONSTRAINT, "No such constraint"},
   { WWARN_INVALID_CONST_VAL, "Invalid value for constraint"},
   { WWARN_INVALID_ATTR, "Invalid attribute"},
   { WWARN_CON_NOT_GLOBAL, "Constraint not global"},
   { WWARN_CON_NOT_GLOBAL, "Constraint not local"},
   { WWARN_NOARG_COMMAND, "Command does not take an argument"},
   { WERR_BAD_INPUT, "Badly formed input"},
   { WERR_LOGFILE, "Can't open log file"},
   { WERR_OPEN_CONFIG, "Can't open configuration file"},
   { WERR_TMPL_FILE, "Can't read template initialization file"},
   { WERR_LAST, ""}  /* Has to be last */
};

#ifdef __STDC__

char *wErrorReply(int werr_no, char *fmt, ...) 
{
   va_list ap;
   static char out1[2048];
   char output[2048];
   int i;

   va_start(ap, fmt);

   vsprintf(output, fmt, ap);

   for(i = 0; i < WERR_LAST; i++){

      if(werr_str[i].werr_no == werr_no){

	 sprintf(out1, "%% %d %s ", werr_str[i].werr_no, werr_str[i].werr_msg);
	 break;
      }
   }

   if(i == WERR_LAST)
	 sprintf(out1, "%% %d %s ", werr_str[0].werr_no, werr_str[0].werr_msg);

   strcat(out1, output);
	 
   va_end(ap);

   return out1;
}

#else

char *wErrorReply(va_alist)
   va_dcl
{
   va_list ap;
   static char out1[2048];
   char output[2048];
   int i;
   int werr_no;
   char *fmt;

   va_start(ap);

   werr_no = va_arg(ap, int);
   fmt = (ap, char *);

   vsprintf(output, fmt, ap);

   for(i = 0; i < WERR_LAST; i++){

      if(werr_str[i].werr_no == werr_no){

	 sprintf(out1, "%% %d %s ", werr_str[i].werr_no, werr_str[i].werr_msg);
	 break;
      }
   }

   if(i == WERR_LAST)
	 sprintf(out1, "%% %d %s ", werr_str[0].werr_no, werr_str[0].werr_msg);

   strcat(out1, output);
	 
   va_end(ap);

   return out1;
}

#endif
