
/* Copyright (c) CNIDR (Work in progress) */

/* WIDE AREA INFORMATION SERVER SOFTWARE:
   No guarantees or restrictions.  See the readme file for the full standard
   disclaimer.

   Brewster@think.com
*/

/* This is a simple shell user interface for generating wprot packets.
 * -brewster 7/90
 *
 * $Log: shell-ui.c,v $
 * Revision 1.1  1993/02/16  15:09:27  freewais
 * Initial revision
 *
 * Revision 1.34  92/06/03  17:29:49  jonathan
 * Fixed so it exits on NULL input.
 * 
 * Revision 1.33  92/04/29  13:21:12  jonathan
 * Updated for release.
 * 
 * Revision 1.32  92/04/09  14:19:53  morris
 * now, specifying a port on the command line does a remote search on the
 * local machine at the specified port.  the previous behavior was to do a
 * local search, even when you specify a port.
 * 
 * Revision 1.31  92/03/17  14:39:28  jonathan
 * modified to work with new ui scheme.
 * 
 * Revision 1.30  92/03/06  14:50:34  jonathan
 * Correctly handle init_connection <= 0.
 * 
 * Revision 1.29  92/03/06  12:34:57  jonathan
 * Use result of init_connection to set message length.
 * 
 * Revision 1.28  92/02/29  20:04:32  jonathan
 * Fixed spelling of opening.
 * 
 * Revision 1.27  92/02/21  11:47:48  jonathan
 * fixed code to re-init properly (instead of using connect_to_server).
 * 
 * Revision 1.26  92/02/20  16:13:15  jonathan
 * Added -m for max results.
 * 
 * Revision 1.25  92/02/16  12:13:36  jonathan
 * Added domainname to init message.
 * 
 *
 * Important functions:
 *   display_search_response
 *   main
 *
 */

/* to do:
 *  fix the number parser in view document number
 *  fix if <cr> put to view document number, same as q
 *  show the index again after viewing a document
 *  do a 'more' type thing on viewing the doc  
 *  do something to allow relevance feedback
 */

/* Unix includes */

#include <ctype.h>
#include <string.h>
#include <unistd.h>
#include <strings.h>

/* WAIS includes */

#include <ui.h>
#include <sockets.h>
#include <docid.h>

/* local includes */

#include "wais_interface.h"
#include "whois.h"


#define MAX_MESSAGE_LEN 100000
#define CHARS_PER_PAGE 10000 /* number of chars retrieved in each request */
#define MAX_FILE_NAME_LEN 1000
#define Z39_50_SERVICE "210"

#define WAISSEARCH_DATE "Thu Aug 27 1992"

#define MAX_KEYWORDS_LENGTH 1000
#define MAX_SERVER_LENGTH 1000
#define MAX_DATABASE_LENGTH 1000
#define MAX_SERVICE_LENGTH 1000

char* log_file_name;
FILE* logfile = NULL;

#define	 error(x) 

int wais_interface(server_name, service, result, keywords, database, maxhits, tmpl_type)
   char *server_name;
   int service;
   WItem  *result;
   char *keywords;
   char *database;
   int maxhits;
   char *tmpl_type;
{

   char userInfo[500];
   char* request_message = NULL; /* arbitrary message limit */
   char* response_message = NULL; /* arbitrary message limit */
   long request_buffer_length;	/* how of the request is left */
   SearchResponseAPDU  *query_response;
   SearchResponseAPDU  *retrieval_response;
   WAISSearchResponse  *query_info, *retrieval_info;
   long count, message_length = MAX_MESSAGE_LEN;
   FILE *connection;
   WAISSearchResponse *info = (WAISSearchResponse *) NULL;
   int doc_number;
   char tmp_str[1048576];


   if(((server_name == (char *) NULL) || (server_name[0] == '\0')) && service == 0)
      connection = NULL; /* do local searching */

#if 0

  /* If gatewaying allowed code up this */

   else {
      int socket_fd;

      /* remote search, fill in defaults if necessary */if (server_name[0] == '\0')

       gethostname(server_name,MAX_SERVER_LENGTH); /*default to local machine*/

     if (service[0] == '\0')
       strcpy(service, Z39_50_SERVICE); /* default */

     if (cliconnect(server_name,service, &socket_fd) != 0){
#if 0
	 error(A_ERR, "prwais_do_search", "Can't connect to %s service %d", server_name, service);
#endif
	 return(-1);
      }

   }
#endif
   
   request_message = (char*)s_malloc((size_t)message_length * sizeof(char));
   response_message = (char*)s_malloc((size_t)message_length * sizeof(char));

#if 0
   sprintf(userInfo, "waissearch %s, from host: %s", 
	 VERSION, hostname);
#endif

   sprintf(userInfo, "waissearch %s", VERSION);


   if((message_length = 
       init_connection(request_message, response_message,
		     message_length,
		     connection,
		     userInfo)) <= 0) {
#if 0
      error(A_ERR, "Error opening connection to %s via service %d", server_name, service);
#endif
      return(-1);
   }

   request_buffer_length = message_length; /* how of the request is left */

   if(generate_search_apdu(request_message + HEADER_LENGTH, &request_buffer_length,
			   keywords, database, NULL, maxhits) == NULL){
#if 0
      error(A_INTERR, "Error creating search APDU: request too large");
#endif
   }

  if(interpret_message(request_message, message_length - request_buffer_length, 
		       response_message, message_length, connection,false) == 0) {

      /* perhaps the server shut down on us, let's see: */

      if(connection != NULL) {
	 fclose(connection);
	 if((message_length = init_connection(request_message, response_message,
				  message_length,
				  connection,
				  userInfo)) <= 0){
#if 0
	    error(A_ERR, "Error opening connection to %s via service %d", server_name, service);
#endif
	    return(-1);
	 }
	if(interpret_message(request_message, 
			     message_length - request_buffer_length, 
			     response_message,
			     message_length,
			     connection,
			     false /* true verbose */
			     ) == 0)
	  fprintf(stderr,"Can't deliver message\n");

      }
#if 0
      error(A_ERR, "prwais_do_search", "returned message too large");
#endif
   }

   readSearchResponseAPDU(&query_response, response_message + HEADER_LENGTH);

#if 0
   display_search_response(query_response);

#endif

   query_info = (WAISSearchResponse *)query_response->DatabaseDiagnosticRecords;

   if((info = (WAISSearchResponse *) query_response->DatabaseDiagnosticRecords) != (WAISSearchResponse *) NULL){
      diagnosticRecord **d;

      d = info -> Diagnostics;

      if(d != NULL){
	 long i;

	 for(i = 0; d[i] != NULL; i++) {
	    if(d[i]->ADDINFO != NULL) {
	       sprintf(tmp_str, "Code: %s, %s;", d[i]->DIAG, d[i] ->ADDINFO);
	    }
	 }

	 return(-1);
      }
	       
   }
#if 0

   if(query_info->DocHeaders[0]->Score == 0)
      return(-1);
#endif

   if(!query_info -> DocHeaders)
     return(-1);

   if(query_info->DocHeaders[0]->BestMatch == -1)
      return(0);

   for(doc_number = 0; doc_number < query_response -> NumberOfRecordsReturned; doc_number++){

      if(1){
	 char *type;
	 int i;
	 WAISDocumentText *record;

	 /*
	  * We are sending all information along with the link so it is a
	  * "file" and cannot be expanded further
	  */

	 if(query_info->DocHeaders[doc_number]->Types == NULL)
	    type = s_strdup("TEXT");
	 else
	    type = s_strdup(query_info->DocHeaders[doc_number]->Types[0]);

	 request_buffer_length = message_length; /* how of the request is left */

	 if(0 ==
	    generate_retrieval_apdu(request_message + HEADER_LENGTH,
				    &request_buffer_length, 
				    query_info->DocHeaders[doc_number]->DocumentID, 
				    CT_byte,
				    0,
				    query_info->DocHeaders[doc_number]->DocumentLength,
				    type,
				    database
				    )) {
#if 0
	   error(A_INTERR, "prwais_do_search", "Error generating retrieval APDU: request too long");
#endif
	   break;
	 }
	    
	 if(0 ==
	    interpret_message(request_message, 
			      message_length - request_buffer_length, 
			      response_message,
			      message_length,
			      connection,
			      false /* true verbose */	
			      )) { /* perhaps the server shut down on us, let's see: */

	   if ( connection != NULL) {
	     fclose(connection);
	     if ((connection=connect_to_server(server_name,atoi(service))) == NULL) 
	       {
		 fprintf (stderr, "Error opening connection to %s via service %d.\n",
			  server_name, service);
		 exit(-1);
	       }
	     if(0 ==
		interpret_message(request_message, 
				  message_length - request_buffer_length, 
				  response_message,
				  message_length,
				  connection,
				  false /* true verbose */
				  )) {
	       printf("really couldn't deliver message");
	       break;
	     }
	   }
	   else {
	     printf("Error deliverring message");
	     break;
	   }
	 }
	    
	 readSearchResponseAPDU(&retrieval_response, 
				response_message + HEADER_LENGTH);

	 if(NULL == ((WAISSearchResponse *)retrieval_response->DatabaseDiagnosticRecords)->Text){

	 }

	 tmp_str[0] = '\0';

	 record = ((WAISSearchResponse *)retrieval_response->DatabaseDiagnosticRecords)->Text[0];
      
	 for(count = 0, i=0; count < record->DocumentText->size; count++){
	    long ch = (unsigned char)record->DocumentText->bytes[count];

	    if(27 == ch){

	    /* then we have an escape code */
	    /* if the next letter is '(' or ')', then ignore two letters */

	    if('(' == record->DocumentText->bytes[count + 1] ||
	       ')' == record->DocumentText->bytes[count + 1])
	       count += 1;             /* it is a term marker */
	    else
	       count += 4;		/* it is a paragraph marker */
	    }
	    else
	       tmp_str[i++] = ch;
	    
	 }

	 tmp_str[i] = '\0';

	 wAppendTerm(result, R_FULL_FMT, tmpl_type, query_info -> DocHeaders[doc_number] -> Headline);

	 breakout_template(result, tmp_str);

	 freeWAISSearchResponse( retrieval_response->DatabaseDiagnosticRecords); 
         freeSearchResponseAPDU( retrieval_response);
      }
      else{

      }


   }

   freeWAISSearchResponse(query_response->DatabaseDiagnosticRecords);         
   freeSearchResponseAPDU( query_response);

   s_free(request_message);
   s_free(response_message);
	 
   return(0);
}



int breakout_template(result, content)
   WItem *result;
   char *content;

{
   char *bptr;
   char curr_attribute[25600];
   char hold_str[25600];
   char tmp_str[25600];
   char holder[25600];
   int retval;
   char *cptr;


   curr_attribute[0] = '\0';
   holder[0] = '\0';
   tmp_str[0] = '\0';
   hold_str[0] = '\0';

   bptr = content;


   while(1){

      if((retval = sscanf(bptr, "%[a-zA-Z0-9:-]", holder)) == 1){

	 /* We haven't seen an attribute yet */

	 if(curr_attribute[0] != '\0'){

	    for(cptr = hold_str; (*cptr != NULL) && (isspace(*cptr)); cptr++);

	    if(*cptr != NULL){
	       char *a;
	       /* send out old attribute */

	       for(a = cptr; *a != '\0'; a++)	/* Convert tabs to spaces */
		  if((*a != ' ') && isspace(*a))
		     *a = ' ';

	       wAppendTerm(result, F_ATTR_VAL, curr_attribute,cptr);
	    }
	 }

	 bptr += strlen(holder);

	 /* bug */

	 cptr = index(holder, ':');

	 if(cptr != NULL)
	    *cptr = '\0';
	 else{
	    return(-1);
	 }
	 

	 /* We have an attribute name */

	 strcpy(curr_attribute, holder);
	 hold_str[0] = '\0';
      }
      else{

	 if(retval == EOF){

	    for(cptr = hold_str; (*cptr != NULL) && (isspace(*cptr)); cptr++);

	    if(*cptr != NULL){
	       char *a;

	       /* send out old attribute */

	       for(a = cptr; *a != '\0'; a++)
		  if((*a != ' ') && isspace(*a))
		     *a = ' ';

	       wAppendTerm(result, F_ATTR_VAL, curr_attribute,cptr);
	    }

	    break;
	 }

	 sscanf(bptr, "%[^\n]", tmp_str);

	 strcat(hold_str, tmp_str);

	 bptr += strlen(tmp_str) + 1;
      }
   }

   return(0);
}
