/*
 * Copyright 1993, Bunyip Information Systems. This file is part of the
 * Bunyip WHOIS++ distribution and may be freely distributed as long as
 * this notice remains intact. The contents of this file may not be used in
 * any product for commercial gain.
 */

#include <stdio.h>
#include <strings.h>
#include "whois.h"
#include "whoisd.h"
#include "templates.h"



int do_search(input_list, result)
   WItem *input_list;
   WItem *result;

{
   extern template_str *template_head;
   extern Val logical;
   extern constraint_set_t constraint_set[];
   extern int maxhits;


   char *lhs, *rhs;
   char keywords[1024];
   char fixed_keywords[1024];
   WItem *scan;
   WItem *tmpl_list = wCreateSearch();
   WItem *attrval_list = wCreateSearch();
   WItem *val_list = wCreateSearch();
   WItem *attr_list = wCreateSearch();
   WItem *scandb;
   template_str *template;
   int firstword = 1;	      /* Due to logical AND'ing and OR'ring
				 we have to keep track of the first
				 keyword */

   keywords[0] = '\0';

   for(scan = input_list; scan != (WItem *) NULL;){
      WItem *a;

      /* scan for any potential TEMPLATE types specified */

      if(wGetFormat(scan) == F_TEMPL){

	 a = wAppendTerm(tmpl_list, F_TEMPL, wGetLHS(scan), "");

	 if(a)
	   a -> cons = wFirstConstraint(scan);
      }

      /* Scan for attribute/value pairs */

      if(wGetFormat(scan) == F_ATTR_VAL){

	 a = wAppendTerm(attrval_list, F_ATTR_VAL, wGetLHS(scan), wGetRHS(scan));
	 
	 if(a)
	    a -> cons = wFirstConstraint(scan);
      }

      /* Scan for value searches */

      if(wGetFormat(scan) == F_VALUE){

	 a = wAppendTerm(val_list, F_VALUE, wGetLHS(scan), "");
	 
	 if(a)
	   a -> cons = wFirstConstraint(scan);
      }

      /* Scan for attribute searches */

      if(wGetFormat(scan) == F_ATTR){

	 a = wAppendTerm(attr_list, F_ATTR, wGetLHS(scan), "");
	 
	 if(a)
	    a -> cons = wFirstConstraint(scan);
      }

      scan = wNextItem(scan);

   }

   /*
    * tmpl_list now contains list of templates that have to be OR'd
    * together. attrval_list contains a list of attribute/value combinations
    * which have to be put together (AND or OR depending on the "logical"
    * global contraint. val_list contains general search terms and
    * attr_list contains attributes to be searched for
    */


   /* construct the query for the WAIS search engine */

   /*
    * first the general searches that don't need the knowledge of the
    * template that you're searching
    */

   fixed_keywords[0] = '\0';

   for(scan = wNextItem(val_list); scan != (WItem *) NULL;){
      char tmp_str[1024];
      WItem *lcon;
      int partial_match = 0;

      /* handle local contraints */

      for(lcon = wFirstConstraint(scan); lcon;){
	 char *lrhs;
	 char *llhs;
	 int i;

	 llhs = wGetLHS(lcon);
	 lrhs = wGetRHS(lcon);

	 for(i = 0; i < CON_LAST; i++){

	    if(strncasecmp(llhs, constraint_set[i].con_name) == 0){

	       if(constraint_set[i].con_scope != C_SLOCAL){
		  wAppendSystemMessage(result, wErrorReply(WWARN_CON_NOT_LOCAL, "%s", llhs));
		  break;
	       }

	       switch(i){

		  case CON_MATCH:
		     if(strncasecmp("PARTIAL", lrhs, strlen(lrhs)) == 0)
			partial_match = 1;
		     else if(strncasecmp(lrhs, "STANDARD", strlen(lrhs))){
			wAppendSystemMessage(result, wErrorReply(WWARN_INVALID_CONST_VAL, "%s: %s", llhs, lrhs));
			partial_match = 0;
		     }
		     break;
	       }
	    }
	 }

	 lcon = wNextItem(lcon);
      }

      /* Construct the keyword list */

      if(firstword){
         sprintf(tmp_str, "%s%s ", wGetLHS(scan), partial_match ? "*" : "");
	 firstword = 0;
      }
      else
         sprintf(tmp_str, "%s %s%s ", logical == WAND ? "and" : "or", wGetLHS(scan), partial_match ? "*" : "");

      strcat(fixed_keywords, tmp_str);
      scan = wNextItem(scan);
   }

   /* go through the templates that we know about */

   for(template = template_head; template -> t_name[0] != '\0'; template++){

      keywords[0] = '\0';

      if(fixed_keywords[0] == '\0')
         firstword = 1;
      else
         firstword = 0;

      for(scandb = wNextItem(tmpl_list); scandb != (WItem *) NULL;){

	 /* If we are restricted to certain template types */

	 if(strcasecmp(template -> t_name, wGetLHS(scandb)) != 0){
	    scandb = wNextItem(scandb);
	    continue;
	 }
	 else
	    break;
      }

      /*
       * There is a list of templates but we didn't find the one that they
       * ere asking for
       */

      if((scandb == (WItem *) NULL) && (tmpl_list -> next != (WItem *) NULL))
	 continue;

      /* do the attribute search */

      for(scan = wNextItem(attr_list); scan != (WItem *) NULL;){
	 WItem *ats;
	 int found = 0;

	 lhs = wGetLHS(scan);

	 if((ats = template -> t_def))
	    ats = wNextItem(ats);
	 else{
	    scan = wNextItem(scan);
	    continue;
	 }

	 while(ats != (WItem *) NULL){

	    if(strcasecmp(lhs, wGetLHS(ats)) == 0){
	       char tmp_str[1024];
	       int partial_match = 0;
	       WItem *lcon;

	       found = 1;

	       /* Local contraints */

	       for(lcon = wFirstConstraint(scan); lcon;){
		  char *lrhs;
		  char *llhs;
		  int i;

		  llhs = wGetLHS(lcon);
		  lrhs = wGetRHS(lcon);

		  for(i = 0; i < CON_LAST; i++){

		     if(strncasecmp(llhs, constraint_set[i].con_name) == 0){

			if(constraint_set[i].con_scope != C_SLOCAL){
			   wAppendSystemMessage(result, wErrorReply(WWARN_CON_NOT_LOCAL, "%s", llhs));
			   break;
			}

			switch(i){

			   case CON_MATCH:
			      if(strncasecmp("PARTIAL", lrhs, strlen(lrhs)) == 0)
				 partial_match = 1;
			      else if(strncasecmp(lrhs, "STANDARD", strlen(lrhs))){
				 wAppendSystemMessage(result, wErrorReply(WWARN_INVALID_CONST_VAL, "%s: %s", llhs, lrhs));
				 partial_match = 0;
			      }
			      break;
			}
		     }
		  }

		  lcon = wNextItem(lcon);
	       }
		  
	       if(firstword){
	          sprintf(tmp_str, "%s%s* ", wGetLHS(wNextItem(wFirstConstraint(ats))), INDEX_PRFX);
		  firstword = 0;
	       }
	       else
	          sprintf(tmp_str, "%s %s%s%s ", logical == WAND ? "and" : "or", wGetLHS(wNextItem(wFirstConstraint(ats))), INDEX_PRFX, partial_match ? "*" : "");
	       strcat(keywords, tmp_str);
	       break;
	    }
	    else
	       ats = wNextItem(ats);
	 }

#if 0
	 if(!found)
	    wAppendSystemMessage(result, wErrorReply(WWARN_INVALID_ATTR, "for template %s '%s'", template -> t_name, lhs));
#endif

         scan = wNextItem(scan);	 
      }


      /* Do attribute value searching */

      for(scan = wNextItem(attrval_list); scan != (WItem *) NULL;){
	 WItem *ats;
	 int found = 0;

	 lhs = wGetLHS(scan);
	 rhs = wGetRHS(scan);

	 if((ats = template -> t_def))
	    ats = wNextItem(ats);
	 else{
	    scan = wNextItem(scan);
	    continue;
	 }

	 while(ats != (WItem *) NULL){

	    if(strcasecmp(lhs, wGetLHS(ats)) == 0){
	       char tmp_str[1024];
	       int partial_match = 0;
	       WItem *lcon;

	       found = 1;

	       for(lcon = wFirstConstraint(scan); lcon;){
		  char *lrhs;
		  char *llhs;
		  int i;

		  llhs = wGetLHS(lcon);
		  lrhs = wGetRHS(lcon);

		  for(i = 0; i < CON_LAST; i++){

		     if(strncasecmp(llhs, constraint_set[i].con_name) == 0){

			if(constraint_set[i].con_scope != C_SLOCAL){
			   wAppendSystemMessage(result, wErrorReply(WWARN_CON_NOT_LOCAL, "%s", llhs));
			   break;
			}

			switch(i){

			   case CON_MATCH:
			      if(strncasecmp("PARTIAL", lrhs, strlen(lrhs)) == 0)
				 partial_match = 1;
			      else if(strncasecmp(lrhs, "STANDARD", strlen(lrhs))){
				 wAppendSystemMessage(result, wErrorReply(WWARN_INVALID_CONST_VAL, "%s: %s", llhs, lrhs));
				 partial_match = 0;
			      }
			      break;
			}
		     }
		  }

		  lcon = wNextItem(lcon);
	       }
		  
	       if(firstword){
		  sprintf(tmp_str, "%s%s%s%s ", wGetLHS(wNextItem(wFirstConstraint(ats))), INDEX_PRFX, rhs, partial_match ? "*" : "");
		  firstword = 0;
	       }
	       else
		  sprintf(tmp_str, "%s %s%s%s%s ", logical == WAND ? "and" : "or", wGetLHS(wNextItem(wFirstConstraint(ats))), INDEX_PRFX, rhs, partial_match ? "*" : "");

	       strcat(keywords, tmp_str);
	       break;
	    }
	    else
	       ats = wNextItem(ats);
	 }

#if 0
	 if(!found)
	    wAppendSystemMessage(result, wErrorReply(WWARN_INVALID_ATTR, "for template %s '%s'", template -> t_name, lhs));
#endif
         scan = wNextItem(scan);	 
      }
	 
      /* Put together all the keywords we have */

      strcat(keywords, fixed_keywords);

      /* go for it... */

      wais_interface(NULL, 0, result, keywords, template -> t_dir, maxhits, template -> t_name);
   }

   return(0);
}
	 
