/*  ARC - Archive utility - ARC Header

    Version 2.17, created on 04/22/87 at 13:09:43

(C) COPYRIGHT 1985,86 by System Enhancement Associates; ALL RIGHTS RESERVED

    By:  Thom Henderson

    Description: 
         This is the header file for the ARC archive utility.  It defines
         global parameters and the references to the external data.


    Language:
         Computer Innovations Optimizing C86
*/
#include "arcs.h"

extern int keepbak;             /* true if saving the old archive */
extern int warn;                /* true to print warnings */
extern int note;                /* true to print comments */
extern int bose;                /* true to be verbose */
extern int nocomp;              /* true to suppress compression */
extern int overlay;             /* true to overlay on extract */
extern int kludge;              /* kludge flag */
extern char *arctemp;        /* arc temp file prefix */
extern char *password;       /* encryption password pointer */
extern int nerrs;               /* number of errors encountered */
extern int changing;            /* true if archive being modified */

extern char hdrver;                      /* header version */

extern FILE *arc;                        /* the old archive */
extern FILE *new;                        /* the new archive */
extern char arcname[$strlen];           /* storage for archive name */
extern char bakname[$strlen];           /* storage for backup copy name */
extern char newname[$strlen];           /* storage for new archive name */
extern unsigned int arcdate;    /* archive date stamp */
extern unsigned int arctime;    /* archive time stamp */
extern unsigned int olddate;    /* old archive date stamp */
extern unsigned int oldtime;    /* old archive time stamp */
