--------------------------------------------------------------------
signal
--------------------------------------------------------------------

NAME

     signal -- implements trapping of user interrupts

USAGE

     int (*signal (int sig, int (*action))) ()

PROTOTYPE IN

     signal.h /* but you must add it yourself */

DESCRIPTION

The function `signal' is used to establish an action routine for servicing a
user interrupt.  Under MS-DOS, typing Ctrl-C causes a user interrupt.  (On
IBM-compatible systems the Ctrl-Break key will cause the same user
interrupt, and may work when a Ctrl-C fails.)

The first argument to `signal', sig, is a number identifying the signal for
which an action is established.  The value for sig must be SIGINT.

The second parameter, `action', specifies the action to be taken when SIGINT
occurs.  It is either the name of a user-defined function or one of the
constants SIG_DFL (default, which aborts the process) or SIG_IGN (ignore,
which causes SIGINT to be ignored;  however, in the case of MS-DOS, a '^C'
is always echoed to the controlling device).

There are no special restrictions on what the action function may do,
including continuing execution, returning normally or with a longjmp
statement, or terminating executing with exit().  If the function returns
normally, execution continues where it was interrupted by the occurrence of
the SIGINT signal, except that any MS-DOS system call that was in progress
may need to be restarted.

Before the user-defined function is called, the action on the event is
restored to be SIG_DFL.  Thus a second SIGINT event will cause termination
of the process unless the signal handler takes care to restore its action
with a call to `signal'.  Even if it does so, however, a race condition
still exists and two SIGINTs occurring rapidly will terminate the process.
(But nobody types that fast.)

RETURN VALUE

If the specified signal is not SIGINT, the return value is SIG_ERR, which is
defined in `signal.h', and errno is set to EINVAL.  Otherwise the return
value is the value of `action' that was supplied to `signal' in the most
recent legal call, or SIG_DFL if `signal' has never been called.

NOTE

A header file `signal.h' is already provided with Turbo C.  Revise it by
adding the following line at the end:

     int (*_Cdecl signal (int sig, int (*action)())) ();  /* R.D */

AUTHOR

     Rahul Dhesi

EXAMPLE

#include <stdio.h>
#include <signal.h>

int my_handler()
{
   signal (SIGINT, SIG_IGN);      /* ignore signals for now */
   fflush (stdout);
   printf ("\n<Break>\n");
   fflush (stdout);
   signal (SIGINT, my_handler);   /* reinstall signal handler */
}

unsigned _stklen = 4000;          /* reserve stack */

main()
{
   int c;
   signal (SIGINT, my_handler);
   printf ("Control C is being trapped\n");
   printf ("Type Q then <return> to exit\n");
   for (;;) {
      c = getchar();
      if (c == 'q' || c == 'Q' || c == EOF)
         break;
   }
}
