#include <stdlib.h>
#include <sys/types.h>
#include <sys/param.h>
#include <sys/file.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <errno.h>

#include <netkey/key.h>
#include <netkey/key_debug.h>


void
print_keymsghdr(km)
     struct key_msghdr *km;
{
  if (km) {
    printf("key_msglen=%d ", km->key_msglen);
    printf("key_msgvers=%d ", km->key_msgvers);
/*    printf("key_msgtype=%d ", km->key_msgtype);    */
    switch(km->key_msgtype) {
    case KEY_ADD:
      printf("key_msgtype=KEY_ADD ");
      break;
    case KEY_DELETE:
      printf("key_msgtype=KEY_DELETE ");
      break;
    case KEY_UPDATE:
      printf("key_msgtype=KEY_UPDATE ");
      break;
    case KEY_GET:
      printf("key_msgtype=KEY_GET ");
      break;
    case KEY_ACQUIRE:
      printf("key_msgtype=KEY_ACQUIRE ");
      break;
    case KEY_GETSPI:
      printf("key_msgtype=KEY_GETSPI ");
      break;
    case KEY_REGISTER:
      printf("key_msgtype=KEY_REGISTER ");
      break;
    case KEY_EXPIRE:
      printf("key_msgtype=KEY_EXPIRE ");
      break;
    case KEY_DUMP:
      printf("key_msgtype=KEY_DUMP ");
      break;
    case KEY_FLUSH:
      printf("key_msgtype=KEY_FLUSH ");
      break;
    default:
      printf("key_msgtype=%d ",km->key_msgtype);
    }
    printf("key_pid=%d ", km->key_pid);
    printf("key_seq=%d\n", km->key_seq);
    printf("key_errno=%d ", km->key_errno);
    printf("type=0x%x ", km->type);
    printf("state=0x%x ", km->state);
    printf("label=0x%x ", km->label);
    printf("spi=0x%x ", km->spi);
    printf("keylen=%d ", km->keylen);
    printf("ivlen=%d\n", km->ivlen);
    printf("algorithm=%d ", km->algorithm);
    printf("lifetype=0x%x ", km->lifetype);
    printf("lifetime1=%u ", km->lifetime1);
    printf("lifetime2=%u\n", km->lifetime2);
  } else
    printf("key_msghdr pointer is NULL!\n");
}

void
print_keymsginfo(kp)
     struct key_msgdata *kp;
{
  int i;

  if (kp) {
    printf("src addr:\n");
    dump_smart_sockaddr(kp->src);
    printf("dest addr:\n");
    dump_smart_sockaddr(kp->dst);
    printf("from addr:\n");
    dump_smart_sockaddr(kp->from);
#define dumpbuf(a, b) \
    { for (i= 0; i < (b); i++) \
      printf("0x%2x%s", (unsigned char)(*((caddr_t)a+i)),((i+1)%16)?" ":"\n");\
      printf("\n"); }
    printf("key is:\n");
    dumpbuf(kp->key, kp->keylen);
    printf("iv is:\n");
    dumpbuf(kp->iv, kp->ivlen);
#undef dumpbuf    
  } else
    printf("key_msgdata pointer is NULL!\n");
}


struct m_keymsg {
  struct key_msghdr km;
  char m_buffer[512];
};

int
key_xdata(km, len, kip, parseflag)
     struct key_msghdr *km;
     int len;
     struct key_msgdata *kip;
     int parseflag;
{
  char *cp, *cpmax;
 
  if (!km || (len <= 0))
    return (-1);
  cp = (caddr_t)(km + 1);
  cpmax = (caddr_t)km + len;
 
#define ROUNDUP(a) \
  ((a) > 0 ? (1 + (((a) - 1) | (sizeof(long) - 1))) : sizeof(long))
#define ADVANCE(x, n) \
    { x += ROUNDUP(n); if (cp > cpmax) return(-1); }
 
  /* Need to clean up this code later */
 
  /* Grab src addr */
  kip->src = (SOCKADDR *)cp;
  if (!kip->src->sa_len) {
    return(-1);
  }
  ADVANCE(cp, kip->src->sa_len);

  /* Grab dest addr */
  kip->dst = (SOCKADDR *)cp;
  if (!kip->dst->sa_len) {
    return(-1);
  }
  ADVANCE(cp, kip->dst->sa_len);
  if (parseflag == 1) {
    kip->from = 0;
    kip->key = kip->iv = 0;
    kip->keylen = kip->ivlen = 0;
    return(0);
  }
 
  /* Grab from addr */
  kip->from = (SOCKADDR *)cp;
  if (!kip->from->sa_len) {
    return(-1);
  }
  ADVANCE(cp, kip->from->sa_len);

  /* Grab key */
  if (kip->keylen = km->keylen) {
    kip->key = cp;
    ADVANCE(cp, km->keylen);
  } else
    kip->key = 0;
 
  /* Grab iv */
  if (kip->ivlen = km->ivlen)
    kip->iv = cp;
  else
    kip->iv = 0;
  return (0);
}

int
main(argc, argv)
     int argc;
     char **argv;
{
  struct m_keymsg m_keymsg;
  struct m_keymsg im_keymsg;
  struct key_msgdata keyinfo;
  struct hostent *hp;
  pid_t mypid;
  char iv[4]; 
  char key[8];
  int i, s, l, len;
  char *cp = m_keymsg.m_buffer;

  mypid = getpid();
  if (mypid < 0) {
    perror("getpid");
    exit(1);
  }

  if ((s = socket(PF_KEY, SOCK_RAW, 0)) < 0) {
    perror("socket");
    exit(1);
  }
 
  bzero((char *)&m_keymsg, sizeof(m_keymsg));
  m_keymsg.km.key_msgvers = KEY_VERSION;
  m_keymsg.km.key_msgtype = KEY_REGISTER;
  m_keymsg.km.key_msglen = sizeof(struct key_msghdr); 

  for (i = 1; i < 4; i++) {
    m_keymsg.km.type = i;
    if ((len = write(s, (char *)&m_keymsg, m_keymsg.km.key_msglen)) < 0) {
      perror("write");
      exit(1);
    }
  }


readit:
  if ((len = read(s, (char *)&im_keymsg, 256)) < 0) {
    perror("read");
  }
  printf("--------------Got key message from kernel!----------\n");
  printf("keymsghdr is:\n");
  print_keymsghdr(&(im_keymsg.km));
  if ((im_keymsg.km.key_msgtype == KEY_ADD) || 
      (im_keymsg.km.key_msgtype == KEY_UPDATE) ||
      ((im_keymsg.km.key_msgtype == KEY_GET) && (im_keymsg.km.key_pid))) {
    if (key_xdata(&im_keymsg, len, &keyinfo, 0) == 0) {
      printf("keydata is:\n");
      print_keymsginfo(&keyinfo);
    }
  } else  if ((im_keymsg.km.key_msgtype == KEY_DELETE) || 
	      (im_keymsg.km.key_msgtype == KEY_ACQUIRE) ||
	      (im_keymsg.km.key_msgtype == KEY_GET) ||
	      (im_keymsg.km.key_msgtype == KEY_GETSPI)) {
    if (key_xdata(&im_keymsg, len, &keyinfo, 1) == 0) {
      printf("keydata is:\n");
      print_keymsginfo(&keyinfo);
    }
  }

  switch(im_keymsg.km.key_msgtype) {
  case KEY_ACQUIRE:
    {
      u_long waittime;

/*      waittime = random() % 10;   */
      waittime = 0; 
      printf("\nKernel begging for key...");
      printf("sleeping for %u seconds before responding!\n", waittime);
      sleep(waittime);
      printf("Sending key_getspi message...");
      cp = m_keymsg.m_buffer;
      bzero((char *)&m_keymsg, sizeof(m_keymsg));
      m_keymsg.km.key_msgvers = KEY_VERSION;
      m_keymsg.km.key_msgtype = KEY_GETSPI;
      m_keymsg.km.key_seq = 1;
      m_keymsg.km.type = im_keymsg.km.type;

      m_keymsg.km.lifetime1 = 256;  /* overload: min spi value to get */
      m_keymsg.km.lifetime2 = 0xffffffff; /* overload: max spi value to get */

#define ADDDATA(a, b) \
  {l = ROUNDUP(b); bcopy((char *)(a), cp, l); cp += l;}

      ADDDATA(keyinfo.src, keyinfo.src->sa_len);
      ADDDATA(keyinfo.dst, keyinfo.dst->sa_len);
      m_keymsg.km.key_msglen = cp - (char *)&m_keymsg;
      if (write(s, (char *)&m_keymsg, m_keymsg.km.key_msglen) < 0) {
	perror("\ngetspi failed:");
      } else
	printf("done\n");
    }
    break;
  case KEY_GETSPI:
    {
      u_long word1, word2;

      if (im_keymsg.km.key_pid != mypid)
	break;
      if (im_keymsg.km.key_errno) {
	printf("\nKernel returns error for getspi operation\n");
	break;
      }
      printf("\nKernel returns spi, cool!\n");
      printf("Sending key_update message to update key material...");
      cp = m_keymsg.m_buffer;
      bzero((char *)&m_keymsg, sizeof(m_keymsg));
      m_keymsg.km = im_keymsg.km;
      m_keymsg.km.key_msgtype = KEY_UPDATE;
      m_keymsg.km.key_seq = 1;
      m_keymsg.km.lifetime1 = 0;  /* Blank out overloaded fields */
      m_keymsg.km.lifetime2 = 0;

      m_keymsg.km.algorithm = 0; /* dummy */

#if 0
      if (m_keymsg.km.type == SS_AUTHENTICATION)
	m_keymsg.km.algorithm = IPSEC_ALGTYPE_AH_DUMMY;
      else if (m_keymsg.km.type == SS_ENCRYPTION_TRANSPORT || 
	       m_keymsg.km.type == SS_ENCRYPTION_NETWORK)
	m_keymsg.km.algorithm = IPSEC_ALGTYPE_ESP_DUMMY;
#endif /* 0 */

      m_keymsg.km.keylen = sizeof(key);
      m_keymsg.km.ivlen = sizeof(iv);
      word1 = random();
      word2 = random();
      bcopy((char *)&word1, (char *)&key, sizeof(word1));
      bcopy((char *)&word2, (char *)&key + sizeof(word1), sizeof(word2));
      word1 = random();
      bcopy((char *)&word1, (char *)&iv, sizeof(word1));

      ADDDATA(keyinfo.src, keyinfo.src->sa_len);
      ADDDATA(keyinfo.dst, keyinfo.dst->sa_len);
      ADDDATA(keyinfo.dst, keyinfo.dst->sa_len); /* XXX - from */
      ADDDATA(key, m_keymsg.km.keylen);
      ADDDATA(iv, m_keymsg.km.ivlen);
      m_keymsg.km.key_msglen = cp - (char *)&m_keymsg;
      if (write(s, (char *)&m_keymsg, m_keymsg.km.key_msglen) < 0) {
	perror("write");
      } else
	printf("done\n");
    }
    break;
  }
goto readit;
  
}
