/*----------------------------------------------------------------------
  ipsec.h:  Global declarations for IP Security services, not including
            PF_KEY stuff.  rja

  This software is Copyright 1995 by Randall Atkinson, Bao Phan, &
  Dan McDonald, All Rights Reserved.  All Rights have been assigned
  to the US Naval Research Laboratory.  The NRL Copyright Notice and
  License Agreement below applies to this software.
----------------------------------------------------------------------*/

/*----------------------------------------------------------------------
#	@(#)COPYRIGHT	1.1a (NRL) 17 August 1995

COPYRIGHT NOTICE

All of the documentation and software included in this software
distribution from the US Naval Research Laboratory (NRL) are
copyrighted by their respective developers.

This software and documentation were developed at NRL by various
people.  Those developers have each copyrighted the portions that they
developed at NRL and have assigned All Rights for those portions to
NRL.  Outside the USA, NRL also has copyright on the software
developed at NRL. The affected files all contain specific copyright
notices and those notices must be retained in any derived work.

NRL LICENSE

NRL grants permission for redistribution and use in source and binary
forms, with or without modification, of the software and documentation
created at NRL provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.
3. All advertising materials mentioning features or use of this software
   must display the following acknowledgement:

	This product includes software developed at the Information
	Technology Division, US Naval Research Laboratory.

4. Neither the name of the NRL nor the names of its contributors
   may be used to endorse or promote products derived from this software
   without specific prior written permission.

THE SOFTWARE PROVIDED BY NRL IS PROVIDED BY NRL AND CONTRIBUTORS ``AS
IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL NRL OR
CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

The views and conclusions contained in the software and documentation
are those of the authors and should not be interpreted as representing
official policies, either expressed or implied, of the US Naval
Research Laboratory (NRL).

----------------------------------------------------------------------*/

#ifndef _NETSEC_IPSEC_H
#define _NETSEC_IPSEC_H 1

/* Symbolic names for System Security Levels */
/* Note: the concept of system security levels needs revisiting. rja */
#define IPSEC_LEVEL_DEFAULT	0 /* send plaintext, accept any */
#define IPSEC_LEVEL_USE		1 /* use outbound, don't require inbound */
#define IPSEC_LEVEL_REQUIRE	2 /* use both directions */
#define IPSEC_LEVEL_UNIQUE	3 /* use both directions, 
				     and outbound uses a unique key */

/* Symbolic names for Security Types */ 
#define SECURITY_TYPE_NONE		0
#define SECURITY_TYPE_AUTH_AH           1
#define SECURITY_TYPE_ENCR_ESPTRANSPORT	8
#define SECURITY_TYPE_ENCR_ESPTUNNEL	9
#define SECURITY_TYPE_MAX		9

/* Symbolic names for algorithms */
#define IPSEC_ALGTYPE_AH_MD5            0
#define IPSEC_ALGTYPE_AH_SHA            1
#define IPSEC_ALGTYPE_AH_HMACMD5        2
#define IPSEC_ALGTYPE_AH_HMACSHA        3
#ifdef IPSEC_DEBUG
#define IPSEC_ALGTYPE_AH_DUMMY          4
#define IPSEC_ALGTYPE_AH_SUM            5
#endif /* IPSEC_DEBUG */

#define IPSEC_ALGTYPE_ESP_DES_CBC       0
#ifdef IPSEC_DEBUG
#define IPSEC_ALGTYPE_ESP_DUMMY         1
#endif /* IPSEC_DEBUG */

struct ah_stat_table {
  /* kernel statistics relating to IP Authentication Header */
  u_long    ah_sent;
  u_long    ah_accepted;
  u_long    ah_in_errs;
  u_long    ah_out_errs;
  u_long    ah_missing;
  u_long    ah_spoof;

  u_long    ah_sa_unavailable;
  u_long    ah_sa_invalid;
  u_long    ah_sa_delayed;
};

struct esp_stat_table {
  u_long    esp_transport_sent; 
  u_long    esp_tunnel_sent; 
  u_long    esp_accepted;
  u_long    esp_trans_missing;
  u_long    esp_tunnel_missing;
  u_long    esp_in_errs;
  u_long    esp_trans_out_errs;
  u_long    esp_tunnel_out_errs;
  u_long    esp_tunnel_spoof;

  u_long    esp_sa_unavailable;
  u_long    esp_sa_invalid;
  u_long    esp_sa_delayed;
};

struct  ah_stat_table  ah_stats;  /* lives and initialised in ipsec.c */
struct esp_stat_table esp_stats;  /* lives and initialised in ipsec.c */

#ifdef KERNEL
/* The array below SHOULD be modifyable using a sysctl or similar 
   so that one can tune the system security without building a new
   kernel, but support for that is not yet implemented. */
u_int ipsec_system_sec_level[4];  /* used in ipsec_policy.c */

/* lives in ipsec.c */
void        ipsec_init __P((void));
#endif /* KERNEL */

#define IPSEC_BOUNDEDCOPY(in, inlen, out, bound) \
{ \
    if ((inlen) >= (bound)) { \
      bcopy((caddr_t)(in), (caddr_t)(out), (bound)); \
    } else { \
      bcopy((caddr_t)(in), (caddr_t)(out), (inlen)); \
      bzero((caddr_t)(out) + (inlen), (bound) - (inlen)); \
    } \
}

struct ipsec_ah
{
  u_int8_t ah_nexthdr;          /* Next header type. */
  u_int8_t ah_datalen;          /* Length of authentication data in 64 bit chunks. */
  u_int16_t ah_reserved;        /* 16 bits of reserved padding. */
  u_int32_t ah_spi;             /* Security paramaters index */
};

#ifdef KERNEL
struct in6_hdrindex;
void     ipsec_ah_input __P((struct mbuf *, int, struct in6_hdrindex *, int));
struct key_secassoc;
struct mbuf  *ipsec_ah_output __P((struct mbuf *, struct key_secassoc *));

#if IPSEC_ESP
void ipsec_esp_input __P((struct mbuf *, int, struct in6_hdrindex *, int));
int ipsec_esp_transport_output __P((struct mbuf *, struct key_secassoc *));
int ipsec_esp_tunnel_output __P((struct mbuf *, struct key_secassoc *));
#endif /* IPSEC_ESP */
#endif /* KERNEL */
#endif /* _NETSEC_IPSEC_H */
