#ifndef _OSDEP_44BSD_H
#define _OSDEP_44BSD_H 1

#include <sys/types.h>

#if defined(_KERNEL) && !defined(KERNEL)
#define KERNEL 1
#endif /* defined(_KERNEL) && !defined(KERNEL) */

#include <limits.h>

#define SOCKADDR struct sockaddr
#define SOCKET struct socket

#ifdef INET6
#define SOCKADDR_MAXSZ 24 /* sizeof(struct sockaddr_in6) */
#else /* INET6 */
#define SOCKADDR_MAXSZ 16 /* sizeof(struct sockaddr_in) */
#endif /* INET6 */

/*
 * Bit-specific primitives.
 *
 * You'll want to change these per architecture, especially if going to
 * a non-32-bit box.
 *
 */
#ifdef 0
#ifndef u_int8_t
#define u_int8_t  unsigned char
#endif /* u_int8_t */

#ifndef u_int16_t
#define u_int16_t unsigned short
#endif /* u_int16_t */

#ifndef u_int32_t
#define u_int32_t unsigned long
#endif /* u_int32_t */
#endif /* 0 */

#ifdef __STDC__
#define DEFARGS(arglist, args) (args)
#define AND ,
#else /* __STDC__ */
#define DEFARGS(arglist, args) arglist args;
#define AND ;
#endif /* __STDC__ */

#ifdef KERNEL
#define REAL_KMALLOC(p, t, n) (p = (t) malloc((unsigned long)(n), M_SECA, M_DONTWAIT))
#define REAL_KFREE(p) free((caddr_t)p, M_SECA);
#define REAL_KFREE_LEN(p, n) free((caddr_t)p, M_SECA);

#ifdef KEY_DEBUG
#define KMALLOC(p, t, n) (p = (t)key_debug_malloc(n, #t))
#define KFREE(p) key_debug_free(p)
#define KFREE_LEN(p, n) key_debug_free_len(p, n)
#else /* KEY_DEBUG */
#define KMALLOC(p, t, n) REAL_KMALLOC(p, t, n)
#define KFREE(p) REAL_KFREE(p)
#define KFREE_LEN(p, n) REAL_KFREE_LEN(p, n)
#endif /* KEY_DEBUG */

#define CRITICAL_DCL int critical_s;
#define CRITICAL_START critical_s = splnet()
#define CRITICAL_END splx(critical_s)

#define TIME_SECONDS time.tv_sec
#define CURRENT_PID curproc->p_pid
#endif /* KERNEL */

#endif /* _OSDEP_44BSD_H */
