/*----------------------------------------------------------------------
  Portions Copyright 1996 by Larry Bassham, All Rights Reserved.
  The NRL COPYRIGHT NOTICE and LICENSE governs distribution and use of
  this software.

  Portions Copyright 1995 by Bao Phan, Dan McDonald, & Randall Atkinson.
  All Rights Reserved. All Rights have been assigned to the US
  Naval Research Laboratory (NRL). The NRL COPYRIGHT NOTICE and
  LICENSE governs distribution and use of this software.
----------------------------------------------------------------------*/
/*----------------------------------------------------------------------
#	@(#)COPYRIGHT	1.1a (NRL) 17 August 1995

COPYRIGHT NOTICE

All of the documentation and software included in this software
distribution from the US Naval Research Laboratory (NRL) are
copyrighted by their respective developers.

This software and documentation were developed at NRL by various
people.  Those developers have each copyrighted the portions that they
developed at NRL and have assigned All Rights for those portions to
NRL.  Outside the USA, NRL also has copyright on the software
developed at NRL. The affected files all contain specific copyright
notices and those notices must be retained in any derived work.

NRL LICENSE

NRL grants permission for redistribution and use in source and binary
forms, with or without modification, of the software and documentation
created at NRL provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.
3. All advertising materials mentioning features or use of this software
   must display the following acknowledgement:

	This product includes software developed at the Information
	Technology Division, US Naval Research Laboratory.

4. Neither the name of the NRL nor the names of its contributors
   may be used to endorse or promote products derived from this software
   without specific prior written permission.

THE SOFTWARE PROVIDED BY NRL IS PROVIDED BY NRL AND CONTRIBUTORS ``AS
IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL NRL OR
CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

The views and conclusions contained in the software and documentation
are those of the authors and should not be interpreted as representing
official policies, either expressed or implied, of the US Naval
Research Laboratory (NRL).

----------------------------------------------------------------------*/
#include <sys/types.h>
#include <sys/param.h>
#include <sys/malloc.h>
#include <sys/systm.h>

#include <netkey/key.h>
#include <netsec/ipsec.h>

#include "md5.h"

struct md5state {
  struct MD5_CTX isb;               /* Internal state block for MD5 */
  struct key_secassoc *assoc;       /* Security association (keys!) */
};

static u_int8	ipad[64]={0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36,
  		  0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36,
  		  0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36,
  		  0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36,
  		  0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36,
  		  0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36,
  		  0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36,
  		  0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36};

static u_int8	epad[64]={0x5c, 0x5c, 0x5c, 0x5c, 0x5c, 0x5c, 0x5c, 0x5c,
  		  0x5c, 0x5c, 0x5c, 0x5c, 0x5c, 0x5c, 0x5c, 0x5c,
  		  0x5c, 0x5c, 0x5c, 0x5c, 0x5c, 0x5c, 0x5c, 0x5c,
  		  0x5c, 0x5c, 0x5c, 0x5c, 0x5c, 0x5c, 0x5c, 0x5c,
  		  0x5c, 0x5c, 0x5c, 0x5c, 0x5c, 0x5c, 0x5c, 0x5c,
  		  0x5c, 0x5c, 0x5c, 0x5c, 0x5c, 0x5c, 0x5c, 0x5c,
  		  0x5c, 0x5c, 0x5c, 0x5c, 0x5c, 0x5c, 0x5c, 0x5c,
  		  0x5c, 0x5c, 0x5c, 0x5c, 0x5c, 0x5c, 0x5c, 0x5c};

static void bytnxor __P((u_int8 *, u_int8 *, u_int8 *, int));
caddr_t ah_hmacmd5init __P((struct key_secassoc *));
caddr_t ah_hmacmd5update __P((caddr_t, caddr_t, int));
caddr_t ah_hmacmd5finish __P((caddr_t, caddr_t));

/* dest = src1 XOR src2  */
static void
bytnxor(dest, src1, src2, len)
u_int8	*dest, *src1, *src2;
int	len;
{
  while ( len-- > 0 ) *dest++ = *src1++ ^ *src2++;
}

/*----------------------------------------------------------------------
  hmacmd5init():   Initialize MD5 state and stash pertinent
               Security Association away in md5state.
----------------------------------------------------------------------*/
caddr_t ah_hmacmd5init(assoc)
     struct key_secassoc *assoc;
{
  struct md5state *md5state = malloc(sizeof(struct md5state), M_TEMP, M_NOWAIT);
  int	keylen;
  
  if (md5state) {
    u_int8 xorkey[64];

    keylen=assoc->keylen;
    if (keylen > 64) {  /* key needs to be hashed first  */
      MD5Init(&(md5state->isb));
      MD5Update(&(md5state->isb), (u_int8 *)assoc->key, keylen);
      MD5Final(NULL, &(md5state->isb));
      /*  K XOR ipad  */
      bytnxor(xorkey, (u_int8 *)md5state->isb.state, ipad, 16);
      bcopy(ipad+16, xorkey+16, 64-16);
    } else {
      /*  K XOR ipad  */
      bytnxor(xorkey, assoc->key, ipad, keylen);
      bcopy(ipad+keylen, xorkey+keylen, 64-keylen);
    }
    MD5Init(&(md5state->isb));
    MD5Update(&(md5state->isb), xorkey, 64);
    md5state->assoc = assoc;
  }

  return (caddr_t)md5state;
};

/*----------------------------------------------------------------------
  hmacmd5update():  Continue the MD5 calculation over some data in the packet.
----------------------------------------------------------------------*/
caddr_t ah_hmacmd5update(state, data, len)
     caddr_t state;
     caddr_t data;
     int len;
{
  MD5Update(&(((struct md5state *)state)->isb), (unsigned char *)data, len);
  return state;
};

/*----------------------------------------------------------------------
  hmacmd5finish():  Conclude the MD5 calculation for AH and return AH data (?).
----------------------------------------------------------------------*/
caddr_t ah_hmacmd5finish(state, data)
caddr_t state;
caddr_t data;
{
  int	keylen;
  u_int8	result1[16],result2[16];
  u_int8 xorkey[64];
  struct md5state *md5state = (struct md5state *)state;

  MD5Final(result1,&(md5state->isb));
  keylen=md5state->assoc->keylen;
  if (keylen > 64) {  /* key needs to be hashed first  */
	MD5Init(&(md5state->isb));
	MD5Update(&(md5state->isb), (u_int8 *)md5state->assoc->key, keylen);
	MD5Final(result2,&(md5state->isb));
	/*  K XOR epad  */
	bytnxor(xorkey, result2, epad, 16);
	bcopy(epad+16, xorkey+16, 64-16);
	}
  else {
	/*  K XOR epad  */
	bytnxor(xorkey, md5state->assoc->key, epad, keylen);
	bcopy(epad+keylen, xorkey+keylen, 64-keylen);
	}
  MD5Init(&(md5state->isb));
  MD5Update(&(md5state->isb), xorkey, 64);
  MD5Update(&(md5state->isb), result1, 16);
  MD5Final((unsigned char *)data,&(md5state->isb));
  free(md5state, M_TEMP);
  return data;
};
