#
# $Id: scaling.pl,v 1.4 1997/04/07 23:36:46 he Exp $
#

# Copyright (c) 1996, 1997
#      UNINETT and NORDUnet.  All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
# 3. All advertising materials mentioning features or use of this software
#    must display the following acknowledgement:
#      This product includes software developed by UNINETT and NORDUnet.
# 4. Neither the name of UNINETT or NORDUnet nor the names
#    of its contributors may be used to endorse or promote
#    products derived from this software without specific prior
#    written permission.
#
# THIS SOFTWARE IS PROVIDED BY UNINETT AND NORDUnet ``AS IS'' AND ANY
# EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
# PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL UNINETT OR NORDUnet OR
# THEIR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#


# Calculate autoscaled "nice" max value
#
# Call maxit(v) with each value
# max_scale() returns a nice max value for autoscaling

package scaling;

sub main::maxit {
    local($value) = @_;

    if (!defined($max_value) ||
	$value > $max_value)
    {
	$max_value = $value;
    }
}

sub main::max_scale {
    local($log10, $limit, $upper, $bound);
    
    if (defined($max_value) &&
	$max_value > 0)
    {
	$log10 = log($max_value) / log(10);
	$limit = int($log10 + 1);
	$upper = exp($limit * log(10));
	if ($max_value < $upper / 8) {
	    $bound = $upper / 8;
	} elsif ($max_value < $upper / 4) {
	    $bound = $upper / 4;
	} elsif ($max_value < $upper / 2) {
	    $bound = $upper / 2;
	} else {
	    $bound = $upper;
	}
    } else {
	$bound = 0.0001;
    }
    return $bound;
}

1;
