/*********************************************************************
vpc_base.c

*********************************************************************/

#include <stdlib.h>
#include <assert.h>
#include <stdio.h>
//#include <dos.h>
#include <math.h>
#include "vpc_play.h"




//unsatisfied with buildnewships since each base not independent
//now they are...sort of (depends on what is done in BuildNewShips) -Miikka
void BuildNewShipsAllBases(void)
{
   int x;
   BASETYPE baseT;
   PLANTYPE plan;
   //RefreshABrain();

   for( x = 1 ; x<=500;x++){// 500
      if( rBase[x-1] == race && rPlanet[x-1] == race ) {
	  LBase(&baseT, x);
	  LPlanet(&plan, x);
	  BuildNewShips(&baseT,&plan);
	  SPlanet(&plan, x);
	  SBase(&baseT, x);
       } //If
   } //NEXT I
}



int decide_whats_needed(BASETYPE *baseT, PLANTYPE *plan)
{
int classcount[10]={ 0,0,0,0,0,0,0,0,0,0 };//AS INTEGER
int tar[10]={ 0,0,0,0,0,0,0,0,0,0 };//AS INTEGER
int I ;//AS LONG
int makethis=0;//,c,r;//,fgship=0;
//int jipped=0;
int alch_first;

HULLSPEC hull;

   assert(baseT);
   assert(plan);
   assert(ships_counted);

   classcount[0]=scouts;
   classcount[1]=eggs;
   classcount[2]=destroyers;
   classcount[3]=battleships;
   classcount[4]=refineries;
   classcount[5]=merlins;
   classcount[6]=fuel_carriers;
   classcount[7]=big_eggs;
   classcount[8]=specials;


   tar[0] = MAX(5,(int)SQR(pcount)) + MAX(0,(int)SQR(dominion_unexplored_count)) + random(sbcount+1);
   tar[1] = pcount / 10 + random(5);//random(dominion_unexplored_count)+1;
   tar[2] = pcount / 3 + random(sbcount);//+ random(5)+1;  one for every third planet
   tar[3] = pcount / 5 + epcount / 5 + random(sbcount+1);       //large bship
   tar[4] = sbcount;   // alchemy
   tar[5] = sbcount;   // refinery
   tar[6] = random(sbcount+1);   // fuel ships
   tar[7] = sbcount + random(sbcount+1); //large transports
   switch(race) {
   case RACE_CRY:
	tar[8] = sbcount * 3;
	break;
   case RACE_LIZ:
	tar[8] = sbcount * 5;
	break;
   case RACE_CYL:
	tar[8] = sbcount;
	break;
   case RACE_EMP:
	tar[8] = sbcount;
	break;
   default:
	tar[8] = 0;
	break;
   }

   if(strategy_option & STRATEGY_ECONOMIST) {
     tar[0] *= .8;
     tar[1] *= 2.0;
     tar[2] *= .6;
     tar[3] *= .6;
     tar[7] *= 4.0;
   }
   if(strategy_option & STRATEGY_SCIENTIST) {
     tar[0] *= 2.0;
     tar[1] *= .8;
     tar[2] *= .8;
     tar[3] *= .6;
   }
   if(strategy_option & STRATEGY_MILITARIST) {
     tar[0] *= .8;
     tar[1] *= .5;
     tar[2] *= 1.5;
     tar[3] *= 2.0;
   }

   if(fig.Alchemy==0) {   //no alchemy ships!  dont make any u bonehead!
     tar[MERLIN-1]=0;
     tar[REFINERY-1]=0;
   }

   if(CLIP_INFO(3)) {
     printf(" Dominion Manifest:\n (%i Scouts) (%i Eggs) (%i Destroyers) (%i Battleships)\n (%i Refineries) (%i Merlins) (%i Fuel Carriers) (%i Big Eggs)\n <%i Pla %i Bas %i Dom %i Unk>\n",
      (int)classcount[0],(int)classcount[1],(int)classcount[2],(int)classcount[3],
      (int)classcount[4],(int)classcount[5],(int)classcount[6],(int)classcount[7],
      (int)pcount,sbcount,(int)total_dominion,(int)dominion_unexplored_count);
   } else if(CLIP_INFO(2)) {
     printf(" Dominion Surveyors report ");
     if(classcount[1-1]+classcount[2-1]<=tar[1-1]+tar[2-1]) {
       printf("few scouts and freighters, ");
     } else {
       printf("many scouts and freighters, ");
     }
     if(classcount[3-1]+classcount[4-1]<=tar[3-1]+tar[4-1]) { //fleet strength
       printf("few warships,\n");
     } else {
       printf("many warships,\n");
     }
     if(classcount[5-1]+classcount[6-1]<=tar[5-1]+tar[6-1]) {
       printf("few alchemy ships, ");
     } else {
       printf("many alchemy ships, ");
     }
     if(classcount[7-1]+classcount[8-1]<=tar[7-1]+tar[8-1]) {
       printf("few bulk transports.\n");
     } else {
       printf("many bulk transports.\n");
     }

     if(pcount<epcount*1+dominion_unexplored_count*1) {  //scattering factor
       printf("Our empire is widely scattered ");
     } else if(pcount<epcount*2+dominion_unexplored_count*2) {
       printf("Our empire is scattered ");
     } else if(pcount<epcount*4+dominion_unexplored_count*4) {
       printf("Our empire is intact ");
     } else {
       printf("Our empire is secured ");
     }

     if(sbcount<pcount/15) {   //starbase density
       printf("and weakly fortified.\n");
     } else if(sbcount<pcount/10) {
       printf("and fortified.\n");
     } else if(sbcount<pcount/5) {
       printf("and heavily fortified.\n");
     } else {
       printf("and very heavily fortified.\n");
     }
   }

   //if(total_dominion!=dominion_unexplored_count+pcount) {
   //  printf("Possible minor dominion manifest error... sum of planets mismatch\n");
   //  printf("it is noncritical... but means Miikka was lazy.\n");
   //}

   makethis = 4;
   alch_first = strategy_option & STRATEGY_ALCHEMY_FIRST;

   for( I = 10 ; I>=1;I--){// 4 STEP -1
     if(random(10)==0) continue; //10% chance of skipping a type

     if(I==REFINERY) {
		if(get_orbit_hull(plan,104)==0) makethis = I;
     } else if(I==MERLIN) {
		if(get_orbit_hull(plan,105)==0) makethis = I;
     } else {
		if( tar[I-1] > classcount[I-1] ) makethis = I;
     }
   }



   if(classcount[1-1]+classcount[2-1]+classcount[3-1]+classcount[4-1]>15) {
     if(classcount[7-1]<=sbcount&&race!=RACE_BOR
	  &&race!=RACE_FED&&race!=RACE_EMP) //i.e. no neutronic fuel carriers
	if((get_orbit_hull(plan,14)==0)  //this is neutronic fuel carrier
	      &&(get_orbit_hull(plan,82)==0)) //this is Q tanker
	  makethis = 7;  //only if no Qtankers and Neutronic carriers in orbit
   }
   if(strategy_option & STRATEGY_SCIENTIST) {
     if(classcount[1-1]<=MAX(5,dominion_unexplored_count / 5) )
	makethis = 1;
   }
   if(strategy_option & STRATEGY_MILITARIST) {
     if(classcount[3-1]<=sbcount && pcount > 5)
	makethis = 3;
     if(classcount[4-1]<=sbcount && pcount > 10)
	makethis = 4;
   }
   if(strategy_option & STRATEGY_ECONOMIST) {
     if(classcount[EGG-1]<=sbcount && pcount > 5)
	makethis = EGG;
     if(classcount[BIG_EGG-1]<=sbcount && pcount > 10 && baseT->techH>=10)
	makethis = BIG_EGG;
   }
   if(classcount[8]<tar[8]) { //special mission ships important override
     switch(race) {           //above design requests
     case RACE_CRY:
	if(random(3)==1) {
	  makethis = 9;
	}
	break;
     case RACE_LIZ:
	if(random(3)==1) {
	  makethis = 9;
	}
	break;
     case RACE_CYL:
	if(random(3)==1) {
	  makethis = 9;
	}
	break;
     case RACE_EMP:
	if(random(3)==1) {
	  if(get_orbit_hull(plan,76)) makethis = 9;
	}
	break;
     default:
	break;
     }
   }


   if(alch_first) {
     if(baseT->techH>=10 && get_orbit_hull(plan, 104)==0) {
       if(classcount[EXPLORER-1]) { //still have scouts
	 makethis=REFINERY;//merlin
       }
       LHull( &hull, 104 );
       if( (plan->eleM + plan->resM < hull.eleM)
	 ||(plan->eleD + plan->resD < hull.eleD)
	 ||(plan->eleT + plan->resT < hull.eleT) ) {
	 if(INFO_CLIP(4)) printf("BERZERK! cant make refinery with native minerals\n");
	 makethis = random(SPECIAL);//scout some place with minerals?
	 //sometimes above makes ships, sometimes not.  this puts base in
	 //random berzerker build mode in a desperate attempt to expand
	 if(makethis==MERLIN&&get_orbit_hull(plan,105)) makethis = 0;
       }
     }
     if(baseT->techH>=10 && get_orbit_hull(plan, 105)==0) {
       if(classcount[EXPLORER-1]) { //still have scouts
	 makethis=MERLIN;//merlin
       }
       LHull( &hull, 105 );
       if( (plan->eleM + plan->resM < hull.eleM)
	 ||(plan->eleD + plan->resD < hull.eleD)
	 ||(plan->eleT + plan->resT < hull.eleT) ) {
	 if(INFO_CLIP(4)) printf("BERZERK! cant make merlin with native minerals\n");
	 makethis = random(SPECIAL);//scout some place with minerals?
	 //sometimes above makes ships, sometimes not.  this puts base in
	 //random berzerker build mode in a desperate attempt to expand
	 if(makethis==REFINERY&&get_orbit_hull(plan,104)) makethis = 0;
       }
     }
   }
   if(random(10)) { //10% chance clip fails for anti jip logic
     if(plan->eleN <= 200) { //if no fuel, dont make anything big!
      if( makethis != REFINERY && makethis != MERLIN && makethis != EXPLORER)
	makethis = 0;
     }

     if(plan->eleN <= 10) { //if no fuel, dont make anything!
      if( makethis != REFINERY && makethis != MERLIN )
	makethis = 0;
     }
   }

   return(makethis);
}



void BuildNewShips(BASETYPE *baseT,PLANTYPE *plan)
{ //BuildNewShips
//int classcount[10]={ 0,0,0,0,0,0,0,0,0,0 };//AS INTEGER
//int tar[10]={ 0,0,0,0,0,0,0,0,0,0 };//AS INTEGER
//long x1 ;//AS LONG
//long size ;//AS LONG
//long S ;//AS LONG
int I ;//AS LONG
int makethis=0,c,r,fgship=0;
int jipped=0;
//int alch_first;
//int total_needed=0;

//SHIPTYPE me;
//BASETYPE baseT;
//PLANTYPE plan;
HULLSPEC hull;


//   'ship types:
//   '1 'explorer'  aka local bolt cruiser
//   '2 'egg'
//   '3 small warship  'destroyer'
//   '4 large warship  'battleship'
//   '5 neutronic 'refinery'
//   '6 'merlin' class
//   '7 neutronic 'fuel carrier'
//    8 large egg (i made this so i can have small eggs different) Miikka
//    9 race specific special missions ships Miikka

   if(INFO_CLIP(2)==0) printf( "Ship Building\n");

   assert(baseT);
   assert(plan);
   //printf("Hull manifest\n");
   //for(I=1;I<=10;I++) {
   //  printf("Race Hull slot: %d  number stored: %d\n",I,baseT->storeH[I-1]);
   //}
   //printf("sleeping 5\n");
   //sleep(5);
   if(CLIP_INFO(3)) {
	printf("Base [%d]:  TechH %d TechE %d TechW %d TechT %d    Def %d   Fgtrs %d\n",
		baseT->ID, baseT->techH, baseT->techE, baseT->techW, baseT->techT,
		baseT->defense, baseT->storeF);
	printf("    Nt: %ld     Tr: %ld Du: %ld Mol: %ld     Mc: %ld Sp: %ld\n",
	 plan->eleN, plan->eleT, plan->eleD, plan->eleM, plan->money, plan->eleS);
	printf(" Population:  %ld    Natives: %ld     Type: %s\n",
	 plan->eleC, plan->native, speciesname[MAX(0,MIN(9,plan->species))]);
   } else if(INFO_CLIP(2)) {
	printf("Starbase at %s reports", PLANETNAME(baseT->ID));
	if(baseT->techH>6&&baseT->techH<10) printf(" advanced hull capability,");
	if(baseT->techH==10) printf(" maximum hull capability,");
	if(baseT->techE>6&&baseT->techE<10) printf(" advanced engine capability,");
	if(baseT->techH==10) printf(" maximum engine capability,");
	if(baseT->techW>6&&baseT->techW<10) printf(" advanced weapon capability,");
	if(baseT->techH==10) printf(" maximum weapon capability,");
	if(baseT->techT>6&&baseT->techT<10) printf(" advanced torpedo capability,");
	if(baseT->techH==10) printf(" maximum torpedo capability,");
	if(plan->eleN < 10) printf(" severe fuel shortage,");
	else if(plan->eleN < 100) printf(" serious fuel shortage,");
	else if(plan->eleN < 300) printf(" fuel shortage,");
	if(plan->eleT<150||plan->eleD<150||plan->eleM<150)
		printf(" severe materials shortage,");
	else if(plan->eleT<300||plan->eleD<300||plan->eleM<300)
		printf(" moderate materials shortage,");
	else if(plan->eleT<700||plan->eleD<700||plan->eleM<700)
		printf(" slight materials shortage,");
	else if(plan->eleT<2000||plan->eleD<2000||plan->eleM<2000)
		printf(" sufficient materials,");
	if(plan->eleC < 10000) printf(" low population on base planet,");
	if(plan->money < 1000) printf(" low monetary reserves,");
	if(plan->eleS < 100) printf(" low supply stockpile,");
	if(baseT->storeF < 20) printf(" insufficient defense fighters,");
	if(baseT->defense < 100) printf(" base defenses are minimal,");
	if(baseT->damage) printf(" base has been damaged!\n");
	else printf(" base is fully operational.\n");
   }

   //should have separate function to determine whats needed
   //initialize ship numbers table
   makethis = decide_whats_needed(baseT, plan);


   c = 0;      //choose randomly from various hull selections c=# of choices
   if( makethis > 0 ) {
      for( I = 1 ; I<=20;I++){// 20
	 if( shipclass[race-1][I-1] == makethis ) {
		c = c + 1 ;
	 }
      } //NEXT I

      if( c > 0 ) {
	 r = MAX(1 , MIN(20,random(c)+1)); //build the r'th of makethis class
	 c = 0;
	 fgship = 0;
	 for( I = 1 ; I<=20;I++){// 20
	    if( shipclass[race-1][I-1] == makethis ) c++;

	    if( c == r ) {  //dont use c>=r only c==r
	       c=999;
	       fgship = I;
	       if( truehull[race-1][fgship-1] == 0 ) {
		  printf( "BAD HULL DATA ERROR!\n");
	       } //If      Moral of the story: DONT USE BREAK in loops
	    } //If         for no reason, sort of screwey (i.e. dont
	 } //NEXT I        understand perfectly why it didnt work here)
      } else {  // anti borg has no fuel carrier jip
	 if(CLIP_INFO(3)) printf("building random ship\n");
	 fgship = random(20)+1;
	 if(truehull[race-1][fgship-1]==0) fgship=0;
	 //make random ship

      } // end of fgship selector
   }//if makethis>0


   if( fgship > 0 ) {
       if(CLIP_INFO(2)) {
		LHull( &hull, truehull[race-1][fgship-1] );
		printf( "Military advisors request %s\n", hull.nm);
       } else if(CLIP_INFO(1)) printf( "Trying to build a ship class %d\n",makethis);

       if( baseT->techE >= 3 ) {  // base doesnt make ships til 3?
	  LHull( &hull, truehull[race-1][fgship-1] );
	  if((((hull.cost <= plan->money + plan->eleS)    //have materials
	    && (hull.eleM <= plan->eleM )
	    && (hull.eleT <= plan->eleT )
	    && (hull.eleD <= plan->eleD ))
	    || (baseT->storeH[fgship-1]>=1))  ){
		if(hull.tech<=baseT->techH) {
		   BuildShip( baseT, plan, fgship, &hull );
		} else {
		   if(CLIP_INFO(4)) printf("Base Hull tech<ship jip\n");
		   jipped=1;
		}
	  } else {
	    if(CLIP_INFO(4)) printf("standard jip... no hull or no materials.\n");
	    jipped=1;
	  }
       } else {
	 if(CLIP_INFO(4)) printf("Base Hull tech <3 jip\n");
	 jipped=1;
       }
   } //If
   if(jipped) {
     if(CLIP_INFO(2)) {
	printf("Military hawks look to salvage mothballed hulls.\n");
     }
     for(I=1;I<=20;I++) {
	if(baseT->storeH[I-1]>=1) {  //available hull attempts
	      LHull( &hull, truehull[race-1][I-1] );
	      if(BuildShip( baseT, plan, I, &hull )==1) { //success
		I=999;//terminate loop
	      } //else continue loop might find one that works
	}
     }
     //sleep(1);
   }
} //EnD sUb



void BuildNewStarbase() { //BuildNewStarbase
   //' 7  Building Starbase here
   int p,I;//,I;
   PLANTYPE plan;
   BASETYPE baseT;

   //this overrides the host, BAD BAD BAD -Miikka
   for( p = 1 ; p<=500; p++){// 500
      if( rPlanet[p-1] == race ) {
	 if( (abrain[p-1] == ABRAIN_BUILD_BASE) && (rBase[p-1] != race) ) {
	    //planetSlot = p;
	    LPlanet(&plan, p);
	    if( plan.money >= 900 ) {
	       if( plan.eleT >= 402 ) {
		  if( plan.eleD >= 120 ) {
		     if( plan.eleM >= 340 ) {
			 if(CLIP_INFO(2)) {
				printf("Colonists build starbase at %s\n",PLANETNAME(p));
			 } else {
				if(CLIP_INFO(1)) printf( "Building starbase!\n");
			 }
			 LBase(&baseT, p);
			 //plan.bStarbase = race;//guess it is base ID??
			 plan.money = plan.money - 900;
			 plan.eleT = plan.eleT - 402;
			 plan.eleD = plan.eleD - 120;
			 plan.eleM = plan.eleM - 340;

			 total_cash_consumption += 900;
			 total_eleT_consumption += 402;
			 total_eleD_consumption += 120;
			 total_eleM_consumption += 340;

			 rBase[p] = race;
			 baseT.ID = p;//planetSlot;
			 baseT.pNum = race;
			 baseT.defense = 0;
			 baseT.damage = 0;
			 baseT.techE = 1;
			 baseT.techH = 1;
			 baseT.techW = 1;
			 baseT.techT = 1;

			 switch( plan.species ){
			    case 1:   //humanoid
			       baseT.techH = 10;
			       break;
			    case 7:   //amphibious
			       baseT.techW = 10;
			       break;
			    case 8:
			       baseT.techE = 10;
			       break;
			    case 9:   //silicoid??
			       baseT.techT = 10;
			       break;
			    default:
			       break;
			 }
			 // c jip arrays taken care of here
			 for( I = 1 ; I<=9; I++){// 9
			    baseT.storeE[I-1] = 0;
			 } //NEXT I
			 for( I = 1 ; I<=20; I++){// 20
			    baseT.storeH[I-1] = 0;
			 }//NEXT I
			 for( I = 1 ; I<=10; I++){// 10
			    baseT.storeW[I-1] = 0;
			    baseT.storeT[I-1] = 0;
			    baseT.storeTorps[I-1] = 0;
			 } //NEXT I
			 baseT.storeF = 0;
			 baseT.mission = 1;
			 baseT.makeshipH = 0;
			 baseT.makeshipE = 0;
			 baseT.makeshipW = 0;
			 baseT.makeshipWc = 0;
			 baseT.makeshipT = 0;
			 baseT.makeshipTc = 0;
			 baseT.makeshipFc = 0;
			 SBase(&baseT, p);
			 SPlanet(&plan, p);
		      } //If
		   } //If
		} //If
	    } //If
	    //SPlanet(&plan, p);
	 } //If
      } //If
   } //NEXT p
} //EnD sUb


//if ship is obsolete will be recycled instead of repaired
int is_ship_obsolete(SHIPTYPE *me)
{
  int result=0;

  assert(me);

  if(am_i_a_spider_weaver(me) && me->tube<6) result++;
  if(am_i_robot_cats_paw(me) && me->tube<6) result++;
  if(am_i_lizard_cruiser(me) && me->eng<6) result++;


  switch(classlist[me->hull-1]) {
    case 1:
	if(me->eng<7) result++;
	break;
    case 2:
	if(me->eng<6) result++;
	break;
    case 3:
    case 4:
	if(me->wbanks && me->weapon<6) result++;
	if(me->tbanks && me->tube<6) result++;
	if(me->eng<7) result++;
	break;
    case 5:
    case 6:
	if(me->weapon<3) result++;
	break;
    case 7:
	if(me->eng<7) result++;
	break;
    case 8:
    case 9:
	if(me->eng<7) result++;
	break;
    default:
	assert(0);  //unknown type do a crash
	break;
  }

  return(result);
}


int is_design_smart(int fgship, int bestE, int bestW, int bestT)
{
   //printf("testing design of ship\n");
   //sleep(1);
   if( bestW < 4 ) {  // KLis hog disruptors
      //logic added here Miikka
      switch(shipclass[race-1][fgship-1]) {
	case 1:  // scouts and backwater local bolt cruisers
	case 2:  // eggs
	case 6:  // merlins
	case 5:  // neutronic refineries
	case 7:  // fuel carrier
	case 8:  //large eggs
	case 9:  //specials (cry spider weavers, liz cloak droppers
		 //          and other race specific specials)
	  //it is ok dont care about pitiful weapons
#ifdef DEBUG
	  //printf("pitiful beam weapons ok\n");
#endif
	  break;
	case 3: //cruisers
	case 4: //big badass battleships
	default:  //dont want to jip warships
#ifdef DEBUG
	  //printf("no pitiful beam weapons wanted.\n");
#endif
	  if(random(100)<97) return(0);  //still slight chance
#ifdef DEBUG
	  //printf( "Pitiful beams installed. . .\n");
#endif
	  break;
      }
   }
   if( bestT < 6 ) {  // hull has 0 case still ok
      //logic added here Miikka
      switch(shipclass[race-1][fgship-1]) {
	case 1:  // scouts and backwater local bolt cruisers
	case 2:  // eggs
	case 6:  // merlins
	case 5:  // neutronic refineries
	//case 3:  // local bolt cruisers
	case 8:  //large eggs
	  //it is ok dont care about pitiful weapons
#ifdef DEBUG
	  //printf("pitiful torps ok\n");
#endif
	  break;
	case 3:
	case 4: //big badass battleships
	case 9: //race specials need good torps
	default:  //dont want to jip warships at least MK4 4 torps
#ifdef DEBUG
	  //printf("no pitiful tubes wanted.\n");
#endif
	  if(random(100)<97) return(0); // still slight chance
#ifdef DEBUG
	  //printf( "Pitiful tubes installed. . .\n");
#endif
	  break;
      }
   }
   if( bestE < 4 ) {  //less than super stardrive 4?
      switch(shipclass[race-1][fgship-1]) {
	case 6:   //merlins and refineries dont care
	case 5:   //they are not going anywhere
	  break;
	case 2: //eggs
	case 1: // scouts
	case 3: //small bolt cruisers
	case 4: //big badass battleships
	case 7: //fuel carriers
	case 8: //large eggs
	case 9: //race specials need to go fast
	default:
	  return(0);
	  break;
      }
   } //If
   if( bestE < 6 ) { //less than supernova 6 drive?
      switch(shipclass[race-1][fgship-1]) {
	//case 1:  // scouts and backwater local bolt cruisers
	case 2:  // eggs
	  if(random(bestE)==0) return(0);  // twin return check still
	  if(random(bestE)==0) return(0);  // sometimes builds
	  if(random(bestE)==0) return(0);
	  break;
	case 6:   //merlins and refineries dont care
	case 5:   //they are not going anywhere
	  break;
	case 1: // scouts
	case 3: //small bolt cruisers
	case 4: //big badass battleships
	case 7: //fuel carriers
	case 8: //large eggs
	case 9: //race specials need to go fast
	default:
	  return(0);
	  break;
      }
   } //If

  if(CLIP_INFO(2)) printf("Design verified by scientists as logical.\n");
  return(1);  //ok if not clipped above
}

int raw_build_beam(BASETYPE *baseT, PLANTYPE *plan, BEAMSPEC *beam, int fgship)
{
  assert(baseT);
  assert(plan);
  assert(beam);
  assert(fgship>=1 && fgship <=10);
  assert(baseT->techW>=beam->tech);

  while(beam->cost > plan->money && plan->eleS) { //sell some supplies
    plan->eleS -= 1;
    plan->money += 1;
  }
  assert(plan->eleD >= beam->eleD);
  assert(plan->eleM >= beam->eleM);
  assert(plan->eleT >= beam->eleT);
  assert(plan->money >= beam->cost);

  total_eleD_consumption += beam->eleD;
  total_eleM_consumption += beam->eleM;
  total_eleT_consumption += beam->eleT;
  total_cash_consumption += beam->cost;


  plan->eleD -= beam->eleD;
  plan->eleM -= beam->eleM;
  plan->eleT -= beam->eleT;
  plan->money -= beam->cost;
  baseT->storeW[fgship-1] = baseT->storeW[fgship-1] + 1;
  return(1);
}

int raw_build_tube(BASETYPE *baseT, PLANTYPE *plan, TORPSPEC *tube, int fgship)
{
  assert(baseT);
  assert(plan);
  assert(tube);
  assert(fgship>=1 && fgship <=10);
  assert(baseT->techT>=tube->tech);

  while(tube->cost > plan->money && plan->eleS) { //sell some supplies
    plan->eleS -= 1;
    plan->money += 1;
  }
  assert(plan->eleD >= tube->eleD);
  assert(plan->eleM >= tube->eleM);
  assert(plan->eleT >= tube->eleT);
  assert(plan->money >= tube->cost);

  total_eleD_consumption += tube->eleD;
  total_eleM_consumption += tube->eleM;
  total_eleT_consumption += tube->eleT;
  total_cash_consumption += tube->cost;

  plan->eleD -= tube->eleD;
  plan->eleM -= tube->eleM;
  plan->eleT -= tube->eleT;
  plan->money -= tube->cost;
  baseT->storeT[fgship-1] = baseT->storeT[fgship-1] + 1;
  return(1);
}

int raw_build_eng(BASETYPE *baseT, PLANTYPE *plan, ENGSPEC *eng, int fgship)
{
  assert(baseT);
  assert(plan);
  assert(eng);
  assert(fgship>=1 && fgship <=9);
  assert(baseT->techE>=eng->tech);

  while(eng->cost > plan->money && plan->eleS) { //sell some supplies
    plan->eleS -= 1;
    plan->money += 1;
  }
  assert(plan->eleD >= eng->eleD);
  assert(plan->eleM >= eng->eleM);
  assert(plan->eleT >= eng->eleT);
  assert(plan->money >= eng->cost);

  total_eleD_consumption += eng->eleD;
  total_eleM_consumption += eng->eleM;
  total_eleT_consumption += eng->eleT;
  total_cash_consumption += eng->cost;

  plan->eleD -= eng->eleD;
  plan->eleM -= eng->eleM;
  plan->eleT -= eng->eleT;
  plan->money -= eng->cost;
  baseT->storeE[fgship-1] = baseT->storeE[fgship-1] + 1;
  return(1);
}

int raw_build_hull(BASETYPE *baseT, PLANTYPE *plan, HULLSPEC *hull, int fgship)
{
  assert(baseT);
  assert(plan);
  assert(hull);
  assert(fgship>=1 && fgship <=20);
  assert(baseT->techH>=hull->tech);

  if(CLIP_INFO(2)) printf("Technicians prepare hull for refit at space dock.\n");
     //time to build the hull!

  while(hull->cost > plan->money && plan->eleS) { //sell some supplies
    plan->eleS -= 1;
    plan->money += 1;
  }
  assert(plan->eleD >= hull->eleD);
  assert(plan->eleM >= hull->eleM);
  assert(plan->eleT >= hull->eleT);
  assert(plan->money >= hull->cost);

  total_eleD_consumption += hull->eleD;
  total_eleM_consumption += hull->eleM;
  total_eleT_consumption += hull->eleT;
  total_cash_consumption += hull->cost;

  plan->eleD -= hull->eleD;
  plan->eleM -= hull->eleM;
  plan->eleT -= hull->eleT;
  plan->money -= hull->cost;
  baseT->storeH[fgship-1] = baseT->storeH[fgship-1] + 1;

  return(1);
}

int get_base_hull(int number, int the_hull)
{
  int I;
  BASETYPE baseT;

  assert(number>=1 && number <=500);
  assert(the_hull>=1 && the_hull<=105);

  LBase( &baseT, number );

  for(I=1;I<=20;I++) {
    if(truehull[race-1][I-1]==the_hull)
	return(baseT.storeH[I-1]);
  }
  return(0);
}

//urgent 2 is emergency      urgent 1 is this is for a specific good ship
//urgent 0 means im just building up reserves
//negative urgencies possible, means only if im very wealthy
int plan_afford_beam(BEAMSPEC *beam, PLANTYPE *plan, int urgent, int many)
{
  HULLSPEC tmp;
  int min_money;

  assert(beam);
  assert(plan);
  assert(urgent<=2);

  if(urgent==0&&lowtech==0 && (strategy_option&STRATEGY_ALCHEMY_FIRST)) {
    //check if theres no alchemy save metal for it
    if(get_orbit_hull(plan, 105)==0 && get_base_hull(plan->ID,105)==0) {
	LHull( &tmp, 105 ); //load merlin to check on needed
	if(beam->eleD && plan->eleD < many*beam->eleD + tmp.eleD) return(0);
	if(beam->eleT && plan->eleT < many*beam->eleT + tmp.eleT) return(0);
	if(beam->eleM && plan->eleM < many*beam->eleM + tmp.eleM) return(0);
    }
    if(get_orbit_hull(plan, 104)==0 && get_base_hull(plan->ID,104)==0) {
	LHull( &tmp, 104 ); //load refinery to check on needed
	if(beam->eleD && plan->eleD < many*beam->eleD + tmp.eleD) return(0);
	if(beam->eleT && plan->eleT < many*beam->eleT + tmp.eleT) return(0);
	if(beam->eleM && plan->eleM < many*beam->eleM + tmp.eleM) return(0);
    }
  }
  min_money = 100 - 50 * urgent;
  if(strategy_option&STRATEGY_ECONOMIST) min_money *= 3.0;
  if(strategy_option&STRATEGY_MILITARIST) min_money *= .5;

  if(many*beam->cost + min_money > plan->money) return(0);
  if(beam->eleD && many*beam->eleD + (300 - 150 * urgent) > plan->eleD) return(0);
  if(beam->eleM && many*beam->eleM + (300 - 150 * urgent) > plan->eleM) return(0);
  if(beam->eleT && many*beam->eleT + (300 - 150 * urgent) > plan->eleT) return(0);
  return(1);
}

int plan_afford_tube(TORPSPEC *tube, PLANTYPE *plan, int urgent, int many)
{
  HULLSPEC tmp;
  int min_money;

  assert(tube);
  assert(plan);
  assert(urgent<=2);

  if(urgent==0&&lowtech==0 && (strategy_option&STRATEGY_ALCHEMY_FIRST)) {
    //check if theres no alchemy save metal for it
    if(get_orbit_hull(plan, 105)==0 && get_base_hull(plan->ID,105)==0) {
	LHull( &tmp, 105 ); //load merlin to check on needed
	if(tube->eleD && plan->eleD < many*tube->eleD + tmp.eleD) return(0);
	if(tube->eleT && plan->eleT < many*tube->eleT + tmp.eleT) return(0);
	if(tube->eleM && plan->eleM < many*tube->eleM + tmp.eleM) return(0);
    }
    if(get_orbit_hull(plan, 104)==0 && get_base_hull(plan->ID,104)==0) {
	LHull( &tmp, 104 ); //load refinery to check on needed
	if(tube->eleD && plan->eleD < many*tube->eleD + tmp.eleD) return(0);
	if(tube->eleT && plan->eleT < many*tube->eleT + tmp.eleT) return(0);
	if(tube->eleM && plan->eleM < many*tube->eleM + tmp.eleM) return(0);
    }
  }
  min_money = 100 - 50 * urgent;
  if(strategy_option&STRATEGY_ECONOMIST) min_money *= 3.0;
  if(strategy_option&STRATEGY_MILITARIST) min_money *= .5;

  if(many*tube->tubecost + min_money > plan->money) return(0);
  if(tube->eleD && many*tube->eleD + (300 - 150 * urgent) > plan->eleD) return(0);
  if(tube->eleM && many*tube->eleM + (300 - 150 * urgent) > plan->eleM) return(0);
  if(tube->eleT && many*tube->eleT + (300 - 150 * urgent) > plan->eleT) return(0);
  return(1);
}

int plan_afford_eng(ENGSPEC *engv, PLANTYPE *plan, int urgent, int many)
{
  HULLSPEC tmp;
  int min_money;

  assert(engv);
  assert(plan);
  assert(urgent <= 2);

  if(urgent==0&&lowtech==0&&(strategy_option&STRATEGY_ALCHEMY_FIRST)) {
    //check if theres no alchemy save metal for it
    if(get_orbit_hull(plan, 105)==0 && get_base_hull(plan->ID,105)==0) {
	LHull( &tmp, 105 ); //load merlin to check on needed
	if(engv->eleD && plan->eleD < many*engv->eleD + tmp.eleD) return(0);
	if(engv->eleT && plan->eleT < many*engv->eleT + tmp.eleT) return(0);
	if(engv->eleM && plan->eleM < many*engv->eleM + tmp.eleM) return(0);
    }
    if(get_orbit_hull(plan, 104)==0 && get_base_hull(plan->ID,104)==0) {
	LHull( &tmp, 104 ); //load refinery to check on needed
	if(engv->eleD && plan->eleD < many*engv->eleD + tmp.eleD) return(0);
	if(engv->eleT && plan->eleT < many*engv->eleT + tmp.eleT) return(0);
	if(engv->eleM && plan->eleM < many*engv->eleM + tmp.eleM) return(0);
    }
  }

  min_money = 200 - 100 * urgent;
  if(strategy_option&STRATEGY_ECONOMIST) min_money *= 3.0;
  if(strategy_option&STRATEGY_MILITARIST) min_money *= .5;

  if(many*engv->cost + min_money > plan->money) return(0);
  if(engv->eleD && many*engv->eleD + (300-150*urgent) > plan->eleD) return(0);
  if(engv->eleM && many*engv->eleM + (300-150*urgent) > plan->eleM) return(0);
  if(engv->eleT && many*engv->eleT + (300-150*urgent) > plan->eleT) return(0);
  return(1);
}

int plan_afford_hull(HULLSPEC *hullv, PLANTYPE *plan, int urgent, int many)
{
  HULLSPEC tmp;
  int min_money;

  assert(hullv);
  assert(plan);
  assert(urgent <= 2);

  if(urgent==0&&lowtech==0 && (strategy_option&STRATEGY_ALCHEMY_FIRST)) {
    //check if theres no alchemy save metal for it
    //HACK ALERT  compares only mineral amounts to determine if hulls same
    if(get_orbit_hull(plan, 105)==0 && get_base_hull(plan->ID,105)==0) {
      LHull( &tmp, 105 ); //load merlin to check on needed
      if(tmp.eleT!=hullv->eleT||tmp.eleD!=hullv->eleD||tmp.eleM!=hullv->eleM) {
	if(hullv->eleD && plan->eleD < many*hullv->eleD + tmp.eleD) return(0);
	if(hullv->eleT && plan->eleT < many*hullv->eleT + tmp.eleT) return(0);
	if(hullv->eleM && plan->eleM < many*hullv->eleM + tmp.eleM) return(0);
      }
    }
    if(get_orbit_hull(plan, 104)==0 && get_base_hull(plan->ID,104)==0) {
      LHull( &tmp, 104 ); //load refinery to check on needed
      if(tmp.eleT!=hullv->eleT||tmp.eleD!=hullv->eleD||tmp.eleM!=hullv->eleM) {
	if(hullv->eleD && plan->eleD < many*hullv->eleD + tmp.eleD) return(0);
	if(hullv->eleT && plan->eleT < many*hullv->eleT + tmp.eleT) return(0);
	if(hullv->eleM && plan->eleM < many*hullv->eleM + tmp.eleM) return(0);
      }
    }
  }

  min_money = 400 - 200 * urgent;
  if(strategy_option&STRATEGY_ECONOMIST) min_money *= 3.0;
  if(strategy_option&STRATEGY_MILITARIST) min_money *= .5;

  if(many*hullv->cost + min_money > plan->money) return(0);
  if(hullv->eleD && many*hullv->eleD + (300-150*urgent) > plan->eleD) return(0);
  if(hullv->eleM && many*hullv->eleM + (300-150*urgent) > plan->eleM) return(0);
  if(hullv->eleT && many*hullv->eleT + (300-150*urgent) > plan->eleT) return(0);
  return(1);
}


int try_to_complete_parts(HULLSPEC *hull, BASETYPE *baseT, PLANTYPE *plan, int hullnum)
{
  ENGSPEC engv;
  TORPSPEC torpv;
  BEAMSPEC beamv;
  int number_of_parts, i, max_number_slot;
  int needed;
  int stillneeded=0;
  int urgency;
  int sentinel_ok;
  int is_alchemy;
  int redesign_method=1;
  //redesign_method:
  //1 means buy best there is that you can afford no matter what

  //0 means use whatever you have most of in the reserves above the
  //cutoff tech level, or if enough stored up use maximum level stored up
  //that you have enough of

  assert(hull);
  assert(baseT);
  assert(plan);
  assert(hullnum>=1 && hullnum<=105);

  urgency=0;
  sentinel_ok=0; //for BIG HONKY designs and alchemy ships
  is_alchemy=0;


  if(hullnum==105||hullnum==104) {
	urgency=2;
	sentinel_ok=1;
	is_alchemy=1;
  }
  if(classlist[hullnum-1]==4) { //hack for large warships
	urgency=MAX(1,urgency);
  }
  if(classlist[hullnum-1]==1) { //hack for scouts
	urgency=MAX(2,urgency);
  }


  if(CLIP_INFO(2)) printf("Engineers try to 'improve' vessel design.\n");


//engines satisfactory, makes best possible afforded
//BEGIN MODULE   now engines
  max_number_slot=MAX(1,MIN(baseT->techE,6)); //notice default tech 6
  if(sentinel_ok) max_number_slot=1;//sentinel so warp 1 ok

switch(race) {
  case 0: //no race of this type
	redesign_method = 0;
	break;
  default:  //all races buy best engines no matter what
	redesign_method = 1;
	break;
}
if(redesign_method) {
  number_of_parts=0;
  for(i=max_number_slot;i<=9;i++) { //first try to complete engines
    LEng( &engv, i );
    if(baseT->techE >= engv.tech) {
      if(plan_afford_eng(&engv, plan, urgency,
	MAX(0,hull->engines-baseT->storeE[i-1]))) {
      //if(baseT->storeE[i-1]>number_of_parts) {
	max_number_slot=i;
	number_of_parts=baseT->storeE[i-1];
      }
    }
  }  // assert max_number_slot points to best candidate
} else {
  number_of_parts=0;
  for(i=max_number_slot;i<=9;i++) { //first try to complete engines
    LEng( &engv, i );
    if(baseT->techE >= engv.tech) {
      //if(plan_afford_eng(&engv, plan, urgency,
	//MAX(0,hull->engines-baseT->storeE[i-1]))) {
      if(baseT->storeE[i-1]>number_of_parts) {
	max_number_slot=i;
	number_of_parts=baseT->storeE[i-1];
      }
    }
  } // max_number_slot is now the slot with the maximum number of parts
}
  if(is_alchemy) {  //if not enough already just build stardrive 1
    max_number_slot=1;
    number_of_parts=baseT->storeE[1-1];
  }
  LEng( &engv, max_number_slot );
  needed=hull->engines - number_of_parts;  // must be positive
  needed=MAX(0,needed);
  //assert(needed>=0);
  //can I afford to build it?
  while(needed && (plan_afford_eng(&engv, plan, urgency,1)==1)) {
    raw_build_eng(baseT,plan,&engv,max_number_slot);
    needed--;
  }
  stillneeded += needed;
  if(INFO_CLIP(4) && needed) printf("Politicians cut engine %d funding. short %d\n"
	,max_number_slot,needed);
//END MODULE


//beams unsatisfactory, should concentrate on reserves
//BEGIN MODULE    beams
  max_number_slot=MAX(1,MIN(baseT->techW,6)); //notice default slot 6 (disruptors)
  if(is_alchemy) max_number_slot=1;
  number_of_parts=0;

switch(race) {
  case RACE_PRI:
	redesign_method = 1;
	break;
  default:
	redesign_method = 0;
	break;
}
if(redesign_method) {
  for(i=max_number_slot;i<=10;i++) { //first try to complete beams
    LBeam( &beamv, i );
    if(baseT->techW>=beamv.tech) {
      if(plan_afford_beam(&beamv, plan, urgency,
	MAX(0,hull->weapon-baseT->storeW[i-1]))) {
      //if(baseT->storeW[i-1]>number_of_parts) {
	max_number_slot=i;
	number_of_parts=baseT->storeW[i-1];
      }
    }
  }  // assert max_number_slot points to best candidate
} else {
  for(i=max_number_slot;i<=10;i++) { //first try to complete beams
    LBeam( &beamv, i );
    if(baseT->techW>=beamv.tech) {
      //if(plan_afford_beam(&beamv, plan, urgency,
	//MAX(0,hull->weapon-baseT->storeW[i-1]))) {
      if(baseT->storeW[i-1]>number_of_parts) {
	max_number_slot=i;
	number_of_parts=baseT->storeW[i-1];
      }
    }
  }
}

  if(is_alchemy) {  //if not enough already just build laser 1
    if(baseT->storeW[max_number_slot-1]!=10) {
      max_number_slot=1;
      number_of_parts=baseT->storeW[1-1];
    }
  }
  LBeam( &beamv, max_number_slot );
  needed=hull->weapon - number_of_parts;  // must be positive
  needed=MAX(0,needed);
  //assert(needed>=0);
  //can I afford to build it?
  while(needed && (plan_afford_beam(&beamv, plan, urgency,1)==1)) {
    raw_build_beam(baseT,plan,&beamv,max_number_slot);
    needed--;
  }
  stillneeded += needed;
  if(INFO_CLIP(4) && needed) printf("Politicians cut weapons %d funding. short %d\n"
	,max_number_slot,needed);
//END MODULE


//tubes good for crystallines, bad for other races.
//BEGIN MODULE   now tubes
  max_number_slot=MAX(1,MIN(baseT->techT,6)); //notice default remains mk4
  number_of_parts=0;
switch(race) {
  case RACE_CRY:
	redesign_method = 1;
	break;
  case RACE_CYL:
	redesign_method = 1;   //only have one ship use it as super minelayer
	break;
  default:
	redesign_method = 0;
	break;
}
if(redesign_method) {
  for(i=max_number_slot;i<=10;i++) { //first try to complete torps
    LTorp( &torpv, i );
    if(baseT->techT>=torpv.tech) {
      if(plan_afford_tube(&torpv, plan, urgency,
	MAX(0,hull->torp-baseT->storeT[i-1]))) {
      //if(baseT->storeT[i-1]>number_of_parts) {
	max_number_slot=i;
	number_of_parts=baseT->storeT[i-1];
      }
    }
  }  // assert max_number_slot points to best candidate
} else {
  for(i=max_number_slot;i<=10;i++) { //first try to complete torps
    LTorp( &torpv, i );
    if(baseT->techT>=torpv.tech) {
      //if(plan_afford_tube(&torpv, plan, urgency,
	//MAX(0,hull->torp-baseT->storeT[i-1]))) {
      if(baseT->storeT[i-1]>number_of_parts) {
	max_number_slot=i;
	number_of_parts=baseT->storeT[i-1];
      }
    }
  }  // a
}
  if(is_alchemy) {  //if not enough already just build torp 1
    if(baseT->storeT[max_number_slot-1]!=10) {
      max_number_slot=1;
      number_of_parts=baseT->storeT[1-1];
    }
  }
  LTorp( &torpv, max_number_slot );
  needed=hull->torp - number_of_parts;  // must be positive
  needed=MAX(0,needed);
  //assert(needed>=0);
  //can I afford to build it?
  while(needed &&(plan_afford_tube(&torpv, plan, urgency,1)==1)) {
    raw_build_tube(baseT,plan,&torpv,max_number_slot);
    needed--;
  }
  stillneeded += needed;
  if(INFO_CLIP(4) && needed) printf("Politicians cut torpedo %d funding. short %d\n"
	,max_number_slot,needed);
//END MODULE

  if(stillneeded && INFO_CLIP(2)) printf("Politicians cut porkbarrel project.\n");
  return(stillneeded);  //unused but neat to return failure or success
}



int BuildShip(BASETYPE *baseT, PLANTYPE *plan, int fgship, HULLSPEC *hull) { //BuildShi (fgship%)
//this function bypasses host starbase building... BAD   not anymore Miikka
   int bestE=0,bestT=0,bestW=0;//,fg=0;//,max=0;
   int PartNumber=0;

   assert(baseT);
   assert(plan);
   assert(hull);
   assert(fgship>=1);
   assert(fgship<=20);

   //cancel previous build orders
   baseT->makeshipH=0;
   baseT->makeshipE=0;
   baseT->makeshipW=0;
   baseT->makeshipWc=0;
   baseT->makeshipT=0;
   baseT->makeshipTc=0;
   baseT->makeshipFc=0;

   //now build the hull if it does not exist already, store it for later
   // in case build fails

   if((int)(baseT->storeH[fgship-1])==0)
     raw_build_hull(baseT,plan,hull,fgship); //else already had one
   if(baseT->storeH[fgship-1]<0) {
     printf("critical hull storage error aborting to avoid damaging host\n");
     exit(1);
   }

   //baseT->storeH[fgship-1] = MAX(0, (baseT->storeH[fgship-1]) );
   //error trap

   try_to_complete_parts(hull, baseT, plan, truehull[race-1][fgship-1]);
   //now check for available parts
   for( PartNumber = 1 ; PartNumber<=10; PartNumber++){// 10
      if( PartNumber < 9 ) {
	 if( baseT->storeE[PartNumber-1] >= hull->engines ) { bestE = PartNumber; }
      } else {
	 if( baseT->storeE[9-1] >= hull->engines ) { bestE = 9; }
      }
      if( baseT->storeT[PartNumber-1] >= hull->torp ) { bestT = PartNumber; }
      if( baseT->storeW[PartNumber-1] >= hull->weapon ) { bestW = PartNumber; }
   }

   if( bestE <= 0 || bestT <= 0 || bestW <= 0 ) {
      if(CLIP_INFO(2)) printf("Materials shortage forces workers to stop.\n");
      return(0);//EXIT int name_ () {
   } //If
   if(is_design_smart(fgship, bestE, bestW, bestT)==0) {
      if(CLIP_INFO(2)) printf("Scientists reject final design as irrational.\n");
      if(random(100)<97) return(0); //make it very rarely as jip? 2% jip
   }

   if(no_politics_disasters==0) {
   if(CHEAT_CLIP(4))
   if(random(6)==3) { //geek geek compensation for cheating
      if(CLIP_INFO(2)) printf("Labor Union strike prevents further work.\n");
      return(0);
   }
   if(CHEAT_CLIP(2))
   if(random(6)==3) { //geek geek compensation for cheating
     if(plan->happynessC<60) {
       if(CLIP_INFO(2)) printf("Political unrest prevents further work.\n");
       return(0);
     }
   }
   if(CHEAT_CLIP(1))
   if(random(6)==3) { //geek geek compensation for cheating
     if(plan->happynessN<60&&plan->native>500) {
       if(CLIP_INFO(2)) printf("Natives riot and damage ground facilities.\n");
       if(baseT->damage<15) baseT->damage += random(6);
       return(0);
     }
   }
   } //no politics disasters

   if(bestE>9 || bestT>10 || bestW>10) {
      printf( "best tech error. . .\n");
      assert(0);
   } //If


   assert(bestE); assert(bestW); assert(bestT);
   assert((baseT->storeH[fgship-1]));
   assert((baseT->storeE[bestE-1]>=hull->engines));

   if(hull->weapon) assert(baseT->storeW[bestW-1]>=hull->weapon);
   if(hull->torp) assert(baseT->storeT[bestT-1]>=hull->torp);

   baseT->makeshipH=fgship;
   baseT->makeshipE=bestE;
   if(hull->weapon) {
	baseT->makeshipW=bestW;
   } else {
	baseT->makeshipW=0;
   }
   baseT->makeshipWc=hull->weapon;
   if(hull->torp) {
	baseT->makeshipT=bestT;
   } else {
	baseT->makeshipT=0;
   }
   baseT->makeshipTc=hull->torp;
   baseT->makeshipFc=hull->bays;

   if(CLIP_INFO(2)) {
     if(CLIP_INFO(3)) {
     printf( "Building Ship: (%d type %d Eng) (%d type %d Beam) (%d type %d tubes)\n",
      hull->engines,bestE,hull->weapon,bestW,hull->torp,bestT);
     }
     printf( "Techs build %s at %s Starbase.\n", hull->nm, PLANETNAME(plan->ID));
   } else if(CLIP_INFO(1)) {
     printf( "NOW Building a Ship\n");
   }
   return(1);
}




//called by worksonbase
int enough_engines(BASETYPE *baseT, PLANTYPE *plan, int warp_level)
{
  int in_stock;
  int lowest_metal;
  int percentage_factor;
  int ideal_stock;
  int relative_value;
  //int total_all_levels;
  //BASETYPE baseT;
  //PLANTYPE plan;

//what fraction of metal reserved for engine construction
#define PERCENT_DIV_E  4
// max stockpile of engines per tech
#define MAX_STOCK_E   10

  if(baseT==NULL||plan==NULL) {
    printf("enough engines error\n");
    exit(1);
  }

  if(warp_level<1 || warp_level>9) return(1); //error returns enough
  //really should check stored hulls etc

  in_stock=baseT->storeE[warp_level-1];
  lowest_metal=MIN(plan->eleT,MIN(plan->eleD,plan->eleM)); //lowest metal
  percentage_factor=lowest_metal/PERCENT_DIV_E;
  if(lowest_metal<300 && warp_level>6) return(1); //emergency

  switch( warp_level )
  {      //gives value
    case 1:
       relative_value=100;//cheap anti-jip moly pumpers
       break;
    case 2:
       relative_value=1;//useless
       break;
    case 3:
       relative_value=1;//relatively useless but emergency
       break;
    case 4:
       relative_value=10;
       break;
    case 5:
       relative_value=100;//relatively useless but emergency
       break;
    case 6:
       relative_value=4;
       break;
    case 7:
       relative_value=10;  //low moly useage
       break;
    case 8:
       relative_value=4; //why not go for all
       break;
    case 9:
       relative_value=8; //important to have fast ships
       break;
    default:
       relative_value=0;  //error, dont build
       return(1);
       break;
  }
  ideal_stock=MIN(MAX_STOCK_E,MAX(0,relative_value*percentage_factor/100));

  if(in_stock<ideal_stock) return(0);

  return(1);  //have enough if not returned earlier
}

//called by worksonbase
int enough_beams(BASETYPE *baseT, PLANTYPE *plan, int beam_level)
{
  int in_stock;
  int lowest_metal;
  int percentage_factor;
  int ideal_stock;
  int relative_value;
  //BASETYPE baseT;
  //PLANTYPE plan;

  if(baseT==NULL||plan==NULL) {
    printf("enough beams error\n");
    exit(1);
  }
//what fraction of metal reserved for engine construction
#define PERCENT_DIV_W  5
// max stockpile of engines per tech
#define MAX_STOCK_W   10

  if(beam_level<1 || beam_level>10) return(1); //error returns enough
  //really should check stored hulls etc

  in_stock=baseT->storeW[beam_level-1];
  lowest_metal=MIN(plan->eleT,MIN(plan->eleD,plan->eleM)); //lowest metal
  percentage_factor=lowest_metal/PERCENT_DIV_W;
  if(lowest_metal<300 && beam_level>6) return(1); //emergency


  switch( beam_level )
  {      //gives value
    case 1:
       relative_value=100;//cheap anti-jip moly pumpers
       break;
    case 2:
       relative_value=2;//useless x-ray lasers
       break;
    case 3:
       relative_value=10;//relatively useless but emergency
       break;
    case 4:
       relative_value=10;  //pos beam or blaster??? cant remember
       break;
    case 5:
       relative_value=2;   //pos beam good but high moly
       break;
    case 6:
       relative_value=10;  //disruptors good low moly
       if(race==RACE_PRI) relative_value=100;
       break;
    case 7:
       relative_value=20;  //best destructor for price hvy blasters
       if(race==RACE_PRI) relative_value=10;
       break;
    case 8:
       relative_value=2; //too expensive  phaser
       break;
    case 9:
       relative_value=2; //too expensive  hvy disruptor
       if(race==RACE_PRI) relative_value=100;  //good with privateers
       break;
    case 10:
       relative_value=2; //too expensive  hvy phaser
       break;
    default:
       relative_value=0; //error, dont build
       return(1);
       break;
  }
  ideal_stock=MIN(MAX_STOCK_W,MAX(0,relative_value*percentage_factor/100));

  if(in_stock<ideal_stock) return(0);

  return(1);  //have enough if not returned earlier
}



//called by worksonbase
int enough_tubes(BASETYPE *baseT, PLANTYPE *plan, int tube_level)
{
  int in_stock;
  int lowest_metal;
  int percentage_factor;
  int ideal_stock;
  int relative_value;
  //BASETYPE baseT;
  //PLANTYPE plan;
  if(baseT==NULL||plan==NULL) {
    printf("enough tubes error\n");
    exit(1);
  }
//what fraction of metal reserved for torpedo tube construction
#define PERCENT_DIV_T  6
// max stockpile of engines per tech
#define MAX_STOCK_T   10

  if(tube_level<1 || tube_level>10) return(1); //error returns enough
  //really should check stored hulls etc

  in_stock=baseT->storeT[tube_level-1];
  lowest_metal=MIN(plan->eleT,MIN(plan->eleD,plan->eleM)); //lowest metal
  percentage_factor=lowest_metal/PERCENT_DIV_T;

  if(lowest_metal<300 && tube_level<6) return(1); //emergency
  //invert tube rule so little metal favors high tech tubes
  //since torps suck up all the metal, rather use money

  switch( tube_level )
  {      //gives value
    case 1:
       relative_value=1;//cheap anti-jip moly pumpers mk1
       break;
    case 2:
       relative_value=1;//proton?
       break;
    case 3:
       relative_value=1;//MK2?
       break;
    case 4:
       relative_value=1;  //gamma bombs
       break;
    case 5:
       relative_value=1;   //mk3
       break;
    case 6:
       relative_value=30;  //mk4
       if(race==RACE_CRY) relative_value=10;
       break;
    case 7:
       relative_value=1;  //mk5
       break;
    case 8:
       relative_value=1; //MK 6
       break;
    case 9:
       relative_value=20; //mk 7 best for moderate wealth
       if(race==RACE_CRY) relative_value=10;
       break;
    case 10:
       relative_value=6; //mk 8 torps too expensive good for tholians
       if(race==RACE_CRY) relative_value=40;
       break;
    default:
       relative_value=0; //error, dont build
       return(1);
       break;
  }
  ideal_stock=MIN(MAX_STOCK_T,MAX(0,relative_value*percentage_factor/100));

  if(in_stock<ideal_stock) return(0);

  return(1);  //have enough if not returned earlier
}



// Completely Translated Procedure array check done
void WorkOnSBase() {    //works on all bases at once
   int ship_count=0,planet_count=0;      //ship count, planet count
   int p,I,original_mission;
   BASETYPE baseT;
   PLANTYPE plan;
   ENGSPEC engv;
   BEAMSPEC beam;
   TORPSPEC torpv;
   SHIPTYPE me_in_dock;
   int one_per_turn_flag;
   long min_money;

   printf( "Working on starbases\n");
   for( I = 1 ; I<=500; I++){// 500
      if( mapr[I-1] == race ) {
	 ship_count = ship_count + 1;
      } //If
      if( rPlanet[I-1] == race ) {
	 planet_count = planet_count + 1;
      } //If
   } //NEXT I

   for( p = 1 ; p<=500; p++) {// 500
      if( rBase[p-1] == race ) {
	 //baseSlot = p;
	 //planetSlot = p;
	 LBase(&baseT, p);
	 LPlanet(&plan, p);
	 if(rPlanet[p-1]!=race && plan.eleC==0) {
	   printf("some fool pillaged/rebel ground attacked a planet out of existence when\n");
	   printf("a starbase was there!  This causes maketurn to think there is a data\n");
	   printf("encryption error from cheating.  Artificially fixing this bug up...\n");
	   printf("(Tim forgot to delete the base flag or something)\n");
	   rPlanet[p-1]=race;
	   plan.pNum = race;
	   plan.eleC = 1;  // min 1 colonists
	   //sleep(3);
	 }

	 assert(baseT.ID == p);
	 assert(plan.ID == p);

	 original_mission = baseT.mission;

	 one_per_turn_flag = 0;
	 if((lowtech==0 && baseT.techE < 10 )||(lowtech==1 && baseT.techE<6)) {
	    if(CLIP_INFO(1)) printf( "Improving Engine Tech Level\n");
	    if( lowtech == 0 ) {
	       while ( plan.money > 100*baseT.techE && baseT.techE < 10
		  && (one_per_turn_flag==0||baseT.techE<6)){
		  plan.money = plan.money - baseT.techE * 100;
		  total_cash_consumption += baseT.techE * 100;
		  baseT.techE = baseT.techE + 1;
		  if((strategy_option&STRATEGY_SCIENTIST)==0)
			one_per_turn_flag++;
	       }
	    } else {
	       while ( plan.money > 100*baseT.techE && baseT.techE < 6
		  && (one_per_turn_flag==0||baseT.techE<4)){
		  plan.money = plan.money - baseT.techE * 100;
		  total_cash_consumption += baseT.techE * 100;
		  baseT.techE = baseT.techE + 1;
		  if((strategy_option&STRATEGY_SCIENTIST)==0)
			one_per_turn_flag++;
	       }
	    } //If
	 } //If

	 one_per_turn_flag = 0;
	 if( lowtech == 0 ) {
	    if(plan.money>1000) {
	       while( plan.money > baseT.techH*100 && baseT.techH < 10
		  && one_per_turn_flag==0) {
		  if(CLIP_INFO(1)) printf( "Improving Hull Tech Level\n");
		  plan.money = plan.money - baseT.techH * 100;
		  total_cash_consumption += baseT.techH * 100;
		  baseT.techH = baseT.techH + 1;
		  if((strategy_option&STRATEGY_SCIENTIST)==0)
			one_per_turn_flag++;
	       } //If
	    } //If
	 } else {
	    if( baseT.techH < 6 ) {
	       while( plan.money > baseT.techH * 100 && baseT.techH<6
		  && one_per_turn_flag==0) {
		  if(CLIP_INFO(1)) printf( "Improving Hull Tech Level\n");
		  plan.money = plan.money - baseT.techH * 100;
		  total_cash_consumption += baseT.techH * 100;
		  baseT.techH = baseT.techH + 1;
		  if((strategy_option&STRATEGY_SCIENTIST)==0)
			one_per_turn_flag++;
	       } //If
	    } //If
	 } //If

	 one_per_turn_flag=0;
	 if( lowtech == 0 ) {
	    if(plan.money>1000) {
	       while( plan.money > baseT.techT * 100 && baseT.techT<10
		  && one_per_turn_flag==0) {
		  if(CLIP_INFO(1)) printf( "Improving Torp Tech Level\n");
		  plan.money = plan.money - baseT.techT * 100;
		  total_cash_consumption += baseT.techT * 100;
		  baseT.techT = baseT.techT + 1;
		  if((strategy_option&STRATEGY_SCIENTIST)==0&&race!=RACE_CRY)
			one_per_turn_flag++;
	       } //If
	    } //If
	 } else {
	    if( (baseT.techT < 6 && ship_count > 10) || baseT.techT < 5 ) {
	       while( plan.money > baseT.techT * 100 && baseT.techT<6
		  && one_per_turn_flag==0) {
		  if(CLIP_INFO(1)) printf( "Improving Torp Tech Level\n");
		  plan.money = plan.money - baseT.techT * 100;
		  total_cash_consumption += baseT.techT * 100;
		  baseT.techT = baseT.techT + 1;
		  if((strategy_option&STRATEGY_SCIENTIST)==0&&race!=RACE_CRY)
			one_per_turn_flag++;
	       } //If
	    } //If
	 } //If
	 one_per_turn_flag=0;
	 if( lowtech == 0 ) {   //was 1 typo?
	    if(plan.money>1000) {
	       while( plan.money > baseT.techW * 400 && baseT.techW<10
		  && one_per_turn_flag==0) {
		  if(CLIP_INFO(1)) printf( "Improving Beam Weapon Tech Level\n");
		  plan.money = plan.money - baseT.techW * 100;
		  total_cash_consumption += baseT.techW * 100;
		  baseT.techW = baseT.techW + 1;
		  if((strategy_option&STRATEGY_SCIENTIST)==0&&race!=RACE_PRI)
			one_per_turn_flag++;
	       } //If
	    } //If
	 } else {
	    if( (baseT.techW < 6 && ship_count > 10) || baseT.techW < 4 ) {
	       while( plan.money > baseT.techW * 400 && baseT.techW<6
		  && one_per_turn_flag==0) {
		  if(CLIP_INFO(1)) printf( "Improving Beam Weapon Tech Level\n");
		  plan.money = plan.money - baseT.techW * 100;
		  total_cash_consumption += baseT.techW * 100;
		  baseT.techW = baseT.techW + 1;
		  if((strategy_option&STRATEGY_SCIENTIST)==0&&race!=RACE_PRI)
			one_per_turn_flag++;
	       } //If
	    } //If
	 } //If


	 if( plan.money ) {  // now use money in case no supplies
	    min_money = 6000;
	    if(strategy_option&STRATEGY_MILITARIST) min_money *= .7;
	    if(strategy_option&STRATEGY_ECONOMIST) min_money *= 2.0;
	    if(strategy_option&STRATEGY_DEFENSIVE) min_money *= .7;
	    if(race==RACE_EMP) min_money *= 2.0;


	    if( plan.money > min_money && plan.eleM>200 && plan.eleT>300 ) {
	       if(CLIP_INFO(1)) printf( "Building 100mc fighters\n");
	       if(race==RACE_EMP) {
		 while ( plan.money > min_money && plan.eleT > 3 && plan.eleM > 2 && baseT.storeF < 20){
		   plan.eleT = plan.eleT - 3;
		   plan.eleM = plan.eleM - 2;
		   baseT.storeF = baseT.storeF + 1;
		   plan.money = plan.money - 100;

		   total_eleT_consumption += 3;
		   total_eleM_consumption += 2;
		   total_cash_consumption += 100;
		 }
	       } else {
		 while ( plan.money > min_money && plan.eleT > 3 && plan.eleM > 2 && baseT.storeF < 60){
		   plan.eleT = plan.eleT - 3;
		   plan.eleM = plan.eleM - 2;
		   baseT.storeF = baseT.storeF + 1;
		   plan.money = plan.money - 100;

		   total_eleT_consumption += 3;
		   total_eleM_consumption += 2;
		   total_cash_consumption += 100;
		 }
	       }
	    } //If
	 } //If
	 if( race == 9 || race == 10 || race == 11 ) {
	    if(CLIP_INFO(1)) printf( "Building fighters in space\n");   //cheats, needs ship
	    while ( plan.eleT > 3 && plan.eleM > 2 && baseT.storeF < 60 && plan.eleS > 5){
	       plan.eleT = plan.eleT - 3;
	       plan.eleM = plan.eleM - 2;
	       baseT.storeF = baseT.storeF + 1;
	       plan.eleS = plan.eleS - 5;

	       total_eleT_consumption += 3;
	       total_eleM_consumption += 2;
	       total_eleS_consumption += 5;
	    }
	 }

	 if(CLIP_INFO(1)) printf( "Building Engines\n");
	 for( I = 1 ; I<=9; I++) {// baseT.techW
		  LEng(&engv, I );
		  if(baseT.techE>=engv.tech) {
		    while ( enough_engines(&baseT, &plan, I)==0 &&
			  plan_afford_eng(&engv, &plan, 0,1) ) {
		      raw_build_eng(&baseT,&plan,&engv,I);
		    }
		  }
	 } //NEXT I

	 if(CLIP_INFO(1)) printf( "Building Beam Weapons\n");
	 for( I = 1 ; I<=10; I++) {// baseT.techW
	      LBeam(&beam, I );
	      if(baseT.techW>=beam.tech) {
		while ( enough_beams(&baseT, &plan, I)==0 &&
		      plan_afford_beam(&beam, &plan, 0,1) ) {
		  raw_build_beam(&baseT,&plan,&beam,I);
		}
	      }
	 } //NEXT I

	 if(CLIP_INFO(1)) printf( "Building Torpedo Tubes\n");
	 for( I = 1 ; I<=10; I++) {// baseT.techT
	     LTorp(&torpv, I );
	     if(baseT.techT>=torpv.tech)
	     while ( enough_tubes(&baseT, &plan, I)==0 &&
		     plan_afford_tube(&torpv, &plan, 0,1)) {
		raw_build_tube(&baseT,&plan,&torpv,I);
	     }
	 } //NEXT I

	 min_money = 6000;
	 if(strategy_option&STRATEGY_MILITARIST) min_money *= .7;
	 if(strategy_option&STRATEGY_ECONOMIST) min_money *= 2.0;
	 if(strategy_option&STRATEGY_DEFENSIVE) min_money *= .7;

	 if( baseT.defense < 200 && plan.money > min_money && plan.eleD > 700 ){
	   if(CLIP_INFO(2)) printf("Improving Starbase Defences\n");
	 }
	 while ( baseT.defense < 200 && plan.money > min_money && plan.eleD > 700 ){
	    baseT.defense = baseT.defense + 1; //was using all my duranium
	    plan.money = plan.money - 10;
	    plan.eleD--;
	    total_eleD_consumption += 1;
	    total_cash_consumption += 10;
	 } //while


	 baseT.mission = random(6) + 1;   //Miikka experimenting random
	 //baseT.mission = 6;                 //force surrender


	 // 1=refuel 2=max def 3=load torps 4=unload frgtrs 5=repair
	 // 6=force surrender

//MODULE CHECK SHIPS IN ORBIT BEGINS
   for( I = 1 ; I<=500; I++){// 500
      if(mapx[I-1]!=xPlanet[p-1]) continue;
      if(mapy[I-1]!=yPlanet[p-1]) continue;

      if( mapr[I-1] == race ) { //friendly ship
	if(CLIP_INFO(4)) printf("friendly ID=%d in orbit\n",I);
	LShip( &me_in_dock, I );
	if (baseT.mission != 6) {  //if not forcing a surrender
	  switch(random(6)+1) {
	  case 1:
	  case 2:
		if(me_in_dock.eleT+me_in_dock.eleD+me_in_dock.eleM)
		  baseT.mission = 4; //unload freighters
		break;
	  case 3:
	  case 4:
		if(me_in_dock.tbanks)
		  baseT.mission = 3; //load torps oohhh yes!!!
		break;
	  case 5:
	  case 6:
	  default:
		if(me_in_dock.eleN==0)
		  baseT.mission = 1; //refuel wussy
		break;
	  }
	} //forgot !=6 jip
	//does base need fuel?
	if( me_in_dock.eleN > 1 && plan.eleN==0) {
	  plan.eleN++;
	  me_in_dock.eleN--;
	  if(INFO_CLIP(3)) printf("base taking little fuel\n");
	}
	if( me_in_dock.eleN > 100 && plan.eleN < 100 ) {
	  plan.eleN += 10;
	  me_in_dock.eleN -= 10;
	  if(INFO_CLIP(3)) printf("base taking fuel\n");
	}
	//needs fuel?
	if( me_in_dock.eleN == 0 && plan.eleN>1 ) {  //here barely give any anti jip
	  if( plan.eleN ) {
	    plan.eleN--;
	    me_in_dock.eleN++;
	  }
	  if(INFO_CLIP(3)) printf("base giving fuel\n");
	}
	//too many torps?
	//irrelevant, i want many torps if possible!
	//needs torps?
	if(me_in_dock.tbanks&&am_i_low_on_torps(&me_in_dock)&&me_in_dock.damage==0 ) {
	  while(am_i_low_on_torps(&me_in_dock)&&CargoR(&me_in_dock) && baseT.storeTorps[me_in_dock.tube-1]){
	    me_in_dock.torp++;
	    baseT.storeTorps[me_in_dock.tube-1]--;
	  }
	  if(INFO_CLIP(3)) printf("base giving torps\n");
	}
	//needs fighters?
	if(me_in_dock.bays&&am_i_low_on_torps(&me_in_dock)&&me_in_dock.damage==0 ) {
	  if(am_i_fighter_pod(&me_in_dock)==0) {
	    while(CargoR(&me_in_dock) && baseT.storeF>40 && am_i_low_on_torps(&me_in_dock)) {
	      baseT.storeF--;
	      me_in_dock.torp++;
	    }
	    if(race==RACE_EMP) {
	      while(CargoR(&me_in_dock) && baseT.storeF>20 && am_i_low_on_torps(&me_in_dock)) {
		baseT.storeF--;
		me_in_dock.torp++;
	      }
	    }
	    if(INFO_CLIP(3)) printf("base giving fighters\n");
	  }
	}
	//needs repairs?
	if( me_in_dock.damage ) { // fix it
	  baseT.workonshipID = I;
	  baseT.workonshipAction = 1;
	  if(INFO_CLIP(3)) printf("base repairing ship\n");
	}
	//needs recycling? needs improvement but heres something
	if( me_in_dock.damage && is_ship_obsolete(&me_in_dock) ) {
	  //the design is obsolete so scrap it
	  baseT.workonshipID = I;
	  baseT.workonshipAction = 2; //scrap it
	  //maybe need to empty ship to avoid jip.
	  if(INFO_CLIP(3)) printf("base scrapping ship\n");
	  if(me_in_dock.bays) {  //dont jip fighters
	    if(INFO_CLIP(4)) printf("salvaging fighters\n");
	    while(baseT.storeF<60 && me_in_dock.torp) {
	      baseT.storeF++;
	      me_in_dock.torp--;
	    }
	  }
	  if(me_in_dock.tbanks&&me_in_dock.tube) {  //dont jip torpedoes
	    if(INFO_CLIP(4)) printf("salvaging torps\n");
	    baseT.storeTorps[me_in_dock.tube-1] += me_in_dock.torp;
	    me_in_dock.torp = 0;
	  }

	  //just empty hold now

	}


	SShip( &me_in_dock, I);
      } else if( mapr[I-1] ) { //enemy ship
	if(CLIP_INFO(4)) printf("enemy ID=%d in orbit\n",I);

	//force a surrender mode
	baseT.mission = 6;
      }
   }
//MODULE CHECK SHIPS IN ORBIT ENDS
	 if(baseT.damage) {
		baseT.mission=5;  //repair
	 }

	 if(baseT.mission!=original_mission) {
	   if(CLIP_INFO(2)) {
		printf("Changing base mission from %d to %d\n",
		    original_mission, baseT.mission);
	   }
	 }
	 assert(rBase[p-1]==race);
	 SBase(&baseT, p);
	 SPlanet(&plan, p);
      } //If base==race
   } //NEXT p
} //EnD sUb

