#include <owl.h>
#include <bwcc.h>
#include <listbox.h>
#include <scrollba.h>
#include <button.h>
#include <bbutton.h>
#include <edit.h>
#include <combobox.h>
#include <bchkbox.h>
#include <bgrpbox.h>
#include <bradio.h>
#include <bstatic.h>
#include <string.h>
#include <math.h>
#include <fstream.h>
#include <dir.h>

#include "cb_defs.hpp"

class vprprop
{
        int         current;
        int         status;
		struct {
			char    line1[40];
			char    line2[40];
			char    line3[40];
			char    line4[40];
		} Info;
        char        fnm[130];

    public:
                    vprprop(char *fname);
        int         read(int no);
        int         Status(void) {return status;}
		char *      Line(int no);
};

typedef struct {
    long    id;
    char    race[21];
    char    fcode[4];       
    long    structures[5];  
    long    ore[5];         
    long    x;
    long    y;
    long    u;
    char    name[21];
	long    temp;
    long    clan;       	
	long    natives;
	int		starbase;    
} mdatap;

extern double cbrt(double juuri);
extern void ConstructPath(char szBuff[150], char szHelper[150], char szFile[10], char szExt[5], long nro = 0);
extern long IsMiddle(long ala, long dest, long yla);
extern long Scalar(int Scala, int Screen);
extern long InvCalcX(long x, int S, int Screen);
extern long InvCalcY(long y, int S, int Screen);
extern long CalcX(long x, long Ox, int S, int Screen);
extern long CalcY(long y, long Oy, int S, int Screen);
extern int strpos(char *jono, char *pala);
extern long strvaluel(char *jono, char *pala, int adju, long oli);
extern void strvalues(char *kohde, char *jono, char *pala, int adju, int maxle, char lopeta = ' ');
extern mdatap HandleMessage(char *messu);
extern mdatap Explosion(char *messu);
extern mdatap OwnMField(char *messu);
extern mdatap LaidMField(char *messu);
extern mdatap EnemyMField(char *messu);

typedef struct {
		int		id;
		int     owner;
        int		defence;
		int     etech;          
        int     htech;          
        int     wtech;          
        int     ttech;          
		int     fighters;       
} starbase;

typedef struct {
		int		cmd;
		int		red;
		int		blue;
		int		green;
		long	x;
		long	y;
		long	r;
		char	txt[41];
} scripti;

extern scripti ParseScript(scripti kome, char *szScr);

typedef struct {
        int		id;
		int		turn[8];
		int     x[8];
        int     y[8];
		int		owner[8];
		int		warp;
		int		course;
		int		type;
		char	name[21];
} shipdata;

typedef struct {
		int     x;
        int     y;
		int     owner;
        int		starbase;
		char	name[21];
} planetdata;

typedef struct {
		long	res[10][2];
		int		native_race;
} planetres;

typedef struct {
	int	NumOfObjects;
    int	DeletedObjects;
	int	Turn;
	int	BlockSize;
	int Version;
	int Safety;
} header;

typedef struct {
		int 	id;
		int		owner[8];	// Player 1-11
        int		turn[8];	// Turn when info
		int     x[8];       // x-position history
		int     y[8];       // y-position history
		int		w[8];       // weight history
		int		lastseen;	// Round when latest info
		int     type;       // latest ship type
		int		warp;       // warpfactor
		int     course;     // warp direction (-1 - 359)
		int		lastvisual;	// Round when latest "visual" contact
		char    name[21];   // latest ship name
} shipfile;

typedef struct {
		int     id;
		int		x;
		int		y;
        char	name[21];
		char    fcode[4];
		int     owner;
		int 	turn;
		int     mines;
        int     factories;
		int     defences;
		long    supply;
        long    money;
		long    stock_fuel;
        long    stock_tr;
        long    stock_dr;
        long    stock_mb;
		long    ground_fuel;
        long    ground_tr;
        long    ground_dr;
        long    ground_mb;
        int     rate_fuel;
        int     rate_tr;
        int     rate_dr;
        int     rate_mb;
		long    colonist;
		int     tax_col;
		int     feel_col;
		long    natives;
        int     native_race;
		int     native_gov;
		int     tax_nat;
		int     feel_nat;
		int		temperature;
		int		buildbase;
} planetfile;

typedef struct {
		int 	id;
		int		owner;
		int     x;
		int     y;
        long    units;
} mfieldfile;

typedef struct {
		int     x;
		int     y;
} distress;

class TRaceDlg : public TDialog
{
	public:
		struct {
			char	szNa[31];
			char	szSc[6];
			char	szBa[4];
			char	szPl[4];
			char	szWS[4];
			char	szCS[4];
			char	szIn[4][40];
		} Rotu; // Rotu = Race

		PTListBox		RaceLst;
						TRaceDlg(PTWindowsObject AParent, LPSTR AResource, LPSTR ATitle);
		virtual void	SetupWindow();
		virtual void 	Ok(RTMessage Msg);
		virtual void 	HandleLBNs(RTMessage) = [ID_FIRST + RACELIST];
		virtual void 	WMRInfo(RTMessage) = [ID_FIRST + ID_RINFO];
};

class TRaceInfoDlg : public TDialog
{
	public:
						TRaceInfoDlg(PTWindowsObject AParent, LPSTR AResource);
};

class TRScoreDlg : public TDialog
{
	public:
						TRScoreDlg(PTWindowsObject AParent, LPSTR AResource);
};

class TMFieldListDlg : public TDialog
{
	public:
		long			Siirto;
		struct {
            char	szO[3];
			char	szI[4];
			char	szX[5];
			char	szY[5];
            char	szU[7];
		} Kentat; // Kentat = Fields

		PTListBox		MFieldLst;
						TMFieldListDlg(PTWindowsObject AParent, LPSTR AResource);
		virtual void	SetupWindow();
		virtual void 	HandleLBNs(RTMessage) = [ID_FIRST + MFIELDLIST];
		virtual void 	WMAddMField(RTMessage) = [ID_FIRST + ID_MFADD];
		virtual void 	WMModMField(RTMessage) = [ID_FIRST + ID_MFMOD];
		virtual void 	WMDelMField(RTMessage) = [ID_FIRST + ID_MFDEL];
};

class TMFieldEditDlg : public TDialog
{
	public:
						TMFieldEditDlg(PTWindowsObject AParent, LPSTR AResource);
		virtual void	SetupWindow();
};

class TInfoListDlg : public TDialog
{
	public:
		struct {
			char	szTu[4];
			char	szId[5];
			char	szNa[21];
			char	szOw[3];
			char	szFC[6];
			char	szCl[7];
			char	szMi[12];
			char	szFa[12];
			char	szDe[12];
			char	szCo[8];
			char	szCT[20];
			char	szCF[20];
			char	szMo[7];
			char	szSu[7];
			char	szNR[22];
			char	szNG[22];
			char	szNv[8];
			char	szNT[20];
			char	szNF[20];
			char	szSN[6];
			char	szGN[6];
            char	szRN[5];
			char	szST[6];
			char	szGT[6];
            char	szRT[5];
			char	szSD[6];
			char	szGD[6];
            char	szRD[5];
			char	szSM[6];
			char	szGM[6];
			char	szRM[5];
			char	szB1[80];
			char	szB2[80];
		} Planu; // Planets

		struct {
        	char	szId[4];
			char	szLV[4];
			char	szLS[4];
			char	szHu[32];
			char	szNa[21];
			char	szWa[2];
			char	szCo[4];
			char	szRa[34];
			char	szHi[8][80];
			char	szDa[13][6];
		} Alu; // Ships

		int				Lista[510];

		PTListBox		InfoLst;

						TInfoListDlg(PTWindowsObject AParent, LPSTR AResource);
		virtual void	SetupWindow();
		virtual BOOL	CanClose();
		virtual void 	HandleLBNs(RTMessage) = [ID_FIRST + INFOLIST];
		virtual void 	WMDetails(RTMessage) = [ID_FIRST + ID_DETAILS];
		virtual void	DetailPlanet(int Index);
		virtual void	DetailShip(int Index);
};

class TPlanetInfoDlg : public TDialog
{
	public:
						TPlanetInfoDlg(PTWindowsObject AParent, LPSTR AResource);
		virtual void	SetupWindow();
};

class TShipInfoDlg : public TDialog
{
	public:
						TShipInfoDlg(PTWindowsObject AParent, LPSTR AResource);
		virtual void	SetupWindow();
};

class TPassWordDlg : public TDialog
{
	public:
						TPassWordDlg(PTWindowsObject AParent, LPSTR AResource);
};

class TSpaceWindow : public TWindow
{
	public:
		planetres	*reso[501];
		starbase	*base[501];
		planetdata	*planut[501];
		shipdata	*ships[501];
		mfieldfile  mfield[501];
		distress	explo[100];
		scripti		kome[400];

		unsigned long	ColorRef[40];
		int		DOTLineStyle, DASHLineStyle;
		int		ScriptLines, LineWidi, Scale, Action, Mater[10], Shows[30];
		int		ScreenSize, iMessu, iMsg[500], ascirc;
		int		exploKpl, mfieldKpl, mfieldModified, planetModified;
		int		shipKpl, baseKpl;
		long	Kierros, RadarPla, RadarShi, RadarEne;
		int		SKierros, PKierros, MKierros, DKierros;
		long	Ox, Oy, meX, meY, meC, meW, meT, meS, savX, savY, oliX, oliY, etas;
		long	Player, Follow, Siirto, SiirtoX, SiirtoY, SiirtoT, SiirtoS;
		char	szPass[16], racepath[128], stickyT[21];
		char	gameini[204];

						TSpaceWindow(PTWindowsObject Parent, LPSTR Title, LPSTR szCmdLine);
						~TSpaceWindow(void);
		virtual void 	LogError(char *ko, char *su);
		virtual LPSTR 	GetClassName() {return "Crystal";}
		virtual void 	GetWindowClass(WNDCLASS& AWndClass);
		virtual void 	SetupWindow();
		virtual void  	Paint(HDC hDC, PAINTSTRUCT& PaintInfo);
		virtual void  	WMLButtonDown(RTMessage Msg) = [WM_FIRST + WM_LBUTTONDOWN];
		virtual void  	WMLDClick(RTMessage Msg) = [WM_FIRST + WM_LBUTTONDBLCLK];
		virtual void  	WMRButtonDown(RTMessage Msg) = [WM_FIRST + WM_RBUTTONDOWN];

		void  			DownAndDClick(RTMessage Msg, int TempMode);
		void 			ActionAbove(long numes, long numex, long numey);
		void  			OwnRace(void);
		void  			PrimaryEnemy(void);
		void  			EditMFields(void);
		void			UpdateAllData(void);
		void			InitShipdbv(void);
		void			UpdateShipdbv(void);
		void 			InitPlanetdbv(void);
		void			UpdatePlanetdbv(void);
		void 			WriteMFielddbv(void);
		void			MessagesTOdbv(void);
		void			ExportMessage(void);
};

class TMainWindow : public TWindow
{
		TScrollBar		*zoomi;
		TBStatic		*zooseli, *origo;
        TButton			*toimi;
		int				Scale, CanSave, ActiveLayer;
	public:
		TComboBox		*comater;
		TBGroupBox		*gbmater, *gbgrou1, *gbshowi;
		TBCheckBox		*cbmater[10], *cbshowi[30];
		TButton			*bshowi[10];
		TBCheckBox		*cbgravi, *cbtrace, *cbwarpc, *cbmitta;
		TScrollBar		*vaaka, *pysty;
		TBStatic		*koord, *dista, *hyphelp, *llevel[5];
		long			Ox, Oy;
		int				ScreenSize;
        char			gameini[203];
		struct {
        	char	szNa[11][31];
			char	szSc[11][7];
			char	szBa[11][4];
			char	szPl[11][4];
			char	szWS[11][4];
			char	szCS[11][4];
		} Pisteet; // Pisteet = Scores

		PTWindowsObject	ruutu;
		TMainWindow(PTWindowsObject Parent, LPSTR Title, LPSTR szCmdLine);
		virtual BOOL	CanClose(void);
		virtual LPSTR 	GetClassName() {return "Crysball";}
		virtual void 	GetWindowClass(WNDCLASS& AWndClass);
		virtual void 	SetupWindow();
		virtual void 	HideLayer(void);
		virtual void 	ShowLayer(int LayerNo);

		virtual void 	SetBars(void);
		virtual void  	WMActionXY(RTMessage Msg) = [ID_FIRST + ID_COORD];

		virtual void  	WMActivateLayer1(RTMessage Msg) = [ID_FIRST + ID_LAYE1];
		virtual void  	WMActivateLayer2(RTMessage Msg) = [ID_FIRST + ID_LAYE2];
		virtual void  	WMActivateLayer3(RTMessage Msg) = [ID_FIRST + ID_LAYE3];
		virtual void  	WMActivateLayer4(RTMessage Msg) = [ID_FIRST + ID_LAYE4];
		virtual void  	WMActionTurn(RTMessage Msg) = [ID_FIRST + ID_REREAD];
		virtual void 	WMRScore(RTMessage) = [ID_FIRST + ID_SCORE];
		virtual void  	WMEditMFields(RTMessage Msg) = [ID_FIRST + ID_MFIELD];
		virtual void  	WMOwnRace(RTMessage Msg) = [ID_FIRST + ID_OWNRACE];
		virtual void  	WMPrimaryEnemy(RTMessage Msg) = [ID_FIRST + ID_ENEMY];
		virtual void  	WMActionExit(RTMessage Msg) = [ID_FIRST + ID_EXIT];
		virtual void  	WMAllShips(RTMessage Msg) = [ID_FIRST + ID_ALLSH];
		virtual void  	WMAllPlanets(RTMessage Msg) = [ID_FIRST + ID_ALLPL];

		virtual void  	WMMsgNext(RTMessage Msg) = [ID_FIRST + ID_MEPLU];
		virtual void  	WMMsgPrev(RTMessage Msg) = [ID_FIRST + ID_MEMII];

		virtual void  	WMHandleVaaka(RTMessage Msg) = [ID_FIRST + ID_VAAKA];
		virtual void  	WMHandlePysty(RTMessage Msg) = [ID_FIRST + ID_PYSTY];
        virtual void	WMHandleZoomi(RTMessage Msg) = [ID_FIRST + ID_ZOOMI];
		virtual void	WMHandleCenter(RTMessage Msg) = [ID_FIRST + ID_MCENT];

		virtual void 	WMMater(RTMessage) = [ID_FIRST + ID_RAWMAT];
		virtual void 	WMShows(RTMessage) = [ID_FIRST + ID_SHOWI];
		virtual void 	WMExportM(RTMessage) = [ID_FIRST + ID_MEEXP];
};

