/*************************************************************************
  Name: strztok
  Format: char *strztok(char *s1, char *s2)
  Purpose: Parses the string s1 into tokens delimited by the characters in
           string s2.
  Description:    implements a function similar to strtok with some
               differences.  strtok passes over delimiter characters until
               it finds a character that is not in the delimiter set, then
               forms the token from it and all subsequent characters up to
               the next delimiter.  It will never return a null token.
               strztok, on the other hand, will not process more than one
               delimiter character per call.  If there is no string between
               delimiters, then strztok will point to a null string.
                  A couple of examples will illustrate the difference.  In
               both examples, the delimiter character set is "#@".
                  Example 1: string being parsed is "##1@@2"
                    strtok returns: "1", "2"
                    strztok returns: "", "", "1", "", "2"
                  Example 2: string being parsed is "1#@2@#3#"
                    strtok returns: "1", "2", "3"
                    strztok returns: "1", "", "2", "", "3"
                  Both functions are called the same way.  The first time
               the function is called for string s1, a pointer to the
               string is passed to the function.  On subsequent calls to
               the function for the same string, a NULL pointer is passed
               instead.  Both functions act destructively on the string
               being processed.
*************************************************************************/
/* includes */
#include <string.h>

#ifndef NULL
#define NULL 0L
#endif

/* function prototype */
char *strztok(char *, char *);

char *strztok(s1, s2)
char *s1;
char *s2;
  {
    static char *next_start_position;
    char *start_position;
    char *next_delimiter_position;

    if(s1 == NULL)
      { /* subsequent calls to function, start where we left off */
        start_position = next_start_position;
      } /* subsequent calls to function, start where we left off */
    else
      { /* first call to function, start at the beginning of the string */
        start_position = s1;
      } /* first call to function, start at the beginning of the string */
    if(*start_position == '\0')
      { /* no more tokens if we've hit the null terminator */
        return(NULL);
      } /* no more tokens if we've hit the null terminator */
    /* locate the next delimiter */
    next_delimiter_position = strpbrk(start_position, s2);
    if(next_delimiter_position == NULL)
      { /* no next delimiter found, token is rest of string */
        /* point the next start position at the null terminator */
        next_start_position = start_position + strlen(start_position);
      } /* no next delimiter found, token is rest of string */
    else
      { /* next delimiter found */
        /* replace the delimiter character with null terminator */
        *next_delimiter_position = '\0';
        /* next start position is 1 character beyond delimiter */
        next_start_position = next_delimiter_position + 1;
      } /* next delimiter found */
    return(start_position);
  } /* end of strztok() */
