#include <stdio.h>
#include <ctype.h>
#include "global.h"
#define OKAY 0
#define NOT_OKAY 1

int zrealloc_cpy(cpp_to, cp_from)
char **cpp_to, *cp_from;
{
  int from_len;
  /*
   *  In this case free any memory used by cpp_to and
   *  set to NULL.
   */
  if (cp_from == NULL)
  {
    if (*cpp_to != NULL)
    {
      free(*cpp_to);
      *cpp_to = NULL;
    }
    return OKAY;
  }
  /*
   *  Calculate length of string.
   */
  from_len = strlen(cp_from);
  /*
   *  Is the target string going to be too small
   *  for our source string?
   */
  if (*cpp_to != NULL)
    if (from_len > strlen(*cpp_to))
    {
      free(*cpp_to);
      *cpp_to = NULL;
    }
  /*
   *  Allocate target string.
   */
  if (*cpp_to == NULL)
  {
    *cpp_to = (char *) calloc(1, from_len + 1);
    if (*cpp_to == NULL)
      return NOT_OKAY;
  }
  strcpy(*cpp_to, cp_from);

  return OKAY; /* okay */
}

/*
 *   Copy cp_from to the what cpp_to points to.  Irregardless
 *   of what cpp_to points to, a newly alloced string will
 *   be alloced and cpp_to will be set to that string.
 *   If it is wished that what cpp_to points to should be
 *   freed() first, then use zrealloc_cpy().
 */
zalloc_cpy(cpp_to, cp_from)
char **cpp_to, *cp_from;
{
  *cpp_to = NULL;
  return zrealloc_cpy(cpp_to, cp_from);
}

/*
 *   Returns TRUE cp_str contains a valid integer.
 */
strIsInt(cp_str)
char *cp_str;
{
  int i;

  if (cp_str == NULL)
    return FALSE;

  i = 0;

  /* skip over leading spaces */
  while (cp_str[i] == ' ') 
    i++;
  
  if (cp_str[i] == '-')
    i++;

  if (cp_str[i] == '\0')
    return FALSE;

  for (; cp_str[i] != '\0'; i++)
    if (!isdigit(cp_str[i]))
      return FALSE;

  return TRUE;
}
/*
 *   Returns TRUE cp_str contains a valid double.
 *   There may be spaces leading the double.
 */
strIsDouble(cp_str)
char *cp_str;
{
  return str_IsDouble(cp_str);
}
/*
 *   Returns TRUE cp_str contains a valid double.
 *   There may be spaces leading the double.
 */
str_IsDouble(cp_str)
char *cp_str;
{
  char *cp;
  char *copy;
  int found_dot, found_e;
  register int i;

  if (cp_str == NULL)
    return FALSE;

  zalloc_cpy(&copy, cp_str);
  strStripSpaces(copy);

  i = 0;
  /*
   *  May start number with optional minus sign.
   */
  if (copy[i] == '-')
    i++;
  /*
   *  If we already are at the end of the string
   *  then return FALSE.
   */
  if (copy[i] == '\0')
  {
    free(copy);
    return FALSE;
  }
  /*
   *  More initialization
   */
  found_dot = 0;
  found_e = 0;

  for (; copy[i] != '\0'; i++)
  {
    /*
     *  Digits always allowable
     */
    if (isdigit(copy[i]))
      continue;
    else
    {
      switch (copy[i])
      {
	case 'e' :
	case 'E' :
	  /*
	   *  More than one 'e' not allowed
	   */
	  if (found_e)
	  {
	    free(copy);
	    return FALSE;
	  }

	  found_e = 1;
	  /*
	   *  Plus or minus legal following the E.
	   */
	  if ((copy[i+1] == '+') || (copy[i+1] == '-'))
	    i++;
	  break;
	case '.' :
	  /*
	   *  More than one dot not allowed,
	   *  also dot not allowed following 'e'.
	   */
	  if ((found_e) || (found_dot))
	  {
	    free(copy);
	    return FALSE;
	  }

	  found_dot = 1;
	  break;
	/*
	 *  Illegal character.
	 */
	default :
	  free(copy);
	  return FALSE;
      }
    }
  }
  free(copy);
  return TRUE;
}


/*
 *   Returns TRUE if cp_str is a blank line.
 *   (i.e. does not contain anything except space, tab, or carriage return) 
 */
int strIsEmptyLine(cp_str)
char *cp_str;
{
   int index;

   if (cp_str == NULL)
      return(TRUE);

   index = 0;
   while (cp_str[index] != '\0')
   {
      if (!isspace(cp_str[index++])) 
	 return(FALSE);
   }
   return(TRUE);
}

/*
 *    TRUE if all spaces in string.
 *    FALSE otherwise.
 */
strIsEmpty(cp_val)
char *cp_val;
{
  char *s;

  for (s = cp_val; (*s != '\0'); s++)
    if (*s != ' ')
      return(FALSE);

  return (TRUE);
}
/*
 *   The integer position is returned in 'cp_target' where there is a string
 *   that matches 'cp_match'.   0 refers to the first character in
 *   cp_target.
 *
 *   Returns NO_MATCH(-1) if no-match at all. 
 */
strLocate(cp_target, cp_match)
char *cp_target, *cp_match;
{
  int cur_target, cur_match, match_start;
  int verbose;

  if (cp_match[0] == '\0')
    return 0; /* empty match string */

  cur_match = 0;
  match_start = NO_MATCH;

  for (cur_target = 0; cp_target[cur_target] != '\0'; cur_target++)
  {
    if (cp_target[cur_target] == cp_match[cur_match])
    {
      if (match_start == NO_MATCH)
	match_start = cur_target; /* first character matched */

      if (cp_match[++cur_match] == '\0')
      {
	return match_start; /* completed match */
      }
    }
    else
    {
      cur_match = 0;
      match_start = NO_MATCH;
    }
  }
  return NO_MATCH;
}


/*
 *   Strip preceeding and proceeding spaces in the string.
 *   0 if there is no non-space character in the passed string.
 */
strStripSpaces(cp_text)
char *cp_text;
{
  char *cp_start;
  int start, end, len;

  if (cp_text == NULL)
    return NOT_OKAY;

  for (start = 0; cp_text[start] != '\0'; start++)
    if (!isspace(cp_text[start]))
      break;

  end = strlen(cp_text) - 1;

  for (; end >= 0; end--)
    if (!isspace(cp_text[end]))
      break;

  if ((cp_text[start] == '\0') || (end < 0))
    cp_text[0] = '\0';
  else
  {
    char *tmp;

    tmp = (char *) malloc(end+3);
    cp_text[end+1] = '\0';
    strcpy(tmp, cp_text+start);
    strcpy(cp_text, tmp);
    free(tmp);
  }
  return (cp_text[0] == '\0' ? NOT_OKAY : OKAY);
}

strRmReturn(cp_line)
char *cp_line;
{
  int len;

  len = strlen(cp_line);

  if (cp_line[len-1] == '\n')
    cp_line[len-1] = '\0';
}

strRmTab(cp_line)
char *cp_line;
{
  char *s;

  for (s = cp_line; *s != '\0'; s++)
    if (isspace(*s))
      *s = ' ';
}

strRmWord(cp_line, cp_word)
char *cp_line;
char *cp_word;
{
    int p, i;

    if ((p=strLocate(cp_line, cp_word)) >= 0)
      for (i = p; i < p+strlen(cp_word);i++)
	cp_line[i] = ' ';

    return(OKAY);
}
