#include <setjmp.h>
#include <stdio.h>
#include <signal.h>
#include "global.h"


char *askstr();
double getf();
double cbrt();
extern int galaxy_version;
extern int line_num;
extern int more_flag;
extern int g_print_group_tech;
extern int g_show_eff;
static jmp_buf g_env;
int traphandler();

main(ac, av)
int ac;
char **av;
{
    int i;

    printf("The Galaxy Game Machine, Version %s\n", VERSION); 

    g_show_eff = 0;

    check_version();

    test_for_ship_list();

    signal(SIGINT, traphandler);

    for (i = 1; i < ac; i++)
    {
      if (av[i][0] == '-')
      {
	switch(av[i][1])
	{
	  case 'm' : 
	    more_flag = 1; 
	    break;
	}
      }
    }
    init_planets();
    init_groups();
    init_ships();

    setjmp(g_env);

    loop();

    save_planets();
    save_ships();
    save_groups();

    exit(0);
}

traphandler()
{
  printf("\nQuit\n");
  raw_off();
  exit(1);
}

loop()
{
    char line[126];
    char *name, *s;
    int go;

    for(go = 1; go;)
    {
      printf("Cmd> ");

      if (gets(line) == NULL)
	break;

      s = line;

      if (*s == 'C')
      {
	printf("Showing effects after full cargo capacity.\n");
	s++;
	g_show_eff = 1;
      }
      else
	g_show_eff = 0;

      switch(*(s++))
      {
	case 'a' :
	  if (*s == 't')
	    test_ship(s+1);
	  else if (*s == 'l')
	    add_new_tech_level(s+1);
	  else if (*s == '\0')
	    add_new_ship(s+1);
	  break;
	case 'c' :
	  if (*s == 's')
	    calc_shield_power();
	  else if (*s == 'd')
	    calc_drive_power();
	  else if (*s == 'k')
	    calc_percent_kill();
	  else if (*s == '\0')
	    calc_ship_cost();
	  break;
	case 'd' :
	  if (*s == 'a')
	    query_all_distance();
	  else if (*s == 'i')
	    display_planets(0);
	  else if (*s == 'p')
	    display_planets(1);
	  else if (*s == '\0')
	    query_distance();
	  break;
	case 'g' :
	  g_print_group_tech = FALSE;

	  if (*s == 'g')
	    print_groups();
	  else if (*s == 'p')
	    print_pl_groups();
	  else if (*s == 's')
	    print_sorted_groups(select_race_id(s+1));
	  else if (*s == 'd')
	    print_area_groups();
	  else if (*s == 'b')
	    print_brief_groups();
	  break;
	case 'p' :
	  if (*s == 'p')
	    print_planets();
	  else if (*s == 'y')
	    print_your_planets();
	  else if (*s == 's')
	    print_ships(s+1);
	  else if (*s == '1')
	    show_path();
	  else if (*s == 'r')
	    print_routes();
	  break;
	case 'q' :
	  go = 0;
	  break;
	case 'r' :
	  if (*s == 't')
	  {
	    name = askstr("filename");
	    read_planet_data(name);
	    read_group_data(name);
	    read_ship_data(name);
	    read_route_data(name);
	  }
	  else if (*s == 'o')
	  {
	    name = askstr("filename");
	    read_send_orders(name);
	  }
	  break;
	case 's' :
	  save_planets();
	  save_ships();
	  save_groups();
	  break;
	case 'x' :
	  exit(0);
	case '?' :
	  line_num = 0;
	  printf("Begin command with the letter 'C' to show effects after full cargo.\n");
	    chk_more(1);
	  printf(" a  - add a new ship or replace an existing ship\n");
	  	chk_more(1);
	  printf(" al - add new tech level to ship group\n"); chk_more(1);
	  printf(" at - try out a test ship\n"); chk_more(1);
	  printf(" c  - calculate how many ships a planet may produce\n"); 
		chk_more(1);
	  printf(" cd - calculate drive power based on mass and ly\n");
	  	chk_more(1);
	  printf(" ck - calculate percentage to kill based on attack and shield\n");
	  	chk_more(1);
	  printf(" cs - calculate shield strength based on mass and defense power\n");
	  	chk_more(1);
	  printf(" d  - query about distance between two planets.\n");
	  	chk_more(1);
	  printf(" da - query about distance between one planet and the rest.\n");
	  	chk_more(1);
	  printf(" di - display planets.\n"); chk_more(1);
	  printf(" dp - display area around planet.\n"); chk_more(1);
	  printf(" gb - display brief list of groups.\n"); chk_more(1);
	  printf(" gd - display group within a certain distance of a planet.\n");
	  	chk_more(1);
	  printf(" gg - display groups.\n"); chk_more(1);
	  printf(" gp - display group at a planet.\n"); chk_more(1);
	  printf(" gs - display groups sorted by planet.\n"); chk_more(1);
	  printf(" pp - print planet data\n"); chk_more(1);
	  printf(" py - print your planet data only\n"); chk_more(1);
	  printf(" pr - print route data\n"); chk_more(1);
	  printf(" ps#,# - print ship design, optional # for ship category, # for tech level\n"); chk_more(1);
	  printf(" p1 - show path from planet A to B, through one intermediate planet.\n"); chk_more(1);
	  printf(" p1 - show path from planet A to B, through one intermediate planet.\n");
	  	chk_more(1);
	  printf(" q  - quit\n"); chk_more(1);
	  printf(" rt - read turn data from specified file\n"); chk_more(1);
	  printf(" ro - read orders from a specified file\n"); chk_more(1);
	  printf(" s  - save data\n"); chk_more(1);
	  printf(" x  - exit without save\n"); chk_more(1);
	  break;
	default :
	  printf("Type '?' for a list of commands.\n");
      }
    }
}

query_distance()
{
    int planet_1, planet_2;
    double dist;

    if ((planet_1 = ask_planet_name("Planet 1")) < 0)
      return;
    if ((planet_2 = ask_planet_name("Planet 2")) < 0)
      return;

    dist = planet_dist(planet_1, planet_2);

    printf("%g light years apart.\n", dist);
}
    
struct sorted {
  float dist;
  int p;
};

char *get_who_str(who)
int who;
{
  switch(who)
  {
    case WHO_ALIEN : return "(Alien)";
    case WHO_ME : return "(Me)";
    case WHO_FRIEND : return "(Friend)";
    default : return "";
  }
}

query_all_distance()
{
    int planet_1, planet_2, i, who;
    struct sorted darray[NUM_PLANETS];
    double dist;
    float res, size;
    int compares();
    char *whos, *names;

    if ((planet_1 = ask_planet_name("Planet Name")) == IS_ERR)
      return;

    line_num = 0;

    /* get all distances */
    for (planet_2 = 0; planet_2 < NUM_PLANETS; planet_2++)
    {
      if (legal_planet(planet_2))
      {
	dist = planet_dist(planet_1, planet_2);
	darray[planet_2].dist = dist;
	darray[planet_2].p = planet_2;
      }
      else
      {
	darray[planet_2].dist = 9999;
	darray[planet_2].p = -1;
      }
    }
    qsort((char *) darray, NUM_PLANETS, sizeof(struct sorted), compares);

    for (i = 0; i < NUM_PLANETS; i++)
    {
      if ((planet_2 = darray[i].p) >= 0)
      {
	if (legal_planet(planet_2))
	{
	  who = get_who(planet_2);
	  whos = get_who_str(who);
	  if ((names = get_planet_text_name(planet_2)) == 0)
	    names = "";

	  printf("Planet %3d: %6.3f light years apart. %s %s",
	    planet_2, darray[i].dist, whos, names);

	  res = get_planet_res(planet_2);
	  size = get_planet_size(planet_2);

	  if (res == 0 && size == 0)
	    printf("\n");
	  else
	  {
	    printf("  %.2f %.1f\n", res, size);
	  }
	  chk_more(1);
	}
      }
    }
}

compares(e1, e2)
struct sorted *e1, *e2;
{
  return(e1->dist >= e2->dist ? 1 : -1);
}

ask_planet_name(prompt)
char *prompt;
{
   char *str; 

   str = askstr(prompt);

   return translate_planet(str);
}

add_new_ship(start)
char *start;
{
    char line[256];
    char msg[256];
    char *name, *new_name;
    int id, attacks;
    float drive, weapons, shields, cargo;
    int race;

    if ((race = get_ship_race(start)) < 0)
      return;

    name = askstr("Ship Name");

    if ((id = get_ship_id(name, race)) == IS_ERR)
    {
      sprintf(msg, "Ship '%s' does not exist, continue? ", name);

      if (!getyes(msg))
        return;

       new_name = name;
    }
    else 
    {
      get_ship_data(id, msg);

      printf("Current: %s\n", msg);

      sprintf(msg, "Ship '%s' already exists, overwrite? ", name);

      if (!getyes(msg))
        return;

      new_name = 0;

      race = get_ship_race_value(id);
    }
    printf("New: ");
    gets(line);

    strStripSpaces(line);
    break_up(line);

    drive = element_float(line, 0);
    attacks = element_int(line, 1);
    weapons = element_float(line, 2);
    shields = element_float(line, 3);
    cargo = element_float(line, 4);

    if (new_name != 0)
      new_ship_data(name, drive, attacks, weapons, shields, cargo, race, 0);
    else
      set_ship_data(id, drive, attacks, weapons, shields, cargo, race, 0);

    sort_ships();
}

add_new_tech_level(start)
char *start;
{
    int race;
    float drive, weapon, shield, cargo;
    char line[256];

    if ((race = get_ship_race(start)) < 0)
      return;
    
    printf("New: ");
    gets(line);

    strStripSpaces(line);
    break_up(line);

    drive = element_float(line, 0);
    weapon = element_float(line, 1);
    shield = element_float(line, 2);
    cargo = element_float(line, 3);

    printf("New tech level for '%s': %5.2f, %5.2f, %5.2f, %5.2f\n", 
	get_race_name(race),
	drive, weapon, shield, cargo);

    if (getyes("Accept?"))
      new_tech_level(race, drive, weapon, shield, cargo);
}

test_ship(start)
char *start;
{
    char line[256];
    char *name;
    int attacks;
    float drive, weapons, shields, cargo;
    int who, techlev;

    who = 0;

    techlev = get_tech_level(who, start);

    printf("New: ");
    gets(line);

    break_up(line);

    drive = element_float(line, 0);
    attacks = element_int(line, 1);
    weapons = element_float(line, 2);
    shields = element_float(line, 3);
    cargo = element_float(line, 4);

    line_num = 0;	/* reset */
    set_ship_data(TEST_SLOT, drive, attacks, weapons, shields, cargo, who, techlev);
    display_ship(TEST_SLOT);
}

calc_ship_cost()
{
    char *name;
    int ship_id, pl_id;
    float mass, num;

    mass = getf("Mass");
    name = askstr("Planet Name");

    if ((pl_id = translate_planet(name)) < 0)
      return;

    num = calc_num_ships(pl_id, mass);
}

display_planets(i_flag)
int i_flag;	/* two modes of display */
{
    float x, y, width, radius;
    int id;
    int opt;
    char *filename;

    if (i_flag)
    {
      if ((id = ask_planet_name("Planet Name")) < 0)
	return;

      x = get_planet_x(id);
      y = get_planet_y(id);
      radius = getf("Radius");

      x -= radius;
      y -= radius;
      width = radius * 2;
    }
    else
    {
      x = getf("x");
      y = getf("y");
      width = getf("width");
    }
    opt = get_planet_option();

    if (getyes("To File? "))
    {
      filename = askstr("Filename");
    }
    else
    {
      filename = 0;
    }
    show_planets(x, y, width, opt, filename);
}

get_planet_option()
{
    char line[256];

    while (1)
    {
      printf("s - size, res - resource, i - id, d - dist> ");
      gets(line);

      switch(line[0])
      {
       case 's' : return OPT_PLANET_SIZE;
       case 'r' : return OPT_PLANET_RES;
       case '\0':
       case 'i' : return OPT_PLANET_ID;
       case 'd' : return OPT_PLANET_DIST;
      }
    }
}
calc_shield_power()
{
    float mass, def, sh, tech;

    mass = getf("mass");
    def = getf("defensive power");
    tech = getf("shield tech level");

    sh = (cbrt((double) mass) / 3.107 * def) / tech;

    printf("Shield power = %5.2f\n", sh);
}

calc_drive_power()
{
    float mass, ly, drive, tech;

    mass = getf("mass");
    ly = getf("ly");
    tech = getf("drive tech level");

    drive = ((ly * mass) / 20.0) / tech;

    printf("Drive power = %5.2f\n", drive);
}

go_home()
{
  longjmp(g_env, 1); /** GOTO setjmp() call in main() above **/
}

show_path()
{
    int start, end;
    float ly;

    if ((start = ask_planet_name("Start Planet")) < 0)
      return;

    if ((end = ask_planet_name("End Planet")) < 0)
      return;

    ly = getf("Max # of light years per jump");

    planet_path_1(start, end, ly);
}


print_pl_groups()
{
    int planet;

    if ((planet = ask_planet_name("Planet")) < 0)
      return;

    g_print_group_tech = getyes("Print tech levels? ");

    line_num = 0;

    write_single_planet(stdout, planet);
    print_pl_routes(planet);
    write_pl_groups(planet);
}

print_area_groups()
{
    float x, y, width, radius;
    int id;

    if ((id = ask_planet_name("Planet Name")) < 0)
      return;

    x = get_planet_x(id);
    y = get_planet_y(id);
    radius = getf("Radius");

    print_groups_brief(RACE_ALL, x, y, radius);
}

/* compute percentage of kill based on basic attack and shield values */
calc_percent_kill()
{
    float attack, shield;
    float tech_attack, tech_shield;
    float mass, defense, ratio;
    float percent;
    double cbrt();

    if (getyes("Enter defensive power? "))
    {
      defense = getf("Defensive Power");
    }
    else
    {
      mass = getf("Mass Of Ship Defending");
      shield = getf("Shield Strength");
      tech_shield = getf("Shield Tech Level");

      defense = (shield*tech_shield) / cbrt((double) mass) * 3.107; 
    }
    attack = getf("Attack Strength");
    tech_attack = getf("Attack Tech Level");

    attack *= tech_attack;

    ratio = attack / defense;

    printf("Attack Power %f, Defensive Power %f, Ratio %f\n",
	attack, defense, ratio);

    if (ratio == 1)
    {
      percent = 50.0;
    }
    else if (attack > defense)
    {
      percent = ((50.0/3.0) * (ratio-1)) + 50.0;
      if (percent > 100)
	percent = 100;
    }
    else /* defense > attack */
    {
      /* do 100 - (percent to miss) */
      ratio = defense / attack;
      percent = 100 - (((50.0/3.0) * (ratio-1)) + 50.0);
      if (percent < 0)
	percent = 0;
    }
    printf("Percent to kill is %.2f%%\n", percent);
}

check_version()
{
  FILE *fp;

  if ((fp = fopen("save.version", "r")) == NULL)
    return(galaxy_version = 2);
  
  fclose(fp);

  printf("Running for Galaxy Game Version 3.0\n");

  return(galaxy_version = 3);
}
