/*
 * File: screen.h
 * Author: Douglas Selph
 * Maintained by: Robin Powell
 * $Id: screen.h,v 1.2 1997/10/30 19:16:37 rlpowell Exp $
 * Purpose:
 *
 *   Defines that the screen module uses.
 */
#ifndef SCREEN_
#define SCREEN_

/* Window numbers */
#define MAP_NUM 0
#define FILE_NUM 1

/* Column number defs */
#define ALL_FILE 0
#define HALF_FILE 1
#define NO_FILE 2

#define NUM_MAIN_ROWS 60
#define NUM_MAIN_COLS 60
#define REAL_NUM_COLS (ScreenIsDouble() ? 30 : 60)
#define MAPWIN MapWin()
#define FILEWIN FileWin()
#define DATAWIN_HEIGHT ScreenDataWinHeight()
#define MAPWIN_WIDTH MapWinWidth()
#define FILEWIN_WIDTH FileWinWidth()

#define PR_NO_OPTIONS  0
#define PR_START_ROW   1
/*
 * The callback below will be called as so:
 *    (*callback)(i_chr, arg)
 */
typedef struct item_description {
    int id;				/* id to indetify this item */
    int top;				/* pulldown menu identifier */
    char *name;				/* name of item */
    char *accl;				/* multi-letter keycode accelerator */
    int (*callback)();			/* callback to call when executed */
    pointer arg;			/* passed argument to call */
    Boolean is_pulldown;		/* top level name for pulldown */
} itemData, *itemList;

#define GM_UNDEFINED   0
#define GM_STRING   1
#define GM_INTEGER  2
#define GM_FLOAT    3
#define GM_DOUBLE   4
#define GM_LOGICAL  5
#define GM_LABEL    6

typedef struct getmany_pass
{
    int type;		/* GM_STRING, GM_INTEGER... */
    char *prompt;
    union values {
      char *sval;
      double dval;
      float fval;
      int ival;
      Boolean lval;
    } u;
} PromptObj;

char ScreenChrTranslate();
char *FileGetFilename();
long PlanetWorldXToLoc();
long PlanetWorldYToLoc();
float PlanetLocToWorldX();
float PlanetLocToWorldY();
WINDOW *MapWin();
WINDOW *FileWin();
WINDOW *SubWin();

#endif
