/*
 * File: fileshow.h
 * Author: Douglas Selph
 * Maintained by: Robin Powell
 * $Id: fileshow.h,v 1.1 1997/10/30 19:16:37 rlpowell Exp $
 * Purpose:
 */
#ifndef _FILESHOW_
#define _FILESHOW_

struct file_show_data
{
    int cur;

    struct previous_files {
      char *name;	/* file to read in */
      char *title;	/* title to place at the top of the window */
      int id;		/* extra id identifying this file */
      struct line_buf {
	char *buf;	/* actual line */
	char *comment;	/* comment portion of line (holds simulator data) */
	int length;	/* allocated space for line */
      } *lines;		/* array of saved lines */
      int numlines_alloced;
      int numlines_seen;
      int numlines_infile;
      int maxcol;
      long endpos;	/* lseek position of point just after what we can see */
      Position cursor, min, max, offset;
    } f[MAX_TMPS];
};

#ifdef DEF
struct file_show_data gFile;
#else
extern struct file_show_data gFile;
#endif 

#define CUR_FILE gFile.f[gFile.cur]

#endif 
