static char *rcsid = "$Header: /navy/homes/zeus/SRC/RCS/loadgame.c,v 2.42 1994/05/17 13:43:15 bampton Exp bampton $";

/*
 * $Log: loadgame.c,v $
 * Revision 2.42  1994/05/17  13:43:15  bampton
 * *** empty log message ***
 *
 * Revision 2.41  1994/04/08  03:11:28  bampton
 * *** empty log message ***
 *
 * Revision 2.40  1994/03/09  20:22:55  bampton
 * *** empty log message ***
 *
 * Revision 2.38  1993/09/27  17:15:54  bampton
 * *** empty log message ***
 *
 *
 */

#define NOTIMEB
#include "common.h"
#include "prot.h"
#include "protos/i-o.h"
#include "protos/misc.h"

void loadgame_rcsid (void);
player *players;
planet *planets;
sorted *sorted_planets;
shiptype *shiptypes;
battle *battles;
bombing *bombings;
double galaxysize;
char buf[256], buf2[256];
int file;
int turn;
int turn_run = 0;
int randseed;
planetdefense *defender;
tmppname *tmpname;
#ifdef UPGRADE
fleetname *fleets;
#endif
#ifdef GAMENAME
extern char gamename[MAXTEXT];
#endif

void
loadgame_rcsid (void)
{
  printf ("%s\n", rcsid);
}

int
listlen (void *base)
{
  list *p;
  int i = 0;

  for (p = base; p; p = p->next, i++);
  return i;
}

void
Read (void *p, int n)
{
  int r;

  if ((r = read (file, p, n)) != n)
  {
    printf ("Can't read %d bytes from file, returncode = %d.\n", n, r);
    exit (1);
  }
}

void
readlist (void *base, int size)
{
  int n;
  list **p = base;

  Read (&n, sizeof (n));
/*  printf ("Reading %d elements size %d\n",n,size);*/
  while (--n >= 0)
  {
    *p = alloc (size);
    Read (*p + 1, size - (int) sizeof (list *));
    p = (list **) (*p);
  }
  *p = 0;
}

int
readint (void)
{
  int i;

  Read (&i, sizeof (i));
  return i;
}

void
loadgame (void)
{
  int i;
  planet *p;
  player *P;
  group *g;
  shiptype *T;
  alliance *a;
  defensive *d;                 /* def mod */
  battle *B;
  shot *S;
  viewer *V;
  participant *PA;
  bombing *b;
#ifdef UPGRADE
  fleetname *f;
#endif
#ifdef CARRYOVER
  techinfo *t;

#endif

#ifdef KCMD
  planetdefense *df;

#endif

#ifndef PREPROC
  printf ("Reading game from file blindrc...");
#endif
#ifdef GAMENAME
  Read (&gamename,sizeof(gamename));
#endif

  Read (&galaxysize, sizeof (galaxysize));
  Read (&turn, sizeof (turn));
  Read (&randseed, sizeof (randseed));
  srandom (randseed);
  readlist (&planets, sizeof (planet));
#ifdef SIZEBUG
  readlist (&shiptypes, sizeof (shiptype)+sizeof(int));
#else
  readlist (&shiptypes, sizeof (shiptype));
#endif
  readlist (&players, sizeof (player));
  readlist (&sorted_planets, sizeof (sorted));  /* sorted reporting list */
  sortplanets ();               /* re-sort, just to be safe */

#ifdef KCMD
  {
    int n, ndf;

    n = readint ();
    for (ndf = 0; ndf < n; ndf++)
    {
      df = (planetdefense *) alloc (sizeof (planetdefense));
      df->dipstat = readint ();
      df->defender = numtop (players, readint ());
      df->planet = numtop (planets, readint ());
      addlist (&defender, df);
    }
  }
#else

  readlist (&defender, sizeof (planetdefense));

#endif

  for (P = players; P; P = P->next)
  {
    readlist (&P->allies, sizeof (alliance));
    /* def mod */
    readlist (&P->defend, sizeof (defensive));
    readlist (&P->groups, sizeof (group));

#ifdef V3
    P->x = readint ();
    P->y = readint ();
    P->size = readint ();
#endif
  }
  for (p = planets; p; p = p->next)
  {
    p->owner = numtop (players, readint ());
    p->producingshiptype = numtop (shiptypes, readint ());
    for (i = 0; i < MAXCARGO; i++)
      p->routes[i] = numtop (planets, readint ());
  }
  for (T = shiptypes; T; T = T->next)
  {
    T->owner = numtop (players, readint ());
    assert (T->owner);
  }
  for (P = players; P; P = P->next)
  {
    for (a = P->allies; a; a = a->next)
    {
      a->ally = numtop (players, readint ());
      assert (a->ally);
    }
    /* def mod */
    for (d = P->defend; d; d = d->next)
    {
      d->defend = numtop (players, readint ());
      assert (d->defend);
    }
    for (g = P->groups; g; g = g->next)
    {
      g->type = numtop (shiptypes, readint ());
      assert (g->type);
      g->from = numtop (planets, readint ());
      assert (g->from);
      g->where = numtop (planets, readint ());
      assert (g->where);
    }
  }
  readlist (&battles, sizeof (battle));
  for (B = battles; B; B = B->next)
  {
    readlist (&B->shots, sizeof (shot));
    for (S = B->shots; S; S = S->next)
    {
      S->attacker = numtop (shiptypes, readint ());
      assert (S->attacker);
      S->target = numtop (shiptypes, readint ());
      assert (S->target);
    }
    readlist (&B->viewers, sizeof (viewer));
    for (V = B->viewers; V; V = V->next)
    {
      V->who = numtop (players, readint ());
      assert (V->who);
    }
    readlist (&B->participants, sizeof (participant));
    for (PA = B->participants; PA; PA = PA->next)
    {
      PA->who = numtop (players, readint ());
      assert (PA->who);
      readlist (&PA->groups, sizeof (group));
      for (g = PA->groups; g; g = g->next)
      {
        g->type = numtop (shiptypes, readint ());
        assert (g->type);
        g->from = numtop (planets, readint ());
        assert (g->from);
        g->where = numtop (planets, readint ());
        assert (g->where);
      }
    }
    B->where = numtop (planets, readint ());
    assert (B->where);
  }
  readlist (&bombings, sizeof (bombing));
  for (b = bombings; b; b = b->next)
  {
    readlist (&b->viewers, sizeof (viewer));
    for (V = b->viewers; V; V = V->next)
    {
      V->who = numtop (players, readint ());
      assert (V->who);
    }
    b->who = numtop (players, readint ());
    assert (b->who);
    b->where = numtop (planets, readint ());
    assert (b->where);

#ifndef BOMBBUG
    /*printf ("Battle at %s\n",b->where->num);*/
    b->whoose = numtop (players, readint ());
    assert (b->whoose);
#endif
  }

#ifdef CARRYOVER
  for (P = players; P; P = P->next)
  {
    readlist (&P->othertechs, sizeof (techinfo));
  }
  for (P = players; P; P = P->next)
  {
    for (t = P->othertechs; t; t = t->next)
      t->whoose = numtop (players, readint ());
  }
#endif
#ifdef NONAMEBUG
  readlist(&tmpname,sizeof(tmppname));
#else
  tmpname=alloc(sizeof(tmppname));
#endif
#ifdef UPGRADE
  readlist(&fleets,sizeof(fleetname));
  for (f=fleets;f;f=f->next)
  {
    f->owner=numtop (players, readint ());
  }
  /* This is here, becuase I goofed when I wrote the bloody savegame
     stuff the first time around */
  if (fleets)
 for (P = players; P; P = P->next)
 {
    for (g=P->groups;g;g=g->next)
      g->fleet=numtofleet(readint());
 }
 else /* Sanity check, more than anything... */
 for (P = players; P; P = P->next)
 {
    for (g=P->groups;g;g=g->next)
      g->fleet=NULL;
 }

#endif
}
