static char    *rcsid = "$Header: /navy/homes/zeus/SRC/RCS/edit.c,v 2.41 1994/04/08 03:11:28 bampton Exp bampton $";

/*
 * $Log: edit.c,v $
 * Revision 2.41  1994/04/08  03:11:28  bampton
 * *** empty log message ***
 *
 * Revision 2.38  1993/09/27  17:15:54  bampton
 * *** empty log message ***
 *
 * Revision 2.38  1993/09/27  17:15:54  bampton
 * *** empty log message ***
 *
 * Revision 2.37  1993/09/07  20:50:32  bampton
 * *** empty log message ***
 *
 * Revision 2.33  1993/08/03  23:10:13  bampton
 * Revision 2.30  1993/07/14  14:59:26  bampton
 * Full RCS version
 * Revision 0.0  1993/07/14  13:41:58  bampton RCS prototype.
 * 
 * 
 */

#include "common.h"
#include "prot.h"
#include "protos/g-report.h"

extern char     buf[256], buf2[256];
extern player  *players;
extern planet  *planets;
extern char     prname[MAXTEXT];
extern FILE    *pr;
extern int      file;
extern int      turn;



void
err (char *a)
{
  printf ("ERROR: %s", a);
}

void
chk_planet (planet * p)
{
  if (p->size < p->ind)
  {
    p->ind = p->size;
    err ("Industry bigger than size of planet!");
  }
  if (p->pop < p->ind)
  {
    p->ind = p->size;
    err ("Industry bigger than population of planet!");
  }
  if (p->size < p->pop)
  {
    p->ind = p->size;
    err ("Population bigger than size of planet!");
  }
  /*
   * others: compare R to max, cap/ind
   */
  return;
}

void
edit_planet (planet * p)
{

  for (;;)
  {
    /* inputpr(); */
    pr = stdout;
    fbegin ("System", "xxffffffxfff");
    fhead ("N#XYSPIRPC$M");
    printplanet (p, p->owner);
    fend ();

    printf ("Planet %s %s> ", p->name, p->num);
    getstr ();
    switch (buf[0])
    {
    case 'q', 'Q':
      return;
    case 'x':
      break;

    case 'n':
      break;
    case 'z':
      break;
    case 'r':
      break;
    case 'p':
      break;
    case 'i':
      p->ind = inputcomponent ("Industry ? ");
      chk_planet (p);
      break;
    case 'P':
      break;
    case 'c':
      break;
    case 'C':
      break;
    case 'm':
      p->mat = inputcomponent ("Materials ? ");
      chk_planet (p);
      break;
    case 's':
      break;
    case 'R':
      break;
    default:
      printf ("Q - quit editing planet\n");
      printf ("X - erase changes (not done)\n");
      printf ("i - change industry\n");
    }
  }
}

int
main ()
{
  planet         *p;
  player         *P = 0;
  shiptype       *T = 0;

  printf ("Galaxy v2.9 by Russell Wallace  " __DATE__ "\n");
  printf ("Blind v2.1 EDITOR\n");
  file = open ("blindrc", O_RDWR | O_BINARY);
  if (file >= 0)
  {
    loadgame ();
    close (file);
    printf ("Game data editor\n");
    printf ("Turn %d\n", turn);
  }
  else
  {
    printf ("could not open data file!!\n");
    exit (1);
  }

  pr = stdout;

  for (;;)
  {
    printf ("edit> ");
    getstr ();
    switch (tolower (buf[0]))
    {
    case 'x':                   /* exit, no changes */
      return 0;
    case 'q':
      file = open ("blindrc", O_CREAT | O_TRUNC | O_RDWR | O_BINARY, 0600);
      if (file < 0)
      {
        printf ("Can't create file blindrc.\n");
        return 1;
      }
      savegame ();
      return 0;

    case 'p':                   /* select player */
      P = inputplayer (players, "Player? ");
      break;

    case 't':                   /* select ship type */
      if (!P)
        printf ("Select player first, with 'p'.\n");
      else
        T = inputshiptype (P);
      break;

    case 'm':                   /* modify this design */
      if (!T)
      {
        printf ("Select%s shiptype first.\n", P ? "" : " player and");
        break;
      }
      else
      {
        T->drive = inputcomponent ("Drive? ");
        printf ("Attacks? ");
        T->nguns = geti ();
        T->guns = inputcomponent ("Weapons? ");
        if (!T->nguns)
          T->guns = 0;
        if (!T->guns)
          T->nguns = 0;
        T->shields = inputcomponent ("Shields? ");
        T->cargo = inputcomponent ("Cargo? ");
      }
      /* fall through ... */
    case 'v':                   /* view this design */
      if (!T)
        printf ("Select%s shiptype first.\n", P ? "" : " player and");
      else
      {
        fbegin ("", "xfifffff");
        fhead ("NDAWSC  ");
        printshiptype (T);
        fend ();
      }
      break;

    case 'l':
      p = inputplanet (planets, "System?");
      if (p)
        edit_planet (p);
      break;

    default:
      printf (
              "P = select Player\n"
              "T = select ship Type\n"
              "V = View selected design\n"
              "M = Modify selected design\n"
              "L = Edit a planet\n"
              "Q = Quit\n"
              "X = Exit without saving\n"
        );
    }
  }
}
