static char    *rcsid = "$Header: /navy/homes/zeus/SRC/RCS/addplayer.c,v 2.42 1994/05/17 13:43:15 bampton Exp bampton $";

/*
 * $Log: addplayer.c,v $
 * Revision 2.42  1994/05/17  13:43:15  bampton
 * *** empty log message ***
 *
 * Revision 2.41  1994/04/08  03:11:28  bampton
 * *** empty log message ***
 *
 * Revision 2.40  1994/03/09  20:22:55  bampton
 * Revision 2.39  1993/10/28  22:31:20  bampton
 * Revision 2.37  1993/09/07  20:50:32  bampton
 * Revision 2.33  1993/08/03  23:10:13  bampton
 * Revision 2.30  1993/07/14  14:59:26  bampton
 * Revision 0.0  1993/07/14  13:41:40  bampton RCS
 * 
 */

#ifdef NEWGAME
#include "common.h"
#include "prot.h"

void addplayer_rcsid (void);
void swap_planet (planet * p);

extern player  *players;
extern battle  *battles;
extern double   galaxysize;
extern planet  *planets;
extern char     buf[256];
extern int      turn;
extern int      randseed;

void
addplayer_rcsid (void)
{
  printf ("%s\n",rcsid);
}

planet         *
place_planet ()
{
  int             i;
  double          x1, y1, x2 = 0, y2 = 0;
  planet         *p;

  do
  {
    i = 0;
    x1 = frand (galaxysize);
    y1 = frand (galaxysize);
    for (p = planets; p && !i; p = p->next)
      /* Keep homeworlds separated by MINSEP LY */
      if (p->owner)
      {
        x2 = min (fabs (x1 - p->x), galaxysize - fabs (x1 - p->x));
        y2 = min (fabs (y1 - p->y), galaxysize - fabs (y1 - p->y));

        if (x2 * x2 + y2 * y2 <= MINSEP * MINSEP)
        {
          i = 1;
        }
      }
      else
      /* Keep homeworlds away from huge planets too */
      if (p->size> MAXPOP)
      {
        x2 = min (fabs (x1 - p->x), galaxysize - fabs (x1 - p->x));
        y2 = min (fabs (y1 - p->y), galaxysize - fabs (y1 - p->y));

        if (x2 * x2 + y2 * y2 <= (MINSEP * MINSEP)/9.0)
        {
          i = 1;
          printf ("Too close %f - %f\n",
             sqrt(x2 * x2 + y2 * y2), MINSEP/3.0);
        }
     }
  }
  while (i);
  p = addplanet ();
  p->x = x1;
  p->y = y1;
  return (p);
}

void
swap_planet (planet * p)
{                               /* do the switcheroo of this planet & another */
  int             oldnum;
  planet         *p2, *p3;
  int             i;
  char            oldnums[MAXTEXT];

  for (p2 = planets, i = 0; p2; p2 = p2->next, i++);
  do
  {
    oldnum = rnd (i);
    sprintf (oldnums, "%d", oldnum);
  }
  /* BUG: need to change this to something besides 80 */
  while (!(strcmp (oldnums, p->num)) || (oldnum < 99) || (i-oldnum<50));

  /* Find planet before the one to swap */
  for (p2 = planets; p2; p2 = p2->next)
    if (!strcmp (p2->next->num, oldnums))
      break;

  /* Find planet before the last one */
  for (p3 = planets; p3; p3 = p3->next)
    if (p3->next == p)
      break;

  /* Swap p & p' where p' is oldnum */
  strcpy (p2->next->num, p->num);
  strcpy (p->num, oldnums);
  strcpy (p2->next->name, p->name);
  strcpy (p->name, oldnums);
  p->next = p2->next->next;
  p3->next = p2->next;
  p2->next = p;
  p3->next->next = NULL;
}


void
addplayer (void)
{
  planet         *p;
  player         *P;
  char            buf2[256];

  if (turn)
    printf ("Warning!!! Game in progress! Turn %d", turn);
  printf ("Player name? ");
  getstr ();
  if (!buf[0])
    return;
  if (nametop (players, buf))
  {
    printf ("Player name %s is already in use.\n", buf);
    return;
  }
  strcpy (buf2, buf);           /* don't overwrite the player name */

#ifndef RANDPLACE
  p = inputplanet (planets, "System?");
  if (p->owner)
  {                             /* Safety feature, HJB */
    printf ("Planet %s is already owned.\n", p->name);
    return;
  }
#endif

  P = alloc (sizeof (player));  /* actually add player */
  memset (P, 0, sizeof (*P));
  addlist (&players, P);
  strcpy (P->name, buf2);

#ifdef RANDPLACE
  p = place_planet ();
  swap_planet (p);
#else
  /* Manual placement .... */
  printf ("New X-coord? ");
  p->x = getf ();
  printf ("New Y-coord? ");
  p->y = getf ();
#endif

  p->owner = P;
  p->size = MAXPOP;
  p->resources = 10.0;
  p->pop = MAXPOP;
  p->ind = MAXPOP;
  p->cap = p->mat = p->col = 0.0;
  p->spent = p->inprogress = 0.0;
  P->homex = p->x;
  P->homey = p->y;              /* GE */
  P->tech.drive = 1.0;
  P->tech.guns = 1.0;
  P->tech.shields = 1.0;
  P->tech.cargo = 1.0;
  P->opts1 = MAP | FULL | PROD | BATTLESUM | FULLTYPE;
  P->opts2 = SHOWOPT | SORTPLANETS;
  P->opts3 = P->lastorders = 0;

#ifdef V3
  P->x = 0;
  P->y = 0;
  P->size = galaxysize;
#endif

#ifdef CARRYOVER
  P->othertechs = alloc (sizeof (techinfo));
  P->othertechs->next = NULL;
  P->othertechs->whoose = NULL;
#endif

  sortplanets ();
}

#endif
