#!/usr/bin/awk -f

BEGIN { inheader=1; }
# check for end of header
/^ *$/ {
    inheader=0;
}

inheader == 1 && $1 == "Subject:" {
    print "Recieved: " $0;
  }

inheader == 1 && $1 == "From:" {
    printf ("Sent by %s %s %s %s %s %s %s %s\n",$2,$3,$4,$5,$6,$7,$8,$9);
  }

inheader == 1 && $1 == "Date:" {
    print $0;
  }
inheader == 0 && /^~/ { print " "$0;}
inheader == 0 && !/^~/ {
    print $0;
  }
END {
    if (reply_to != "")
        reply_address = reply_to;
    else
        reply_address = from;
    print reply_address;
}
