static char *rcsid = "$Header: /plaid/homes/zeus/Blind-2.47/util/RCS/blindrc-to-ascii.c,v 2.46 1997/04/18 12:29:49 zeus Exp $";
/* 
 * $Log: blindrc-to-ascii.c,v $
 * Revision 2.46  1997/04/18 12:29:49  zeus
 * *** empty log message ***
 *
 * Revision 2.45  1997/01/01  00:49:33  zeus
 *
*/

/* See Next comment for older comments.

  This code, when linked with loadgame.c and misc.c should enable one
to produce an ascii version of the blindrc file, which can then be
re-read by its ascii to blindrc converter on different machine, in
order to trasnlate blindrc files.

  Why use this program? For OS's and hardware that use different byte
ordering, or different pointer sizes, blindrc files are not
compatible.

  Note: Doing this with any freqnecy is NOT recommended. Due to
various factors, minor changes in floating point values (planet sizes,
resources, tech levels, etc.) will occur. Players will NOT be too
happy about this.

  Check the documentation for futher details

  Howard Bampton September 1995

*/
/*   Galaxy data file binary to ASCII conversion program
   by Russell Wallace 5 February 1992
   Run the program without any arguments; it will read "blindrc" and write the
   ASCII version to standard output, which should be redirected to a file.
   ASCII version should be slightly smaller than the binary version, however
   some lines may be longer than 80 characters so uuencoding may be required.
   Exact format may depend on version of printf() used; in particular, the
   printf() routine on my C compiler gives exactly 6 decimal places for
   floating-point quantities (implying that any accuracy beyond that will be
   lost in translation), but others may differ.
   ASCII version may be edited, the format is reasonably flexible but it is
   important to ensure that no spaces are introduced anywhere, including at
   the end of lines, and that spaces in strings are not converted to tabs.
   Also, if there are any " symbols in player, ship type or planet names
   within the game, the conversion back to binary will not work - edit by
   hand if necessary - and no number must begin with a decimal point, i.e.
   .435 is no good, it must be written as 0.435.
   Examine galaxy.c or this file for field details if you wish to edit the
   ASCII version, also note that lists of e.g. groups for a player come
   directly after the player record, and that each list is terminated by a
   single . on a line on its own.
   Written in ANSI C, should work on any machine.
   This code is in the public domain.
 */

#define NOTIMEB

#include "protos/common.h"
#include "protos/prototypes.h"
#include "protos/b2a.h"


extern player *players;
extern planet *planets;
extern shiptype *shiptypes;
extern battle *battles;
extern bombing *bombings;
extern double galaxysize;
extern int turn;
extern int randseed;
extern planetdefense *defender;
extern fleetname *fleets;
int nplanets;
#ifdef GAMENAME
char gamename[MAXTEXT];
#endif

void 
pi (int i)
{
  printf ("%d,", i);
}

void 
pf (double f)
{
  printf ("%f,", f);
}

void 
ps (char *s)
{
  printf ("\"%s\",", s);
}

void 
pp (void *base, void *p)
{
  pi (ptonum (base, p));
}

void 
nl (void)
{
  printf ("\n");
}

void 
el (void)
{
  printf (".\n");
}

void 
ptech (Tech t)
{
  pf (t.drive);
  pf (t.guns);
  pf (t.shields);
  pf (t.cargo);
}

void 
palliancelist (alliance * a)
{
  for (; a; a = a->next)
  {
    pp (players, a->ally);
    nl ();
  }
  el ();
}
void 
pguardlist (defensive * a)
{
  for (; a; a = a->next)
  {
    pp (players, a->defend);
    nl ();
  }
  el ();
}

void 
pgrouplist (group * g)
{
  for (; g; g = g->next)
  {
    pp (shiptypes, g->type);
    ptech (g->tech);
    pi (g->loadtype);
    pf (g->load);
    pp (planets, g->from);
    pp (planets, g->where);
    pf (g->dist);
    pi (g->ships);
    pi (g->left);
    pp (fleets,g->fleet);
    nl ();
  }
  el ();
}

#ifdef KCMD
void
pkcmd (void)
{
  planetdefense * pd;

  for (pd=defender;pd;pd=pd->next)
  {
    pi(pd->dipstat);
    pp (players,pd->defender);
    pp (planets,pd->planet);
    nl();
  }
  el();
}
#endif

void
pcarry (player *p)
{
  techinfo *t;

  pp(players,NULL);
  ptech (p->othertechs->tech);
  nl();
  if (p->othertechs->next)
    for (t=p->othertechs->next;t;t=t->next)
    {
      if (t->whoose) /* Clean up garbage in blindrc here */
      { 
        pp(players,t->whoose);
        ptech (t->tech);
        nl();
      }
    }
  el();
}


void 
pshotlist (shot * S)
{
  for (; S; S = S->next)
  {
    pp (shiptypes, S->attacker);
    pp (shiptypes, S->target);
    pi (S->kill);
    nl ();
  }
  el ();
}

void 
pviewerlist (viewer * V)
{
  for (; V; V = V->next)
  {
    pp (players, V->who);
    nl ();
  }
  el ();
}

void 
pparticipantlist (participant * PA)
{
  for (; PA; PA = PA->next)
  {
    pp (players, PA->who);
    nl ();
    pgrouplist (PA->groups);
  }
  el ();
}

void 
outputgame (void)
{
  int i;
  planet *p;
  player *P;
  shiptype *T;
  battle *B;
  bombing *b;
  fleetname *f;

#ifdef GAMENAME
  ps (gamename);
#endif
  pf (galaxysize);
  nl ();

  pi (turn);
  nl ();

  pi (randseed);
  nl ();

  fprintf (stderr,"Planets...");
  for (p = planets; p; p = p->next)
  {
    ps (p->name);
    ps (p->num);
    pp (players, p->owner);
    pf (p->x);
    pf (p->y);
    pf (p->size);
    pf (p->resources);
    pf (p->pop);
    pf (p->ind);
    pi (p->producing);
    pp (shiptypes, p->producingshiptype);
    pf (p->col);
    pf (p->cap);
    pf (p->mat);
    pf (p->inprogress);
    pf (p->spent);
    for (i = 0; i != MAXCARGO; i++)
      pp (planets, p->routes[i]);
    pf (p->drive);
    pf (p->guns);
    pf (p->shields);
    pf (p->cargo);
    nl ();
  }
  el ();

  fprintf (stderr,"Shiptypes...");
  for (T = shiptypes; T; T = T->next)
  {
    ps (T->name);
    pp (players, T->owner);
    pf (T->drive);
    pi (T->nguns);
    pf (T->guns);
    pf (T->shields);
    pf (T->cargo);
    pi (T->flag);
    pi (T->numbuilt);
    nl ();
  }
  el ();

  fprintf (stderr,"Players...");
  for (P = players; P; P = P->next)
  {
    ps (P->name);
    ptech (P->tech);
    pi (P->opts1);
    pi (P->opts2);
    pi (P->opts3);
    pi (P->lastorders);
    pf (P->homex);
    pf (P->homey);
    pi (P->x);
    pi (P->y);
    pi (P->size);
    nl ();
    palliancelist (P->allies);
    pguardlist (P->defend);
    pgrouplist (P->groups);
    pcarry(P);
  }
  el ();

#ifdef KCMD
  fprintf (stderr,"K cmds...");
printf ("KCMD\n");
  pkcmd();
#endif

  fprintf (stderr,"Battles...");
  for (B = battles; B; B = B->next)
  {
    pp (planets, B->where);
    nl ();
    pshotlist (B->shots);
    pviewerlist (B->viewers);
    pparticipantlist (B->participants);
  }
  el ();

  fprintf (stderr,"Bombings...");
  for (b = bombings; b; b = b->next)
  {
    pp (planets, b->where);
    pp (players, b->who);
    pp (players, b->whoose);
    pf (b->pop);
    pf (b->ind);
    pf (b->col);
    pf (b->cap);
    pf (b->mat);
    nl ();
    pviewerlist (b->viewers);
  }
  el ();
  fprintf (stderr,"Fleets\n");
  for (f=fleets;f;f=f->next)
  {
    ps(f->name);
    pf(f->fleetspeed);
    pp(players,f->owner);
    nl();
  }
  el();
}

int
main (int argc)
{
  fprintf (stderr, "Galaxy data file binary to ASCII conversion program\n"
           "by Russell Wallace\n"
           "Blind Galaxy Mods: Glenn Ellingson & Howard Bampton\n");
  if (opengame ()< 0)
  {
    fprintf (stderr, "Can't open file blindrc.\n");
    return 1;
  }
  fprintf (stderr,"Loading...");
  loadgame ();
  outputgame ();
  fprintf (stderr,"Done\n");
  return 0;
}
