#!/usr/local/gnu/gawk -f
#
#!/usr/bin/nawk -f
# Galaxy.awk
#
# If your system has gawk, use it, if you've got nawk it should work
# after you delete the first two lines. On systems without either of them,
# awk may work (sun's doesn't, but they have nawk).

# Script to pre-process E-mail orders for use with Galaxy
# Strips away headers, inserts newlines everywhere, and generally mangles code
# John Pietrzak
# 7/7/92
#
# Arg # checking, and "P" checking for valid research types added
# Howard Bampton, 7/29/92
# V3.1 partial compatibilty, 10/21/92
# V3.x compatibility finished (?)

# On BSD Unix's, can be invoked as "<scriptname> <mailfile> > tempfile
# If entire file parse fine, will exit with status == 0, else 1

BEGIN {
        header_flag = 1;
        exit_flag = 0;
        from_flag = 0;
        IGNORECASE=1;
      }

END   {
        if (from_flag == 1) {
          printf ("ERROR: no orders seen in message body,line %d: %s\n", NR,$0)\
            | "cat 1>&2";
          exit_flag = 100;
        }
        print "q";
        if (header_flag == 0) { # No "Q" line in final message
          printf ("ERROR:orders not terminated in message\n", NR,$0)|"cat 1>&2";
          printf ("ERROR:Missing `#end'?\n", NR,$0)|"cat 1>&2";
          exit 102;
        }
        else
          exit exit_flag;
      }

#
# process commands
#

# Ignore blank lines, and read the next one.
/^$/ {next}
# Ignore comment, and read the next one.
($1 == "#") { }
#($1 == ";") { }
# Strip out comments on same line as orders
/;/ { if (header_flag == 0) { $0= substr($0,1,index($0,";")-1); }}

header_flag == 0 && ($1 == "a" || $1 =="A") {
        if (NF != 2) {
          printf ("ERROR:%s\n",$0) | "cat 1>&2";
          printf ("ERROR:Usage:A <racename>\n") | "cat 1>&2";
          exit_flag = 1
        }
        else {
          print "a";
          print $2;
        }}
header_flag == 0 && ($1 == "b" || $1 =="B" || $1 == "break" || $1 =="Break") {
        if (NF != 3) {
          printf ("ERROR:%s\n",$0) | "cat 1>&2";
          printf ("ERROR:Usage:B <groupnum>\n") | "cat 1>&2";
          exit_flag = 1;
        }
        else {
          print "b";
          print $2;
          print $3;
        }}
header_flag == 0 && ($1 == "c" || $1 =="C") {
        if (NF != 2) {
          printf ("ERROR:%s\n",$0) | "cat 1>&2";
          printf ("ERROR:Usage:C <newracename>\n") | "cat 1>&2";
          exit_flag = 1;
        }
        else {
          print "c";
          print $2;
        }}
header_flag == 0 && ($1 == "d" || $1 =="D") {
        if ((NF != 7) && (NF !=3)) {
          printf ("ERROR:%s\n",$0) | "cat 1>&2";
          printf ("ERROR:Usage:D <name> <drive> <attacks> <weapons> <shields> <cargo>\n") | "cat 1>&2";
          exit_flag = 1
        }
        else {
          print "d";
          print $2;
          print $3;
          print $4;
          print $5;
          print $6;
          print $7;
        }}
header_flag == 0 && ($1 == "e" || $1 =="E" || $1 == "erase" || $1 =="Erase") {
        if (NF != 2 && NF != 3) {
          printf ("ERROR:%s\n",$0) | "cat 1>&2";
          printf ("ERROR:Usage:E <shiptype>\n") | "cat 1>&2";
          printf ("ERROR:Usage:E FLEET <fleetname>\n") | "cat 1>&2";
          exit_flag = 1
        }
        else {
          print "e";
          print $2;
        }}
header_flag == 0 && ($1 == "h" || $1 =="H" ) {
        if (NF != 2) {
          printf ("ERROR:%s\n",$0) | "cat 1>&2";
          printf ("ERROR:Usage:G <race>\n") | "cat 1>&2";
          exit_flag = 1;
        }
        else {
          print "h";
          print $2;
        }}
header_flag == 0 && ($1 == "i" || $1 =="I" || $1 == "intercept" || 
                     $1 =="Intercept") {
        if (NF != 3 && NF != 4) {
          printf ("ERROR:%s\n",$0) | "cat 1>&2";
          printf ("ERROR:Usage:I <group> <planet>\n") | "cat 1>&2";
          exit_flag = 1;
        }
        else {
          print "i";
          print $2;
          print $3;
          if (NF == 4) {
            print $4;
          }
          else
            print 0;
        }}
header_flag == 0 && ($1 == "l" || $1 =="L" || $1 == "load" || $1 =="Load") {
        if ((NF != 3) && (NF != 4)) {
          printf ("ERROR:%s\n",$0) | "cat 1>&2";
          printf ("ERROR:Usage:L <group> <COL|CAP|MAT>\n") | "cat 1>&2";
          exit_flag = 1;
        }
        else {
          if ($3 == "COL" || $3 == "CAP" || $3 == "MAT" ||
              $3 == "Col" || $3 == "Cap" || $3 == "Mat" || 
              $3 == "col" || $3 == "cap" || $3 == "mat") {
            print "l";
            if ($2 == "MAX" || $2 == "Max")
                print "max";
            else
                print $2;
            print $3;
            if (NF == 4) 
              {print $4}
            else 
              print 0;
          }
          else {
            printf ("ERROR: %s\n",$0) | "cat 1>&2";
          printf ("ERROR:Usage:L <group> <COL|CAP|MAT> [NUM]\n") | "cat 1>&2";
            exit_flag = 1;
        }}}
header_flag == 0 && ($1 == "f" || $1 =="F" || $1 == "full" || $1 =="Full") {
          print "f";
        }
header_flag == 0 && ($1 == "m" || $1 =="M" || $1 == "map" || $1 =="Map") {
        if (NF != 4) {
          printf ("ERROR: %s\n",$0) | "cat 1>&2"
          printf ("ERROR:Usage:M <X-center> <Y-center> <size>\n") | "cat 1>&2";
          exit_flag = 1;
        }
        else {
          print "m";
          print $2;
          print $3;
          print $4;
        }}
header_flag == 0 && ($1 == "n" || $1 =="N" || $1 == "name" || $1 =="Name") {
        if (NF != 3) {
          printf ("ERROR: %s\n",$0) | "cat 1>&2"
          printf ("ERROR:Usage:N <oldname> <newname>\n") | "cat 1>&2";
          exit_flag = 1;
        }
        else {
          print "n";
          print $2;
          print $3;
        }}
header_flag == 0 && ($1 == "p" || $1 =="P" || $1 == "produce" || 
                     $1 =="Produce") {
         if (NF != 3 && NF != 7) {
          printf ("ERROR: %s\n",$0) | "cat 1>&2";
          printf ("ERROR:Usage:P <planet> <shiptype> [drive weapons shields cargo\n") | "cat 1>&2";
          printf ("ERROR:Usage:P <planet> <drive|weapons|sheilds|cargo|mat|cap>\n") | "cat 1>&2";
          exit_flag = 1;
        }
        else {
          print "p";
          print $2;
          if ($3 == "ship" || $3 == "SHIP" || $3 == "Ship")
          {
                print $3;
                print $4;
          }
          else 
          {
            if ($3 == "DRIVE" || $3 == "WEAPONS" || $3 == "SHIELDS" ||
                $3 == "CARGO" || $3 == "Drive" || $3 == "Weapons" ||
                $3 == "Shields" || $3 == "Cargo" || $3 == "drive" ||
                $3 == "weapons" || $3 == "shields" || $3 == "cargo" ||
                $3 == "CAP" || $3 == "MAT" || $3 == "Cap" || $3 == "Mat" ||
                $3 == "cap" || $3 == "mat" )
            {

                print $3;
            }
            else
            {
              print "ship";
              print $3;
            }}}}
header_flag == 0 && ($1 == "r" || $1 =="R" || $1 == "route" || $1 =="Route") {
        if (NF != 3 && NF !=4 ) {
          printf ("ERROR: %s\n",$0) | "cat 1>&2";
          printf ("ERROR:Usage:R <from> <COL|CAP|MAT|EMPTY> [<to>]\n") \
            | "cat 1>&2";
          exit_flag = 1;
        }
        else {
          if ($3 == "COL" || $3 == "CAP" || $3 == "MAT" ||
              $3 == "Col" || $3 == "Cap" || $3 == "Mat" || 
              $3 == "col" || $3 == "cap" || $3 == "mat" ||
              $3 == "EMPTY" || $3 == "Empty" || $3 == "empty" ||
              $3 == "emp" || $3 == "EMP" || $3 == "Emp") {
            print "r";
            print $2;
            if ($3 == "emp" || $3 == "EMP" || $3 == "Emp") 
              print "empty";
            else
              print $3;
            if ($4 == "_" || $4 == "no" || $4 == "-")
              print "";
            else 
              print $4; 
          }
          else {
            printf ("ERROR: %s\n",$0) | "cat 1>&2";
            printf ("ERROR:Usage:R <from> <COL|CAP|MAT|EMPTY> [<to>]\n") \
              | "cat 1>&2";
            exit_flag = 1;
        }}}
header_flag == 0 && ($1 == "s" || $1 =="S" || $1 == "send" || $1 =="Send") {
        if (NF != 3 && NF !=4 ) {
          printf ("ERROR: %s\n",$0) | "cat 1>&2";
          printf ("ERROR:Usage:S <group> <to> [<number>]\n") | "cat 1>&2";
          exit_flag = 1;
        }
        else 
        {
          print "s";
          if ($2 == "MAX" || $2 == "Max")
            print "max";
          else 
            print $2;
          if (NF == 3) 
          {
            print $3;
            print "0";
          }
          else
          {
            print $3;
            print $4;
        }}}
header_flag == 0 && ($1 == "t" || $1 =="T") {
        if (NF != 3) {
          printf ("ERROR:%s\n",$0) | "cat 1>&2";
          printf ("ERROR:Usage:T <old shiptype> <new shiptype>\n") | "cat 1>&2";
          exit_flag = 1;
        }
        else {
          print "t";
          print $2;
          print $3;
        }}
header_flag == 0 && ($1 == "u" || $1 =="U" || $1 == "unload" || $1 =="Unload"){
        if ((NF != 2) && (NF != 3)) {
          printf ("ERROR:%s\n",$0) | "cat 1>&2";
          printf ("ERROR:Usage:U <group> [num]\n") | "cat 1>&2";
          exit_flag = 1
        }
        else {
          print "u";
          if ($2 == "MAX" || $2 == "Max")
            print "max";
          else
            print $2;
          if (NF==2) 
          {
            print 0;
          }
          else
            print $3;
        }}
header_flag == 0 && ($1 == "w" || $1 =="W") {
        if (NF != 2) {
          printf ("ERROR:%s\n",$0) | "cat 1>&2";
          printf ("ERROR:Usage:W <race>\n") | "cat 1>&2";
          exit_flag = 1
        }
        else {
          print "w";
          print $2;
        }}
header_flag == 0 && ($1 == "x" || $1 =="X") {
        if ((NF != 2) && (NF != 3)) {
          printf ("ERROR:%s\n",$0) | "cat 1>&2";
          printf ("ERROR:Usage:X <group> [number of ships]\n") | "cat 1>&2";
          exit_flag = 1
        }
        else {
          print "x";
          print $2;
          if (NF==2)
          {
            print 0;
          }
          else
            print $3;
        }}

header_flag == 0 && ($1 == "g" || $1 =="G" || $1 == "upgrade") {
        if ((NF != 2) && (NF != 3)) {
          printf ("ERROR:%s\n",$0) | "cat 1>&2";
          printf ("ERROR:Usage:G <group> [number of ships]\n") | "cat 1>&2";
          exit_flag = 1
        }
        else {
          print "G";
          print $2;
          if (NF==2)
          {
            print 0;
          }
          else
            print $3;
        }}

header_flag == 0 && ($1 == "o" || $1 == "O") {
        if ((NF != 2) && (NF != 3)) {
          printf ("ERROR:%s\n",$0) | "cat 1>&2";
          printf ("ERROR:Usage:O [no] <option>\n") | "cat 1>&2";
          exit_flag = 1
        }
        else
        {
           print "o";
           print $2;
           if (NF == 3) {
             print $3;
           }
}}
/[Ff][Oo][Rr][Ee][Cc][Aa][Ss][Tt]$/ {
if (header_flag == 0 && ($1 == "o" || $1 == "O") && NF==2)  {
            print 0;}}

header_flag == 0 && ($1 == "k" || $1 == "K") {
        if ((NF != 2) && (NF != 4)) {
          printf ("ERROR:%s\n",$0) | "cat 1>&2";
          printf ("ERROR:Usage:K <planet> <status> <race>\n") | "cat 1>&2";
          exit_flag = 1
        }
        else
        {
           print "k";
           print $2;
           if (NF != 2) {
             print $3
             print $4
           }
}}



header_flag == 0 && ($1 == "v" || $1 =="V" || 
    $1 == "y" || $1 =="Y" || $1 =="z" || $1 == "Z" ) {
          printf ("ERROR:%s\n",$0) | "cat 1>&2";
          printf ("ERROR:Unknown or unsupported command\n") | "cat 1>&2";
          exit_flag = 1
       }
header_flag == 0 && ($1 == "Q" || $1 =="q" ) && (NF!=1) {
          printf ("ERROR:%s\n",$0) | "cat 1>&2";
          printf ("ERROR:Unknown or unsupported command\n") | "cat 1>&2";
          printf ("ERROR:Contact GM to quit\n") | "cat 1>&2";
          exit_flag = 1
       }
header_flag == 0 && ($1 == "Q" || $1 =="q" || $1 =="#end" || $1 == "#END" ||
                     $1 == "#End") {
          print "q";
          header_flag = 1;
        }
#
# remove header from mail, and error checking for "where do their
# orders start?"
#

# We've found the "E <racename> line
header_flag == 2 && ($1 == "e" || $1 == "E") {
        if (NF != 2) {
          printf ("ERROR:Malformed E <racename> line:%s\n",$0) | "cat 1>&2";
          exit_flag = 1
        }
        else {
          header_flag = 0;
          print "e";
          print $2;
        }}

# We've hit a second Galaxy ..... line, before an E line.
header_flag == 2 && ($1 == "Galaxy" || $1 == "GALAXY" || $1 == "galaxy" ||
                     $1 == "#Galaxy"|| $1 == "#GALAXY"|| $1 == "#galaxy") {
     printf ("ERROR:line %d:%s\n", NR, $0) | "cat 1>&2";
     exit_flag = 1;
}

# We've not found an E line, and we just read a Galaxy line.
# Flag it, and reset to look for next player
header_flag == 2 && ( NR > line_num) && ( $1 != "#") {
     printf ("ERROR:Missing E <racename> line %d: %s\n", NR, $0) | "cat 1>&2";
     exit_flag = 100;
     header_flag = 1;
}
# We've found the begining of the orders, maybe....
header_flag == 1 && ($1 == "Galaxy" || $1 == "GALAXY" || $1 == "galaxy") {
          header_flag = 2;
          line_num = NR;
          from_flag = 0;
        }
header_flag == 1 && ( $1 == "#Galaxy"|| $1 == "#GALAXY"|| $1 == "#galaxy") {
        if (NF== 3) {
           header_flag = 0;
           from_flag = 0;
           print "E"
           print $3
        }
        else
        {
           printf ("ERROR:line %d:%s\n", NR, $0) | "cat 1>&2";
           printf ("ERROR:V3.x header botched\n", NR, $0) | "cat 1>&2";
        }}

# No Q line, and we've hit the next mail message
($1 == "From:") && (header_flag == 0) { 
     printf ("ERROR: Missing Q, line %d: %s\n", NR, $0) | "cat 1>&2";
     exit_flag = 101;
}
# We've hit the next message (we think), but haven't encountered any orders
($1 == "From:") && (from_flag >= 1) { 
     printf ("ERROR: Two From's, no orders line %d: %s\n", NR, $0) | "cat 1>&2";
     exit_flag = 1;
}
# We're in the header....
($1 == "From:") { from_flag++}
