static char *rcsid = "$Header: /plaid/homes/zeus/Blind-2.47/cmds/RCS/s.c,v 2.47 1998/04/15 21:34:50 zeus Exp zeus $";

/*
 *
 * $Log: s.c,v $
 * Revision 2.47  1998/04/15 21:34:50  zeus
 * *** empty log message ***
 *
 * Revision 2.46  1997/04/18 12:13:56  zeus
 * *** empty log message ***
 *
 * Revision 2.44  1995/12/31  19:45:18  zeus
 * Revision 2.43  1995/03/20  01:43:09  zeus
 *
 */

#define NOTIMEB
 
#include "common.h"
#include "prototypes.h"
#include "enterturn-g.h"
#include "cmds.h"
#include "cmds-g.h"

extern int comment;
extern char err_tmp[];
extern int groupno;

void s_cmd_rcsid (void);

void
s_cmd_rcsid (void)
{
  printf ("%s\n",rcsid);
}

void
s_cmd (char *buf, player * P)
{
  group *g;
  int i;
  fleetname *fl;
  char v[MAXTEXT];
  planet *p;

  cmd_init(buf);
  hstrncpy (v, next_token (),MAXTEXT);
  fl = matchfleet (P, v);
  if (!fl)
    g = matchgroup (P, v);
  else
    g = NULL;
  if (!g && !fl)
  {
    error (err_tmp);
    return;
  }

  if (fl)
  {
    for (g = P->groups; g; g = g->next)
    {
      if ((g->fleet == fl) && (g->dist))
      {
        if (g->dist == UPG)
        {
          sprintf (err_tmp,"Group %d has been upgraded - fleet can not move\n",
            ptonum (P->groups, g));
          error (err_tmp);
        }
        else
	  error ("Fleet is in hyperspace\n");
	return;
      }
      if ((g->fleet == fl) && (!g->type->drive))
      {
	error ("Fleet cannot move");
	return;
      }
    }
  }
  else
  {
    if (group_check (P, g, NULL, groupno, G_DIST | G_DRIVES | G_NOUPG))
    {
      error (err_tmp);
      return;
    }
  }
  p = ninputplanet (P);
  if (!p)
  {
    error (err_tmp);
    return;
  }
  if (fl)
  {
    for (g = P->groups; g; g = g->next)
    {
      if (g->fleet == fl)
      {
	Send (g, p);
      }
    }
    extra_token ();
    return;
  }
  i = ngeti ();
  if (i == NAI)
    comment = 1;
  if (i == BADI)
  {
    error (err_tmp);
    return;
  }
  if (i == MISSINGI)
    i = 0;			/* Too few tokens */
  if (i > g->ships)
  {
    i = g->ships;
    sprintf (err_tmp, "Warning! Only %d ships can be sent.\n", i);
    error (err_tmp);
  }
  if (i <= 0)
    i = g->ships;
  if (i != g->ships)
    g = new_group (P, g, i);
  g->fleet = NULL;
  Send (g, p);
  extra_token ();
}
