static char *rcsid = "$Header: /plaid/homes/zeus/Blind-2.47/cmds/RCS/o.c,v 2.47 1998/04/15 21:34:50 zeus Exp zeus $";

/*

 * $Log: o.c,v $
 * Revision 2.47  1998/04/15 21:34:50  zeus
 * *** empty log message ***
 *
 * Revision 2.46  1997/04/18 12:13:56  zeus
 * *** empty log message ***
 *
 * Revision 2.45  1997/01/01  00:02:00  zeus
 * Revision 2.44  1995/12/31  19:45:18  zeus
 * Revision 2.43  1995/03/20  01:43:09  zeus
 *
 */

#define NOTIMEB

#include "common.h"
#include "prototypes.h"
#include "enterturn-g.h"
#include "cmds.h"
#include "cmds-g.h"
#include "options.h"

extern char err_tmp[];
extern int turn;
extern int comment;

void o_cmd_rcsid (void);
void
o_cmd_rcsid (void)
{
  printf ("%s\n", rcsid);
}

void
o_cmd (char *buf, player * P)
{
  const int opt = 0xffff;
  int optmask = 0, on = 1;
  char t[MAXTEXT];
  double x;

  cmd_init (buf);
  hstrncpy (t, next_token (), MAXTEXT);
  if (t[0])
  {
    if (!hstricmp (t, "no"))
    {
      hstrncpy (t, next_token (), MAXTEXT);
      on = 0;
    }

    if (!hstricmp (t, "map"))
    {
      optmask = MAP;
    }
    if (!hstricmp (t, "fullreport"))
    {
      optmask = FULL;
    }
    if (!hstricmp (t, "production"))
      optmask = PROD;
    if (!hstricmp (t, "smartmap"))
      optmask = MAPPLUS;
    if (!hstricmp (t, "unknown"))
      optmask = UNKNOWN;
    if (!hstricmp (t, "battlesum"))
      optmask = BATTLESUM;
    if (!hstricmp (t, "longbattle"))
      optmask = LONGBATTLE;
    if (!hstricmp (t, "fulltype"))
      optmask = FULLTYPE;
    if (!hstricmp (t, "unsafebreak"))
      optmask = UNSAFEBREAK;
    if (!hstricmp (t, "battlemass"))
      optmask = BATTLEMASS;
    if (!hstricmp (t, "shortint"))
      optmask = SHORTINT;
    if (!hstricmp (t, "bombsum"))
      optmask = BOMBSUM;

#ifdef PARTTECH                 /* This option does not do anything without partial techs */
    if (!hstricmp (t, "techprod"))
      optmask = TECHPROD;
#endif
    if (!hstricmp (t, "stats"))
      optmask = STATS;

    if (optmask)
    {
      if (on)
      {
        P->opts1 = P->opts1 | optmask;
        extra_token ();
      }
      else
      {
        P->opts1 = P->opts1 & (opt ^ optmask);
        extra_token ();
      }
      return;
    }

    if (!hstricmp (t, "techs"))
      optmask = TECHS;
    if (!hstricmp (t, "sortgroups"))
      optmask = SORTGROUPS;
    if (!hstricmp (t, "forecast"))
    {
      int xx;

      optmask = FCAST;
      xx = ngeti ();

      if (xx == NAI)
        comment = 1;

      if (xx == MISSINGI)
        xx = 0;

#ifdef PREPROC
      P->lastorders = xx;
#endif

      if (xx == BADI)
      {
        error (err_tmp);

#ifdef PREPROC
        P->lastorders = turn + 1;
#endif
      }
      if (xx > turn + 5)
      {
        error ("Forcasts can not be done for more than 5 turns in the future\n");

#ifdef PREPROC
        P->lastorders = turn + 5;
#endif
      }

#ifdef PREPROC
      if (xx == 0)
        P->lastorders = turn + 1;
      if (turn >= P->lastorders)
      {
        error ("Forcasts have to be done for turns in the future\n");
        P->lastorders = turn + 1;
      }
#endif
    }
    if (!hstricmp (t, "showopts"))
      optmask = SHOWOPT;
    if (!hstricmp (t, "techplus"))
      optmask = TECHPLUS;
    if (!hstricmp (t, "autounload"))
      optmask = AUTOUNLOAD;
    if (!hstricmp (t, "upgradecost"))
      optmask = UPCOST;
    if (!hstricmp (t, "twospace"))
      optmask = TWOSPACE;
    if (!hstricmp (t, "sortplanets"))
      optmask = SORTPLANETS;
    if (!hstricmp (t, "longforecast"))
      optmask = LONGFORECAST;
    if (!hstricmp (t, "unsafemax"))
      optmask = UNSAFEMAX;
    if (!hstricmp (t, "underscores"))
      optmask = UNDERSCORES;
    if (!hstricmp (t, "showfrom"))
      optmask = SHOWFROM;
    if (!hstricmp (t, "sysmass"))
      optmask = SYSMASS;
    if (!hstricmp (t, "cartesian"))
      optmask = CARTESIAN;
    if (!hstricmp (t, "pedantic"))
      optmask = PEDANTIC;

    if (optmask)
    {
      if (on)
      {
        P->opts2 = P->opts2 | optmask;
        extra_token ();
      }
      else
      {
        P->opts2 = P->opts2 & (opt ^ optmask);
        extra_token ();
      }
      return;
    }

    if (!hstricmp (t, "xcenter"))
    {
      x = ngetf2 ();
      if ((x == MISSINGF) || (x == NAF))
      {
        error (err_tmp);
        return;
      }
      else
      {
        P->homex += x;
        optmask++;
        extra_token ();
        return;
      }
    }
    if (!hstricmp (t, "ycenter"))
    {
      x = ngetf2 ();
      if ((x == MISSINGF) || (x == NAF))
      {
        error (err_tmp);
        return;
      }
      else
      {
        P->homey += x;
        optmask++;
        extra_token ();
        return;
      }
    }
    if (!optmask)
    {
      sprintf (err_tmp, "Unrecognized option: %s\n", t);
      error (err_tmp);
      return;
    }
  }
  else
    error ("Missing option\n");
  extra_token ();
}
