static char *rcsid = "$Header: /plaid/homes/zeus/Blind-2.47/cmds/RCS/i.c,v 2.47 1998/04/15 21:34:50 zeus Exp zeus $";

/*
 *
 * $Log: i.c,v $
 * Revision 2.47  1998/04/15 21:34:50  zeus
 * *** empty log message ***
 *
 * Revision 2.46  1997/04/18 12:13:56  zeus
 * *** empty log message ***
 *
 * Revision 2.45  1996/12/31  23:58:31  zeus
 * Revision 2.44  1995/12/31  19:45:18  zeus
 * Revision 2.43  1995/03/20  01:43:09  zeus
 *
 */

#define NOTIMEB
 
#include "common.h"
#include "prototypes.h"
#include "cmds.h"
#include "cmds-g.h"
#include "enterturn-g.h"

extern int groupno;
extern int comment;
extern char err_tmp[];

void i_cmd_rcsid (void);

void
i_cmd_rcsid (void)
{
  printf ("%s\n",rcsid);
}


void
i_cmd (char *buf, player * P)
{
  group *g, *g2;
  planet *p;
  int i;
  char v[MAXTEXT];
  fleetname *fl;

  cmd_init(buf);
  hstrncpy (v, next_token (),MAXTEXT);
  fl = matchfleet (P, v);
  if (!fl)
    g = matchgroup (P, v);
  else
    g = NULL;
  if (!g && !fl)
  {
    error (err_tmp);
    return;
  }
  if (fl)
  {
    for (g = P->groups; g; g = g->next)
    {
      if ((g->fleet == fl) && (g->dist))
      {
	error ("Fleet is in hyperspace\n");
	return;
      }
      if ((g->fleet == fl) && (!g->type->drive))
      {
	error ("Fleet cannot move");
	return;
      }
    }
  }
  else
  {
    if (group_check (P, g, NULL, groupno, G_DIST | G_DRIVES | G_NOUPG))
    {
      error (err_tmp);
      return;
    }
  }
  p = ninputplanet (P);
  if (!p)
  {
    error (err_tmp);
    return;
  }
  if (fl)
  {
    for (g = P->groups; g; g = g->next)
    {
      if (g->fleet == fl)
      {
	g->from = p;
	g->dist = INTERCEPT;
      }
    }
    return;
  }

  i = ngeti ();
  if (i == NAI)
    comment = 1;
  if (i == BADI)
  {
    error (err_tmp);
    return;
  }
  if (i == MISSINGI)
    i = 0;
  if ((i > 0) && (g->ships != i))
  {
    if (i >= g->ships)
    {
      sprintf (err_tmp, "Not enough ships in group %d.\n", groupno);
      error (err_tmp);
      return;
    }
    g2 = new_group (P, g, i);
    g2->from = p;
    g2->dist = INTERCEPT;
    g2->fleet = NULL;
  }
  else
  {
    g->from = p;
    g->dist = INTERCEPT;
    g->fleet = NULL;
  }
  extra_token ();
}
