static char    *rcsid = "$Header: /plaid/homes/zeus/Blind-2.46/util/RCS/edit.c,v 2.46 1997/04/18 12:29:49 zeus Exp zeus $";

/*
 * $Log: edit.c,v $
 * Revision 2.46  1997/04/18 12:29:49  zeus
 * *** empty log message ***
 *
 * Revision 2.45  1997/01/01  00:49:33  zeus
 * Revision 2.43  1995/03/20  01:43:09  zeus
 * Revision 2.41  1994/04/08  03:11:28  bampton
 * Revision 2.38  1993/09/27  17:15:54  bampton
 * Revision 2.38  1993/09/27  17:15:54  bampton
 * Revision 2.37  1993/09/07  20:50:32  bampton
 * Revision 2.33  1993/08/03  23:10:13  bampton
 * Revision 2.30  1993/07/14  14:59:26  bampton
 * Revision 0.0  1993/07/14  13:41:58  bampton RCS prototype.
 * 
 * 
 */

#include "common.h"
#include "prototypes.h"
#include "edit.h"
#include "report-g.h"
#include "report.h"
#include "new-game.h"
#include "cmds.h"
#include "misc-g.h"

extern char     buf[MAXSTRLEN], buf2[MAXSTRLEN];
extern player  *players;
extern planet  *planets;
extern char     prname[MAXTEXT];
extern FILE    *pr;
extern int      turn;
extern shiptype *shiptypes;

#ifdef GAMENAME
char gamename[MAXTEXT];
#endif

int nplanets;


void
edit_rcsid (void)
{
  printf ("%s\n", rcsid);
}
 

void
err (char *a)
{
  printf ("ERROR: %s", a);
}

void
chk_planet (planet * p)
{
  if (p->size < p->ind)
  {
    p->ind = p->size;
    err ("Industry bigger than size of planet!");
  }
  if (p->pop < p->ind)
  {
    p->ind = p->size;
    err ("Industry bigger than population of planet!");
  }
  if (p->size < p->pop)
  {
    p->ind = p->size;
    err ("Population bigger than size of planet!");
  }
  /*
   * others: compare R to max, cap/ind
   */
  return;
}

void
whack_player (player *P)
{
  planet *p;

  for (p=planets;p;p=p->next)
  {
    if (p->owner==P)
    {
      sterilize(p); /* Nuke planet */
      if (p->size==MAXPOP)
        set_spice(p); /* Reseed homeworld */
    }
  }
  delete_player (P,1);
}

void
edit_planet (planet * p)
{

  for (;;)
  {
    /* inputpr(); */
    pr = stdout;
    fbegin ("System", "xxffffffxfff");
    fhead ("N#XYSPIRPC$M");
    printplanet (p, p->owner);
    fend ();

    printf ("Planet %s %s> ", p->name, p->num);
    getstr ();
    switch (buf[0])
    {
    case 'Q':
    case 'q':
      return;
    case 'x':
      break;

    case 'n':
      break;
    case 'z':
      break;
    case 'r':
      break;
    case 'p':
      break;
    case 'i':
      p->ind = inputcomponent ("Industry ? ");
      chk_planet (p);
      break;
    case 'P':
      break;
    case 'c':
      break;
    case 'C':
      break;
    case 'm':
      p->mat = inputcomponent ("Materials ? ");
      chk_planet (p);
      break;
    case 's':
      break;
    case 'R':
      break;
    default:
      printf ("Q - quit editing planet\n");
      printf ("X - erase changes (not done)\n");
      printf ("i - change industry\n");
    }
  }
}

 
shiptype *
inputshiptype (player * P)
{
  shiptype *T;
 
    printf ("Ship Type? ");
    getstr ();
    if (!buf[0])
      return 0;
    for (T = shiptypes; T; T = T->next)
      if (T->owner == P && !hstricmp (T->name, buf))
        return T;
    printf ("\"%s\" is not a ship type.\n", buf);
    return 0;
}
 

 
planet *
inputplanet (planet * head, char *prompt)
{
  planet *p;
 
  printf ("%s", prompt);
  getstr ();
  if (buf[0])
  {
    if ((p = nametoplan (head, buf)) != 0)
      return p;
    printf ("System \"%s\" not found.\n", buf);
  }
  else
    printf ("No planet given\n");
  return 0;
}
 
double
inputcomponent (char *s)
{
  double x;
 
  printf ("%s", s);
  x = getf ();
  if (!x)
    return 0;
 
  if (x < 1.0)
    return (BADF);
  return x;
}
 


int
main (void)
{
  planet         *p;
  player         *P = NULL;
  shiptype       *T = NULL;
  float version = VER;

  printf ("Galaxy v2.9 by Russell Wallace  " __DATE__ "\n");
  printf ("Blind EDITOR %4.2f\n",version);
  if (opengame () >= 0)
  {
    loadgame ();
    printf ("Game data editor\n");
    printf ("Turn %d\n", turn);
  }
  else
  {
    printf ("could not open data file!!\n");
    exit (1);
  }

  pr = stdout;

  for (;;)
  {
    printf ("edit> ");
    getstr ();
    switch (tolower (buf[0]))
    {
    case 'x':                   /* exit, no changes */
      return 0;
    case 'q':
      savegame ();
      return 0;

    case 'd':
      if (!P)
        printf ("Select player first, with 'p'.\n");
      else
        whack_player(P);
      break;

    case 'p':                   /* select player */
      P = inputplayer (players, "Player? ");
      break;

    case 't':                   /* select ship type */
      if (!P)
        printf ("Select player first, with 'p'.\n");
      else
        T = inputshiptype (P);
      break;

    case 'm':                   /* modify this design */
      if (!T)
      {
        printf ("Select%s shiptype first.\n", P ? "" : " player and");
        break;
      }
      else
      {
        T->drive = inputcomponent ("Drive? ");
        printf ("Attacks? ");
        T->nguns = geti ();
        T->guns = inputcomponent ("Weapons? ");
        if (!T->nguns)
          T->guns = 0;
        if (!T->guns)
          T->nguns = 0;
        T->shields = inputcomponent ("Shields? ");
        T->cargo = inputcomponent ("Cargo? ");
      }
      /* fall through ... */
    case 'v':                   /* view this design */
      if (!T)
        printf ("Select%s shiptype first.\n", P ? "" : " player and");
      else
      {
        fbegin ("", "xfifffff");
        fhead ("NDAWSC  ");
        printshiptype (T,P,1);
        fend ();
      }
      break;

    case 'l':
      p = inputplanet (planets, "System?");
      if (p)
        edit_planet (p);
      break;

    default:
      printf (
              "P = select Player\n"
              "T = select ship Type\n"
              "V = View selected design\n"
              "M = Modify selected design\n"
              "L = Edit a planet\n"
              "Q = Quit\n"
              "X = Exit without saving\n"
        );
    }
  }
}
