#!/bin/csh -f
# Galaxy turn mailer
# sends each <file>.r file to the name found in 
# the races:players file
# races:players file format
# racename:e-mail [e-mail2]
# racename must be correct casewise

# Needs cut (although we could use awk)
# Assumes that each game is in a different directory (again, can be
# hacked around)

# Assumes that reports are in $cwd

#  $Header: /plaid/homes/zeus/Blind-2.46/support/RCS/mailer.csh,v 2.43 1995/03/20 01:43:09 zeus Exp $
#
#  $Log: mailer.csh,v $
# Revision 2.43  1995/03/20  01:43:09  zeus
# *** empty log message ***
#
# Revision 2.42  1994/05/17  13:43:15  bampton
# Revision 2.41  1994/04/08  03:11:28  bampton
# Revision 2.40  1994/03/09  20:22:55  bampton
#

set version = 0.21
set gm = 'bampton@cs.utk.edu'

cut -f1 /dev/null
if ($status ) then
  echo "No sysV extensions."
  exit 1
endif

echo -n "Turn?"
set turn = $<
set turn = `echo $turn`
@ turn2 = $turn + 1

if (-e  .game-name) then
  set game = `cat .game-name`
else
  exit 1
endif

set NOTICEDIR = notices
set BULLETIN = $NOTICEDIR/global.bulletin
set GAMEBUL = $NOTICEDIR/$game.info
set TURNNOTICE = $NOTICEDIR/$game.$turn.notice

set tmp = /tmp/galaxy.$$.send
rm -f $tmp
touch $tmp

if ( -e $BULLETIN ) then
   echo ""  >> $tmp
   echo "General Bulletins:" >> $tmp
   echo ""  >> $tmp
   cat $BULLETIN >> $tmp
   echo ""  >> $tmp
endif
if ( -e $GAMEBUL ) then
   echo "" >> $tmp
   echo "Bulletins for Galaxy Game $game">> $tmp
   echo "" >> $tmp
   cat $GAMEBUL >> $tmp
   echo ""  >> $tmp
endif
if ( -e $TURNNOTICE ) then
   echo "" >> $tmp
   echo "Bulletins for Galaxy Game $game Turn $turn">> $tmp
   echo ""  >> $tmp
   cat $TURNNOTICE >> $tmp
   echo ""  >> $tmp
endif

foreach file (*.r)
  set use = `grep ^${file:r} races:players | cut -f2 -d:` 
  grep -s ^"${file:r}" races:players 
  if ( $status ) then
   echo "Player not found: $file:r"
  else
    echo "Mailing Turn $turn to $use"

    cat > /tmp/mailer.$$ << EOF
HELO
ONEX
MAIL FROM:<zeus@cs.utk.edu> 
EOF
foreach x ($use)
echo RCPT TO: "<$x>" >> /tmp/mailer.$$
end
echo "DATA" >> /tmp/mailer.$$
echo To: \"$file:r\" "<$use[1]>" >> /tmp/mailer.$$
echo "From: Blind Galaxy Server <zeus@cs.utk.edu>" >> /tmp/mailer.$$
echo "Subject: $game Turn $turn for $file:r" >> /tmp/mailer.$$
echo "X-blind-mailer-version: $version" >> /tmp/mailer.$$
#echo "X-blind-mailer-blurb: Sendmail 8.x compliant" >> /tmp/mailer.$$
echo "X-Blind-gm: $gm" >> /tmp/mailer.$$
echo "X-orders-subject: $game orders for $file:r turn $turn2" >> /tmp/mailer.$$
if ( -e .game-time ) then
echo -n "X-orders-time: " >> /tmp/mailer.$$
cat .game-time >> /tmp/mailer.$$
endif
echo "" >> /tmp/mailer.$$
cat $tmp $file >> /tmp/mailer.$$
cat >> /tmp/mailer.$$ << EOF
.
quit
EOF

/usr/lib/sendmail -bs < /tmp/mailer.$$ > /dev/null

rm /tmp/mailer.$$
    sleep 10
  endif
end

rm $tmp
