static char *rcsid = "$Header: /silver/homes/zeus/Blind-2.43/cmds/RCS/u.c,v 2.43 1995/03/20 01:43:09 zeus Exp zeus $";

/*
 *
 * $Log: u.c,v $
 * Revision 2.43  1995/03/20  01:43:09  zeus
 * *** empty log message ***
 *
 *
 */

#define NOTIMEB
 
#include "../protos/common.h"
#include "../protos/prototypes.h"
#include "../protos/enterturn-g.h"
#include "../protos/cmds.h"
#include "../protos/cmds-g.h"

extern char tbuf[];
extern int pos;
extern int groupno;
extern int comment;
extern char err_tmp[];

void
u_cmd (char *buf, player * P)
{
  group *g;
  planet *p;
  int i;

  hstrcpy (tbuf, buf);
  pos = 0;
  (void) next_token ();
  g = ninputgroup (P);
  if (!g)
  {
    error (err_tmp);
    return;
  }
  if (g->loadtype == CG_EMPTY)
  {
    sprintf (err_tmp, "Group %d isn't carrying cargo.\n", groupno);
    error (err_tmp);
    return;
  }
  if (group_check (P, g, NULL, groupno, G_DIST))
  {
    error (err_tmp);
    return;
  }
  p = g->where;
  if ((g->loadtype == CG_COL) && (p->owner != P) && p->owner)
  {
    sprintf (err_tmp, "Group %d at %s can't unload COL at alien planet.\n",
	     groupno, p->num);
    error (err_tmp);
    return;
  }

  if (!p->size)			/* can't unload onto size 0   */
  {
    sprintf (err_tmp, "Group %d can not unload- world %4s is size 0.\n",
	     groupno, p->num);
    error (err_tmp);
    return;
  }
  i = ngeti ();
  if (i == -3)
    comment = 1;
  if (i == BADI)
  {
    error (err_tmp);
    return;
  }
  if (i == MISSINGI)
    i = 0;			/* Too few tokens */
  if (i > g->ships)
  {
    i = g->ships;
    sprintf (err_tmp, "Only %d ships can be unloaded.\n", i);
    error (err_tmp);
    return;
  }
  if (i <= 0)
    i = g->ships;
  if (i != g->ships)
    g = new_group (P, g, i);
  unloadgroup (g, P);
  extra_token ();
}
