/*
 * $Header: /a/beepbeep/navy/homes/zeus/Zeus/SRC/RCS/common.h,v 0.0
 * 1993/07/14 13:42:37 bampton Exp bampton $
 * 
 * $Log: common.h,v $
 * Revision 2.43  1995/03/20  01:43:09  zeus
 * *** empty log message ***
 *
 * Revision 2.42  1994/05/17  13:43:15  bampton
 * Revision 2.40  1994/03/09  20:22:55  bampton
 * Revision 2.39  1993/10/28  22:31:20  bampton
 * Revision 2.38  1993/09/27  17:15:54  bampton
 * Revision 2.37  1993/09/07  20:50:32  bampton
 * Revision 2.34  1993/08/09  23:06:20  bampton
 * Revision 2.33  1993/08/03  23:10:13  bampton
 * Revision 2.30  1993/07/14  14:59:26  bampton
 * Revision 0.0  1993/07/14  13:42:37  bampton RCS prototype.
 * 
 */

#include        <stdio.h>
#include        <stdlib.h>
#include        <string.h>
#include        <fcntl.h>
#include        <ctype.h>
#include        <math.h>
#include        <assert.h>

#ifndef NOTIMEB
#include <sys/time.h>
#endif

#include        "global.h"

#define ALMOSTZERO              0.00000000001   /* don't change! */
#define ROUNDOFF                0.001         /* Round off error fudger */
#define MAXTEXT                 16      /* name lengths */
#define MAXPOP                  1000.0  /* Homeworld size */
#define MATPERCOL               ALMOSTZERO      /* modifiable */
#define POPPERCOL               8.0
#define POPINC                  .08
#define INDPERCOL               ALMOSTZERO      /* modifiable */
#define INDPERSHIP              10.0
#define INDPERCAP               6.0
#define INDFROMCAP              2.0     /* Blind add-on, 1.0 for std games */
#define INDPERRESEARCH          5000
#define BATTLEMAGIC             3.107232506
#define DRIVEMAGIC              20.0
#define MAPWIDTH                80
#define MAPHEIGHT               40
#define LOADSAPLANETS           40
#define O_BINARY                0

#define TRUE 1
#define FALSE 0
#define min(x,y) (x>y  ? y : x)
#define max(x,y) (x<y  ? y : x)
#define ison(opt,optflag) (opt&optflag ? TRUE : FALSE)

/* Status's for K cmd: (flush == clear it out) */
#define PEACE 0
#define GUARD 1
#define WAR 2
#define FLUSH 3

/* Return values for ngeti ngetf */
#define BADF -2.0
#define MISSINGF -1.0
#define BADI -2
#define MISSINGI -1

/* for isnum() function flags */
#define INT 1
#define FLOAT 2

/* For ninputplanet */
#define DASH 1 /* - and _ are valid as well as a real planet */
#define ANY  2 /* - _ ; and # are valid as well as real planet */

/* For magic values for g->dist */
#define UPG -3.0

#ifdef IO

#ifdef PREPROC
static char     lf = '\n';

#else
static char     lf = ' ';

#endif

#endif



#ifdef  INTERACTIVE
#define throwstr()
#else
#define throwstr()              getstr()
#endif

enum
{
  PR_CAP,
  PR_MAT,
  PR_SHIP,
  PR_DRIVE,
  PR_GUNS,
  PR_SHIELDS,
  PR_CARGO
};

enum
{
  CG_COL,
  CG_CAP,
  CG_MAT,
  CG_EMPTY,
  MAXCARGO
};

struct playerstruct;
typedef struct playerstruct player;

typedef struct liststruct
{
  struct liststruct *next;
}               list;

typedef struct tmppname
{
  struct tmppname *next;
  char  nname[MAXTEXT];
  char  oname[MAXTEXT];
} tmppname;

typedef struct
{
  double          drive;
  double          guns;
  double          shields;
  double          cargo;
}               Tech;

typedef struct shiptypestruct
{
  struct shiptypestruct *next;
  char            name[MAXTEXT];
  player         *owner;
  double          drive;
  int             nguns;
  double          guns;
  double          shields;
  double          cargo;
  int             flag;
#ifdef UPGRADE
  int numbuilt;
#endif
}               shiptype;

typedef struct planetstruct
{
  struct planetstruct *next;
  char            name[MAXTEXT];
  char            num[MAXTEXT];
  player         *owner;
  double          x, y;
  double          size;
  double          resources;
  double          pop;
  double          ind;
  int             producing;
  shiptype       *producingshiptype;
  double          col;
  double          cap;
  double          mat;
  double          inprogress;
  double          spent;
  struct planetstruct *routes[MAXCARGO];
#ifdef UPGRADE
  double          drive;
  double          guns;
  double          shields;
  double          cargo;
#endif
}               planet;

typedef struct fleetname {
        struct fleetname *next;
        char name[MAXTEXT];
        double fleetspeed;
        player *owner;
}               fleetname;

typedef struct groupstruct
{
  struct groupstruct *next;
  shiptype       *type;
  Tech            tech;
  int             loadtype;
  double          load;
  planet         *from;
  planet         *where;
  double          dist;
  int             ships;

#ifdef V3
  int             left;
  struct groupstruct   *alias;
#endif
#ifdef UPGRADE
  fleetname        *fleet;
#endif
}               group;

typedef struct alliancestruct
{
  struct alliancestruct *next;
  player         *ally;
}               alliance;

typedef struct defensivestruct  /* def mod */
{
  struct defensivestruct *next;
  player         *defend;
}               defensive;

typedef struct planetdefense
{
  struct planetdefense *next;
  int       dipstat;
  player         *defender;
  planet         *planet;
}               planetdefense;


#ifdef CARRYOVER
typedef struct techinfo
{
  struct techinfo *next;
  Tech            tech;
  player         *whoose;
}               techinfo;

#endif

typedef struct sortedstruct
{
  struct sortedstruct *next;
  planet         *p;
}               sorted;

typedef struct shotstruct
{
  struct shotstruct *next;
  shiptype       *attacker;
  shiptype       *target;
  int             kill;
}               shot;

typedef struct viewerstruct
{
  struct viewerstruct *next;
  player         *who;
}               viewer;

typedef struct participantstruct
{
  struct participantstruct *next;
  player         *who;
  group          *groups;
}               participant;

typedef struct battlestruct
{
  struct battlestruct *next;
  planet         *where;
  shot           *shots;
  viewer         *viewers;
  participant    *participants;
}               battle;

typedef struct bombingstruct
{
  struct bombingstruct *next;
  planet         *where;
  player         *who;
  viewer         *viewers;
  player         *whoose;
  double          pop;
  double          ind;
  double          col;
  double          cap;
  double          mat;
}               bombing;

struct playerstruct
{
  player         *next;
  char            name[MAXTEXT];
  Tech            tech;
  alliance       *allies;
  defensive      *defend;       /* def mod */
  group          *groups;

  int             opts1, opts2, opts3, lastorders;
  double          homex, homey; /* GE: homex, homey = 0,0 in player's view */

#ifdef V3
  int             x, y, size;
#endif

#ifdef CARRYOVER
  techinfo       *othertechs;
#endif
};


/* Defines to allow for the options command.... */

/* opts1 stuff: */
#define MAP 0x01
#define FULL 0x02
#define PROD 0x04
#define MAPPLUS 0x08
#define UNKNOWN 0x10
#define BATTLESUM 0x20          /* V3 only */
#define LONGBATTLE 0x40
#define FULLTYPE 0x80
#define UNSAFEBREAK 0x100
#define	BATTLEMASS 0x200
#define SHORTINT 0x400

/* opts2 stuff */
#define TECHS 0x01
#define SORTGROUPS 0x02
#define FCAST 0x04 /* Forecast hook */
#define SHOWOPT 0x08 /* Show options */
#define TECHPLUS 0x10
#define AUTOUNLOAD 0x20
#define UPCOST 0x40
#define TWOSPACE 0x80
#define SORTPLANETS 0x100
#define LONGFORECAST 0x200
#define UNSAFEMAX 0x400
#define UNDERSCORES 0x800

/* opts3 stuff */
/* Planned ? */

#define TWOCOL 0x10
#define NAMECASE 0x40
