****************
* extended cstart routine:
* - setting up argc and argv
* - setting up environment
* - shrink memory
* - and start main
*
* parameters are NOT wildcard expanded
* ARGV environment parameter is search for instead
*
                GLOBL   exit
                GLOBL   __exit
                GLOBL   _BasPag
                GLOBL   _app
                GLOBL   errno
                GLOBL   _AtExitVec,_FilSysVec
                GLOBL   _RedirTab
                GLOBL   _StkLim
                GLOBL   _PgmSize
                GLOBL	environ
                
                GLOBL   __text
                GLOBL   __data
                GLOBL   __bss
                
                XREF    main
                XREF    _fpuinit
                XREF    _StkSize
                XREF    _FreeAll
				XREF	_StdErrF

* Base page structure

                OFFSET  0

TpaStart:       ds.l    1
TpaEnd:         ds.l    1
TextSegStart:   ds.l    1
TextSegSize:    ds.l    1
DataSegStart:   ds.l    1
DataSegSize:    ds.l    1
BssSegStart:    ds.l    1
BssSegSize:     ds.l    1
DtaPtr:         ds.l    1
PntPrcPtr:      ds.l    1
Reserved0:      ds.l    1
EnvStrPtr:      ds.l    1
Reserved1:      ds.b    7
CurDrv:         ds.b    1
Reserved2:      ds.l    18
CmdLine:        ds.b    128
BasePageSize:   ds      0



                TEXT

Fsetdta         equ     $1a
Fgetdta         equ     $2f
Fseek			equ		$42
Fforce			equ		$46
Mshrink         equ     $4a
Pterm           equ     $4c
Fsfirst         equ     $4e
Fsnext          equ     $4f

__text:
Start:          bra     Start0

                dc.l    _RedirTab
                dc.l    _StkSize

EmpStr:         dc.b    0,0

Start0:         move.l  a0,a3
                move.l  a3,d0
                bne     acc
                move.l  4(a7),a3
                moveq.l #1,d0
                bra     app
acc:            clr.w   d0
app:            move.l  a3,_BasPag
                move.w  d0,_app
                movea.l TextSegSize(a3),a0
                adda.l  DataSegSize(a3),a0
                adda.l  BssSegSize(a3),a0
                adda.w  #BasePageSize,a0
                move.l  a0,_PgmSize

                move.l  a3,d0
                add.l   a0,d0
                and.b   #$FC,d0
                movea.l d0,a7

* check application flag

*        TST.W   _app
*        BEQ     Start8  * No environment and no arguments

                sub.l   #_StkSize-4,d0
                and.b   #$FC,d0
                movea.l d0,a1
                movea.l a1,a4
                move.l  a1,environ
                movea.l EnvStrPtr(a3),a2
                move.l  a2,(a1)+
Start1:         tst.b   (a2)+
                bne     Start1
                move.l  a2,(a1)+
                tst.b   (a2)+
                bne     Start1
                clr.l   -4(a1)
                movea.l a1,a2

                move.l  #EmpStr,(a1)+   ;   argv[0] = ""
                moveq   #1,d3
                lea     CmdLine(a3),a0
                move.b  (a0)+,d1
                ext.w   d1
                cmp.w	#127,d1
                beq		do_argv
                clr.b   0(a0,d1)
Start2:         move.b  (a0)+,d1
                beq     Start99
                cmpi.b  #' '+1,d1
                bmi     Start2
                addq.l  #1,d3
                subq.l  #1,a0
                cmpi.b  #'"',d1
                bne     Start4
                addq.l  #1,a0
                move.l  a0,(a1)+
Start3:         move.b  (a0)+,d1
                beq     Start99
                cmp.b   #'"',d1
                bne     Start3
                clr.b   -1(a0)
                bra     Start2
Start4:         move.l  a0,(a1)+
Start6:         move.b  (a0)+,d1
                beq     Start7
                cmp.b   #' '+1,d1
                bpl     Start6
Start7:         clr.b   -1(a0)
                bra     Start2
Start99:        clr.l   (a1)+
				

do_argv:
                move.w  d3,-(a7)	; push argc
                move.l  a2,-(a7)	; push argv
				move.w	d1,-(a7)
				
                move.l  a1,_StkLim
                move.l  _PgmSize,-(a7)
                move.l  a3,-(a7)
                move.w  #0,-(a7)
                move.w  #Mshrink,-(a7)
                trap    #1
                lea     12(a7),a7

                jsr     _fpuinit
                
                move.w	(a7)+,d1
				
				lea		4(a7),a0
				lea		0(a7),a1
				move.l	environ,a2
				jsr		argv
				
				move.l	#_StdErrF,a0
				move.w	#2,16(a0)	; fileno(stderr) = 2
				tst.b	d1
				bne		nostderr	; environ STDERR found -> shell should handle it
				
				move.w	#1,-(a7)	; offset = Fseek(0l, 2, SEEK_CUR)
				move.w	#2,-(a7)
				clr.l	-(a7)
				move.w	#Fseek,-(a7)
				trap	#1
				move.l	d0,d3
				
				move.w	#0,-(a7)	; Fseek(1l, 2, SEEK_SET)
				move.w	#2,-(a7)
				move.l	#1,-(a7)
				move.w	#Fseek,-(a7)
				trap	#1
				exg		d0,d3
				
				move.w	#0,-(a7)	; Fseek(offset, 2, SEEK_SET)
				move.w	#2,-(a7)
				move.l	d0,-(a7)
				move.w	#Fseek,-(a7)
				trap	#1
				lea		30(a7),a7
				
				subq.l	#1,d3
				beq		nostderr	; not a tty -> don't change
				
				move.w	#-1,-(a7)
				move.w	#2,-(a7)
				move.w	#Fforce,-(a7)
				trap	#1
				addq.l	#6,a7
				
nostderr:		move.l	(a7)+,a0	; restore argv
				move.w	(a7)+,d0	; restore argc
                movea.l a4,a1
                jsr     main


exit:           move.w  d0,-(a7)
                move.l  _AtExitVec,d0
                beq     __exit
                movea.l d0,a0
                jsr     (a0)
__exit:         move.l  _FilSysVec,d0
                beq     Exit1
                movea.l d0,a0
                jsr     (a0)
Exit1:          jsr     _FreeAll
                move.w  #Pterm,-(a7)
                trap    #1



*
* passed: (a0) = argc
*         (a1) = argv
*         a2   = envp[]
*
* returns: d1 != 0 -> STDERR found
*
argv:			movem.l	a3-a4,-(a7)
				move.w	d1,-(a7)
				sf		d1
argv1:			move.l	(a2)+,a3
				move.l	a3,d0
				beq		xenv
				cmp.b	#'A',(a3)
				beq		argv2
				cmp.b	#'S',(a3)
				bne		argv1
				cmp.b	#'T',1(a3)
				bne		argv1
				cmp.b	#'D',2(a3)
				bne		argv1
				cmp.b	#'E',3(a3)
				bne		argv1
				cmp.b	#'R',4(a3)
				bne		argv1
				cmp.b	#'R',5(a3)
				bne		argv1
				cmp.b	#'=',6(a3)
				bne		argv1
				st		d1
				bra		argv1
argv2:			cmp.b	#'R',1(a3)
				bne		argv1
				cmp.b	#'G',2(a3)
				bne		argv1
				cmp.b	#'V',3(a3)
				bne		argv1
				cmp.b	#'A',(a3)
				bne		argv1
				cmp.b	#'=',4(a3)
				bne		argv1
				clr.l	-4(a2)
				clr.b	(a3)
				move.w	(a7),d0
				cmp.w	#127,d0
				bne		xenv
				lea		6(a3),a3
				move.l	a3,a4
scanslash:		tst.b	(a3)
				beq		endslash
				cmp.b	#$5c,(a3)+
				bne		scanslash
				move.l	a3,a4
				bra		scanslash
endslash:		move.l	a4,a3
lowerit:		move.b	(a4)+,d0
				beq		lowerend
				cmp.b	#'A',d0
				bcs		lowerit
				cmp.b	#'Z'+1,d0
				bcc		lowerit
				add.b	#'a'-'A',d0
				move.b	d0,-1(a4)
				bra		lowerit
lowerend:		move.l	(a1),a4
				clr.w	(a0)
nxarg:			move.l	a3,(a4)+
				add.w	#1,(a0)
nxar1:			tst.b	(a3)+
				bne		nxar1
				tst.b	(a3)
				bne		nxarg
				clr.l	(a4)
xenv:			addq	#2,a7
				movem.l	(a7)+,a3-a4
				rts
				
				
                DATA
                
__data:
errno:          dc.w    0
_AtExitVec:     dc.l    0
_FilSysVec:     dc.l    0


                BSS

__bss:
_BasPag:        ds.l    1
_app:           ds.w    1
_StkLim:        ds.l    1
_PgmSize:       ds.l    1
_RedirTab:      ds.b    24
environ:        ds.l    1
