#include <stdio.h>
#include <time.h>
#include <math.h>
#include "gchdr.h"
#include "gcio.h"
#include "gcmapps.h"


static void headerPS _(( FILE *fp, char *fname, PLAYER *aWorld ));
static void footerPS _(( FILE *fp ));

static UWORD Zeichen [79] =
{
	  77, 324, 247, 250, 251, 101, 102, 103, 104, 105,
	 106, 107, 110, 112, 113, 114, 115, 116, 120, 121,
	 122, 123, 124, 125, 126, 127, 130, 131, 132,  60,
	  62,  63,  64,  65,  66,  67,  70,  71,  42,  43,
	  44,  45,  46,  47, 245, 246, 252, 340, 321, 302,
	 345, 306, 267, 141, 142, 143, 144, 145, 146, 147,
	 150, 152, 153, 154, 155, 156, 160, 161, 162, 163,
	 164, 165, 166, 167, 170, 171, 172, 322, 111
};

static double planetSize = 0.3;
static double planetNameSize = 0.75; /* 1.0; */


BYTE buildPS(P(char *) fname, P(PLAYER *) aWorld)
PP(char *fname;)
PP(PLAYER *aWorld;)
{
	char	fpsname[128];
	WORD	number, line, gitterweite, maxMapSize;
	WORD	start = 0, delta = 0, size = mapSize, more;
	XY		linenumber, off, ganz, begin;
	FILE	*fp;
	PlanetList	*list;
	LIMES	*limes, *pre;
	double	gitterfont, halb_x, halb_y;
	char	*title;
	
	if (strcmp(fname, "-") == 0)
	{
		strcpy(fpsname, aWorld->pl_path);
		strcat(fpsname, EXT_PS);
		fp = stdout;
	} else {
		strcpy(fpsname, fname);
		if (strlen(fpsname) < strlen(EXT_PS) ||
			strcmp(fpsname + strlen(fpsname) - strlen(EXT_PS), EXT_PS) != 0)
		{
			strcat(fpsname, EXT_PS);
		}
		fp = fopen(fpsname, "w");
		if (fp == NULL)
		{
			return(FEHLER_C);
		}
	}
	
	if (verbose)
		fprintf(stderr, "writing %s\n", fpsname);
	
	title = strrchr(fpsname, '/');
	if (title == NULL)
		title = strrchr(fpsname, '\\');
	if (title == NULL)
		title = fpsname;
	else
		++title;
	headerPS(fp, title, aWorld);

	corr_x += 0.5;
	corr_y += 0.5;

	maxMapSize = gc_global.maxMapSize;
	
	/*
	 * Kreise fuer Sichtweiten um Planeten ziehen
	 */
	if (showRange)
	{
		fprintf(fp, "0.90 setgray\n");
		for (list = aWorld->pl_planetlist; list != NULL; list = list->l_next)
		{
			if (list->l_planetrange)
			{
				fprintf(fp, "newpath %.5f %.5f %.5f 0 360 arc fill\n",
					corr_x + list->l_koordinate.x, corr_y + list->l_koordinate.y,
					(double) list->l_planetrange + 0.5);
				if (list->l_koordinate.x + list->l_planetrange > maxMapSize - 1)
					fprintf(fp, "newpath %.5f %.5f %.5f 0 360 arc fill\n",
						corr_x + list->l_koordinate.x - maxMapSize,
						corr_y + list->l_koordinate.y, (double) list->l_planetrange + 0.5);
				if (list->l_koordinate.x - list->l_planetrange < 2)
					fprintf(fp, "newpath %.5f %.5f %.5f 0 360 arc fill\n",
						corr_x + list->l_koordinate.x + maxMapSize,
						corr_y + list->l_koordinate.y, (double) list->l_planetrange + 0.5);
				if (list->l_koordinate.y + list->l_planetrange > maxMapSize - 1)
					fprintf(fp, "newpath %.5f %.5f %.5f 0 360 arc fill\n",
						corr_x + list->l_koordinate.x,
						corr_y + list->l_koordinate.y - maxMapSize,
						(double) list->l_planetrange + 0.5);
				if (list->l_koordinate.y - list->l_planetrange < 2)
					fprintf(fp, "newpath %.5f %.5f %.5f 0 360 arc fill\n",
						corr_x + list->l_koordinate.x,
						corr_y + list->l_koordinate.y + maxMapSize,
						(double) list->l_planetrange + 0.5);
			}
		}
	}
	
	/*
	 * Kreise um Heimatplaneten ziehen
	 */
	if (gebiet)
	{
		fprintf(fp, "\n0.0 setgray\n");
		for (number = 1; number <= gc_global.anz_spieler; number++)
		{
			list = findPlanet(aWorld, get_player(number)->pl_heimat, NULL);
			if (list != NULL)
			{
				WORD circle;
				
				fprintf(fp, "0.08 setlinewidth\n");
				fprintf(fp, "[0.4 0.2 0.2 0.2] 0 setdash 1 setlinecap\n");
				for (circle = 0; radius[circle] != 0; circle++)
				{
					fprintf(fp, "newpath %.5f %.5f %d.5 0 360 arc\n",
						corr_x + list->l_koordinate.x,
						corr_y + list->l_koordinate.y,
						radius[circle]);
					fprintf(fp, "stroke\n");
					if (list->l_koordinate.x + radius[circle] > maxMapSize - 1)
						fprintf(fp, "newpath %.5f %.5f %d.5 0 360 arc stroke\n",
							corr_x + list->l_koordinate.x - maxMapSize,
							corr_y + list->l_koordinate.y,
							radius[circle]);
					if (list->l_koordinate.x - radius[circle] < 2)
						fprintf(fp, "newpath %.5f %.5f %d.5 0 360 arc stroke\n",
							corr_x + list->l_koordinate.x + maxMapSize,
							corr_y + list->l_koordinate.y,
							radius[circle]);
					if (list->l_koordinate.y + radius[circle] > maxMapSize - 1)
						fprintf(fp, "newpath %.5f %.5f %d.5 0 360 arc stroke\n",
							corr_x + list->l_koordinate.x,
							corr_y + list->l_koordinate.y - maxMapSize,
							radius[circle]);
					if (list->l_koordinate.y - radius[circle] < 2)
						fprintf(fp, "newpath %.5f %.5f %d.5 0 360 arc stroke\n",
							corr_x + list->l_koordinate.x,
							corr_y + list->l_koordinate.y + maxMapSize,
							radius[circle]);
				}
			}
		}
	}
	
	/*
	 * Grenzlinien einzeichnen
	 */
	if (limesline)
	{
		fprintf(fp, "\n0.0 setgray\n");
		fprintf(fp, "0.4 setlinewidth\n");
		fprintf(fp, "[0.9 0.6 0.4 0.6] 0 setdash 1 setlinecap\n");
		fprintf(fp, "\nnewpath\n");
		limes = aWorld->pl_limes;
		while (limes != NULL)
		{
			if (debug)
				fprintf(stderr, "x %.5g y %.5g line %2d limes %p next %p\n",
					limes->l_x, limes->l_y, limes->l_number, limes, limes->l_next);
			
			pre = limes;
			number = limes->l_limes_number;
			limes = limes->l_next;
			while ((limes != NULL) && (number == limes->l_limes_number))
			{
				if (debug > 1)
					fprintf(stderr, "x%.5g y%.5g line%2d limes%p next%p\n",
						limes->l_x, limes->l_y, number, limes, limes->l_next);
				
				if (pre != NULL)
				{
					fprintf(fp, "%.5g %.5g moveto\n",
						corr_x + pre->l_x, corr_y + pre->l_y);
					pre = NULL;
				}
				fprintf(fp, "%.5g %.5g lineto\n",
					corr_x + limes->l_x, corr_y + limes->l_y);
				limes = limes->l_next;
			}
			if (pre == NULL)
				fprintf(fp, "stroke\n");
		}
	}
	
	/*
	 * Gitter malen
	 */
	if (gitter)
	{
		gitterfont = planetNameSize * size / 30;
		fprintf(fp, "\n0.0 setgray\n");
		fprintf(fp, "\ninitclip\n\n");
		fprintf(fp, "0.05 setlinewidth\n");
		fprintf(fp, "[0.2 0.2 0.4 0.2] 0 setdash 1 setlinecap\n");
		fprintf(fp, "\n/%s-Bold findfont %.5f scalefont setfont\n", fontname, gitterfont);
		{
			WORD zw1, zw2;
			double nanu;
			
			zw1 = (int) (size + 14) / 15;
			nanu = log((double) zw1) / log((double) 2);
			zw2 = (int) (nanu + 0.9999);
			gitterweite = (int) (0.5 + pow((double) 2, (double) zw2));
			if (debug > 1)
			{
				fprintf(stderr, "zw1 %3d nanu %f zw2 %3d pow(%f,%f)= %f %3d ",
					zw1,
					nanu,
					zw2,
					2.0,
					(double) zw2,
					pow(2.0, (double) zw2),
					(int) (0.5 + pow(2.0, (double) zw2)));
			}
		}
		
		if (debug > 1)
			fprintf(stderr, "size %3d gitterweite %2d\n", size, gitterweite);
		
		corr_x -= 0.5;
		corr_y -= 0.5;	
		
		ganz.x = (WORD) corr_x;
		ganz.y = (WORD) corr_y;
		
		map_max.x += ganz.x;
		map_max.y += ganz.y;
		
		halb_x = corr_x - ganz.x;
		halb_y = corr_y - ganz.y;
		off.x = map_min.x - ganz.x;
		off.y = map_min.y - ganz.y;
		
		begin.x = off.x;
		begin.y = off.y;
		if (off.x < 0)
			begin.x += maxMapSize;
		if (off.y < 0)
			begin.y += maxMapSize;
		if (begin.x % gitterweite)
			start = gitterweite - (begin.x % gitterweite);
		if (begin.y % gitterweite)
			delta = gitterweite - (begin.y % gitterweite);
		delta -= start;
		if (begin.y + start + delta < begin.y)
			delta *= -1;
		halb_y += delta;
		off.y += delta;
		
		more = start;
		if (size == maxMapSize)
			more = 0;
		
		corroooooorrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrte * (MAX_NAMELG + 12) * 4), y_pos);
					fprintf(fp, "(\\%d) show\n", Zeichen[number + 1]);
				}
				number++;
			}
		}
	}
	
	fprintf(fp, "\n39 138.6 translate\n");
	if (mapSize < 9)
		cardwidth = SMALL_CARD;
	if (scale < 1.0)
		fprintf(fp, "%.5f %.5f scale\n",
			cardwidth * scale / (double) mapSize,
			cardwidth / (double) mapSize);
	else
		fprintf(fp, "%.5f %.5f scale\n",
			cardwidth / (double) mapSize,
			cardwidth / scale / (double) mapSize);
	
	if (gitter && mapSize != gc_global.maxMapSize)
	{
		fprintf(fp, "0.0 setgray\n");
		fprintf(fp, "\n0.1 setlinewidth\n");
		
		fprintf(fp, "\nnewpath\n");
		fprintf(fp, "0.4 0.4 moveto\n");
		fprintf(fp, "%d.6 0.4 lineto\n", mapSize);
		fprintf(fp, "%d.6 %d.6 lineto\n", mapSize, mapSize);
		fprintf(fp, "0.4 %d.6 lineto\n", mapSize);
		fprintf(fp, "0.4 0.4 lineto\n");
		fprintf(fp, "closepath\n");
		fprintf(fp, "stroke\n\n");
	}
	fprintf(fp, "\nnewpath\n");
	fprintf(fp, "0.5 0.5 moveto\n");
	fprintf(fp, "%d.5 0.5 lineto\n", mapSize);
	fprintf(fp, "%d.5 %d.5 lineto\n", mapSize, mapSize);
	fprintf(fp, "0.5 %d.5 lineto\n", mapSize);
	fprintf(fp, "0.5 0.5 lineto\n");
	fprintf(fp, "clip\n\n");
}


static void footerPS(P(FILE *) fp)
PP(FILE *fp;)
{
	WORD mark, ymark = 6;
	double xpos, ypos, skaleH = 40.0, sizeV = 3.0;

	if (normal == FALSE)
	{
		/* zeichne Entfernungsskale */
		fprintf(fp, "0.1 setlinewidth\n");
		fprintf(fp, "\ninitclip 0 %.5f translate\n", (double) mapSize / -5.0);
		fprintf(fp, "newpath\n");
		fprintf(fp, "0 %.5f moveto\n", (double) (ymark - sizeV) / skaleH * (double) mapSize);
		fprintf(fp, "%d 0 rlineto\n", mapSize + 1);
		fprintf(fp, "0 %.5f rlineto\n", (double) mapSize / skaleH * sizeV);
		fprintf(fp, "%d 0 rlineto\n", -(mapSize + 1));
		fprintf(fp, "0 %.5f rlineto\n", (double) mapSize / skaleH * -sizeV);
		fprintf(fp, "clip\n");
		
		ypos = (double) ymark / skaleH * (double) mapSize;
		for (mark = 6; mark <= mapSize; mark += 2)
			fprintf(fp, "newpath 0.5 %.5f %d 0 360 arc stroke\n", ypos, mark);
		fprintf(fp, "initclip\n");
		fprintf(fp, "newpath 0.5 %.5f %.5f 0 360 arc stroke\n",
			ypos, planetSize);
		fprintf(fp, "newpath 0.5 %.5f %.5f 0 360 arc fill\n",
			ypos, 0.3 * planetSize);
		fprintf(fp, "newpath 6.5 %.5f moveto %d.5 %.5f lineto stroke\n",
			ypos, mapSize, ypos);
		for (mark = 10; mark <= mapSize; mark += 10)
		{
			xpos = mark != mapSize ? (double) mark + 0.5 : (double) mark;
			fprintf(fp, "newpath %.1f %.5f moveto (%d) center show stroke\n",
				xpos, ypos, mark);
		}
	}
	
	fprintf(fp, "\nshowpage\n");
	
	fprintf(fp, "\n%%%%PageTrailer\n");
	fprintf(fp, "%%%%Trailer\n");
	fprintf(fp, "%%%%Pages: 1 1\n");
	fprintf(fp, "%%%%BoundingBox:36 427 559 770\n");
}
