#include <stdio.h>
#include <errno.h>
#include <ctype.h>
#include "gchdr.h"
#include "gcio.h"

int debug = 0;

static char sp_namen[MAX_SPIELER][MAX_NAMELG];

static BYTE get_sp_namen _(( char * ));
static BYTE get_doc _(( void ));
int main _(( int, char *[] ));


static BYTE get_sp_namen(P(char *) player)
PP(char *player;)
{
	FILE *gcb_datei;
	char datei[MAX_PATHLEN];
	STATIC char r_buf[2048];
	char *space;
	int weg, anzahl;

	sprintf(datei, "%s%s", player, EXT_GCB);
	if ((gcb_datei = fopen(datei, FREAD_TEXT)) == NULL)
	{
		fclose(gcb_datei);
		return FEHLER_C;
	}
	for (weg = 0; weg < 7; weg++)
		if (NULL == fgets(r_buf, (int) sizeof(r_buf), gcb_datei))
			return (FEHLER_F);

	if (NULL == fgets(r_buf, (int) sizeof(r_buf), gcb_datei))
		return (FEHLER_F);
	if (sscanf(r_buf, "%d ", &anzahl) != 1)
		return (FEHLER_F);
	for (weg = 0; weg < anzahl; weg++)
	{
		if (NULL == fgets(r_buf, (int) sizeof(r_buf), gcb_datei))
			return (FEHLER_F);
		if ((space = strchr(r_buf, '\r')) != NULL)
		{
			*space = '\0';
		} else
		{
			if ((space = strchr(r_buf, '\n')) != NULL)
				*space = '\0';
		}
		strncpy(sp_namen[weg], r_buf, MAX_NAMELG);
	}
	fclose(gcb_datei);
	return (OK);
}


static BYTE get_doc(P(void))
{
	FILE *doc_datei;
	char name[MAX_NAMELG];
	char datei[MAX_PATHLEN];
	STATIC char r_buf[2048];
	int heimat[MAX_SPIELER + 1];
	int date, score, pl, anzahl, spalte;

	for (anzahl = 0; anzahl < MAX_SPIELER; anzahl++)
	{
		make_player_filename(name, sp_namen[anzahl]);
		sprintf(datei, "%s%s", name, ".doc");
		if ((doc_datei = fopen(datei, FREAD_TEXT)) == NULL)
		{
			fclose(doc_datei);
			return FEHLER_C;
		}
		if (NULL == fgets(r_buf, (int) sizeof(r_buf), doc_datei))
			return (FEHLER_F);
		if (NULL == fgets(r_buf, (int) sizeof(r_buf), doc_datei))
			return (FEHLER_F);
		while (NULL != fgets(r_buf, (int) sizeof(r_buf), doc_datei))
		{
			if (sscanf(r_buf, "%4d %5d %3d", &date, &score, &pl) != 3)
				return (FEHLER_F);
			heimat[anzahl + 1] = pl;
		}
		fclose(doc_datei);
	}
	score = 0;
	for (spalte = 1; spalte < MAX_SPIELER + 1; spalte++)
	{
		if ((spalte % 21) == 0)
			fprintf(stderr, "\n");
		fprintf(stderr, "%3d ", heimat[spalte]);
		score += heimat[spalte];
	}
	fprintf(stderr, "Gesamt: %4d ", score);
	fprintf(stderr, "\n");

	return (OK);
}


int main(P(int) argc, P(char **) argv)
PP(int argc;)
PP(char **argv;)
{
	char *zeichen;
	BYTE result;

	if (argc != 2)
		return(1);
	zeichen = argv[1];
	while (*zeichen != 0 && *zeichen != '.')
		zeichen++;
	if (*zeichen == '.')
		*zeichen = 0;
	if ((result = get_sp_namen(argv[1])) != OK)
	{
		fprintf(stderr, " fehler beim lesen von %s%s \n", argv[1], EXT_GCB);
		return (result);
	}
	if ((result = get_doc()) != OK)
	{
		fprintf(stderr, " fehler beim lesen von %s%s \n", argv[1], ".doc");
		return (result);
	}
	return(0);
}
