#include <stdio.h>
#include "gchdr.h"
#include "gcio.h"
#include "gcmapps.h"


#if !DEBUG_ALLOC
#define getmem malloc
#endif


void translateMap(P(PLAYER *) aWorld, P(WORD) x_offset, P(WORD) y_offset)
PP(PLAYER *aWorld;)
PP(WORD x_offset;)
PP(WORD y_offset;)
{
	PlanetList	*plnt;
	LIMES		*limes;
	WORD		maxMapSize;
	
	if (verbose)
		fprintf(stderr, "transpose map\n");
	
	maxMapSize = gc_global.maxMapSize;
	map_min.x += (gc_global.maxMapSize - x_offset) % maxMapSize;
	map_min.x %= maxMapSize;
	map_min.y += (gc_global.maxMapSize - y_offset) % maxMapSize;
	map_min.y %= maxMapSize;
	for (plnt = aWorld->pl_planetlist; plnt != NULL; plnt = plnt->l_next)
	{
		plnt->l_koordinate.x += x_offset;
		plnt->l_koordinate.x %= maxMapSize;
		if (plnt->l_koordinate.x < 1)
			plnt->l_koordinate.x += maxMapSize;
		
		plnt->l_koordinate.y += y_offset;
		plnt->l_koordinate.y %= maxMapSize;
		if (plnt->l_koordinate.y < 1)
			plnt->l_koordinate.y += maxMapSize;
	}
	if (limesline)
	{
		for (limes = aWorld->pl_limes; limes != NULL; limes = limes->l_next)
		{
			limes->l_x += x_offset;
			if (limes->l_x > maxMapSize) limes->l_x -= maxMapSize;
			if (limes->l_x < 1) limes->l_x += maxMapSize;
			
			limes->l_y += y_offset;
			if (limes->l_y > maxMapSize) limes->l_y -= maxMapSize;
			if (limes->l_y < 1) limes->l_y += maxMapSize;
		}
	}
}


void zoomMap(P(PLAYER *) aWorld)
PP(PLAYER *aWorld;)
{
	PlanetList	*plnt;
	LIMES		*limes;
	WORD		range, size, x, xr, y, yr;
	XY			minimum;
	
	size = gc_global.maxMapSize;
	if (part)
	{
		x = map_max.x - map_min.x;
		y = map_max.y - map_min.y;
		if ((x < 0) || (y < 0))
		{
			minimum.x = map_min.x;
			minimum.y = map_min.y;
			translateMap(aWorld, -map_min.x, -map_min.y);
			map_max.x = x + size;
			map_max.y = y + size;
			if (x > 0) map_max.x = x;					
			if (y > 0) map_max.y = y;
			map_min.x = map_min.y = 0;
			miniMap(aWorld);
			if (debug)
				fprintf(stderr, "max %3d %3d min %3d %3d size %3d\n",
					map_max.x, map_max.y, map_min.x, map_min.y, size);
			map_min.x = minimum.x;
			map_min.y = minimum.y;
			if (debug)
				fprintf(stderr, "max %3d %3d min %3d %3d size %3d\n",
					map_max.x, map_max.y, map_min.x, map_min.y, size);
		} else {
			miniMap(aWorld);
		}
	}
	
	if (verbose)
		fprintf(stderr, "zooming map\n");
	
	if (debug)
		fprintf(stderr, "max %3d %3d min %3d %3d size %3d\n",
			map_max.x, map_max.y, map_min.x, map_min.y, size);
	minimum.x = minimum.y = size;
	map_max.x = map_max.y = 1;
	for (plnt = aWorld->pl_planetlist; plnt != NULL; plnt = plnt->l_next)
	{
		if (plnt->l_planetrange != 0 && showRange)
		{
			range = plnt->l_planetrange;
			x  = plnt->l_koordinate.x + range;
			xr = plnt->l_koordinate.x - range;
			y  = plnt->l_koordinate.y + range;
			yr = plnt->l_koordinate.y - range;
		} else {
			x = plnt->l_koordinate.x;
			y = plnt->l_koordinate.y;
			xr = x;
			yr = y;
		}
		if (debug)
			fprintf(stderr, "nr %3d x %3d y %3d xr %3d yr %3d\n",
				plnt->l_number, x, y, xr, yr);
		
		if (minimum.x > xr) minimum.x = xr;
		if (map_max.x < x ) map_max.x = x;
		if (minimum.y > yr) minimum.y = yr;
		if (map_max.y < y ) map_max.y = y;
	}
	
	x = map_max.x - minimum.x;
	y = map_max.y - minimum.y;
	size = ( x > y ? x + 1 : y + 1);
	
	if (debug)
		fprintf(stderr, "max %3d %3d min %3d %3d size %3d\n",
			map_max.x, map_max.y, minimum.x, minimum.y, size);
	
	if (size < gc_global.maxMapSize)
	{
		corr_x = (double)(size - x) / 2.0;
		corr_y = (double)(size - y) / 2.0;
		
		if (debug)
			fprintf(stderr, "corr %3.2f %3.2f\n", corr_x, corr_y);
		
		for (plnt = aWorld->pl_planetlist; plnt != NULL; plnt = plnt->l_next)
		{
			plnt->l_koordinate.x -= minimum.x;
			plnt->l_koordinate.y -= minimum.y;
		}
		
		if (limesline)
		{
			for (limes = aWorld->pl_limes; limes != NULL; limes = limes->l_next)
			{
				limes->l_x -= minimum.x;
				limes->l_y -= minimum.y;
			}
		}
		map_min.x += minimum.x;
		map_min.y += minimum.y;
		map_max.x = map_min.x + x + 1;
		map_max.y = map_min.y + y + 1;
	} else {
		if (!quiet)
			fprintf(stderr, "no zooming possible\n");
		translateMap(aWorld, 0, 0);
		size = gc_global.maxMapSize;
		map_max.x = map_max.y = size + 1;
	}
	mapSize = size;
}


void miniMap(P(PLAYER *) aWorld)
PP(PLAYER *aWorld;)
{
	PlanetList *plnt, *father;
	
	if (verbose)
		fprintf(stderr, "parting map\n");
	
	father = aWorld->pl_planetlist;
	plnt = aWorld->pl_planetlist;
	while (plnt != NULL)
	{
		if (debug)
			fprintf(stderr, "nr %3d x %3d y %3d ",
				plnt->l_number, plnt->l_koordinate.x, plnt->l_koordinate.y);
		
		if ((plnt->l_koordinate.x > map_max.x)||(plnt->l_koordinate.x < map_min.x)||
			(plnt->l_koordinate.y > map_max.y)||(plnt->l_koordinate.y < map_min.y))
		{
			if (debug)
				fprintf(stderr, "nr %3d x %3d y %3d\n",
					plnt->l_number, plnt->l_koordinate.x, plnt->l_koordinate.y);
			
			if (plnt == aWorld->pl_planetlist)
			{
				aWorld->pl_planetlist = plnt->l_next;
				father = aWorld->pl_planetlist;
				OFREE(plnt);
				plnt = father;
			} else {	
				father->l_next = plnt->l_next;
				OFREE(plnt);
				plnt = father->l_next;
			}
		} else {
			father = plnt;
			plnt = father->l_next;
			if (debug)
				fprintf(stderr, "\n");
		}
	}
	map_min.x = map_min.y = 0;
}


BYTE MakeMap(P(PLAYER *) aWorld)
PP(PLAYER *aWorld;)
{
	PlanetList	*fromPt, **list;
	PLANET *planet, **planets;
	WORD i;
	
	freeMap(aWorld);
	planets = aWorld->pl_planets;
	if (planets == NULL)
		return(OK);
	list = &aWorld->pl_planetlist;
	for (i = 0; i < gc_global.anz_planeten; i++)
	{
		planet = planets[i];
		if (planet != NULL && position_known(planet))
		{
			fromPt = NEW(PlanetList, "MakeMap");
			if (fromPt == NULL)
				return(FEHLER_M);
			fromPt->l_owner = planet->p_owner;
			fromPt->l_number = planet->p_number;
			fromPt->l_koordinate.x = planet->p_pos_x;
			fromPt->l_koordinate.y = planet->p_pos_y;
			fromPt->l_status = planet_status(aWorld, planet);
			if (fromPt->l_status == STATUS_OWN)
				fromPt->l_planetrange = regel.radius[aWorld->pl_tech_level[FG_SPY]];
			else
				fromPt->l_planetrange = 0;
			fromPt->l_natdef = planet->p_nat_def;
			fromPt->l_festungen = planet->p_festungen;
			fromPt->l_visited = planet->p_visited;
			fromPt->l_planet = planet;
			fromPt->l_next = NULL;
			*list = fromPt;
			list = &fromPt->l_next;
		}
	}
	return(OK);
}


BYTE MergeInfo(P(PLAYER *) aWorld)
PP(PLAYER *aWorld;)
{
	PlanetList	*list;
	PLANET *planet;
	
	for (list = aWorld->pl_planetlist; list; list = list->l_next)
	{
		planet = find_planet(aWorld, list->l_number, NULL);
		if (planet != NULL)
		{
			list->l_natdef = planet->p_nat_def;
			if (list->l_status == STATUS_UNKNOWN)
				list->l_festungen = -1;
			else
				if (planet->p_festungen != -1)
					list->l_festungen = planet->p_festungen;
			if (planet->p_visited)
				list->l_visited = planet->p_visited;
			if (messydos)
			{
				aWorld->pl_planets[planet->p_number-1] = NULL;
				OFREE(planet);
				list->l_planet = NULL;
			} else {
				list->l_planet = planet;
			}
		}
	}
	return(OK);
}


void freeMap(P(PLAYER *) aWorld)
PP(PLAYER *aWorld;)
{
	PlanetList	*fromPt, *next;
	
	for (fromPt = aWorld->pl_planetlist; fromPt != NULL; fromPt = next)
	{
		next = fromPt->l_next;
		OFREE(fromPt);
	}
	aWorld->pl_planetlist = NULL;
}


void debugFile(P(PLAYER *) aWorld, P(char *) dName)
PP(PLAYER *aWorld;)
PP(char *dName;)
{
	FILE		*fp;
	PlanetList	*list;
	
	fp = fopen (dName, "w");
	if (fp == NULL)
	{
		fprintf(stderr, "can't create file %s\n", dName);
		exit (1);
	}
	fprintf (stderr, "writing %s\n", dName);
	fprintf (fp, "plotStatus = %d\n", plotStatus);
	fprintf (fp, "mapOffset.x = %d\n", map_offset.x);
	fprintf (fp, "mapOffset.y = %d\n", map_offset.y);
	fprintf (fp, "nplanets = %d\n", aWorld->pl_known_planets);
	fprintf (fp, "starDate = %d\n", gc_global.starDate);
	fprintf (fp, "maxMapSize = %d\n", gc_global.maxMapSize);
	for (list = aWorld->pl_planetlist; list != NULL; list = list->l_next)
	{
		fprintf (fp, "%2d: Planet = %3d (%d,%d) %d\n", aWorld->pl_number, list->l_number,
			list->l_koordinate.x, list->l_koordinate.y, list->l_status);
	}
	f_close (fp);
}

