#include <stdio.h>
#include <time.h>
#include <errno.h>
#include "gchdr.h"
#include "gcio.h"
#define EXTERN
#include "gcmapps.h"

#undef Version
#undef VDate
#define Version "1.0"
#define VDate "10.07.94"


#if !DEBUG_ALLOC
#define getmem malloc
#define getcmem calloc
#endif


static PLAYER *me;


/* Prototypen */

static Bool read_gcb _(( char *pathname, GC_MISC *gcb ));
static Bool write_gcb _(( PLAYER *player ));
static Bool read_map _(( PLAYER *player ));
static PLAYER *find_player _(( char *filename ));
static char *compress_file_name _(( char *src ));
static void usage _(( void ));
static void mem_err _(( void ));
int main _(( int, char ** ));


int main(P(int) argc, P(char **) argv)
PP(int argc;)
PP(char **argv;)
{
	char	fnameIn[MAX_PATHLEN];
	PLAYER	*player;
	char	all_player[MAX_SPIELER*MAX_NAMELG];
	int		num_spieler;
	
	program_name = "map2gcb";
	if (argc != 2)
	{
		fprintf (stderr, "no input file.\n\n");
		usage();
	}
	verbose = TRUE;
	
	STRCPY(fnameIn, argv[1]);
	compress_file_name(fnameIn);
	if (read_gcb(fnameIn, &gc_global) == FALSE)
		exit(1);
	me = get_player(gc_global.sp_nummer);
	strcpy(me->pl_path, fnameIn);
	if (read_map(me) == FALSE)
		exit(1);
	num_spieler = suche_spielername(all_player, EXT_MAP, MAX_SPIELER);
	for (argc = 0; argc < num_spieler; argc++)
	{
		STRCPY(fnameIn, all_player + argc*MAX_NAMELG);
		compress_file_name(fnameIn);
		player = find_player(fnameIn);
		if (player != NULL && player != me)
		{
			strcpy(player->pl_path, fnameIn);
			if (read_map(player) == FALSE)
				exit(1);
		}
	}
	
	FindHomePlanets();
	for (argc = 1; argc <= gc_global.anz_spieler; argc++)
	{
		player = get_player(argc);
		if (player != NULL && player != me)
		{
			if (player->pl_heimat != 0)
			{
				write_gcb(player);
			} else {
				fprintf(stderr, "Heimatplanet von %s nicht gefunden\n", player->pl_name);
			}
		}
	}
	
	for (argc = 1; argc <= gc_global.anz_spieler; argc++)
	{
		player = get_player(argc);
		delete_player(player);
		OFREE(player);
	}
	FREE(gc_global.spieler, gc_global.anz_spieler * sizeof(PLAYER *));
	gc_global.spieler = NULL;
	return(0);
}


static PLAYER *find_player(P(char *) filename)
PP(char *filename;)
{
	PLAYER *player;
	WORD i;
	char fnamebuf[10];
	char searchbuf[10];
	
	make_player_filename(searchbuf, filename);
	for (i = 1; i <= gc_global.anz_spieler; i++)
	{
		player = get_player(i);
		if (player != NULL)
		{
			make_player_filename(fnamebuf, player->pl_name);
			if (strcmp(fnamebuf, searchbuf) == 0)
				return(player);
		}
	}
	return(NULL);
}


static char *compress_file_name(P(char *) src)
PP(char *src;)
{
	char *p, *dot, *basename;
	
	basename = src;
	for (p = src, dot = NULL; *p; p++)
	{
		if (*p == '.')
			dot = p;
		else if (*p == '\\' || *p == '/')
		{
			dot = NULL;
			basename = p+1;
		}
	}
	if (dot)
		*dot = '\0';
	return(basename);
}


static Bool read_gcb(P(char *) pathname, P(GC_MISC *) gcb)
PP(char *pathname;)
PP(GC_MISC *gcb;)
{
	switch (get_gcb(pathname, gcb))
	{
	case FEHLER_O:
		fprintf(stderr, "can't open %s%s\n", pathname, EXT_GCB);
		return(FALSE);
	case FEHLER_M:
		mem_err();
		return(FALSE);
	case FEHLER_V:
		fprintf(stderr, "wrong GCB-File Version in %s (%d.%d); need %d.%d\n",
			pathname,
			gcb->major, gcb->minor,
			GC_MAJOR, GC_MINOR);
		return(FALSE);
	case FEHLER_STYPEN:
		fprintf(stderr, "can handle only %d types of ships\n", MAX_STYPEN);
		return(FALSE);
	case FEHLER_SPIELER:
		fprintf(stderr, "can handle only %d players\n", MAX_SPIELER);
		return(FALSE);
	case FEHLER_SPIELER_NUMMER:
		fprintf(stderr, "illegal player number in %s\n", pathname);
		return(FALSE);
	case OK:
		break;
	default:
		fprintf(stderr, "error reading %s%s\n", pathname, EXT_GCB);
		return(FALSE);
	}
	return(TRUE);
}


static Bool write_gcb(P(PLAYER *) player)
PP(PLAYER *player;)
{
	switch (put_gcb(player, player->pl_path))
	{
	case FEHLER_C:
		fprintf(stderr, "can't create %s%s\n", player->pl_path, EXT_GCB);
		return(FALSE);
	case FEHLER_M:
		mem_err();
		return(FALSE);
	case OK:
		break;
	default:
		fprintf(stderr, "error writing %s%s\n", player->pl_path, EXT_GCB);
		return(FALSE);
	}
	return(TRUE);
}


static Bool read_map(P(PLAYER *) player)
PP(PLAYER *player;)
{
	switch (get_map(player, player->pl_path, FALSE))
	{
	case FEHLER_R:
		fprintf(stderr, "error reading %s%s\n", player->pl_path, EXT_MAP);
		return(FALSE);
	case FEHLER_O:
		fprintf(stderr, "warning: can't find map file for %s\n", player->pl_path);
		return(TRUE);
	case FEHLER_M:
		mem_err();
		return(FALSE);
	case FEHLER_V:
		fprintf(stderr, "Version mismatch in %s%s\n", player->pl_path, EXT_MAP);
		return(FALSE);
	case OK:
		break;
	default:
		fprintf(stderr, "format error in %s%s\n", player->pl_path, EXT_MAP);
		return(FALSE);
	}
	return(TRUE);
}


static void usage(P(void))
{
	fprintf (stderr, "%s v%s %s\n", program_name, Version, VDate);
	fprintf (stderr, "Usage: %s input\n", program_name);
	exit (2);
}


static void mem_err(P(void))
{
	fprintf(stderr, "not enough memory\n");
	exit(1);
}

/* EOF */
